<?php

/*
 * LinkorCMS 1.4
 *  2012 LinkorCMS Development Group
 */


if(!defined('VALID_RUN')){
	header("HTTP/1.1 404 Not Found");
	exit;
}

System::admin()->AddSubTitle('');

if(!System::user()->CheckAccess2('news', 'news')){
	System::admin()->AccessDenied();
}
global $action, $news_access_editnews, $news_access_edittopics, $news_access_editconfig;
$news_access_editnews = System::user()->CheckAccess2('news', 'news_edit');
$news_access_edittopics = System::user()->CheckAccess2('news', 'edit_topics');
$news_access_editconfig = System::user()->CheckAccess2('news', 'news_conf');

include_once System::config('inc_dir').'configuration/functions.php';

$action = 'main';
if(isset($_GET['a'])) $action = $_GET['a'];

System::admin()->SideBarAddMenuItem('', 'exe=news', 'main');
System::admin()->SideBarAddMenuItemDelimiter();
if($news_access_editnews) System::admin()->SideBarAddMenuItem(' ', 'exe=news&a=add', 'add');
if($news_access_edittopics) System::admin()->SideBarAddMenuItem(' ', 'exe=news&a=topics', 'topics');
if($news_access_editconfig) System::admin()->SideBarAddMenuItem('', 'exe=news&a=config', 'config');
System::admin()->SideBarAddMenuBlock('', $action);

switch($action){
	case 'main':
		AdminNewsMain();
		break;
	case 'add':
	case 'edit':
		AdminNewsEditor();
		break;
	case 'preview':
		AdminNewsPreview();
		break;
	case 'save':
		AdminNewsSave();
		break;
	case 'delete':
		AdminNewsDelete();
		break;
	case 'changestatus':
		AdminNewsChangeStatus();
		break;
	case 'topics':
		AdminNewsTopics();
		break;
	case 'savetopic':
	case 'addtopic':
		AdminNewsTopicSave();
		break;
	case 'deltopic':
		AdminNewsTopicsDelete();
		break;
	case 'edittopic':
		AdminNewsEditTopic();
		break;
	case 'config':
		if(!$news_access_editconfig){
			System::admin()->AccessDenied();
		}
		System::admin()->AddCenterBox('  ""');
		if(isset($_GET['saveok'])){
			System::admin()->Highlight(' .');
		}
		System::admin()->ConfigGroups('news');
		System::admin()->AddConfigsForm(ADMIN_FILE.'?exe=news&a=configsave');
		break;
	case 'configsave':
		if(!$news_access_editconfig){
			System::admin()->AccessDenied();
		}
		System::admin()->SaveConfigs('news');
		Audit(':   ');
		GO(ADMIN_FILE.'?exe=news&a=config&saveok');
		break;
}

function CalcNewsCounter($topic_id, $inc){
	System::database()->Select('news_topics', "`id`='".$topic_id."'");
	$topic = System::database()->FetchRow();
	if($inc == true){
		$counter_val = $topic['counter']+1;
	} else{
		$counter_val = $topic['counter']-1;
	}
	System::database()->Update('news_topics', "counter='".$counter_val."'", "`id`='".$topic_id."'");
}

/*
 *     .
 */
function AdminNewsClearBlockCache(){
	System::cache()->Delete('block', array('news1', 'news2', 'news3', 'news4'));
}

/**
 *  ,  
 * @return void
 */
function AdminNewsMain(){
	global $news_access_editnews;
	System::admin()->AddSubTitle('');
	$back = SaveRefererUrl();

	//    
	if(isset($_REQUEST['onpage'])){
		$num = intval($_REQUEST['onpage']);
	}else{
		$num = System::config('news/newsonpage');
	}
	if(isset($_REQUEST['page'])){
		$page = intval($_REQUEST['page']);
	}else{
		$page = 1;
	}

	$newsdb = System::database()->Select('news');
	$columns = array('title', 'date', 'hit_counter', 'comments_counter', 'view', 'enabled');
	$sortby = 'date';
	$sortbyid = 1;
	$desc = true;
	if(isset($_REQUEST['sortby'])){
		$sortby = $columns[$_REQUEST['sortby']];
		$sortbyid = intval($_REQUEST['sortby']);
		$desc = $_REQUEST['desc'] == '1';
	}
	SortArray($newsdb, $sortby, $desc);

	//  
	UseScript('jquery_ui_table');
	$table = new jQueryUiTable();
	$table->listing = ADMIN_FILE.'?exe=news&ajax';
	$table->del = ADMIN_FILE.'?exe=news&a=delete';
	$table->total = count($newsdb);
	$table->onpage = $num;
	$table->page = $page;
	$table->sortby = $sortbyid;
	$table->sortdesc = $desc;

	$table->AddColumn('');
	$table->AddColumn('', 'left', true, true);
	$table->AddColumn('', 'right');
	$table->AddColumn('', 'right');
	$table->AddColumn(' ', 'center');
	$table->AddColumn('', 'center');
	$table->AddColumn('', 'center', false, true);

	$newsdb = ArrayPage($newsdb, $num, $page); //      
	foreach($newsdb as $news){
		$id = SafeDB($news['id'], 11, int);

		$status = System::admin()->SpeedStatus('', '', ADMIN_FILE.'?exe=news&a=changestatus&id='.$id, $news['enabled'], 'images/bullet_green.png', 'images/bullet_red.png');
		$view = ViewLevelToStr(SafeDB($news['view'], 1, int));

		$allowComments = SafeDB($news['allow_comments'], 1, bool);
		$comments = SafeDB($news['comments_counter'], 11, int); //  

		$title = SafeDB($news['title'], 255, str);

		$func = '';
		$link_go = Ufu('index.php?name=news&op=readfull&news='.$id.'&topic='.SafeDB($news['topic_id'], 11, int), 'news/{topic}/{news}/');
		$func .= System::admin()->SpeedButton('    ', $link_go, 'images/link_go.png', false, false, 'target="_blank"');
		if($news_access_editnews){
			$func .= System::admin()->SpeedButton('', ADMIN_FILE.'?exe=news&a=edit&id='.$id.'&back='.$back, 'images/admin/edit.png');
			$func .= System::admin()->SpeedConfirmJs(
				'',
				'$(\'#jqueryuitable\').table(\'deleteRow\', '.$id.');',
				'images/admin/delete.png',
				',     ?'
			);
			$title = '<b>'.System::admin()->Link($title, ADMIN_FILE.'?exe=news&a=edit&id='.$id.'&back='.$back).'</b>';
		}

		$table->AddRow(
			$id,
			$title,
			TimeRender(SafeDB($news['date'], 11, int)),
			SafeDB($news['hit_counter'], 11, int),
			($allowComments ? $comments : ' '),
			$view,
			$status,
			$func
		);
	}

	if(isset($_GET['ajax'])){
		echo $table->GetOptions();
		exit;
	}else{
		$table->AddTable('');
	}
}

/**
 *   ( / )
 * @return void
 */
function AdminNewsEditor(){
	global $news_access_editnews;
	if(!$news_access_editnews){
		System::admin()->AccessDenied();
	}
	UseScript('jquery_ui', 'colorbox?theme=admin');

	System::admin()->AddOnLoadJS('
	$("#datepicker").datepicker({
		dateFormat: "dd.mm.yy",
		changeMonth: true,
		changeYear: true
	});');

	$topic_id = 0; //  
	$newstitle = ''; //  
	$icon = ''; // 
	$stext = ''; //  
	$ctext = ''; //  
	$view = 4; //  
	$allow_comments = true; //  
	$auto_br = false; //    <br />
	$enabled = true; //  /
	$alname = ''; //    
	$img_view = 0;
	// SEO
	$seo_title = '';
	$seo_keywords = '';
	$seo_description = '';

	$public_date = date("d.m.Y", time());
	$public_time = date("G:i", time());

	if(!isset($_GET['id'])){ //  
		$auto_br = false;
		$title = ' ';
		$caption = '';
		TAddSubTitle($title);
		$met = '';
	}else{ //  
		System::database()->Select('news', "`id`='".SafeEnv($_GET['id'], 11, int)."'");
		$news = System::database()->FetchRow();
		$topic_id = SafeDB($news['topic_id'], 11, int);
		$newstitle = SafeDB($news['title'], 255, str);
		$icon = SafeDB($news['icon'], 255, str);
		$stext = SafeDB($news['start_text'], 0, str, false);
		$ctext = SafeDB($news['end_text'], 0, str, false);
		$allow_comments = SafeDB($news['allow_comments'], 1, bool);
		$auto_br = SafeDB($news['auto_br'], 1, bool);
		$img_view = SafeDB($news['img_view'], 1, int);

		$view = SafeDB($news['view'], 1, int);
		$enabled = SafeDB($news['enabled'], 1, bool);

		// SEO
		$seo_title = SafeDB($news['seo_title'], 255, str);
		$seo_keywords = SafeDB($news['seo_keywords'], 255, str);
		$seo_description = SafeDB($news['seo_description'], 255, str);

		$public_date = date("d.m.Y", $news['date']);
		$public_time = date("G:i", $news['date']);

		$title = ' ';
		$caption = ' ';
		TAddSubTitle($title);
		$met = '&id='.SafeEnv($_GET['id'], 11, int);
	}

	System::admin()->AddJS(Indent('
		NewsPreviewOpen = function(){
			if(tinyMCE){
				tinyMCE.triggerSave();
			}
			var form_data = Admin.SerializeFormData(document.forms.news_editor);
			var left = parseInt(screen.width / 2) - 400;
			var top = parseInt(screen.height / 10);
			var wp = window.open("", "Preview", "resizable=yes,scrollbars=yes,menubar=no,status=no,location=no,width=800,height=600,left="+left+",top="+top+"");
			wp.document.open();
			$.ajax({
				type: "POST",
				url: "'.ADMIN_FILE.'?exe=news&a=preview'.$met.'",
				data: form_data,
				dataType: "html",
				success: function(data){
					wp.document.write(data);
					wp.document.close();
				}
			});
		}
	'));

	System::database()->Select('news_topics', '');
	$topicdata = array();
	while($topic = System::database()->FetchRow()){
		System::admin()->DataAdd($topicdata, $topic['id'], $topic['title'], ($topic['id'] == $topic_id));
	}
	if(count($topicdata) == 0){
		AddTextBox($title, '   .     .');
		return;
	}

	$img_view_data = array();
	System::admin()->DataAdd($img_view_data, '0', '', $img_view == 0);
	System::admin()->DataAdd($img_view_data, '1', ' ', $img_view == 1);
	System::admin()->DataAdd($img_view_data, '2', '', $img_view == 2);

	$acts = array();
	System::admin()->DataAdd($acts, 'save', $alname);
	System::admin()->DataAdd($acts, 'preview', '');

	FormRow('', System::admin()->Select('topic_id', $topicdata, false, 'class="autofocus"'));
	FormRow(' ', System::admin()->Edit('title', $newstitle, false, 'style="width:400px;"'));

	//  SEO
	FormRow('[seo]  ', System::admin()->Edit('seo_title', $seo_title, false, 'style="width:400px;"'));
	FormRow('[seo]  ', System::admin()->Edit('seo_keywords', $seo_keywords, false, 'style="width:400px;"'));
	FormRow('[seo] ', System::admin()->Edit('seo_description', $seo_description, false, 'style="width:400px;"'));

	list($width, $height) = SafeDB(explode(':', System::config('news/tmb_size')), 11, int);
	FormRow('',
		System::admin()->FileManager('icon', $icon).
		'<br>
		<a href="'.$icon.'" class="filemanager_icon colorbox" data-content="href:path" target="_blank">
			<img src="'.GetThumb($icon, $width, $height).'" class="filemanager_icon" data-content="src:tmb" style="margin-top: 5px; max-width: 250px;">
		</a>'
	);
	//AdminImageControl('', ' ', $icon, System::config('news/icons_dirs'), 'icon', 'up_photo', 'news_editor');
	FormRow(' ', System::admin()->Select('img_view', $img_view_data));

	FormTextRow('  (HTML)', System::admin()->HtmlEditor('shorttext', $stext, 600, 200));
	FormTextRow('  (HTML)', System::admin()->HtmlEditor('continuation', $ctext, 600, 400));

	FormRow('', '   HTML: '.System::admin()->Select('auto_br', GetEnData($auto_br, '', '')));

	FormRow('   ',
	        System::admin()->Edit('public_date', $public_date, false, 'id="datepicker" style="width:120px;"')
	        .'&nbsp;'.System::admin()->Edit('public_time', $public_time, false, 'style="width:60px;"'));

	FormRow('', System::admin()->Select('acomments', GetEnData($allow_comments, '', '')));
	FormRow(' ', System::admin()->Select('view', GetUserTypesFormData($view)));
	FormRow('', System::admin()->Select('enabled', GetEnData($enabled, '', '')));

	AddCenterBox($title);
	$back = '';
	if(isset($_REQUEST['back'])){
		$back = '&back='.SafeDB($_REQUEST['back'], 255, str);
	}
	AddForm(
		'<form name="news_editor" action="'.ADMIN_FILE.'?exe=news&a=save'.$met.$back.'" method="post" enctype="multipart/form-data" name="news_editor">',
		System::admin()->Button('', 'onclick="history.go(-1)"')
			.System::admin()->Button('', 'onclick="NewsPreviewOpen();"')
			.System::admin()->Submit($caption)
	);
}

function AdminNewsPreview(){
	$_POST = ObjectUtf8ToCp1251($_POST);

	$preview = new Page('module/news_preview.html', '', false, PAGE_SPECIAL);
	$preview->Doctype = '<!DOCTYPE html>';
	$preview->AddCSSFile('style.css');

	$preview->AddBlock('news', true, true);

	//     
	$preview->SetVar('template', 'enabled_comments', false);
	$preview->SetVar('template', 'disabled_comments', true);
	//   
	$preview->AddBlock('comments_navigation', false);
	$preview->AddBlock('news_comments', false);
	$preview->AddBlock('news_comments_form', false);
	$preview->SetTitle(SafeDB($_POST['title'], 255, str));

	$topic_id = SafeEnv($_POST['topic_id'], 11, int);
	System::database()->Select('news_topics', "`id`='$topic_id'");
	$topic = System::database()->FetchRow();
	$topic_title = SafeDB($topic['title'], 255, str);

	if(isset($_GET['id'])){
		$news_id = SafeDB($_GET['id'], 11, int);
		System::database()->Select('news', "`id`='".SafeEnv($_GET['id'], 11, int)."'");
		$news = System::database()->FetchRow();
		$comments_counter = SafeDB($news['comments_counter'], 11, int);
		$hit_counter = SafeDB($news['hit_counter'], 11, int);
	}else{
		$news_id = 0;
		$comments_counter = 0;
		$hit_counter = 0;
	}

	$img_view = SafeDB($_POST['img_view'], 1, int);
	$link = Ufu('index.php?name=news&op=readfull&news='.$news_id.'&topic='.$topic_id, 'news/{topic}/{news}/');
	$topic_link = Ufu('index.php?name=news&topic='.$topic_id, 'news/{topic}/');

	$vars['topic'] = $topic_title;
	$vars['id'] = $news_id;
	$vars['title'] = SafeDB($_POST['title'], 255, str);
	$vars['author'] = System::user()->Get('u_name');

	$date = strtotime(str_replace('.', '-', $_POST['public_date']).' '.$_POST['public_time']);

	$vars['date'] = TimeRender($date);
	$vars['time'] = date('H:i', $date);
	$vars['day'] = date('d', $date);
	$vars['month'] = date('m', $date);
	$vars['year'] = date('y', $date);
	$vars['year_full'] = date('Y', $date);

	$vars['link'] = $link;
	$vars['cat_link'] = $topic_link;
	$vars['com_count'] = $comments_counter;
	$vars['hit_count'] = $hit_counter;
	$vars['admin'] = System::user()->isAdmin();

	if(strlen(strip_tags($_POST['continuation'])) > 0){ //    
		$vars['full'] = '<a href="'.$link.'"> </a>';
		$read_more = true;
	}else{
		$vars['full'] = '';
		$read_more = false;
	}

	$image = SafeDB($_POST['icon'], 255, str);
	list($width, $height) = SafeDB(explode(':', System::config('news/tmb_size')), 11, int);
	if($image == '' || substr($image, 0, 7) == 'http://'){
		$vars['image'] = $image;
		$vars['image_url'] = false;
	}elseif($img_view == 1){ //  
		$vars['image'] = GetThumb($image, $width, $height);
		$vars['image_url'] = false;
	}elseif($img_view == 2){ // 
		$vars['image'] = GetThumb($image, $width, $height);
		$vars['image_url'] = $image;
	}elseif($img_view == 0){ // 
		$size = ImageSize($image);
		if($size['width'] > $width){
			$vars['image'] = GetThumb($image, $width, $height);
			$vars['image_url'] = $image;
		}else{
			$vars['image'] = $image;
			$vars['image_url'] = false;
		}
	}

	$vars['com_status'] = '';

	if($read_more){
		$vars['text'] = SafeDB($_POST['shorttext'].$_POST['continuation'], 0, str, false, false);
	}else{
		$vars['text'] = SafeDB($_POST['shorttext'], 0, str, false, false);
	}

	if($_POST['auto_br'] == 'on'){
		$vars['text'] = nl2br($vars['text']);
	}

	$preview->AddSubBlock('news', true, $vars);
	$preview->TEcho(false, false);
	exit();
}

function AdminNewsSave(){
	global $news_access_editnews;

	if(!$news_access_editnews){
		System::admin()->AccessDenied();
	}

	$author = SafeEnv(System::user()->Get('u_name'), 255, str);

	//  
	$topic_id = SafeEnv($_POST['topic_id'], 11, int);
	$title = SafeEnv($_POST['title'], 255, str);
	//  SEO
	$seo_title = SafeEnv($_POST['seo_title'], 255, str);
	$seo_keywords = SafeEnv($_POST['seo_keywords'], 255, str);
	$seo_description = SafeEnv($_POST['seo_description'], 255, str);
	//
	$allow_comments = EnToInt($_POST['acomments']);

	$icon = SafeEnv($_POST['icon'], 255, str);

	$start_text = SafeEnv($_POST['shorttext'], 0, str, false);
	$end_text = SafeEnv($_POST['continuation'], 0, str, false);
	$auto_br = EnToInt($_POST['auto_br']);
	$view = ViewLevelToInt(SafeEnv($_POST['view'],15,str));
	$enabled = EnToInt($_POST['enabled']);
	$img_view = SafeEnv($_POST['img_view'],1,int);

	$public_date = $_POST['public_date'];
	$public_time = $_POST['public_time'];
	$public = strtotime(str_replace('.', '-', $public_date).' '.$public_time);

	$comments_counter = 0;
	$hit_counter = 0;

	if(isset($_GET['id'])){
		$id = SafeEnv($_GET['id'],11,int);
		System::database()->Select('news', "`id`='$id'");
		$news = System::database()->FetchRow();
		$author = SafeEnv($news['author'], 255, str);
		$comments_counter = SafeEnv($news['comments_counter'], 11, int);
		$hit_counter = SafeEnv($news['hit_counter'], 11, int);
		if($topic_id != $news['topic_id'] && $news['enabled'] == 1){
			CalcNewsCounter($news['topic_id'], false);
			CalcNewsCounter($topic_id, true);
		}
		if($enabled != $news['enabled']){
			CalcNewsCounter($topic_id, $enabled);
		}
	}

	$vals = Values('', $title, $public, $author, $topic_id,
	$allow_comments, $icon, $start_text, $end_text, $auto_br,
	$comments_counter, $hit_counter, $view, $enabled, $img_view,
	$seo_title, $seo_keywords, $seo_description);

	if(isset($id)){
		System::database()->Update('news', $vals, "`id`='$id'", true);
		Audit('  "'.$title.'" (id: '.$id.')');
	}else{
		System::database()->Insert('news', $vals);
		CalcNewsCounter($topic_id, true);
		Audit(':   "'.$title.'"');
	}

	AdminNewsClearBlockCache();

	if(isset($_REQUEST['back'])){
		GoRefererUrl($_REQUEST['back']);
	}else{
		GO(ADMIN_FILE.'?exe=news');
	}
}

function AdminNewsDelete(){
	global $news_access_editnews;
	if(!$news_access_editnews){
		System::admin()->AccessDenied();
	}
	if(!isset($_REQUEST['id'])){
		exit('ERROR');
	}
	if(IsAjax() || isset($_GET['ok']) && $_GET['ok'] == '1'){
		$id = SafeEnv($_REQUEST['id'], 11, int);
		System::database()->Select('news', "`id`='$id'");
		$news = System::database()->FetchRow();
		System::database()->Delete('news', "`id`='$id'");
		System::database()->Delete('news_comments', "`object_id`='$id'");
		if($news['enabled']){
			CalcNewsCounter(SafeDB($news['topic_id'], 11, int), false);
		}
		AdminNewsClearBlockCache();

		Audit('  "'.$news['title'].'"');

		if(isset($_GET['back'])){
			GoRefererUrl($_GET['back']);
		}
		GO(ADMIN_FILE.'?exe=news');
	}else{
		System::admin()->AddCenterBox(' ');
		System::database()->Select('news', "`id`='".SafeEnv($_REQUEST['id'], 11, int)."'");
		$news = System::database()->FetchRow();
		$id = SafeDB($_REQUEST['id'], 11, int);
		$back = SafeDB($_REQUEST['back'], 255, str);
		System::admin()->HighlightConfirmNoAjax('  "'.SafeDB($news['title'], 255, str).'"?', ADMIN_FILE.'?exe=news&a=delete&id='.$id.'&back='.$back.'&ok=1');
	}
}

function AdminNewsChangeStatus(){
	global $news_access_editnews;

	if(!isset($_GET['id']) || !$news_access_editnews){
		exit('ERROR');
	}

	$id = SafeEnv($_GET['id'], 11, int);
	System::database()->Select('news', "`id`='$id'");
	$news = System::database()->FetchRow();
	$enabled = ($news['enabled'] ? '0' : '1');
	CalcNewsCounter(SafeDB($news['topic_id'], 11, int), $enabled);
	System::database()->Update('news', "enabled='$enabled'", "`id`='$id'");
	Audit('   "'.$news['title'].'"');

	AdminNewsClearBlockCache();

	exit('OK');
}

function AdminNewsTopics(){
	global $news_access_edittopics;
	UseScript('jquery_ui', 'colorbox?theme=admin');

	if(!$news_access_edittopics){
		System::admin()->AccessDenied();
	}
	$cntr = 0;

	AddCenterBox('  ');
	$topics = System::database()->Select('news_topics');

	$text = '<table style="width: 100%; border: 1px #ABC5D8 solid; background-color: #fff; padding: 10px;">';
	foreach($topics as $topic){
		$topic_id = SafeDB($topic['id'], 11, int);
		$edit_url = ADMIN_FILE.'?exe=news&a=edittopic&id='.$topic_id;
		$link_go = Ufu('index.php?name=news&topic='.$topic_id, 'news/{topic}/');

		$title = SafeDB($topic['title'], 255, str);
		$desc = SafeDB($topic['description'], 255, str);
		$counter = SafeDB($topic['counter'], 11, int);

		$image = SafeDB($topic['image'], 255, str);
		if($image != ''){
			list($width, $height) = SafeDB(explode(':', System::config('news/topics_tmb_size')), 11, int);
			$image = GetThumb($image, $width, $height);
			$image = '<tr><td align="center"><a href="'.$edit_url.'"><img src="'.$image.'" height="80" title="'.$desc.'"></a></td></tr>';
		}

		$func = '';
		$func .= System::admin()->SpeedButton('    ', $link_go, 'images/link_go.png', false, false, 'target="_blank"');
		$func .= System::admin()->SpeedButton('', $edit_url, 'images/admin/edit.png');
		$func .= System::admin()->SpeedAjax('', ADMIN_FILE.'?exe=news&a=deltopic&id='.$topic_id,'images/admin/delete.png', ' ?      -  .', '', "$('#topic_$topic_id').children('table').fadeOut('slow');");

		if($cntr % 4 == 0){
			$text .= '<tr>';
		}

		$text .= Indent('
			<td id="topic_$topic_id" valign="top" align="center" style="padding: 10px;">
				<table align="center" cellspacing="5" cellpadding="0">
					<tr>
						<td align="center">
							<b><a href="'.$edit_url.'">'.$title.'</a> ('.$counter.')</b>
						</td>
					</tr>
					'.$image.'
					<tr>
						<td align="center">'.$func.'</td>
					</tr>
				</table>
			</td>
		');

		if((++$cntr) % 4 == 0){
			$text .= '</tr>';
		}
	}
	if($cntr % 4 != 0) $text .= '</tr>';
	$text .= '</table>';
	AddText($text);

	System::admin()->FormTitleRow('   ');
	System::admin()->FormRow(' ', System::admin()->Edit('topic_name', '', false, 'maxlength="255" style="width:400px;"'));
	System::admin()->FormTextRow(' (HTML)', System::admin()->HtmlEditor('topic_description', '', 600, 200));

	FormRow('',
		System::admin()->FileManager('topic_image', '').
			'<br>
		<a href="images/no_image.png" class="filemanager_topic_image colorbox" data-content="href:path" target="_blank">
			<img src="images/no_image.png" class="filemanager_topic_image" data-content="src:tmb" style="margin-top: 5px; max-width: 250px;">
		</a>'
	);
	System::admin()->AddForm('<form name="topicsform" action="'.ADMIN_FILE.'?exe=news&a=addtopic" method="post" name="topicsform">', System::admin()->Submit(''));
}

/*
 *   
 */
function AdminNewsEditTopic(){
	global $news_access_edittopics;
	if(!isset($_GET['id']) || !$news_access_edittopics){
		System::admin()->AccessDenied();
	}
	AddCenterBox(' ');
	UseScript('jquery_ui', 'colorbox?theme=admin');

	$id = SafeEnv($_GET['id'], 11, int);
	System::database()->Select('news_topics', "`id`='".$id."'");
	$topic = System::database()->FetchRow();

	FormRow(' ', System::admin()->Edit('topic_name', SafeDB($topic['title'], 255, str), false, 'maxlength="255" style="width:400px;" class="autofocus"'));
	FormTextRow(' (HTML)', System::admin()->HtmlEditor('topic_description', SafeDB($topic['description'], 255, str), 600, 200));

	$image = SafeDB($topic['image'], 255, str);
	list($width, $height) = SafeDB(explode(':', System::config('news/topics_tmb_size')), 11, int);
	FormRow('',
		System::admin()->FileManager('topic_image', $image).
			'<br>
		<a href="'.$image.'" class="filemanager_topic_image colorbox" data-content="href:path" target="_blank">
			<img src="'.GetThumb($image, $width, $height).'" class="filemanager_topic_image" data-content="src:tmb" style="margin-top: 5px; max-width: 250px;">
		</a>'
	);

	AddForm(
		'<form name="topicsform" action="'.ADMIN_FILE.'?exe=news&a=savetopic&id='.$id.'" method="post" enctype="multipart/form-data" name="topicsform">',
		System::admin()->Button('', 'onclick="history.go(-1);"').System::admin()->Submit('')
	);
}

/*
 *  
 */
function AdminNewsTopicSave(){
	global $news_access_edittopics, $action;

	if(!$news_access_edittopics){
		System::admin()->AccessDenied();
	}

	$image = SafeEnv($_POST['topic_image'], 255, str, true);

	if($action == 'addtopic'){
		$values = Values('', SafeEnv($_POST['topic_name'], 255, str), SafeEnv($_POST['topic_description'], 255, str), $image, '0');
		System::database()->Insert('news_topics', $values);
		Audit(':    "'.$_POST['topic_name'].'"');
	}elseif($action == 'savetopic'){
		$id = SafeEnv($_GET['id'], 11, int);
		System::database()->Select('news_topics', "`id`='".$id."'");
		$topic = System::database()->FetchRow();
		$values = Values('', SafeEnv($_POST['topic_name'], 255, str), SafeEnv($_POST['topic_description'], 255, str), $image, SafeEnv($topic['counter'], 11, int));
		System::database()->Update('news_topics', $values, "`id`='$id'", true);
		Audit('   "'.$_POST['topic_name'].'"');
	}

	GO(ADMIN_FILE.'?exe=news&a=topics');
}

/*
 *  
 */
function AdminNewsTopicsDelete(){
	global $news_access_edittopics;

	if(!isset($_GET['id']) || !$news_access_edittopics){
		exit('ERROR');
	}

	$id = SafeEnv($_GET['id'], 11, int);
	System::database()->Select('news_topics', "`id`='$id'");
	$topic = System::database()->FetchRow();

	$newsdb = System::database()->Select('news', "`topic_id`='$id'");
	foreach($newsdb as $news){
		System::database()->Delete('news_comments', '`object`=\''.SafeEnv($news['id'], 11, int).'\'');
	}
	System::database()->Delete('news', "`topic_id`='$id'");
	System::database()->Delete('news_topics', "`id`='$id'");

	AdminNewsClearBlockCache();

	Audit(':    "'.$topic['title'].'"');

	exit('OK');
}

