<?php

/*
 * LinkorCMS 1.4
 *  2012 LinkorCMS Development Group
 */

//  

if(!defined('VALID_RUN')){
	header("HTTP/1.1 404 Not Found");
	exit;
}

System::site()->SetTitle('');
System::site()->RssTitle = ' RSS';
System::site()->RssLink = System::config('general/site_url').'rss.php';

if(isset($_GET['op'])){
	$op = $_GET['op'];
}else{
	$op = 'main';
}

switch($op){
	case 'main': IndexNewsMain();
		break;
	case 'readfull': IndexNewsReadFull();
		break;
	case 'topics': IndexNewsTopics();
		break;
	// 
	case 'addpost':
		$id = intval(SafeEnv($_GET['news'], 11, int));
		$topic = SafeDB($_GET['topic'], 11, int);
		CommentsAddPost(
			$id,
			'news_comments',
			'news',
			'comments_counter',
			'allow_comments',
			"index.php?name=news&op=readfull&news=$id&topic=$topic",
			'news/{topic}/{news}/'
		);
		break;
	case 'savepost':
		if(CommentsEditPostSave(SafeEnv($_GET['news'], 11, int), 'news_comments')){
			break;
		}
	case 'editpost':
		CommentsEditPost('news_comments', "index.php?name=news&op=savepost&news=".SafeDB($_GET['news'], 11, int).'&back='.SafeDB($_GET['back'], 255, str));
		break;
	case 'deletepost':
		$id = intval(SafeEnv($_GET['news'], 11, int));
		$delete_url = 'index.php?name=news&op=deletepost&news='.$id.'&back='.SafeDB($_GET['back'], 255, str);
		CommentsDeletePost($id, 'news_comments', 'news', 'comments_counter', $delete_url);
		break;
	// //
	default: IndexNewsMain();
}

function IndexNewsFunc( $id ){
	return '&nbsp'
	.'<a href="'.ADMIN_FILE.'?exe=news&a=edit&id='.$id.'&back='.SaveRefererUrl().'" class="admin_edit_link"><img src="images/admin/edit.png" title=""></a>'
	.'<a href="'.ADMIN_FILE.'?exe=news&a=delete&id='.$id.'&back='.SaveRefererUrl().'&ok=0" class="admin_edit_link"><img src="images/admin/delete.png" title=""></a>';
}

function IndexNewsGetTopics(){
	System::database()->Select('news_topics','');
	$rs = array();
	while($topic = System::database()->FetchRow()){
		$rs[SafeDB($topic['id'], 11, int)] = $topic;
	}
	return $rs;
}

//   (  )
function IndexNewsAdd( &$news, $topic, $readfull=false ){
	$func = IndexNewsFunc(SafeDB($news['id'], 11, int));
	$img_view = SafeDB($news['img_view'],1,int);
	$link = Ufu('index.php?name=news&op=readfull&news='.SafeDB($news['id'], 11, int).'&topic='.SafeDB($news['topic_id'], 11, int), 'news/{topic}/{news}/');
	$topic_link = Ufu('index.php?name=news&topic='.SafeDB($news['topic_id'], 11, int), 'news/{topic}/');

	$vars['topic'] = $topic;
	$vars['id'] = SafeDB($news['id'],11,int);
	$vars['title'] = SafeDB($news['title'],255,str).(System::user()->isAdmin() ? $func : '');
	$vars['author'] = SafeDB($news['author'],255,str);

	$date = SafeDB($news['date'], 11, int);
	$vars['date'] = TimeRender($date);
	$vars['time'] = date('H:i', $date);
	$vars['day'] = date('d', $date);
	$vars['month'] = date('m', $date);
	$vars['year'] = date('y', $date);
	$vars['year_full'] = date('Y', $date);

	$vars['link'] = $link;
	$vars['cat_link'] = $topic_link;
	$vars['com_count'] = SafeDB($news['comments_counter'], 11, int);
	$vars['hit_count'] = SafeDB($news['hit_counter'], 11, int);
	$vars['admin'] = System::user()->isAdmin();

	if(strlen(strip_tags($news['end_text']))>0){ //    .
		$vars['full'] = '<a href="'.$link.'"> </a>';
		$read_more = true;
	}else{
		$vars['full'] = '';
		$read_more = false;
	}

	$image = SafeDB($news['icon'], 255, str);
	list($width, $height) = SafeDB(explode(':', System::config('news/tmb_size')), 11, int);
	if($image == '' || substr($image, 0, 7) == 'http://'){
		$vars['image'] = $image;
		$vars['image_url'] = false;
	}elseif($img_view == 1){ //  
		$vars['image'] = GetThumb($image, $width, $height);
		$vars['image_url'] = false;
	}elseif($img_view == 2){ // 
		$vars['image'] = GetThumb($image, $width, $height);
		$vars['image_url'] = $image;
	}elseif($img_view == 0){ // 
		$size = ImageSize($image);
		if($size['width'] > $width){
			$vars['image'] = GetThumb($image, $width, $height);
			$vars['image_url'] = $image;
		}else{
			$vars['image'] = $image;
			$vars['image_url'] = false;
		}
	}

	if(!$readfull){
	//  
		if($news['allow_comments']=='1'){
			$vars['com'] = '<a href="'.$link.'#comments">('.SafeDB($news['comments_counter'],11,int).')</a>';
		}else{
			$vars['com'] = '';
		}

		if($news['auto_br']=='1'){
			$news['start_text'] = SafeDB(nl2br($news['start_text']), 0, str, false, false);
		}else{
			$news['start_text'] = SafeDB($news['start_text'], 0, str, false, false);
		}
		$vars['text'] = $news['start_text'];

	}else{
	//  
		if(SafeDB($news['comments_counter'], 11, int) > 0){
			$vars['com_status'] = '';
		}else{
			$vars['com_status'] = '  ';
		}
		if($news['auto_br']=='1' && $read_more){
			$news['end_text'] = SafeDB(nl2br($news['end_text']), 0, str, false, false);
		}elseif($news['auto_br']=='0' && $read_more){
			$news['end_text'] = SafeDB($news['end_text'], 0, str, false, false);
		}elseif($news['auto_br']=='1' && !$read_more){
			$news['end_text'] = SafeDB(nl2br($news['start_text']), 0, str, false, false);
		}else{
			$news['end_text'] = SafeDB($news['start_text'], 0, str, false, false);
		}
		$vars['text'] = $news['end_text'];
	}

	System::site()->AddSubBlock('news', true, $vars);
}

//  
function IndexNewsMain(){
	System::site()->AddBlock('news',true,true);

	if(isset($_GET['page'])){
		$page = SafeEnv($_GET['page'], 10, int);
	}else{
		$page = 1;
	}

	$topics = IndexNewsGetTopics();
	if(isset($_GET['topic'])){
		$topic = SafeEnv($_GET['topic'], 11, int);
		$title = SafeDB($topics[$topic]['title'], 255, str);
		System::site()->SetTitle($title);
		System::site()->BreadCrumbAdd($title);
	}else{
		$topic = false;
	}

	$num = SafeDB(System::config('news/newsonpage'), 11, int); //   
	$news = System::database()->Select('news', GetWhereByAccess('view', "`enabled`='1'".($topic !== false ? " and `topic_id`='$topic'" : "")), null, 'date', true);

	//  
	$navigation = new Navigation($page);
	$nav_link = Ufu('index.php?name=news'.($topic != 0 ? '&topic='.$topic : ''), 'news/'.($topic != 0 ? '{topic}/' : '').'page-{page}/', true);
	$navigation->FrendlyUrl = System::config('general/ufu');
	$navigation->GenNavigationMenu($news, $num, $nav_link);

	if(count($news)>0){
		System::site()->AddTemplatedBox('','module/news.html');
		foreach($news as $s){
			IndexNewsAdd($s, SafeDB($topics[$s['topic_id']]['title'], 255, str), false);
		}
	}else{
		if($topic===false){
			$NewsContent = '<p align="center">  </p>';
		}else{
			$NewsContent = '<p align="center">     </p>';
		}
		System::site()->AddTextBox('', $NewsContent);
	}
}

//  
function IndexNewsTopics(){
	$title = ' ';
	System::site()->SetTitle($title);
	System::site()->BreadCrumbAdd($title);
	$topics = IndexNewsGetTopics();
	if(count($topics) == 0){
		System::site()->AddTextBox(' ', '<p align="center">   .</p>');
	}else{
		System::site()->AddTemplatedBox(' ', 'module/news_topics.html');
		System::site()->AddBlock('news_topics', true, true, 'newstopic');
		foreach($topics as $topic){
			$vars = array();
			$image = SafeDB($topic['image'], 255, str);
			if($image == '' || substr($image, 0, 7) == 'http://'){
				$vars['image'] = $image;
				$vars['image_url'] = false;
			}else{
				$size = ImageSize($image);
				list($width, $height) = SafeDB(explode(':', System::config('news/topics_tmb_size')), 11, int);
				if($size['width'] > $width){
					$vars['image'] = GetThumb($image, $width, $height);
					$vars['image_url'] = $image;
				}else{
					$vars['image'] = $image;
					$vars['image_url'] = false;
				}
			}
			$vars['url'] = Ufu('index.php?name=news&topic='.SafeDB($topic['id'], 11, int), 'news/{topic}/');
			$vars['desc'] = SafeDB($topic['description'],255,str);
			$vars['title'] = SafeDB($topic['title'],255,str);
			$vars['num_news'] = SafeDB($topic['counter'],11,int);
			System::site()->AddSubBlock('news_topics',true,$vars);
		}
	}
}

//  
function IndexNewsReadFull(){
	System::site()->AddTemplatedBox('', 'module/news_full.html');
	System::site()->AddBlock('news', true, true);
	if(isset($_GET['news'])){
		$topics = IndexNewsGetTopics();
		$news_id = SafeEnv($_GET['news'],11,int);
		$news = System::database()->SelectOne('news', GetWhereByAccess('view', "`id`='$news_id'"));
		if($news && $news['enabled']=='1'){ //  
			System::site()->SetTitle(SafeDB($news['title'],255,str));

			$topic_id = SafeDB($news['topic_id'], 11, int);
			$topic_title = SafeDB($topics[$topic_id]['title'], 255, str);
			System::site()->BreadCrumbAdd($topic_title, Ufu('index.php?name=news&topic='.$topic_id, 'news/{topic}/'));

			System::site()->BreadCrumbAdd(SafeDB($news['title'], 255, str));

			// SEO
			System::site()->SeoTitle = SafeDB($news['seo_title'], 255, str);
			System::site()->SeoKeyWords = SafeDB($news['seo_keywords'], 255, str);
			System::site()->SeoDescription = SafeDB($news['seo_description'], 255, str);
			//

			IndexNewsAdd($news, $topic_title, true);
			System::database()->Update('news', "hit_counter='".(SafeEnv($news['hit_counter'],11,int)+1)."'","`id`='".$news_id."'");

			//  
			if(isset($_GET['page'])){
				$page = SafeEnv($_GET['page'], 11, int);
			}else{
				$page = 0;
			}
			include_once(System::config('inc_dir').'posts.class.php');
			$posts = new Posts('news_comments', $news['allow_comments'] == '1');
			$posts->EditPageUrl = "index.php?name=news&op=editpost&news=$news_id";
			$posts->DeletePageUrl = "index.php?name=news&op=deletepost&news=$news_id";
			$posts->PostFormAction = "index.php?name=news&op=addpost&news=$news_id&topic=$topic_id&page=$page";

			$posts->NavigationUrl = Ufu("index.php?name=news&op=readfull&news=$news_id&topic=$topic_id", 'news/{topic}/{news}/page{page}/', true);
			$posts->NavigationAnchor = '#comments';
			$posts->RenderPosts($news_id, 'news_comments', 'comments_navigation', false, $page);
			$posts->RenderForm(false, 'news_comments_form');
		}else{
			System::site()->AddTextBox('','<p align="center">      !<br><input type="button" value="" onclick="history.back();"></p>');
		}
	}else{
		System::site()->AddTextBox('','<p align="center"><input type="button" value="" onclick="history.back();"></p>');
	}
}
