<?php

/*
 * LinkorCMS 1.4
 *  2012 LinkorCMS Development Group
 */


if(!defined('VALID_RUN')){
	header("HTTP/1.1 404 Not Found");
	exit;
}

System::admin()->AddSubTitle('');

if(!System::user()->CheckAccess2('pages', 'pages')){
	System::admin()->AccessDenied();
}

if(isset($_GET['a'])){
	$action = $_GET['a'];
}else{
	$action = 'main';
}

TAddToolLink('', 'main', 'pages');
TAddToolLink(' ', 'editor', 'pages&a=editor');
TAddToolLink(' ', 'link', 'pages&a=link');
TAddToolLink(' ', 'cat', 'pages&a=cat');
TAddToolLink('', 'config', 'pages&a=config');
TAddToolBox($action);

switch($action){
	case 'main':
	case 'ajaxtree':
	case 'ajaxnode': AdminPagesAjaxTree();
		break;
	case 'ajaxmove': AdminPagesAjaxMove();
		break;
	case 'delete': AdminPagesDelete();
		break;
	case 'editor': AdminPagesEditor();
		break;
	case 'preview': AdminPagesPreview();
		break;
	case 'save': AdminPagesSave();
		break;
	case 'link': AdminPagesLinkEditor();
		break;
	case 'savelink': AdminPagesLinkSave();
		break;
	case 'cat': AdminPagesCatEditor();
		break;
	case 'savecat': AdminPagesCatSave();
		break;
	case 'changestatus': AdminPagesChangeStatus();
		break;
	case 'changemenu': AdminPagesChangeMenu();
		break;
	case 'resetcounter': AdminPagesResetCounter();
		break;
	case 'config':
		System::admin()->AddCenterBox('  ""');
		if(isset($_GET['saveok'])){
			System::admin()->Highlight(' .');
		}
		System::admin()->ConfigGroups('pages');
		System::admin()->AddConfigsForm(ADMIN_FILE.'?exe=pages&a=configsave');
		break;
	case 'configsave':
		System::admin()->SaveConfigs('pages');
		Audit(':   ');
		GO(ADMIN_FILE.'?exe=pages&a=config&saveok');
		break;
	default:AdminPagesAjaxTree();
}

/**
 *     
 * @return void
 */
function AdminPagesClearCache(){
	System::cache()->Delete('block', array('menu1', 'menu2', 'menu3', 'menu4'));
	System::cache()->Delete('tree', 'pages'); //  ,          
}

/**
 *     
 * @param  $parent_id
 * @return int
 */
function AdminPagesNewOrder( $parent_id ){
	System::database()->Select('pages', "`parent`='$parent_id'");
	return System::database()->NumRows();
}

/**
 *  Ajax  
 * @return void
 */
function AdminPagesAjaxTree(){
	UseScript('jquery_ui_treeview');
	if(CheckGet('parent')){
		$parent = SafeEnv($_GET['parent'], 11, int);
	}else{
		$parent = 0;
	}

	$pages = System::database()->Select('pages');
	SortArray($pages, 'order');
	$pages_tree = new Tree($pages);

	$elements = array();
	if($parent == 0){
		$func = '';
		$func .= SpeedButton('  ', ADMIN_FILE.'?exe=pages&a=editor', 'images/admin/page_add.png');
		$func .= SpeedButton('  ', ADMIN_FILE.'?exe=pages&a=link', 'images/admin/link_add.png');
		$func .= SpeedButton('  ', ADMIN_FILE.'?exe=pages&a=cat', 'images/admin/folder_add.png');
		$site_node = array(
			'id'=>'0',
			'title'=> System::config('general/site_name'),
			'icon'=> 'images/globe.png',
			'func'=>$func,
			'isnode'=>true,
			'opened'=>true,
			'childs'=>array()
		);
	}

	foreach($pages_tree->Cats[$parent] as $page){
		$id = SafeDB($page['id'], 11, int);
		if($page['type'] == 'page'){
			$link = Ufu('index.php?name=pages&file='.SafeDB($page['link'], 255, str), 'pages:page');
			$icon = 'images/page.png';
			$type = '';
			$counter = SafeDB($page['hits'], 11, int);
			$edit_link = ADMIN_FILE.'?exe=pages&a=editor&id='.$id;
		}elseif($page['type'] == 'link'){
			$link = SafeDB($page['text'], 255, str);
			if(substr($link, 0, 6) == 'mod://'){
				$link = Ufu('index.php?name='.substr($link, 6), '{name}/');
			}
			$icon = 'images/link.png';
			$type = '';
			$counter = '-&nbsp;';
			$edit_link = ADMIN_FILE.'?exe=pages&a=link&id='.$id;
		}else{
			$link = Ufu('index.php?name=pages&file='.SafeDB($page['link'], 255, str), 'pages:page');
			$icon = 'images/folder.png';
			$type = '';
			$counter = '-&nbsp;';
			$edit_link = ADMIN_FILE.'?exe=pages&a=cat&id='.$id;
		}
		$func = '';
		$func .= System::admin()->SpeedButton('  ', ADMIN_FILE.'?exe=pages&a=editor&parent='.$id, 'images/admin/page_add.png');
		$func .= System::admin()->SpeedButton('  ', ADMIN_FILE.'?exe=pages&a=link&parent='.$id, 'images/admin/link_add.png');
		$func .= System::admin()->SpeedButton('  ', ADMIN_FILE.'?exe=pages&a=cat&parent='.$id, 'images/admin/folder_add.png');
		$func .= '&nbsp;';
		$func .= System::admin()->SpeedStatus('  ', '  ', ADMIN_FILE.'?exe=pages&a=changemenu&id='.$id, $page['showinmenu'] == '1', 'images/menu_enabled.png', 'images/menu_disabled.png');
		$func .= System::admin()->SpeedStatus('', '', ADMIN_FILE.'?exe=pages&a=changestatus&id='.$id, $page['enabled'] == '1', 'images/bullet_green.png', 'images/bullet_red.png');
		$func .= '&nbsp;';
		$func .= System::admin()->SpeedButton('', $edit_link, 'images/admin/edit.png');

		$func .= System::admin()->SpeedConfirmJs(
			'',
			'$(\'#tree_container\').treeview(\'deleteNode\', '.$id.');',
			'images/admin/delete.png',
			'   ?      -  .'
		);

		$view = ViewLevelToStr(SafeDB($page['view'], 1, int));
		$info = Indent("
			<b></b>: $type<br />
			".($page['type'] == 'page' ? "<b></b>: $counter<br />" : '' )."
			<b></b>: $view<br />
			<b></b>: <a href=\"$link\" target=\"_blank\">/".Utf8ToCp1251(rawurldecode($link))."</a>
		");

		$elements[] = array(
			'id'=>$id,
			'icon'=>$icon,
			'title'=>'<b>'.System::admin()->Link(SafeDB($page['title'], 255, str), $edit_link).'</a></b>',
			'info'=>$info,
			'func'=>$func,
			'isnode'=>isset($pages_tree->Cats[$id]),
			'child_url'=>'admin.php?exe=pages&a=ajaxtree&parent='.$id,
		);
	}

	if($parent == 0){
		$site_node['childs'] = &$elements;
		$tree = array(&$site_node);
	}else{
		$tree = &$elements;
	}

	if($parent == 0){
		System::admin()->AddOnLoadJS('$("#tree_container").treeview({move: \''.ADMIN_FILE.'?exe=pages&a=ajaxmove\', del: \''.ADMIN_FILE.'?exe=pages&a=delete\', tree: '.JsonEncode($tree).'});');
		AddTextBox('', '<div id="tree_container"></div>');
	}else{
		echo JsonEncode($tree);
		exit;
	}
}

/**
 *  
 * @return void
 */
function AdminPagesEditor(){
	$link = '';
	$parent_id = -1;
	if(isset($_GET['parent'])){
		$parent_id = SafeEnv($_GET['parent'], 11, int);
	}
	$page_id = -1;
	$title = '';
	$text = '<p></p>';
	$copy = '';
	$auto_br = false;
	$info = array(false, false, false, false, false);
	$view = 4;
	$enabled = true;
	$showinmenu = true;

	// SEO
	$seo_title = '';
	$seo_keywords = '';
	$seo_description = '';
	//

	if(isset($_GET['id'])){
		$page_id = SafeEnv($_GET['id'], 11, int);
		System::database()->Select('pages', "`id`='".$page_id."'");
		$page       = System::database()->FetchRow();
		$link       = SafeDB($page['link'], 255, str);
		$parent_id  = SafeDB($page['parent'], 11, int);
		$title      = SafeDB($page['title'], 255, str);
		$text       = SafeDB($page['text'], 0, str, false);
		$copy       = SafeDB($page['copyright'], 255, str);
		$auto_br    = SafeDB($page['auto_br'], 1, bool);
		$inf        = SafeDB($page['info_showmode'], 5, str);
		$info       = array($inf[0], $inf[1], $inf[2], $inf[3], $inf[4]);
		$view       = SafeDB($page['view'], 1, int);
		$enabled    = SafeDB($page['enabled'], 1, bool);
		$showinmenu = SafeDB($page['showinmenu'], 1, bool);
		// SEO
		$seo_title       = SafeDB($page['seo_title'], 255, str);
		$seo_keywords    = SafeDB($page['seo_keywords'], 255, str);
		$seo_description = SafeDB($page['seo_description'], 255, str);
		//
		$url       = '&id='.$page_id;
		$submit    = ' ';
		$box_title = ' ';
	}
	else{
		$url       = '';
		$submit    = '';
		$box_title = ' ';
	}

	System::admin()->AddJS(Indent('
		PagesPreviewOpen = function(){
			if(tinyMCE){
				tinyMCE.triggerSave();
			}
			var form_data = Admin.SerializeFormData(document.forms.pages_editor);
			var left = parseInt(screen.width / 2) - 400;
			var top = parseInt(screen.height / 10);
			var wp = window.open("", "Preview", "resizable=yes,scrollbars=yes,menubar=no,status=no,location=no,width=800,height=600,left="+left+",top="+top+"");
			wp.document.open();
			$.ajax({
				type: "POST",
				url: "'.ADMIN_FILE.'?exe=pages&a=preview'.$url.'",
				data: form_data,
				dataType: "html",
				success: function(data){
					wp.document.write(data);
					wp.document.close();
				}
			});
		}
	'));

	//   
	$pages = System::database()->Select('pages');
	SortArray($pages, 'order');
	$tree = new Tree($pages);
	$cats_data = $tree->GetCatsData($parent_id, false, true, $page_id, true);

	FormRow(' ', System::site()->Select('parent_id', $cats_data, false, ($parent_id == -1 ? 'class="autofocus"' : '')));
	FormRow('', System::site()->Edit('title', $title, false, 'style="width:400px;" maxlength="255"'.($parent_id != -1 ? ' class="autofocus"' : '')));
	FormRow('', System::site()->Edit('link', $link, false, 'style="width:400px;"'));

	// SEO
	FormRow('[seo]  ', System::site()->Edit('seo_title', $seo_title, false, 'style="width:400px;"'));
	FormRow('[seo]  ', System::site()->Edit('seo_keywords', $seo_keywords, false, 'style="width:400px;"'));
	FormRow('[seo] ', System::site()->Edit('seo_description', $seo_description, false, 'style="width:400px;"'));
	//
	FormTextRow(' (HTML)', System::site()->HtmlEditor('text', $text, 600, 400));
	FormRow('   HTML', System::admin()->Select('auto_br', GetEnData($auto_br, '', '')));

	FormRow(' ', System::site()->Edit('copy', $copy, false, 'style="width:400px;" maxlength="255"'));
	FormRow('   ',
		'<label>'.System::site()->Check('ins_title', '1', $info[0]).'</label><br />'
		.'<label>'.System::site()->Check('ins_copy', '1', $info[1]).' </label><br />'
		.'<label>'.System::site()->Check('ins_date', '1', $info[2]).' </label><br />'
		.'<label>'.System::site()->Check('ins_modified', '1', $info[3]).'  ( )</label><br />'
		.'<label>'.System::site()->Check('ins_counter', '1', $info[4]).' </label>'
	);
	FormRow(' ', System::site()->Select('view', GetUserTypesFormData($view)));
	FormRow('  ', System::admin()->Select('showinmenu', GetEnData($showinmenu, '', '')));
	FormRow('', System::admin()->Select('enabled', GetEnData($enabled, '', '')));

	AddCenterBox($box_title);
	AddForm('<form action="'.ADMIN_FILE.'?exe=pages&a=save'.$url.'" method="post" name="pages_editor">',
		System::site()->Button('', 'onclick="history.go(-1)"')
		.System::admin()->Button('', 'onclick="PagesPreviewOpen();"')
		.System::site()->Submit($submit)
	);
}

function AdminPagesPreview(){
	$_POST = ObjectUtf8ToCp1251($_POST);

	$preview = new Page('module/page.html', '', false, PAGE_SPECIAL);
	$preview->Doctype = '<!DOCTYPE html>';
	$preview->AddCSSFile('style.css');

	$hits = 0;
	$modified = time();
	$public = time();

	if(isset($_GET['id'])){
		$page_id = SafeEnv($_GET['id'], 11, int);
		System::database()->Select('pages', "`id`='$page_id'");
		$page = System::database()->FetchRow();
		$hits = SafeDB($page['hits'], 11, int);
		$modified = $page['modified'];
		$public = $page['date'];
	}

	$preview->AddBlock('page');
	$vars = array();
	$vars['show_title'] = isset($_POST['ins_title']);
	$vars['show_copy'] = isset($_POST['ins_copy']);
	$vars['show_public'] = isset($_POST['ins_date']);
	$vars['show_modified'] = isset($_POST['ins_modified']);
	$vars['show_hits'] = isset($_POST['ins_counter']);
	$vars['show_info'] = $vars['show_copy'] || $vars['show_public'] || $vars['show_modified'] || $vars['show_hits'];
	$vars['title'] = SafeDB($_POST['title'], 255, str);
	if($_POST['auto_br'] == '1'){
		$text = nl2br(SafeDB($_POST['text'], 0, str, false, false));
	}else{
		$text = SafeDB($_POST['text'], 0, str, false, false);
	}
	$vars['text'] = $text;
	$vars['copyright'] = '&copy; '.SafeDB($_POST['copy'], 255, str);
	$vars['public'] = ': '.TimeRender($public);
	$vars['hits'] = ': '.$hits;
	$vars['modified'] = ': '.TimeRender($modified);

	$preview->SetTitle($vars['title']);

	$preview->SetVars('page', $vars);
	$preview->TEcho(false, false);
	exit();
}

/**
 *   
 * @return void
 */
function AdminPagesSave(){
	$parent_id = SafeEnv($_POST['parent_id'], 11, int);
	$title = SafeEnv($_POST['title'], 255, str);
	$link = SafeEnv($_POST['link'], 255, str);
	if($link == ''){
		$link = SafeEnv(UfuLink($_POST['title']), 255, str);
	}
	$text = SafeEnv($_POST['text'], 0, str);
	$copy = SafeEnv($_POST['copy'], 255, str);
	$auto_br = EnToInt($_POST['auto_br']);
	// SEO
	$seo_title = SafeEnv($_POST['seo_title'], 255, str);
	$seo_keywords = SafeEnv($_POST['seo_keywords'], 255, str);
	$seo_description = SafeEnv($_POST['seo_description'], 255, str);
	//
	$inf = '';
	if(isset($_POST['ins_title'])){
		$inf .= '1';
	}else{
		$inf .= '0';
	}
	if(isset($_POST['ins_copy'])){
		$inf .= '1';
	}else{
		$inf .= '0';
	}
	if(isset($_POST['ins_date'])){
		$inf .= '1';
	}else{
		$inf .= '0';
	}
	if(isset($_POST['ins_modified'])){
		$inf .= '1';
	}else{
		$inf .= '0';
	}
	if(isset($_POST['ins_counter'])){
		$inf .= '1';
	}else{
		$inf .= '0';
	}
	$view = ViewLevelToInt($_POST['view']);
	$enabled = EnToInt($_POST['enabled']);
	$showinmenu = EnToInt($_POST['showinmenu']);
	if(!isset($_GET['id'])){
		$add_date = time();
		$modified = $add_date;
		$counter = 0;
		$order = AdminPagesNewOrder($parent_id);
		$values = Values('', $parent_id, $title, $text, $copy, $add_date, $modified, $counter, $auto_br, $inf, $link, $view, $enabled, $seo_title, $seo_keywords, $seo_description, 'page', $order, $showinmenu);
		System::database()->Insert('pages', $values);
		Audit(':   "'.$title.'"');
	}else{
		$id = SafeEnv($_GET['id'], 11, int);
		System::database()->Select('pages', "`id`='".$id."'");
		$page = System::database()->FetchRow();
		$add_date = SafeDB($page['date'], 11, int);
		$modified = time(); //  
		$counter = SafeDB($page['hits'], 11, int);
		$order = SafeDB($page['order'], 11, int);
		$values = Values('', $parent_id, $title, $text, $copy, $add_date, $modified, $counter, $auto_br, $inf, $link, $view, $enabled, $seo_title, $seo_keywords, $seo_description, 'page', $order, $showinmenu);
		System::database()->Update('pages', $values, "`id`='".$id."'", true);
		Audit(':   "'.$title.'"');
	}
	AdminPagesClearCache();
	GO(ADMIN_FILE.'?exe=pages');
}

/**
 *  
 * @return void
 */
function AdminPagesLinkEditor(){
	UseScript('jquery');
	System::admin()->AddJS(Indent(<<<JS
		SelectLinkType = function(first){
			if(first){
				var url = $('#link_url').val();
				$('#link_mods > option').prop('selected', false);
				if(url.substr(0, 6) == 'mod://'){
					var mod = url.substr(6);
					$('#link_mod_'+mod).prop('selected', true);
					$('.link_form_row').hide();
				}else{
					$('#link_mod').prop('selected', true);
					$('.link_form_row').show();
				}
			}else{
				var v = $('#link_mods').val();
				if(v == ''){
					$('.link_form_row').fadeIn(1000);
				}else{
					$('.link_form_row').hide();
				}
			}
		};
JS
	));

	System::admin()->AddOnLoadJS("SelectLinkType(true);");

	$link = '';
	$id = -1;
	$title = '';
	$parent_id = -1;
	if(isset($_GET['parent'])){
		$parent_id = SafeEnv($_GET['parent'], 11, int);
	}
	$view = array(1 => false, 2 => false, 3 => false, 4 => false);
	$enabled = true;
	$showinmenu = true;
	if(!isset($_GET['id'])){
		$view[4] = true;
		$form_title = ' ';
		$submit = '';
	}else{
		$id = SafeEnv($_GET['id'], 11, int);
		System::database()->Select('pages', "`id`='$id'");
		$pg = System::database()->FetchRow();
		$parent_id = SafeEnv($pg['parent'], 11, int);
		$title = SafeEnv($pg['title'], 255, str);
		$link = SafeEnv($pg['text'], 255, str);
		$view[SafeDB($pg['view'], 1, int)] = true;
		$enabled = SafeDB($pg['enabled'], 1, bool);
		$showinmenu = SafeDB($pg['showinmenu'], 1, bool);
		$form_title = ' ';
		$submit = ' ';
	}

	//   
	$pages = System::database()->Select('pages');
	SortArray($pages, 'order');
	$tree = new Tree($pages);
	$cats_data = $tree->GetCatsData($parent_id, false, true, $id, true);

	//  
	$visdata = array();
	System::site()->DataAdd($visdata, 'all', '', $view['4']);
	System::site()->DataAdd($visdata, 'members', ' ', $view['2']);
	System::site()->DataAdd($visdata, 'guests', ' ', $view['3']);
	System::site()->DataAdd($visdata, 'admins', ' ', $view['1']);

	// 
	$modules_data = array();
	$mods = System::database()->Select('modules', "`enabled`='1' and `isindex`='1'");
	System::site()->DataAdd($modules_data, '', '--- URL ---', false, 'id="link_mod"');
	foreach($mods as $mod){
		$folder = SafeDB($mod['folder'], 255, str);
		System::site()->DataAdd($modules_data, $folder, SafeDB($mod['name'], 255, str), false, 'id="link_mod_'.$folder.'"');
	}

	//  
	System::admin()->FormRow(' ', System::site()->Select('parent_id', $cats_data, false, ($parent_id == -1 ? 'class="autofocus"' : '')));
	System::admin()->FormRow('', System::site()->Edit('title', $title, false, 'style="width:400px;" maxlength="255"'.($parent_id != -1 ? ' class="autofocus"' : '')));

	System::admin()->FormRow('  ', System::site()->Select('module', $modules_data, false, 'id="link_mods" onchange="SelectLinkType();"'));
	System::admin()->FormRow(' (URL)', System::site()->Edit('link', $link, false, 'style="width:400px;" id="link_url"'), 'class="link_form_row"');
	System::admin()->FormRow(' ', System::site()->Select('view', $visdata));

	System::admin()->FormRow('  ', System::admin()->Select('showinmenu', GetEnData($showinmenu, '', '')));
	System::admin()->FormRow('', System::admin()->Select('enabled', GetEnData($enabled, '', '')));

	System::admin()->AddCenterBox($form_title);
	System::admin()->AddForm(
		System::admin()->FormOpen(ADMIN_FILE.'?exe=pages&a=savelink'.($id != -1 ? '&id='.$id : '')),
		System::admin()->Button('', 'onclick="history.go(-1)"').System::admin()->Submit($submit)
	);
}

/**
 *   
 * @return void
 */
function AdminPagesLinkSave(){
	$parent_id = SafeEnv($_POST['parent_id'], 11, int);
	$title = SafeEnv($_POST['title'], 255, str);
	$link = SafeEnv(UfuLink($_POST['title']), 255, str);
	if($_POST['module'] != ''){
		$url = 'mod://'.SafeEnv($_POST['module'], 255, str);
	}else{
		$url = SafeEnv($_POST['link'], 255, str);
	}
	$view = ViewLevelToInt($_POST['view']);
	$enabled = EnToInt($_POST['enabled']);
	$showinmenu = EnToInt($_POST['showinmenu']);
	if(isset($_GET['id'])){
		$id = SafeEnv($_GET['id'], 11, int);
		System::database()->Select('pages', "`id`='".$id."'");
		$page = System::database()->FetchRow();
		$order = SafeDB($page['order'], 11, int);
	}else{
		$order = AdminPagesNewOrder($parent_id);
	}
	$values = Values('', $parent_id, $title, $url, '', time(), time(), '0', '0', '', $link, $view, $enabled, '', '', '', 'link', $order, $showinmenu);
	if(isset($_GET['id'])){ // 
		$id = SafeEnv($_GET['id'], 11, int);
		System::database()->Update('pages', $values, "`id`='".$id."'", true);
		Audit(':   "'.$title.'"');
	}else{
		System::database()->Insert('pages', $values);
		Audit(':   "'.$title.'"');
	}
	AdminPagesClearCache();
	GO(ADMIN_FILE.'?exe=pages');
}

/**
 *  
 * @return void
 */
function AdminPagesCatEditor(){
	$id = -1;
	$title = '';
	$parent_id = -1;
	if(isset($_GET['parent'])){
		$parent_id = SafeEnv($_GET['parent'], 11, int);
	}
	$view = array(1 => false, 2 => false, 3 => false, 4 => false);
	$enabled = true;
	$showinmenu = true;
	if(!isset($_GET['id'])){
		$view[4] = true;
		$form_title = ' ';
		$submit = '';
	}else{
		$id = SafeEnv($_GET['id'], 11, int);
		System::database()->Select('pages', "`id`='$id'");
		$pg = System::database()->FetchRow();
		$parent_id = SafeEnv($pg['parent'], 11, int);
		$title = SafeEnv($pg['title'], 255, str);
		$view[SafeDB($pg['view'], 1, int)] = true;
		$enabled = SafeDB($pg['enabled'], 1, bool);
		$showinmenu = SafeDB($pg['showinmenu'], 1, bool);
		$form_title = ' ';
		$submit = ' ';
	}
	//   
	$pages = System::database()->Select('pages');
	SortArray($pages, 'order');
	$tree = new Tree($pages);

	$cats_data = $tree->GetCatsData($parent_id, false, true, $id, true);

	//  
	$visdata = array();
	System::site()->DataAdd($visdata, 'all', '', $view['4']);
	System::site()->DataAdd($visdata, 'members', ' ', $view['2']);
	System::site()->DataAdd($visdata, 'guests', ' ', $view['3']);
	System::site()->DataAdd($visdata, 'admins', ' ', $view['1']);

	FormRow(' ', System::site()->Select('parent_id', $cats_data, false, ($parent_id == -1 ? 'class="autofocus"' : '')));
	FormRow('', System::site()->Edit('title', $title, false, 'style="width:400px;" maxlength="255"'.($parent_id != -1 ? ' class="autofocus"' : '')));
	FormRow(' ', System::site()->Select('view', $visdata));

	FormRow('  ', System::admin()->Select('showinmenu', GetEnData($showinmenu, '', '')));
	FormRow('', System::admin()->Select('enabled', GetEnData($enabled, '', '')));

	AddCenterBox($form_title);
	AddForm('<form action="'.ADMIN_FILE.'?exe=pages&a=savecat'.($id != -1 ? '&id='.$id : '').'" method="post">', System::site()->Button('', 'onclick="history.go(-1)"').System::site()->Submit($submit));
}

/**
 *   
 * @return void
 */
function AdminPagesCatSave(){
	$parent_id = SafeEnv($_POST['parent_id'], 11, int);
	$title = SafeEnv($_POST['title'], 255, str);
	$link = SafeEnv(UfuLink($_POST['title']), 255, str);
	$view = ViewLevelToInt($_POST['view']);
	$enabled = EnToInt($_POST['enabled']);
	$showinmenu = EnToInt($_POST['showinmenu']);
	if(isset($_GET['id'])){
		$id = SafeEnv($_GET['id'], 11, int);
		System::database()->Select('pages', "`id`='".$id."'");
		$page = System::database()->FetchRow();
		$order = SafeDB($page['order'], 11, int);
	}else{
		$order = AdminPagesNewOrder($parent_id);
	}
	$values = Values('', $parent_id, $title, '', '', time(), time(), '0', '0', '', $link, $view, $enabled, '', '', '', 'cat', $order, $showinmenu);
	if(isset($_GET['id'])){ // 
		System::database()->Update('pages', $values, "`id`='".$id."'", true);
		Audit(':   "'.$title.'"');
	}else{
		System::database()->Insert('pages', $values);
		Audit(':   "'.$title.'"');
	}
	AdminPagesClearCache();
	GO(ADMIN_FILE.'?exe=pages');
}

/**
 *     
 * @return void
 */
function AdminPagesChangeStatus(){
	$page_id = SafeEnv($_GET['id'], 11, int);
	System::database()->Select('pages', "`id`='$page_id'");
	$page = System::database()->FetchRow();
	if($page['enabled'] == 1){
		$en = '0';
	}else{
		$en = '1';
	}
	System::database()->Update('pages', "enabled='$en'", "`id`='$page_id'");
	Audit(':    "'.$page['title'].'"');
	AdminPagesClearCache();
	if(IsAjax()){
		echo 'OK';
		exit;
	}else{
		GO(ADMIN_FILE.'?exe=pages');
	}
}

/**
 *        
 * @return void
 */
function AdminPagesChangeMenu(){
	$page_id = SafeEnv($_GET['id'], 11, int);
	System::database()->Select('pages', "`id`='$page_id'");
	$page = System::database()->FetchRow();
	if($page['showinmenu'] == 1){
		$en = '0';
	}else{
		$en = '1';
	}
	System::database()->Update('pages', "showinmenu='$en'", "`id`='$page_id'");
	Audit(':       "'.$page['title'].'"');
	AdminPagesClearCache();
	if(IsAjax()){
		echo 'OK';
		exit;
	}else{
		GO(ADMIN_FILE.'?exe=pages');
	}
}

function _DeletePage($id){
	$sub_items = System::database()->Select('pages', "`parent`='$id'");
	foreach($sub_items as $item){
		_DeletePage(SafeEnv($item['id'], 11, int));
	}
	System::database()->Delete('pages', "`id`='$id'");
}

/**
 *    
 * @return void
 */
function AdminPagesDelete(){
	if(!isset($_POST['id'])){
		exit('ERROR');
	}
	$page_id = SafeEnv($_POST['id'], 11, int);
	System::database()->Select('pages', "`id`='$page_id'");
	$page = System::database()->FetchRow();
	_DeletePage($page_id);
	Audit(':  "'.$page['title'].'"');
	AdminPagesClearCache();
	exit('OK');
}

/**
 *    
 * @return void
 */
function AdminPagesResetCounter(){
	$page_id = SafeEnv($_POST['id'], 11, int);
	System::database()->Select('pages', "`id`='$page_id'");
	$page = System::database()->FetchRow();
	System::database()->Update('pages', "hits='0'", "`id`='".SafeEnv($_GET['id'], 11, int)."'");
	Audit(':  "'.$page['title'].'"');
	GO(ADMIN_FILE.'?exe=pages');
}

/**
 *       
 * @return void
 */
function AdminPagesAjaxMove(){
	$itemId = SafeEnv($_POST['item_id'], 11, int);
	$parentId = SafeEnv($_POST['target_id'], 11, int);
	$position = SafeEnv($_POST['item_new_position'], 11, int);

	//  
	System::database()->Select('pages',"`id`='$itemId'");
	if(System::database()->NumRows() == 0){
		// Error
		exit;
	}
	$item = System::database()->FetchRow();
	//   ,  
	if($item['parent'] != $parentId){
		System::database()->Update('pages', "`parent`='$parentId'", "`id`='$itemId'");
	}
	//   
	$indexes = array(); //    id 
	$items = System::database()->Select('pages',"`parent`='$parentId'");
	if($position == -1){
		$position = count($items);
	}
	SortArray($items, 'order');
	$i = 0;
	foreach($items as $p){
		if($p['id'] == $itemId){
			$indexes[$p['id']] = $position;
		}else{
			if($i == $position) $i++;
			$indexes[$p['id']] = $i;
			$i++;
		}
	}
	//  
	foreach($indexes as $id=>$order){
		System::database()->Update('pages', "`order`='$order'", "`id`='$id'");
	}
	Audit(':  "'.$item['title'].'"');
	AdminPagesClearCache();
	exit;
}
