<?php

/*
 * LinkorCMS 1.4
 *  2012 LinkorCMS Development Group
 */


if(!defined('VALID_RUN')){
	header("HTTP/1.1 404 Not Found");
	exit;
}

System::site()->SetTitle('  ');

global $searchstr, $search_results;
$searchstr = ''; //       
$search_results = array(); //     (  )

if(isset($_GET['op'])){
	$op = $_GET['op'];
}else{
	$op = 'main';
}

switch($op){
	case 'main':
		IndexSearchMain();
		break;
	case 'search':
		IndexSearchResults();
		break;
	default:
		HackOff();
}

//    (  )
function IndexSearchMain(){
	if(isset($_GET['mod'])){
		$mods = $_GET['mod'];
		$all = false;
	}else{
		$mods = array();
		$all = true;
	}

	//   
	System::site()->AddBlock('search_form', true, false, 'form');
	$vars = array();
	$vars['form_name'] = 'search_form';
	$vars['url'] = 'index.php';
	$vars['lsubmit'] = '';
	$vars['searchstr'] = (isset($_GET['searchstr']) ? SafeDB($_GET['searchstr'], 255, str) : '');
	System::site()->SetVars('search_form', $vars);

	//    ()
	System::site()->AddBlock('search_modules', true, true, 'mod');
	$plugins = PluginsGetInfo('search');
	foreach($plugins as $mod){
		$vars = array();
		$vars['title'] = $mod['mod_title'];
		$vars['name'] = $mod['folder'];
		$vars['checked'] = in_array($mod['folder'], $mods) || $all;
		if($all){
			$mods[] = $mod['folder'];
		}
		System::site()->AddSubBlock('search_modules', true, $vars);
	}

	//  
	System::site()->AddTemplatedBox('  ', 'module/search_form.html');

	return $mods;
}

//   
function IndexSearchResults(){
	global $searchstr;

	//   ,  -     ( )
	$mods = IndexSearchMain();

	//  URL    
	$mods_str = '';
	foreach($mods as $i=>$mod){ //  
		$mods[$i] = $mod;
		$mods_str .= '&mod[]='.SafeDB($mods[$i], 255, str);
	}
	if(isset($_GET['searchstr'])){ //  
		$searchstr = $_GET['searchstr'];
	}else{
		System::site()->AddTextBox('', '<div style="text-align: center;">     .</div>');
		return;
	}
	$SearchUrl = 'index.php?name=search&op=search&searchstr='.urlencode(SafeDB($searchstr, 255, str)).$mods_str;

	// 
	if(isset($_GET['page'])){
		$page = SafeEnv($_GET['page'], 10, int);
	}else{
		$page = 1;
	}

	//   
	System::site()->BreadCrumbAdd('   "'.SafeDB($searchstr, 255, str).'"');

	// 
	$results = IndexSearchSearch($mods);

	//   
	usort($results, 'IndexSearchSortResults');

	//  
	if(count($results) > 0){
		$num = 20; //   
		$si = ($num * ($page-1));
		$navigation = new Navigation($page);
		$navigation->GenNavigationMenu($results, $num, $SearchUrl);
		System::site()->AddTemplatedBox(' ', 'module/search_results.html');
		System::site()->AddBlock('search_results', true, true, 'result');
		foreach($results as $i=>$result){
			$result['no'] = $si+$i+1;
			System::site()->AddSubBlock('search_results', true, $result);
		}
	}else{
		System::site()->AddTextBox('', '<div style="text-align: center;">     .</div>');
	}
}

//     
function IndexSearchSearch( $mods ){
	global $search_results;
	$search_results = array();
	foreach($mods as $mod){ // mod   function     
		$plugins = IncludePluginsGroup('search', $mod, true);
		foreach($plugins as $plugin){ //         
			$plugin_info = ExtLoadInfo($plugin);
			include($plugin.'index.php');
		}
	}
	return $search_results;
}

//     
function IndexSearchSortResults($a, $b){
	global $searchstr;
	return stripos($a['title'], $searchstr) !== false ? -1 : 1;
}