<?php

/*
 * LinkorCMS 1.4
 *  2012 LinkorCMS Development Group
 */


if(!defined('VALID_RUN')){
	header("HTTP/1.1 404 Not Found");
	exit;
}

System::site()->AddTemplatedBox('  '.Url(System::config('general/site_url')), 'module/sitemap.html');
$Sitemap = System::site()->NewBlock('sitemap', true, true, 'map');
global $sitemap_objects_block, $sitemap_objects, $sitemap_category;

/**
 *    ,        .
 * @param $Title
 */
function SitemapAddCategory($Title){
	global $sitemap_objects, $sitemap_category;
	$sitemap_category = $Title;
	$sitemap_objects[$Title] = array();

}

/**
 *        .
 * @param        $Level
 * @param        $Title
 * @param string $Url
 * @param string $Icon
 */
function SitemapAddObject($Level, $Title, $Url = '', $Icon = 'cat'){
	global $sitemap_objects, $sitemap_category;
	if($Icon != ''){
		if($Icon == 'cat'){
			$Icon = 'images/cat.gif';
		}
		elseif($Icon == 'folder'){
			$Icon = 'images/folder.png';
		}
		elseif($Icon == 'page'){
			$Icon = 'images/page.png';
		}
	}
	$sitemap_objects[$sitemap_category][] = array('is_raw' => false, 'margin' => 20 * $Level, 'title' => SafeDB($Title, 255, str), 'url' => $Url, 'icon' => $Icon);
}

/**
 *       .
 * @param $Data
 */
function SitemapAddRawData($Data){
	global $sitemap_objects, $sitemap_category;
	$sitemap_objects[$sitemap_category][] = array('is_raw' => true, 'raw_output' => SafeDB($Data, 0, str, false, false), 'margin' => 0,);
}

if(System::cache()->HasCache(system_cache, 'sitemap')){
	$sitemap_objects = System::cache()->Get(system_cache, 'sitemap');
}else{
	//     
	IncludePluginsGroup('sitemap');
	System::cache()->Write(system_cache, 'sitemap', $sitemap_objects, Day2Sec);
}

foreach($sitemap_objects as $title=>$objects){
	$sitemap_category = $Sitemap->NewSubBlock(true, array('title'=> SafeDB($title, 255, str)));
	$sitemap_objects_block  = $sitemap_category->NewBlock('sitemap_objects', true, true, 'object');
	foreach($objects as $vars){
		$sitemap_objects_block->NewSubBlock(true, $vars);
	}
}
