<?php

/*
 * LinkorCMS 1.4
 *  2012 LinkorCMS Development Group
 */


if(!defined('VALID_RUN')){
	header("HTTP/1.1 404 Not Found");
	exit;
}

System::admin()->AddSubTitle('');

if(!System::user()->CheckAccess2('smilies', 'smilies')){
	System::admin()->AccessDenied();
}

global $smilies_dir, $mod;
$smilies_dir = RealPath2(System::config('general/smilies_dir')).'/';
$mod = ADMIN_FILE.'?exe=smilies';

if(isset($_GET['a'])){
	$action = $_GET['a'];
}else{
	$action = 'main';
}

TAddToolLink('', 'main', 'smilies');
TAddToolLink(' ', 'add', 'smilies&a=add');
TAddToolLink('-', 'auto', 'smilies&a=auto');
TAddToolBox($action);
switch($action){
	case 'main': AdminSmilesMain();
		break;
	case 'add': AdminSmilesEditSmile();
		break;
	case 'delete': AdminSmilesDeleteSmile();
		break;
	case 'edit': AdminSmilesEditSmile();
		break;
	case 'save': AdminSmilesSave();
		break;
	case 'changestatus': AdminBlocksChangeStatus();
		break;
	case 'auto': AdminSmiliesAutoAdd();
		break;
	case 'autosave': AdminSmiliesAutoSave();
		break;
	case 'deletefile': AdminSmiliesDeleteFile();
		break;
	default:
		AdminSmilesMain();
}

function AdminSmiliesLoadInfo( $Path, $RelativePath, $Files ){
	$smilies_info = array();
	if(is_file($Path.'info.ini')){ //   LinkorCMS
		$info = file($Path.'info.ini');
		$lines = count($info);
		for($i=0; $i<$lines; $i+=3){
			$smilies_info[$RelativePath.trim($info[$i])] = array(
				'file' => $RelativePath.trim($info[$i]),
				'code' => trim($info[$i+1]),
				'desc' => trim($info[$i+2])
			);
		}
	}
	elseif(is_file($Path.'_define.ini')){ //   QIP
		$info = file($Path.'_define.ini');
		foreach($Files as $i=>$file){
			$smilies_info[$RelativePath.$file] = array(
				'file' => $RelativePath.$file,
				'code' => trim($info[$i]),
				'desc' => GetFileName($file, true)
			);
		}
	}
	return $smilies_info;
}

function AdminSmiliesGetData( $Selected, $Xor = array(), $RevertXor = false ){
	global $smilies_dir;

	$xor_smilies = array();
	foreach($Xor as $smile){
		$xor_smilies[] = $smile['file'];
	}

	$data = array();
	$smilies_info = AdminSmiliesFind($smilies_dir, $xor_smilies, $RevertXor);
	foreach($smilies_info as $file=>$info){
		$file = SafeDB($file, 255, str);
		$desc = SafeDB($info['desc'], 255, str);
		$code = SafeDB($info['code'], 255, str);
		System::site()->DataAdd($data, $file, $file, $file == $Selected, 'description="'.$desc.'" code="'.$code.'"');
	}
	return $data;
}

function AdminSmiliesFind( $DirName, $Xor = array(), $RevertXor = false, $New = true ){
	static $result = array();
	static $BasePath;
	if($New){
		$result = array();
		$BasePath = $DirName;
	}
	$files = array();
	$folders = array();
	$relative_path = str_replace($BasePath, '', $DirName);

	$dir = @opendir($DirName);
	while($file = @readdir($dir)){
		if(is_dir($DirName.$file) && ($file != '.') && ($file != '..')){
			$folders[] = $file;
		}else{
			$ext = GetFileExt($file);
			if($ext == '.gif' || $ext == '.png'){
				$file = $relative_path.$file;
				if(!in_array($file, $Xor) || $RevertXor){
					$files[] = $file;
				}
			}
		}
	}
	$info = AdminSmiliesLoadInfo($DirName, $relative_path, $files);
	foreach($files as $file){
		if(isset($info[$file])){
			$result[$file] = $info[$file];
		}else{
			$result[$file] = array(
				'file' => $file,
				'desc' => GetFileName($file, true),
				'code' => '*'.GetFileName($file, true).'*'
			);
		}
	}
	foreach($folders as $folder){
		AdminSmiliesFind($DirName.$folder.'/', $Xor, $RevertXor, false);
	}
	return $result;
}

function AdminSmilesMain(){
	global $smilies_dir, $mod;
	System::admin()->AddCenterBox('');
	System::database()->Select('smilies');
	$text = '<table cellspacing="0" cellpadding="0" class="cfgtable">';
	$text .= '<tr><th></th><th></th><th></th><th> </th><th></th><th></th></tr>';
	if(System::database()->NumRows() > 0){
		while($row = System::database()->FetchRow()){
			$sid = SafeDB($row['id'], 11, int);
			if(!is_file($smilies_dir.$row['file'])){
				System::database()->Delete('smilies', "`file`='".SafeEnv($row['file'], 255, str)."'");
				continue;
			}
			$en = System::admin()->SpeedStatus('', '', $mod.'&a=changestatus&id='.$sid, $row['enabled'] == '1');

			$func = '';
			$func .= System::admin()->SpeedButton('', $mod.'&a=edit&id='.$sid, 'images/admin/edit.png');
			$func .= System::admin()->SpeedConfirm('', $mod.'&a=delete&sid='.$sid, 'images/admin/delete.png', ' ?');

			$text .= "<tr>
			<td>".System::admin()->Link('<img src="'.$smilies_dir.$row['file'].'">', $mod.'&a=edit&id='.$sid)."</td>
			<td>{$row['code']}</td>
			<td>{$row['desc']}</td>
			<td>{$row['file']}</td>
			<td>$en</td>
			<td>$func</td>
			</tr>";
		}
	}else{
		$text .= '<tr><td colspan="6" style="text-align: left;"> .</td></tr>';
	}
	$text .= '</table>';
	AddText($text);
}

function AdminSmilesEditSmile(){
	global $smilies_dir, $mod;

	System::admin()->AddJS(Indent('
		SelectSmile = function(){
			var selected = $("#smile_file option:selected");
			$("#smile_image").prop("src", "'.$smilies_dir.'"+selected.val());
			$("#smile_code").val(selected.attr("code"));
			$("#smile_desc").val(selected.attr("description"));
		};
	'));

	$id = 0;
	$file = '';
	$code = '';
	$desc = '';
	$enabled = true;
	$box_title = ' ';
	$submit = '';
	if(isset($_GET['id'])){
		$id = SafeEnv($_GET['id'], 11, int);
		System::database()->Select('smilies', "`id`='$id'");
		$smile = System::database()->FetchRow();
		$file = $smile['file'];
		$code = SafeDB($smile['code'], 255, str);
		$desc = SafeDB($smile['desc'], 255, str);
		$enabled = SafeDB($smile['enabled'], 1, bool);
		$submit = '';
		$box_title = ' ';
		System::admin()->AddOnLoadJS('$("#smile_image").prop("src", "'.$smilies_dir.'"+$("#smile_file option:selected").val());');
	}else{
		System::admin()->AddOnLoadJS('SelectSmile();');
	}

	AddCenterBox($box_title);

	$smilies = System::database()->Select('smilies');
	$xor = array();
	if($id == 0){
		$xor = &$smilies;
	}else{
		foreach( $smilies as $smile ){
			if($smile['id'] != $id){
				$xor[] = $smile;
			}
		}

	}

	$smilies_data = AdminSmiliesGetData($file, $xor);
	if($id == 0 && count($smilies_data) == 0){
		System::admin()->Highlight('     <b>'.$smilies_dir.'</b>  .');
		return;
	}

	FormRow('', System::site()->Select('file', $smilies_data, false, 'onchange="SelectSmile()" id="smile_file" class="autofocus"'));
	FormRow('', '<img id="smile_image">');
	FormRow('', System::site()->Edit('code', $code, false, 'style="width: 200px;" id="smile_code"'));
	FormRow('', System::site()->Edit('desc', $desc, false, 'style="width: 200px;" id="smile_desc"'));
	FormRow('', System::admin()->Select('indexview', GetEnData($enabled, '', '')));

	AddForm('<form name="newsmile" action="'.$mod.'&a=save'.($id != 0 ? '&id='.$id : '').'" method="post">',
		System::site()->Button('', 'onclick="history.go(-1)"')
		.System::site()->Submit($submit));
}

function AdminSmilesSave(){
	global $mod;
	$code = SafeEnv($_POST['code'], 255, str);
	$desc = SafeEnv($_POST['desc'], 255, str);
	$file = SafeEnv($_POST['file'], 255, str);
	$enabled = EnToInt($_POST['indexview']);
	if(isset($_GET['id'])){
		$id = SafeEnv($_GET['id'], 11, int);
		$set = "`code`='$code',`desc`='$desc',`file`='$file',`enabled`='$enabled'";
		System::database()->Update('smilies', $set, "`id`='$id'");
		Audit(':   "'.$code.'"');
	}else{
		System::database()->Insert('smilies', Values('', $code, $desc, $file, $enabled));
		Audit(':   "'.$code.'"');
	}
	GO($mod);
}

function AdminSmilesDeleteSmile(){
	global $mod;
	$smile_id = SafeEnv($_GET['sid'], 11, int);
	System::database()->Select('smilies', "`id`='$smile_id'");
	$smile = System::database()->FetchRow();
	System::database()->Delete('smilies', "`id`='$smile_id'");
	Audit(':   "'.$smile['code'].'"');
	GO($mod);
}

function AdminBlocksChangeStatus(){
	global $mod;
	$smile_id = SafeEnv($_GET['sid'], 11, int);
	System::database()->Select('smilies', "`id`='$smile_id'");
	if(System::database()->NumRows() > 0){
		$smile = System::database()->FetchRow();
		if($smile['enabled'] == '1'){
			$en = '0';
		}else{
			$en = '1';
		}
		System::database()->Update('smilies', "enabled='$en'", "`id`='$smile_id'");
		Audit(':    "'.$smile['code'].'"');
	}
	GO($mod);
}

function AdminSmiliesAutoAdd(){
	global $mod, $smilies_dir;
	AddCenterBox('- ');

	$smilies = System::database()->Select('smilies');
	$xor_smilies = array();
	foreach($smilies as $smile){
		$xor_smilies[] = $smile['file'];
	}

	$find_smilies = AdminSmiliesFind($smilies_dir, $xor_smilies);
	if(count($find_smilies) == 0){
		System::admin()->Highlight('   .     : <b>'.$smilies_dir.'</b>.');
		return;
	}

	$text = '';
	$text .= System::site()->FormOpen(ADMIN_FILE.'?exe=smilies&a=autosave');
	$text .= '<table cellspacing="0" cellpadding="0" class="cfgtable">';
	$text .= '<tr>
		<th></th>
		<th></th>
		<th></th>
		<th></th>
		<th> </th>
		<th></th>
		<th></th>
	</tr>';

	foreach($find_smilies as $sm){
		$file = SafeDB($sm['file'], 255, str);
		$func = System::admin()->SpeedConfirm(' ', $mod.'&a=deletefile&name='.$file, 'images/admin/delete.png', '   ?');
		$text .= '<tr>'
		.'<td>'.System::site()->Check('smilies[]', $file, true).'</td>'
		.'<td><img src="'.$smilies_dir.$file.'"></td>'
		.'<td>'.System::site()->Edit('code['.$file.']', SafeDB($sm['code'], 255, str), false, 'style="width:160px;"').'</td>'
		.'<td>'.System::site()->Edit('desc['.$file.']', SafeDB($sm['desc'], 255, str), false, 'style="width:160px;"').'</td>'
		.'<td>'.$file.'</td>'
		.'<td>'.System::site()->Check('en['.$file.']', '1', true).'</td>'
		.'<td>'.$func.'</td>'
		.'</tr>';
	}
	$text .= '</table>';
	$text .= System::site()->Submit('').'<br /><br />';
	$text .= System::site()->FormClose();
	AddText($text);
}

function AdminSmiliesAutoSave(){
	global $mod;
	$count = count($_POST['smilies']);
	foreach($_POST['smilies'] as $file){
		$file = RealPath2(SafeEnv($file, 255, str));
		$code = SafeEnv($_POST['code'][$file], 255, str);
		$desc = SafeEnv($_POST['desc'][$file], 255, str);
		$disp = (isset($_POST['en'][$file]) ? '1' : '0');
		$vals = Values('', $code, $desc, $file, $disp);
		System::database()->Insert('smilies', $vals);
	}
	Audit(': -,  '.$count.' .');
	GO($mod);
}

function AdminSmiliesDeleteFile(){
	global $smilies_dir, $mod;
	$name = $_GET['name'];
	unlink(RealPath2($smilies_dir.$name));
	Audit(':    '.$smilies_dir.$name);
	GO($mod.'&a=auto');
}
