<?php

/*
 * LinkorCMS 1.4
 *  2012 LinkorCMS Development Group
 */


if(!defined('VALID_RUN')){
	header("HTTP/1.1 404 Not Found");
	exit;
}

System::site()->SetTitle('');

if(isset($_GET['op'])){
	$op = $_GET['op'];
}else{
	$op = 'userslist';
}

switch($op){
	case 'registration':
		System::site()->BreadCrumbAdd('');
		if(isset($_POST['condition']) || (System::config('user/view_conditions') == 'off' && !isset($_POST['usersave']))){
			IndexUserRegistration();
		}elseif(isset($_POST['usersave'])){
			IndexUserRegistrationOk();
		}else{
			IndexUserConditions();
		}
		break;
	case 'editprofile':
		System::site()->BreadCrumbAdd(' ');
		IndexUserRegistration(false, true);
		break;
	case 'userinfo':
		IndexUserInfo();
		break;
	case 'userslist':
		IndexUserlist();
		break;
	case 'forgotpass':
		IndexUserForgotPassword();
		break;
	case 'sendpassword':
		IndexUserSendPassword();
		break;
	case 'login':
		IndexUserLogOn();
		break;
	case 'exit':
		IndexUserLogOut();
		break;
	case 'activate':
		IndexUserActivate();
		break;
	default:
		HackOff();
}

function AcceptPost(&$login, &$pass, &$rpass, &$email, &$hideemail, &$nikname, &$realname, &$age, &$homepage, &$icq, &$city, &$avatar, &$apersonal, &$gmt, &$about, &$snews){
	if(isset($_POST['login'])){
		$login = substr($_POST['login'], 0, 30);
	}else{
		$login = '';
	}
	if(isset($_POST['pass'])){
		$pass = $_POST['pass'];
	}else{
		$pass = '';
	}
	if(isset($_POST['rpass'])){
		$rpass = $_POST['rpass'];
	}else{
		$rpass = '';
	}
	if(isset($_POST['email'])){
		$email = substr($_POST['email'], 0, 50);
	}else{
		$email = '';
	}
	if(isset($_POST['hideemail'])){
		$hideemail = true;
	}else{
		$hideemail = false;
	}
	if(isset($_POST['nikname'])){
		$nikname = substr($_POST['nikname'], 0, 50);
	}else{
		$nikname = '';
	}
	if(isset($_POST['realname'])){
		$realname = substr($_POST['realname'], 0, 250);
	}else{
		$realname = '';
	}
	if(isset($_POST['age'])){
		$age = substr($_POST['age'], 0, 3);
	}else{
		$age = '';
	}
	if(isset($_POST['homepage'])){
		$homepage = substr(Url($_POST['homepage']), 0, 250);
	}else{
		$homepage = '';
	}
	if(isset($_POST['icq'])){
		$icq = substr($_POST['icq'], 0, 15);
	}else{
		$icq = '';
	}
	if(isset($_POST['city'])){
		$city = substr($_POST['city'], 0, 100);
	}else{
		$city = '';
	}
	if(isset($_POST['avatar'])){
		$avatar = substr($_POST['avatar'], 0, 250);
	}else{
		$avatar = '';
	}
	if(isset($_POST['gmt'])){
		$gmt = SafeEnv($_POST['gmt'], 255, str);
	}else{
		$gmt = System::config('general/default_timezone');
	}
	if(isset($_POST['about'])){
		$about = substr($_POST['about'], 0, System::config('user/about_max_length'));
	}else{
		$about = '';
	}
	if(isset($_POST['snews'])){
		$snews = true;
	}else{
		$snews = false;
	}
}

#       
function GetEditUserData(&$login, &$email, &$hideemail, &$nikname, &$realname, &$age, &$homepage, &$icq, &$city, &$avatar, &$apersonal, &$gmt, &$about, &$snews){
	System::database()->Select('users', "`id`='".System::user()->Get('u_id')."'");
	$u = System::database()->FetchRow();
	$login = SafeDB($u['login'], 30, str);
	$email = SafeDB($u['email'], 50, str);
	$hideemail = SafeDB($u['hideemail'], 1, int);
	$nikname = SafeDB($u['name'], 50, str);
	$realname = SafeDB($u['truename'], 250, str);
	$age = SafeDB($u['age'], 11, str);
	$homepage = SafeDB($u['url'], 250, str);
	$icq = SafeDB($u['icq'], 15, str);
	$city = SafeDB($u['city'], 100, str);
	$avatar = SafeDB($u['avatar'], 250, str);
	$apersonal = SafeDB($u['a_personal'], 1, int);
	$gmt = SafeDB($u['timezone'], 255, str);
	$about = SafeDB($u['about'], 0, str);
	$snews = SafeDB($u['servernews'], 1, int);
}

function IndexUserConditions(){
	if(System::config('user/registration') == 'off'){
		System::site()->AddTextBox('', '<p align="center">,  .</p>');
		return;
	}
	System::site()->SetTitle(' ');
	$vars['taname'] = 'conditions';
	$vars['conditions'] = System::config('user/reg_condition');
	$vars['reg_url'] = Ufu('index.php?name=user&op=registration', 'user/{op}/');
	$vars['lsubmit'] = '';

	System::site()->AddTemplatedBox(' ', 'module/user_conditions.html');
	System::site()->AddBlock('user_mod', true, false, 'user');
	System::site()->Blocks['user_mod']['vars'] = $vars;
}

//   /  
function IndexUserRegistration($acceptPost = false, $edit = false){
	if(!$edit){
		System::user()->UnLogin(false);
	}else{
		if(!System::user()->Auth){
			System::site()->Login();
			return;
		}
	}
	System::site()->AddJS(Indent('
		function checkData(f){
			if(f.login.value = \'\'){
				alert("     '.System::config('user/login_min_length').'    15 .");
				f.login.focus();
				return false;
			}
		}
	'));

	if(!$edit && System::config('user/registration') == 'off'){
		System::site()->AddTextBox('', '<p align="center">,  .</p>');
		return;
	}
	if($acceptPost){
		AcceptPost($login, $pass, $rpass, $email, $hideemail, $nikname, $realname, $age, $homepage, $icq, $city, $avatar, $apersonal, $gmt, $about, $snews);
	}elseif($edit){
		GetEditUserData($login, $email, $hideemail, $nikname, $realname, $age, $homepage, $icq, $city, $avatar, $apersonal, $gmt, $about, $snews);
		$pass = '';
		$rpass = '';
	}else{
		$login = '';
		$pass = '';
		$rpass = '';
		$email = '';
		$hideemail = false;
		$nikname = '';
		$realname = '';
		$age = '';
		$homepage = '';
		$icq = '';
		$city = '';
		$avatar = 'noavatar.gif';
		$apersonal = '0';
		$gmt = System::config('general/default_timezone');
		$about = '';
		$snews = false;
	}

	//  
	System::site()->AddBlock('user_form', true, false, 'form');
	$vars = array();
	if($edit){
		$vars['action'] = 'update';
		$vars['laction'] = '';
		$topcaption = ' ';
	}else{
		$vars['action'] = 'create';
		$vars['laction'] = '';
		$topcaption = '';
	}
	$fields = explode(',', System::config('user/register_call_data')); //email,snews,realname,age,city,icq,gmt,about
	$activate = System::config('user/activate_type'); //auto, mail, manual

	$vars['form_name'] = 'userform';
	$vars['url'] = Ufu('index.php?name=user&op=registration', 'user/{op}/');
	$vars['enctype'] = 'multipart/form-data';

	$vars['llogin'] = ' <font color="#FF0000">*</font>';
	$vars['login'] = $login;

	$vars['lpass'] = ' <font color="#FF0000">*</font>';
	$vars['pass'] = $pass;

	$vars['lrpass'] = '  <font color="#FF0000">*</font>';
	$vars['rpass'] = $rpass;

	$vars['lnikname'] = '    <font color="#FF0000">*</font>';
	$vars['nikname'] = $nikname;

	$vars['lrealname'] = ' (...)';
	$vars['realname'] = $realname;
	$vars['use_realname'] = (in_array('realname', $fields) || $edit);

	$vars['lemail'] = 'E-mail <font color="#FF0000">*</font>';
	$vars['email'] = $email;
	$vars['lhideemail'] = ' e-mail';
	$vars['hideemail'] = ($hideemail ? ' checked="checked"' : '');
	$vars['use_email'] = (in_array('email', $fields) || $activate == 'mail' || $edit);

	$vars['lage'] = '';
	$vars['age'] = $age;
	$vars['use_age'] = (in_array('age', $fields) || $edit);

	$vars['lhomepage'] = '';
	$vars['homepage'] = $homepage;
	$vars['use_homepage'] = (in_array('homepage', $fields) || $edit);

	$vars['licq'] = ' ICQ';
	$vars['icq'] = $icq;
	$vars['use_icq'] = (in_array('icq', $fields) || $edit);

	$vars['lcity'] = '';
	$vars['city'] = $city;
	$vars['use_city'] = (in_array('city', $fields) || $edit);

	$vars['lavatar'] = '';
	$vars['lload_avatar'] = ' <br>(     .  : gif, jpeg, png.)';
	$vars['avatar_onchange_func'] = 'ShowAvatar()';
	$vars['avatar_filename'] = $avatar;
	$vars['use_avatar'] = (in_array('avatar', $fields) || $edit);

	if($vars['use_avatar']){
		System::site()->AddBlock('avatars', true, true, 'avatar');
		$avatars = GetFiles(System::config('general/avatars_dir'), false, true, '.gif.jpg.jpeg.png');
		if($apersonal == '1'){
			$selected = GetPersonalAvatar(System::user()->Get('u_id'));
		}elseif($edit){
			$selected = GetGalleryAvatar($avatar);
		}else{
			$selected = GetGalleryAvatar($avatars[1]);
		}

		if($apersonal == '1'){
			System::site()->AddSubBlock('avatars', true, array(
				'name' => '',
				'caption' => '',
				'selected' => true
			));
		}

		for($i = 0, $c = count($avatars); $i < $c; $i++){
			$avars = array();
			$sel = ($avatar == $avatars[$i]);
			$avars['name'] = $avatars[$i];
			$avars['selected'] = $sel;
			$avars['caption'] = $avatars[$i];
			System::site()->AddSubBlock('avatars', true, $avars);
		}

		$vars['av_selected'] = $selected;

		System::site()->AddJS('
			function ShowAvatar(){
				if(document.userform.avatar.value==\'\'){
					document.userform.avatarview.src = \''.(System::config('user/secure_avatar_upload') ? 'index.php?name=plugins&p=avatars_render&user='.System::user()->Get('u_id') : System::config('general/personal_avatars_dir').$avatar).'\';
				}else{
					document.userform.avatarview.src = \''.(System::config('user/secure_avatar_upload') ? 'index.php?name=plugins&p=avatars_render&aname=' : System::config('general/avatars_dir')).'\'+document.userform.avatar.value;
				}
			}'
		);
	}

	$vars['lgmt'] = ' ';
	$vars['use_gmt'] = (in_array('gmt', $fields) || $edit);
	if($vars['use_gmt']){
		$gmtd = GetGmtArray();
		System::site()->AddBlock('gmt_data', true, true, 'gmt');
		for($i = 0, $c = count($gmtd); $i < $c; $i++){
			$gvars['name'] = $gmtd[$i][1];
			$gvars['caption'] = $gmtd[$i][0];
			$gvars['selected'] = ($gmt == $gmtd[$i][1]);
			System::site()->AddSubBlock('gmt_data', true, $gvars);
		}
	}
	$vars['labout'] = '  ';
	$vars['about'] = $about;
	$vars['use_about'] = (in_array('about', $fields) || $edit);

	$vars['kaptcha_url'] = 'index.php?name=plugins&p=antibot';
	$vars['kaptcha_width'] = '120';
	$vars['kaptcha_height'] = '40';

	$vars['lsnews'] = '        ';
	$vars['snews'] = ($snews ? ' checked="checked"' : '');
	$vars['use_snews'] = (in_array('snews', $fields) || $edit);

	System::site()->AddTemplatedBox($topcaption, 'module/user_form.html');
	System::site()->SetTitle($topcaption);
	System::site()->Blocks['user_form']['vars'] = $vars;
}

function IndexUserRegistrationOk(){
	System::site()->SetTitle('  ');

	if(isset($_POST['usersave']) && $_POST['usersave'] == 'update'){
		$edit = true;
		$user_id = System::user()->Get('u_id');
		System::database()->Select('users', "`id`='".$user_id."'");
		$user = System::database()->FetchRow();
	}else{
		$edit = false;
	}
	if(!$edit){
		System::user()->UnLogin(false);
	}else{
		if(!System::user()->Auth){
			GO(Ufu('index.php'));
		}
	}
	if(System::config('user/registration') == 'off' && !$edit){
		System::site()->AddTextBox('', '<p align="center">,   .</p>');
		return;
	}

	// 
	$errors = array();

	// 
	$login = '';
	$sendlogin = '';
	if(isset($_POST['login']) && CheckLogin(SafeEnv($_POST['login'], 30, str), $errors, true, ($edit ? $user_id : 0))){
		$login = SafeEnv($_POST['login'], 30, str);
		$sendlogin = $_POST['login'];
	}

	// 
	$pass = '';
	$sendpass = '';
	$pass_generate_message = '';
	if(!System::user()->isAdmin() && $_POST['pass'] <> ''){
		$pass = SafeEnv($_POST['pass'], 255, str);
		$rpass = SafeEnv($_POST['rpass'], 255, str);
		$sendpass = $_POST['pass'];

		if($edit){
			if($rpass != ''){
				if(!CheckPass(SafeEnv($_POST['pass'], 255, str), $errors)){
					$pass = '';
				}elseif($rpass <> $pass){
					$errors[] = '  .';
					$pass = '';
				}
			}else{
				$pass = '';
			}
		}else{
			if($_POST['pass'] == ''){
				srand(time());
				$pass = GenBPass(rand(System::config('user/pass_min_length'), 15));
				$sendpass = $pass;
				$pass_generate_message = '<br>     ,         E-mail.';
			}else{
				if(CheckPass(SafeEnv($_POST['pass'], 255, str), $errors)){
					if($rpass <> $pass){
						$errors[] = '  .';
					}
				}
			}
		}
		$pass2 = md5($pass);
	}

	// E-mail
	if(!System::user()->isAdmin() && isset($_POST['email']) && CheckUserEmail(SafeEnv($_POST['email'], 50, str, true), $errors, true, ($edit ? $user_id : 0))){
		$email = SafeEnv($_POST['email'], 50, str, true);
	}else{
		$email = '';
	}

	//  E-mail
	if(isset($_POST['hideemail'])){
		$hide_email = '1';
	}else{
		$hide_email = '0';
	}

	//  
	if(isset($_POST['nikname']) && CheckNikname(SafeEnv($_POST['nikname'], 50, str, true), $errors, true, ($edit ? $user_id : 0))){
		$nik_name = SafeEnv($_POST['nikname'], 50, str, true);
	}else{
		$nik_name = '';
	}

	//  
	if(isset($_POST['realname'])){
		$real_name = SafeEnv($_POST['realname'], 250, str, true);
	}else{
		$real_name = '';
	}

	//  
	if(isset($_POST['age'])){
		if($_POST['age'] == '' || is_numeric($_POST['age'])){
			$age = SafeEnv($_POST['age'], 3, int);
		} else{
			$errors[] = '    !';
		}
	}else{
		$age = '';
	}

	//   
	if(isset($_POST['homepage'])){
		$homepage = SafeEnv(Url($_POST['homepage']), 250, str, true);
	}else{
		$homepage = '';
	}

	//  ICQ
	if(isset($_POST['icq'])){
		if($_POST['icq'] == '' || is_numeric($_POST['icq'])){
			$icq = SafeEnv($_POST['icq'], 15, str, true);
		}else{
			$errors[] = ' ICQ    !';
		}
	}else{
		$icq = '';
	}

	// 
	if(isset($_POST['city'])){
		$city = SafeEnv($_POST['city'], 100, str, true);
	}else{
		$city = '';
	}

	//  
	if(isset($_POST['gmt'])){
		$gmt = SafeEnv($_POST['gmt'], 255, str);
	}else{
		$gmt = System::config('general/default_timezone');
	}

	//  
	if(isset($_POST['about'])){
		$about = SafeEnv($_POST['about'], System::config('user/about_max_length'), str, true);
	}else{
		$about = '';
	}

	//   
	if(isset($_POST['snews'])){
		$server_news = '1';
	}else{
		$server_news = '0';
	}

	if(!$edit && (!System::user()->Auth && !System::user()->isDef('captcha_keystring') || System::user()->Get('captcha_keystring') != $_POST['keystr'])){
		$errors[] = '      .';
	}

	// 
	$updateAvatar = true;
	if(isset($_POST['avatar'])){
		if(System::config('user/avatar_transfer') == '1' && isset($_FILES['upavatar']) && file_exists($_FILES['upavatar']['tmp_name'])){
			UserLoadAvatar($errors, $avatar, $a_personal, $user['avatar'], $user['a_personal'] == '1', $edit);
		}elseif($_POST['avatar'] == ''){
			$updateAvatar = false;
		}elseif(file_exists(RealPath2(System::config('general/avatars_dir').$_POST['avatar']))){
			if($edit){
				if($user['a_personal'] == '1'){
					UnlinkUserAvatarFiles($user['avatar']);
				}
			}
			$a_personal = '0';
			$avatar = $_POST['avatar'];
		}else{
			$avatar = 'noavatar.gif';
			$a_personal = '0';
		}
	}else{
		$avatar = 'noavatar.gif';
		$a_personal = '0';
	}

	//  
	$active = '1';
	$code = '';
	$SendActivation = false;
	$activate = '';
	if(!$edit){
		$activate = System::config('user/activate_type');
		switch($activate){
			case 'manual':
				$active = '0';
				$code = '';
				$SendActivation = false;
				break;
			case 'auto':
				$active = '1';
				$code = '';
				$SendActivation = false;
				break;
			case 'mail':
				$active = '0';
				$code = GenRandomString(32);
				$SendActivation = true;
				break;
		}
	}

	$status = 2;
	$access = -1;
	$reg_date = time();
	$last_visit = time();
	$ip = getip();
	$points = 0;
	$visits = 0;

	// 
	if(count($errors) == 0){
		if($SendActivation){
			UserSendActivationMail($nik_name, $email, $sendlogin, $sendpass, $code, $reg_date);
			$finish_message = Indent('
				<br>
				   E-Mail  ,
				    .
				       
				  !
			');
		}elseif(!$edit){
			UserSendEndRegMail($email, $nik_name, $sendlogin, $sendpass, $reg_date);
			$finish_message = '<br>  E-mail      .';
		}
		if(!$edit){ //   
			$values = Values('', $login, $pass2, $nik_name, $real_name,
				$age, $email, $hide_email, $city, $icq,
				$homepage, $gmt, $avatar, $about, $server_news,
				$reg_date, $last_visit, $ip, $points, $visits,
				$active, $code, $status, $access, $a_personal, serialize(array()));

			System::database()->Insert('users', $values);

			//   
			System::cache()->Delete(system_cache, 'users');

			//  
			if($activate == 'auto'){
				System::user()->Login($login, $pass, true, false);
				System::site()->InitVars();
			}elseif($activate == 'mail'){
				System::user()->Def('activate_ps', base64_encode($pass));
			}

			System::site()->AddTextBox(''
				, '<p align="center">!     .'.$pass_generate_message.$finish_message.'<br> ,   <strong>'.System::config('general/site_name').'.</strong></p>');


		}else{ //  
			$set = "`login`='$login',`hideemail`='$hide_email',`name`='$nik_name',"
				."`truename`='$real_name',`age`='$age',`url`='$homepage',`icq`='$icq',`city`='$city',`timezone`='$gmt'"
				.($updateAvatar == true ? ",`avatar`='$avatar',`a_personal`='$a_personal'" : '').",`about`='$about',"
				."`servernews`='$server_news'".($pass <> '' ? ",`pass`='$pass2'" : '').($email <> '' ? ",`email`='$email'" : '');

			System::database()->Update('users', $set, "`id`='".System::user()->Get('u_id')."'");
			System::user()->UpdateMemberSession();
			UpdateUserComments(System::user()->Get('u_id'), System::user()->Get('u_id'), $nik_name, $email, $hide_email, $homepage, getip());

			//   
			System::cache()->Delete(system_cache, 'users');
			GO(GetSiteUrl().Ufu('index.php?name=user&op=userinfo', 'user/{op}/'));
		}
	}else{ // 
		$text = '   '.($edit ? '' : '').',   :<br><ul>';
		foreach($errors as $error){
			$text .= '<li>'.$error;
		}
		$text .= '</ul>';
		//  
		if($a_personal == '1' && !$edit){
			unlink(System::config('general/personal_avatars_dir').$avatar);
		}
		System::site()->AddTextBox('', $text);
		IndexUserRegistration(true, $edit);
	}
}

function IndexUserInfo(){
	if(isset($_GET['user'])){
		$user_id = SafeEnv($_GET['user'], 11, int);
	}elseif(System::user()->Auth){
		$user_id = System::user()->Get('u_id');
	}else{
		System::site()->Login();
		return;
	}

	$usr = GetUserInfo($user_id);

	if($usr !== false){
		System::site()->SetTitle('   '.SafeDB($usr['name'], 50, str));
		System::site()->AddTemplatedBox('', 'module/user_info.html');
		System::site()->AddBlock('userinfo', true, false, 'user');

		$vars['user_id'] = SafeDB($usr['id'], 11, int);
		$vars['name'] = SafeDB($usr['name'], 50, str);
		$vars['true_name'] = SafeDB($usr['truename'], 250, str);
		$vars['avatar'] = RealPath2(SafeDB($usr['avatar_file'], 255, str));
		$vars['rankimage'] = RealPath2(SafeDB($usr['rank_image'], 255, str));
		$vars['rank'] = SafeDB($usr['rank_name'], 255, str);
		$vars['age'] = SafeDB($usr['age'], 11, str);
		$vars['city'] = SafeDB($usr['city'], 100, str);
		if($usr['hideemail'] == '1'){
			$vars['email'] = '';
		}else{
			$vars['email'] = SafeDB($usr['email'], 50, str);
		}
		$vars['icq'] = SafeDB($usr['icq'], 15, str);
		$vars['site'] = Url(SafeDB($usr['url'], 250, str));
		$vars['site_url'] = UrlRender(SafeDB($usr['url'], 250, str));
		$vars['about'] = SafeDB($usr['about'], 0, str);
		$vars['regdate'] = TimeRender($usr['regdate'], false);
		$vars['lastdate'] = TimeRender($usr['lastvisit']);
		$vars['counter'] = SafeDB($usr['visits'], 11, int);
		if($usr['online']){
			$vars['online'] = '  .';
		}else{
			$vars['online'] = '';
		}
		System::site()->BreadCrumbAdd('  "'.$vars['name'].'"');
		System::site()->Blocks['userinfo']['vars'] = $vars;
	}else{
		System::site()->AddTextBox('', '<p align="center">  .<p>');
	}
}

function IndexUserlist(){
	System::site()->SetTitle(' ');
	System::site()->BreadCrumbAdd(' ');

	$page = 0;
	if(isset($_GET['page'])){
		$page = SafeEnv($_GET['page'], 11, int);
	}else{
		$page = 1;
	}
	$users = System::database()->Select('users', "`active`='1'");
	SortArray($users, 'points', true); // regdate
	SortArray($users, 'type', false); // type
	$num = System::config('user/users_on_page');

	$navigation = new Navigation($page);
	$navigation->FrendlyUrl = System::site()->Ufu;
	$navigation->GenNavigationMenu($users, $num, Ufu('index.php?name=user&op=userslist', 'user/users/page{page}/', true));

	System::site()->AddTemplatedBox(' ', 'module/user_list.html');
	System::site()->AddBlock('userlist_th', true, false, 'title');
	System::site()->Blocks['userlist_th']['vars'] = array(
		'name' => '',
		'email' => 'E-mail',
		'date' => ' ',
		'last_visit' => '. ',
		'last' => '. ',
		'rank' => '/'
	);
	System::site()->AddBlock('userlist', true, true, 'user');
	foreach($users as $usr){
		$vars = array();
		$rank_stat = GetUserRank($usr['points'], $usr['type'], $usr['access']);
		$rank_stat = $rank_stat[0];
		$vars['avatar'] = GetUserAvatar($usr['id']);
		$vars['avatar_small'] = GetSmallUserAvatar($usr['id'], $vars['avatar']);
		$vars['avatar_smallest'] = GetSmallestUserAvatar($usr['id'], $vars['avatar']);
		$vars['user_id'] = SafeDB($usr['id'], 11, int);
		$vars['url'] = Ufu('index.php?name=user&op=userinfo&user='.SafeDB($usr['id'], 11, int), 'user/{user}/info/');
		$vars['name'] = SafeDB($usr['name'], 50, str);
		if($usr['hideemail'] == '1'){
			$vars['email'] = '';
		}else{
			$vars['email'] = SafeDB($usr['email'], 50, str);
		}
		$vars['date'] = TimeRender($usr['regdate'], true);
		$vars['lastdate'] = TimeRender($usr['lastvisit'], true);
		$vars['rank'] = $rank_stat;
		System::site()->AddSubBlock('userlist', true, $vars);
	}
}

function IndexUserForgotPassword(){
	System::site()->SetTitle(' /');
	System::site()->BreadCrumbAdd(' /');
	System::site()->AddTemplatedBox(' /', 'module/user_forgotpassword.html');
	System::site()->AddBlock('forgot_form', true, false, 'form');
	$vars['form_name'] = 'forgotpassword';
	$vars['url'] = Ufu('index.php?name=user&op=sendpassword', 'user/{op}/');
	$vars['lemail'] = 'E-mail';
	$vars['llogin'] = '';
	$vars['lsubmit'] = '';
	System::site()->Blocks['forgot_form']['vars'] = $vars;
}

function IndexUserSendPassword(){
	$title = ' /';
	System::site()->SetTitle($title);
	System::site()->BreadCrumbAdd(' /');
	if(isset($_POST['email']) || isset($_POST['login'])){
		$login = SafeEnv($_POST['login'], 30, str);
		$email = SafeEnv($_POST['email'], 50, str, true);
		System::database()->Select('users', "`login`='$login' or `email`='$email'");
		if(System::database()->NumRows() == 0){
			$endmsg = '<br>     E-mail   .';
		}else{
			$user = System::database()->FetchRow();
			srand(time());
			$pass = GenBPass(rand(System::config('user/pass_min_length'), 15));
			$pass2 = md5($pass);
			System::database()->Update('users', "pass='$pass2'", "`id`='".SafeEnv(SafeDB($user['id'], 11, int), 11, int)."'");

			UserSendForgotPassword(SafeDB($user['email'], 255, str), SafeDB($user['name'], 255, str), SafeDB($user['login'], 255, str), $pass);
			$endmsg = '<br>         e-mail.';
		}
		System::site()->AddTextBox($title, $endmsg);
	}else{
		System::site()->AddTextBox($title, ",   .");
	}
}

function IndexUserLogOn(){
	if(System::user()->Auth){ //   ,  
		GO(Ufu('index.php'));
	}

	if(!isset($_POST['login_form']) || !isset($_POST['login']) || !isset($_POST['pass'])){ //   ,    
		System::site()->Login();
		return;
	}

	$auth_result = System::user()->Login(SafeEnv($_POST['login'], 30, str), SafeEnv($_POST['pass'], 32, str), isset($_POST['remember']));

	if($auth_result === true){
		if(strpos($_SERVER['HTTP_REFERER'], 'index.php?name=user&op=registration') === false && strpos($_SERVER['HTTP_REFERER'], 'user/registration/') === false){
			GoBack();
		}else{ //     ,     
			GO(Ufu('index.php'));
		}
	}else{
		System::site()->Login($auth_result);
	}
}

function IndexUserLogOut(){
	if(System::user()->Auth){
		System::user()->UnLogin(false);
		GoBack();
	}else{
		System::site()->Login(); //   ,    
	}
}

function IndexUserActivate(){
	if(isset($_GET['code'])){
		$code = SafeEnv($_GET['code'], 32, str);
		System::database()->Select('users', "`activate`='".$code."'");
		if(System::database()->NumRows() > 0){
			$activation_user = System::database()->FetchRow();
			System::database()->Update('users', "`active`='1',`activate`=''", "`id`='".SafeDB($activation_user['id'], 11, int)."'");

			//  
			if(System::user()->isDef('activate_ps')){
				$pass = base64_decode(System::user()->Get('activate_ps'));
				System::user()->Login($activation_user['login'], $pass, true);
				System::user()->UnDef('activate_ps');
				System::site()->InitVars();
				UserSendEndRegMail($activation_user['email'], $activation_user['name'], $activation_user['login'], $pass, $activation_user['regdate']);
			}

			System::site()->AddTextBox('', '<p align="center">  .     .</p>');
		}else{
			System::site()->AddTextBox('', '<p align="center">  .</p>');
		}
	}else{
		GO(Ufu('index.php'));
	}
}
