<?php

// LinkorCMS  
if(!($GLOBALS['userAuth'] === 1
	&& $GLOBALS['userAccess'] === 1
	&& System::user()->AllowCookie(System::user()->AdminCookieName, true))
){
	exit('Access Denied!');
}
//////////////////////////////////

include_once dirname(__FILE__).DIRECTORY_SEPARATOR.'elFinderConnector.class.php';
include_once dirname(__FILE__).DIRECTORY_SEPARATOR.'elFinder.class.php';
include_once dirname(__FILE__).DIRECTORY_SEPARATOR.'elFinderVolumeDriver.class.php';
include_once dirname(__FILE__).DIRECTORY_SEPARATOR.'elFinderVolumeLocalFileSystem.class.php';

$opts = array(
	'debug' => false,
	'roots' => array(
		array(
			// driver for accessing file system (REQUIRED)
			'driver'        => 'LocalFileSystem',
			// path to files (REQUIRED)
			'path'          => 'uploads/',
			// URL to files (REQUIRED)
			'URL'           => GetSiteUrl().'uploads/',
			// image manipulation library (imagick, mogrify, gd)
			//'imgLib'        => 'gd',
			'tmbSize' => 80,
			'tmbCrop' => false,
			'uploadAllow'   => array(
				// applications
				'application/x-executable',
				'application/vnd.ms-word',
				'application/vnd.ms-excel',
				'application/vnd.ms-powerpoint',
				'application/vnd.ms-powerpoint',
				'application/pdf',
				'application/xml',
				'application/vnd.oasis.opendocument.text',
				'application/x-shockwave-flash',
				'application/x-bittorrent',
				'application/x-jar',
				// archives
				'application/x-gzip',
				'application/x-gzip',
				'application/x-bzip2',
				'application/x-bzip2',
				'application/x-bzip2',
				'application/zip',
				'application/x-rar',
				'application/x-tar',
				'application/x-7z-compressed',
				// texts
				'text/plain',
				'text/html',
				'text/html',
				'text/javascript',
				'text/css',
				'text/rtf',
				'text/rtfd',
				'text/xml',
				'text/x-sql',
				'text/plain',
				'text/x-comma-separated-values',
				// images
				'image/x-ms-bmp',
				'image/jpeg',
				'image/jpeg',
				'image/gif',
				'image/png',
				'image/tiff',
				'image/tiff',
				'image/x-targa',
				'image/vnd.adobe.photoshop',
				'image/vnd.adobe.photoshop',
				'image/xbm',
				'image/pxm',
				//audio
				'audio/mpeg',
				'audio/midi',
				'audio/ogg',
				'audio/ogg',
				'audio/x-m4a',
				'audio/wav',
				'audio/x-ms-wma',
				// video
				'video/x-msvideo',
				'video/x-dv',
				'video/mp4',
				'video/mpeg',
				'video/mpeg',
				'video/quicktime',
				'video/x-ms-wmv',
				'video/x-flv',
				'video/x-matroska',
				'video/webm',
				'video/ogg',
				'video/ogg'
			),
			// disable and hide dot starting files (OPTIONAL)
			'accessControl' => 'ElFinderAccess'
		)
	)
);

function ElFinderAccess($attr, $path, $data, $volume) {
	return strpos(basename($path), '.') === 0       // if file/folder begins with '.' (dot)
		? !($attr == 'read' || $attr == 'write')    // set read+write to false, other (locked+hidden) set to true
		:  null;                                    // else elFinder decide it itself
}

// run elFinder
$connector = new elFinderConnector(new elFinder($opts));
$connector->run();
