<?php

/*
 * LinkorCMS 1.4
 *  2012 LinkorCMS Development Group
 */


class CacheOptions{

	public $engine = 'LmFileCache';
	public $path = '';
	public $cache_suffix = '.cache';
	public $expiry_suffix = '.expiry';
	public $servers = array();
	public $enabled = false;

	function  __construct() {
		global $config;
		$this->path = System::config('cache_dir');
		$this->enabled = (USE_CACHE && is_dir($this->path) && is_writable($this->path) && !defined('SETUP_SCRIPT'));
	}

}

/**
 *  .
 */
class LmFileCache{

	static protected $_instance;
	public $Path; //      
	public $FileSuffix = '.cache'; //   
	public $ExpirySuffix = '.expiry'; //   
	public $Enabled = false; //  

	function  __construct( CacheOptions $options ){
		$this->Initialize($options);
	}

	/**
	 *   .
	 * @param CacheOptions $options
	 */
	public function Initialize( CacheOptions $options ){
		$this->Path = $options->path;
		$this->FileSuffix = $options->cache_suffix;
		$this->ExpirySuffix = $options->expiry_suffix;
		$this->Enabled = $options->enabled;
	}

	/**
	 *        ,     .
	 * @param $Group
	 * @param $Key
	 * @return array <type>
	 */
	public function GetFiles( $Group, $Key ){
		$cacheGroupPath = $this->Path.$Group;
		if(!is_dir($cacheGroupPath)){
			MkDirRecursive($cacheGroupPath);
		}
		$cacheGroupPath .= '/';
		$Key = rawurlencode($Key);
		return array(
			$cacheGroupPath.$Key.$this->FileSuffix,
			$cacheGroupPath.$Key.$this->ExpirySuffix
		);
	}

	/**
	 *     .
	 *
	 * @param string $Group   /     
	 * @param string $Key     
	 * @param array $Value  
	 * @param int $Expiry        
	 * @return bool
	 */
	public function Write( $Group, $Key, &$Value, $Expiry = 0 ){
		//              .
		if($this->Enabled){
			$files = $this->GetFiles($Group, $Key);
			if($Expiry != 0){
				$Expiry = time() + $Expiry;
			}
			file_put_contents($files[0], serialize($Value), LOCK_SH);
			file_put_contents($files[1], $Expiry, LOCK_SH);
		}
	}

	/**
	 *   .
	 * @param string $Group
	 * @param string|array $Key
	 */
	public function Delete( $Group, $Key ){
		if($this->Enabled){
			if(!is_array($Key)){
				$Key = array($Key);
			}
			foreach($Key as $k){
				$files = $this->GetFiles($Group, $k);
				if(is_file($files[0])){
					unlink($files[0]);
					unlink($files[1]);
				}
			}
		}
	}

	/**
	 *       .
	 * @param string $Group
	 * @param string $Key
	 * @return bool
	 */
	public function HasCache( $Group, $Key ){
		if(!$this->Enabled)
			return false;
		$files = $this->GetFiles($Group, $Key);
		if(!is_dir($this->Path.$Group) || !is_writable($this->Path.$Group) || !is_file($files[0])){ //       
			return false;
		}
		$expiry = file_get_contents($files[1]);
		if($expiry != 0 && (time()>$expiry)){
			$this->Delete($Group, $Key);
			return false;
		}else{
			return true;
		}
	}

	/**
	 *    .
	 * @param string $Group  /     
	 * @param string $Key  .
	 * @return mixed
	 */
	public function Get( $Group, $Key ){
		if(!$this->Enabled)
			return false;
		if($this->HasCache($Group, $Key)){
			$files = $this->GetFiles($Group, $Key);
			return Unserialize(file_get_contents($files[0]));
		}else{
			return false;
		}
	}

	/**
	 *   .   ,     .
	 * @param string $Group
	 * @param string $Group2
	 * @param string $Group3
	 */
	public function Clear( $Group, $Group2 = '', $Group3 = '' ){
		$args = func_get_args();
		if(is_array($args[0])){
			$args = $args[0];
		}
		foreach($args as $group){
			$cacheGroupPath = $this->Path.$group.'/';
			if(is_dir($cacheGroupPath)){
				$files = GetFiles($cacheGroupPath, false, true, "{$this->FileSuffix},{$this->ExpirySuffix}");
				foreach($files as $file){
					@unlink($cacheGroupPath.$file);
				}
			}
		}
	}

	/**
	 *   .
	 */
	public function ClearAll(){
		$groups = $this->GetGroups();
		foreach($groups as $g){
			$this->Clear($g);
		}
	}

	/**
	 *     .
	 */
	public function GetGroups(){
		return GetFolders($this->Path);
	}

	/**
	 *       .
	 * @param string $Group
	 * @return array
	 */
	public function GetKeys( $Group ){
		$files = GetFiles($this->Path.$Group.'/');
		foreach($files as $key=>$file){
			$files[$key] = GetFileName($file, true);
		}
		return $files;
	}

	/**
	 *   .
	 * @return LmFileCache
	 */
	static public function Instance(){
		if(!(self::$_instance instanceof LmFileCache)){
			self::$_instance = new LmFileCache( new CacheOptions() );
		}
		return self::$_instance;
	}

}
