<?php

/*
 * LinkorCMS 1.4
 *  2012 LinkorCMS Development Group
 */


/**
 *  .
 */
class Navigation{

	static public $StarkytDefault = null; // ,     
	static public $AdminAjaxLinks = false; //  Ajax   -

	public $page = 0;
	public $param_name;

	/**
	 * @var StarkytBlock|string
	 */
	public $template_block;
	public $FrendlyUrl = false;
	public $Starkyt = null;

	/**
	 *        (        FrendlyUrl)
	 * @var string
	 */
	public $DefaultPageLink = null;

	/**
	 *   .
	 * @var int
	 */
	public $DefaultPage = 1;

	/**
	 *   .   #.
	 * @var string
	 */
	public $Anchor = '';

	/**
	 * 
	 * @param <type> $ParamName
	 * @param string|StarkytBlock $Block
	 * @param string $ParamName
	 */
	public function  __construct( $Page, $Block = 'navigation', $ParamName = 'page' ){
		$this->page = $Page;
		$this->param_name = $ParamName;
		if(self::$StarkytDefault == null){
			$this->Starkyt = System::site();
		}else{
			$this->Starkyt = self::$StarkytDefault;
		}
		$this->template_block = $Block;
	}

	/**
	 * @return StarkytBlock
	 */
	private function GetBlock(){
		if(is_string($this->template_block)){
			$this->Starkyt->SetVar('template', 'if_'.$this->template_block, true);
			$this->template_block = $this->Starkyt->NewBlock($this->template_block, true, false, 'nav', 'navigation.html');
		}
		if(!$this->template_block->HasBlock('back')){
			$this->template_block->NewBlock('back', true, true, 'item', 'navigation_item.html');
			$this->template_block->NewBlock('begin', true, true, 'item', 'navigation_item.html');
			$this->template_block->NewBlock('left', true, true, 'item', 'navigation_item.html');
			$this->template_block->NewBlock('active', true, true, 'item', 'navigation_item.html');
			$this->template_block->NewBlock('right', true, true, 'item', 'navigation_item.html');
			$this->template_block->NewBlock('end', true, true, 'item', 'navigation_item.html');
			$this->template_block->NewBlock('next', true, true, 'item', 'navigation_item.html');
			$this->template_block->NewBlock('is_next');
			$this->template_block->NewBlock('is_back');
		}
		return $this->template_block;
	}

	/**
	 *    .
	 */
	public function DisableNavigation(){
		$this->GetBlock()->Enabled(false);
		$this->Starkyt->SetVar('template', 'if_'.$this->GetBlock()->Name, false);
	}

	private function GetUrl( $Link, $Page ){
		if($this->FrendlyUrl){
			if(isset($this->DefaultPageLink) && $Page == $this->DefaultPage){
				return $this->DefaultPageLink;
			}else{
				return str_replace('{'.$this->param_name.'}', $Page, $Link).$this->Anchor;
			}
		}else{
			return $Link.($Page > 1 ? '&'.$this->param_name.'='.$Page : '').$this->Anchor;
		}
	}

	private function SetItem( $Pos, $Enabled ){
		$this->GetBlock()->GetChildBlock($Pos)->Enabled($Enabled);
	}

	private function AddItem( $Pos, $Link, $Page, $Text, $isText = false ){
		$url = $this->GetUrl($Link, $Page);
		$pos_css = $Pos;
		$title = '';
		$other = '';
		if($Pos == 'left' || $Pos == 'right'){
			$pos_css = 'link';
			$title = '   '.$Page;
		}elseif($Pos == 'back'){
			$title = '  ';
			$other = ' rel="prev"';
		}elseif($Pos == 'next'){
			$title = '  ';
			$other = ' rel="next"';
		}
		if(!$isText){
			if(self::$AdminAjaxLinks){
				$link_a = System::admin()->Link($Text, $url);
			}else{
				$link_a = '<a href="'.$url.'" class="navigation_item navigation_'.$pos_css.'" title="'.$title.'"'.$other.'>'.$Text.'</a>';
			}
		}else{
			$link_a = '<span class="navigation_textitem navigation_text'.$pos_css.'">'.$Text.'</span>';
		}
		$vars = array(
			'link' => $link_a,
			'link_url' => $url,
			'text' => $Text,
			'is_text' => $isText,
			'is_link' => !$isText,
			'pos' => $Pos,
			'params' => $other
		);
		$this->GetBlock()->GetChildBlock($Pos)->NewSubBlock(true, $vars);
	}

	/**
	 *   
	 * @param <type> $ItemsCount
	 * @param <type> $ItemsOnPage
	 * @param <type> $Link
	 * @param <type> $Page
	 */
	public function GenNavigationMenu2( $ItemsCount, $ItemsOnPage, $Link, $Page = null ){
		if($Page == null){
			$Page = $this->page;
		}
		if($ItemsCount <= $ItemsOnPage){
			$this->DisableNavigation();
			return;
		}

		$PagesCount = ceil($ItemsCount / $ItemsOnPage);

		if($Page < 1){
			$Page = 1;
		}elseif($Page > $PagesCount){
			$Page = $PagesCount;
		}

		//       
		$min = $Page - 5;
		$max = $Page + 5;
		if($min < 1){
			$min = 1;
		}
		if($max > $PagesCount){
			$max = $PagesCount;
		}

		//      
		if($Page > 1){ //    
			$this->AddItem('back', $Link, $Page - 1, '');
			$this->SetItem('is_back', true);
		}else{
			$this->AddItem('back', $Link, $Page - 1, '', true);
			$this->SetItem('is_back', false);
		}

		//      
		if($min > 1){
			$this->AddItem('begin', $Link, 1, '1..');
		}

		//  
		for($i = $min; $i <= $max; $i++){
			if($i < $Page){
				$this->AddItem('left', $Link, $i, $i);
			}elseif($i > $Page){
				$this->AddItem('right', $Link, $i, $i);
			}else{
				$Active = '<span class="navigation_textitem navigation_active">'.$i.'</span>';
				$this->AddItem('active', $Link, $i, $i);
				$this->GetBlock()->SetVar('active', $Active);
			}
		}

		//      
		if($max < $PagesCount){
			$this->AddItem('end', $Link, $PagesCount, '..'.$PagesCount);
		}

		//      
		if($Page < $PagesCount){
			$this->AddItem('next', $Link, $Page + 1, '');
			$this->SetItem('is_next', true);
		}else{
			$this->AddItem('next', $Link, $Page + 1, '', true);
			$this->SetItem('is_next', false);
		}
	}

	/**
	 *    .
	 * @param array   $Items    .       .
	 * @param int     $ItemsOnPage   .
	 * @param string  $Link  .       page.
	 * @param int     $Page   ( 1).
	 */
	public function GenNavigationMenu( &$Items, $ItemsOnPage, $Link, $Page = null ){
		if($Page == null){
			$Page = $this->page;
		}
		$ItemsCount = count($Items);
		if(count($Items) > $ItemsOnPage){
			$pages = array_chunk($Items, $ItemsOnPage);
		}else{
			$pages[0] = $Items;
		}
		$pages_count = count($pages);
		if($Page > $pages_count) $Page = $pages_count;
		if($Page <= 0) $Page = 1;
		$Items = $pages[$Page - 1];
		$this->GenNavigationMenu2($ItemsCount, $ItemsOnPage, $Link, $Page);
	}

	/**
	 *    .      MySQL .
	 * @param int $ItemsCount   .
	 * @param int $ItemsOnPage     .
	 * @param string $Link  .       page.
	 * @param int $Page  .
	 * @return string      SQL ,   ,      .
	 */
	public function GenNavigationMenuSql( $ItemsCount, $ItemsOnPage, $Link, $Page = null ){
		if($Page == null){
			$Page = $this->page;
		}
		$this->GenNavigationMenu2($ItemsCount, $ItemsOnPage, $Link, $Page);
		return 'LIMIT '.(($Page - 1) * $ItemsOnPage).', '.$ItemsOnPage;
	}
}
