<?php

/*
 * LinkorCMS 1.4
 *  2012 LinkorCMS Development Group
 */


define('STARKYT_START', 1);
define('STARKYT_COND', 2);
define('STARKYT_POLY', 3);
define('STARKYT_TABLE', 4);
define('STARKYT_VAR', 5);
define('STARKYT_TEMPVAR', 6);
define('STARKYT_END', 7);
define('STARKYT_TEXT', 8);
define('STARKYT_SPEED_COND', 9);
define('STARKYT_OPENKEY', '{');
define('STARKYT_CLOSEKEY', '}');
define('STARKYT_CACHE', 'templates');

/**
 *     LinkorCMS
 */
class Starkyt extends HTML{

	public $Root = ''; //     ,   
	public $DefaultRoot = ''; //      
	public $ModRoot = ''; //     
	public $TemplateFile = ''; //       ,    

	public $TableOpen = '';
	public $TableClose = '';
	public $TableCellOpen = '';
	public $TableCellClose = '';

	public $Blocks = array();
	public $OpenedBlocks = array();
	public $CurrentBlock = null;
	public $Cache = array(); //   
//	public $ToCache = array(); //      . array('filename'=>'full file name', ...)

	// 
	public function InitStarkyt($RootDir, $TemplateFile){
		$this->Root = $RootDir;
		$this->TemplateFile = $TemplateFile;
		$this->GetSBlocks($TemplateFile);
		$this->AddBlock('comment', false); //    {comment}{/comment}
		$this->AddBlock('hide', false); //   
	}

	/**
	 *    
	 * @param  $Root
	 * @return void
	 */
	public function SetRoot($Root){
		$this->Root = $Root;
	}

	/**
	 * ,     
	 * @param $FileName
	 * @return bool|string
	 */
	public function TemplateExists($FileName){
		if($FileName == ''){
			return false;
		}
		$param_pos = strpos($FileName, '?');
		if($param_pos !== false){
			$param_pos = explode('?', $FileName);
			$FileName = $param_pos[0];
			$param_pos = '?'.$param_pos[1];
		}else{
			$param_pos = '';
		}
		if(is_file($this->Root.$FileName)){
			$FileName = $this->Root.$FileName;
		}elseif(is_file($this->DefaultRoot.$FileName)){
			$FileName = $this->DefaultRoot.$FileName;
		}elseif(is_file($this->ModRoot.$FileName)){
			$FileName = $this->ModRoot.$FileName;
		}else{
			return false;
		}
		return $FileName.$param_pos;
	}

	/**
	 *   
	 * @deprecated
	 * @param $table_open
	 * @param $table_close
	 * @param $table_cell_open
	 * @param $table_cell_close
	 */
	public function SetTableTemplate($table_open, $table_close, $table_cell_open, $table_cell_close){
		$this->TableOpen = file_get_contents($this->TemplateExists($table_open));
		$this->TableClose = file_get_contents($this->TemplateExists($table_close));
		$this->TableCellOpen = file_get_contents($this->TemplateExists($table_cell_open));
		$this->TableCellClose = file_get_contents($this->TemplateExists($table_cell_close));
	}

	/**
	 *      .
	 * @param  $TemplateFile   .
	 * @param  $Data          ,  ,        .
	 * @return array
	 */
	public function &GetSBlocks($TemplateFile, $Data = null){
		if(!isset($Data)){
			if(isset($this->Cache[$TemplateFile])){
				return $this->Cache[$TemplateFile];
			}
			$blocks2 = array();
			if($TemplateFile == ''){
				return $blocks2;
			}
			$filename = $this->TemplateExists($TemplateFile);
//			$filename_md5 = md5($filename);
//			if(System::cache()->HasCache(STARKYT_CACHE, $filename_md5)){
//				$this->Cache[$TemplateFile] = System::cache()->Get(STARKYT_CACHE, $filename_md5);
//				return $this->Cache[$TemplateFile];
//			}else{
//				$this->ToCache[$TemplateFile] = $filename_md5;
//			}
			if($filename === false){
				echo '   : <b>'.$TemplateFile.'</b><br />';
				return $blocks2;
			}
			global $config, $site, $user, $db; //     
			ob_start();
			include($filename);
			$Data = ob_get_clean();
		}

		//  
		$Data = preg_replace('/\{noblocks\}(.*)\{\\/noblocks\}/se', 'str_replace(array("{", "}", "\\\'"), array("&#123;", "&#125;", "\'"), "\\1")', $Data);
		$Data = str_replace(array('\{', '\}'), array('&#123;', '&#125;'), $Data);

		$blocks = explode(STARKYT_OPENKEY, $Data);
		$blocks2 = array($blocks[0]);
		unset($blocks[0]);
		foreach($blocks as $b){
			$tag = explode(STARKYT_CLOSEKEY, $b);
			$blocks2[] = $tag[0];
			if(isset($tag[1])){
				$blocks2[] = $tag[1];
			} else{
				$blocks2[] = '';
			}
		}
		$this->Cache[$TemplateFile] = $blocks2;
		return $blocks2;
	}

	/**
	 *     .   GetSBlocks.
	 * @param $Name
	 * @param $TemplateStr
	 */
	public function AddTemplate( $Name, $TemplateStr ){
		$this->GetSBlocks($Name, $TemplateStr);
	}

	/**
	 *       ,     
	 * @static
	 */
	static public function &RepairBlock(&$Block, $enabled = true, $poly = false, $alias = '', $templatefile = '', $plaintext = '', $child = array(), $parent = null){
		if(isset($Block['alias'])){
			//ErrorHandler(E_USER_ERROR, '   '.$alias.'.', __FILE__);
			//return $Block;
			return Starkyt::CreateBlock($enabled, $poly, $alias, $templatefile, $plaintext, $child);
		}
		$NewBlock = Starkyt::CreateBlock($enabled, $poly, $alias, $templatefile, $plaintext, $child, $parent);
		$NewBlock['sub'] = $Block['sub'];
		if(!isset($NewBlock['sub'][0]['enabled'])){
			$NewBlock['sub'][0] = Starkyt::CreateSubBlock(true,
				isset($NewBlock['sub'][0]['vars']) ? $NewBlock['sub'][0]['vars'] : array(),
				isset($NewBlock['sub'][0]['tempvars']) ? $NewBlock['sub'][0]['tempvars'] : array()
			);
		}
		return $NewBlock;
	}

	static public function &RepairTable(&$Block, $enabled = true, $alias = '', $cols = 5, $templatefile = '', $plaintext = ''){
		if(isset($Block['alias'])){
			//ErrorHandler(E_USER_ERROR, '   '.$alias.'.');
			//return $Block;
			return Starkyt::CreateTable($enabled, $alias, $cols, $templatefile, $plaintext);
		}
		$NewBlock = Starkyt::CreateTable($enabled, $alias, $cols, $templatefile, $plaintext);
		$NewBlock['sub'] = $Block['sub'];
		if(!isset($NewBlock['sub'][0]['enabled'])){
			$NewBlock['sub'][0] = Starkyt::CreateSubBlock(true,
				isset($NewBlock['sub'][0]['vars']) ? $NewBlock['sub'][0]['vars'] : array(),
				isset($NewBlock['sub'][0]['tempvars']) ? $NewBlock['sub'][0]['tempvars'] : array()
			);
		}
		return $NewBlock;
	}

	/**
	 *     
	 * @param bool   $enabled
	 * @param bool   $poly
	 * @param string $alias
	 * @param string $templatefile
	 * @param string $plaintext
	 * @param array  $child
	 * @param null   $parent
	 * @return array
	 */
	static public function &CreateBlock($enabled = true, $poly = false, $alias = '', $templatefile = '', $plaintext = '', $child = array(), $parent = null){
		if(!$poly){
			$new = array('type' => STARKYT_POLY, 'alias' => $alias, 'sub' => array(Starkyt::CreateSubBlock($enabled, array(), array(), $templatefile, $plaintext, $child)), 'parent' => $parent);
		} else{
			$new = array('type' => STARKYT_POLY, 'alias' => $alias, 'sub' => array(), 'parent' => $parent);
			if($templatefile != ''){
				$new['template'] = $templatefile;
			}
			if($plaintext != ''){
				$new['plaintext'] = $plaintext;
			}
			if(count($child) > 0){
				$new['child'] = $child;
			}
		}
		return $new;
	}

	/**
	 *     
	 * @param bool   $enabled
	 * @param array  $vars
	 * @param array  $tempvars
	 * @param string $templatefile
	 * @param string $plaintext
	 * @param array  $child
	 * @param null   $parent
	 * @return array
	 */
	static public function &CreateSubBlock($enabled = true, $vars = array(), $tempvars = array(), $templatefile = '', $plaintext = '', $child = array(), $parent = null){
		$block = array(
			'enabled' => $enabled,
			'plaintext' => $plaintext,
			'template' => $templatefile,
			'vars' => $vars,
			'tempvars' => $tempvars,
			'child' => $child,
			'parent' => $parent
		);
		return $block;
	}

	/**
	 *   
	 * @deprecated
	 * @param bool   $enabled
	 * @param string $alias
	 * @param int    $cols
	 * @param string $templatefile
	 * @param string $plaintext
	 * @return array
	 */
	static public function &CreateTable($enabled = true, $alias = '', $cols = 5, $templatefile = '', $plaintext = ''){
		$new = array('type' => STARKYT_TABLE, 'alias' => $alias, 'sub' => array(), 'cols' => $cols);
		if($templatefile != ''){
			$new['template'] = $templatefile;
		}
		if($plaintext != ''){
			$new['plaintext'] = $plaintext;
		}
		return $new;
	}

	/**
	 *    
	 * @deprecated
	 * @param bool   $enabled
	 * @param array  $vars
	 * @param array  $tempvars
	 * @param string $templatefile
	 * @param string $plaintext
	 * @param int    $colspan
	 * @param int    $rowspan
	 * @param array  $child
	 * @return array
	 */
	static public function &CreateTableCell($enabled = true, $vars = array(), $tempvars = array(), $templatefile = '', $plaintext = '', $colspan = 1, $rowspan = 1, $child = array()){
		$table = array(
			'enabled' => $enabled,
			'plaintext' => $plaintext,
			'template' => $templatefile,
			'vars' => $vars,
			'tempvars' => $tempvars,
			'child' => $child,
			'colspan' => $colspan,
			'rowspan' => $rowspan
		);
		return $table;
	}

	/**
	 *     
	 * @param        $name
	 * @param bool   $enabled
	 * @param bool   $poly
	 * @param string $alias
	 * @param string $templatefile
	 * @param string $plaintext
	 * @param array  $child
	 */
	public function AddBlock($name, $enabled = true, $poly = false, $alias = '', $templatefile = '', $plaintext = '', $child = array()){
		if(isset($this->Blocks[$name])){
			$this->Blocks[$name] = Starkyt::RepairBlock($this->Blocks[$name], $enabled, $poly, $alias, $templatefile, $plaintext, $child);
		} else{
			$this->Blocks[$name] = Starkyt::CreateBlock($enabled, $poly, $alias, $templatefile, $plaintext, $child);
		}
		$this->GetSBlocks($templatefile);
	}

	/**
	 *          
	 * @param        $name
	 * @param bool   $enabled
	 * @param array  $vars
	 * @param array  $tempvars
	 * @param string $templatefile
	 * @param string $plaintext
	 * @param array  $child
	 * @return int
	 */
	public function AddSubBlock($name, $enabled = true, $vars = array(), $tempvars = array(), $templatefile = '', $plaintext = '', $child = array()){
		$this->Blocks[$name]['sub'][] = Starkyt::CreateSubBlock($enabled, $vars, $tempvars, $templatefile, $plaintext, $child);
		$this->GetSBlocks($templatefile);
		foreach($tempvars as $temp){
			$this->GetSBlocks($temp);
		}
		return (count($this->Blocks[$name]['sub']) - 1);
	}

	/**
	 *   -
	 * @deprecated
	 * @param        $name
	 * @param bool   $enabled
	 * @param string $alias
	 * @param int    $cols
	 * @param string $templatefile
	 * @param string $plaintext
	 */
	public function AddTable($name, $enabled = true, $alias = '', $cols = 5, $templatefile = '', $plaintext = ''){
		if(isset($this->Blocks[$name])){
			$this->Blocks[$name] = Starkyt::RepairTable($this->Blocks[$name], $enabled, $alias, $cols, $templatefile, $plaintext);
		} else{
			$this->Blocks[$name] = Starkyt::CreateTable($enabled, $alias, $cols, $templatefile, $plaintext);
		}
		$this->GetSBlocks($templatefile);
	}

	/**
	 *   - .
	 * @deprecated
	 * @param        $name
	 * @param bool   $enabled
	 * @param array  $vars
	 * @param array  $tempvars
	 * @param string $templatefile
	 * @param string $plaintext
	 * @param int    $colspan
	 * @param int    $rowspan
	 * @param array  $child
	 * @return int
	 */
	public function AddTableCell($name, $enabled = true, $vars = array(), $tempvars = array(), $templatefile = '', $plaintext = '', $colspan = 1, $rowspan = 1, $child = array()){
		$this->Blocks[$name]['sub'][] = Starkyt::CreateTableCell($enabled, $vars, $tempvars, $templatefile, $plaintext, $colspan, $rowspan, $child);
		$this->GetSBlocks($templatefile);
		foreach($tempvars as $temp){
			$this->GetSBlocks($temp);
		}
		return (count($this->Blocks[$name]['sub']) - 1);
	}

	/**
	 *          .
	 * @param     $Block
	 * @param     $VarName
	 * @param     $Value
	 * @param int $SubId
	 */
	public function SetVar($Block, $VarName, $Value, $SubId = 0){
		if(isset($this->Blocks[$Block])){
			$this->Blocks[$Block]['sub'][$SubId]['vars'][$VarName] = $Value;
		}
	}

	/**
	 *        .
	 * @since 1.4
	 * @param     $Block
	 * @param     $Vars
	 * @param int $SubId
	 */
	public function SetVars($Block, $Vars, $SubId = 0){
		if(isset($this->Blocks[$Block])){
			$this->Blocks[$Block]['sub'][$SubId]['vars'] = $Vars;
		}
	}

	/**
	 *      ,      .
	 * @since 1.4
	 * @param     $Block
	 * @param     $Vars
	 * @param int $SubId
	 */
	public function AddVars($Block, $Vars, $SubId = 0){
		if(isset($this->Blocks[$Block])){
			if(!isset($this->Blocks[$Block]['sub'][$SubId]['vars'])){
				$this->Blocks[$Block]['sub'][$SubId]['vars'] = array();
			}
			$block_vars = & $this->Blocks[$Block]['sub'][$SubId]['vars'];
			foreach($Vars as $key => $value){
				$block_vars[$key] = $value;
			}
		}
	}

	/**
	 * ,        .
	 * @param     $Block
	 * @param     $VarName
	 * @param int $SubId
	 * @since 1.4.1
	 */
	public function HasVar($Block, $VarName, $SubId = 0){
		return isset($this->Blocks[$Block]['sub'][$SubId]['vars'][$VarName]);
	}

	/**
	 *  -        
	 * @param     $Block
	 * @param     $VarName
	 * @param     $TemplateFile
	 * @param int $SubId
	 */
	public function SetTempVar($Block, $VarName, $TemplateFile, $SubId = 0){
		if(isset($this->Blocks[$Block])){
			$this->Blocks[$Block]['sub'][$SubId]['tempvars'][$VarName] = $TemplateFile;
			$this->GetSBlocks($TemplateFile);
		}
	}

	/**
	 *   -        
	 * @since 1.4
	 * @param     $Block
	 * @param     $Vars
	 * @param int $SubId
	 */
	public function SetTempVars($Block, $Vars, $SubId = 0){
		if(isset($this->Blocks[$Block])){
			$this->Blocks[$Block]['sub'][$SubId]['tempvars'] = $Vars;
			foreach($Vars as $temp){
				$this->GetSBlocks($temp);
			}
		}
	}

	/**
	 *  -    ,      .
	 * @since 1.4
	 * @param     $Block
	 * @param     $Vars
	 * @param int $SubId
	 */
	public function AddTempVars($Block, $Vars, $SubId = 0){
		if(isset($this->Blocks[$Block])){
			if(!isset($this->Blocks[$Block]['sub'][$SubId]['tempvars'])){
				$this->Blocks[$Block]['sub'][$SubId]['tempvars'] = array();
			}
			$block_vars = & $this->Blocks[$Block]['sub'][$SubId]['tempvars'];
			foreach($Vars as $key => $value){
				$block_vars[$key] = $value;
				$this->GetSBlocks($value);
			}
		}
	}

	/**
	 * ,         .
	 * @param     $Block
	 * @param     $VarName
	 * @param int $SubId
	 * @since 1.4.1
	 */
	public function HasTempVar($Block, $VarName, $SubId = 0){
		return isset($this->Blocks[$Block]['sub'][$SubId]['tempvars'][$VarName]);
	}

	/**
	 *           
	 * @param        $name
	 * @param bool   $enabled
	 * @param bool   $poly
	 * @param string $alias
	 * @param string $templatefile
	 * @param string $plaintext
	 * @return StarkytBlock
	 */
	public function NewBlock($name, $enabled = true, $poly = false, $alias = '', $templatefile = '', $plaintext = ''){
		if(isset($this->Blocks[$name])){
			$this->Blocks[$name] = Starkyt::RepairBlock($this->Blocks[$name], $enabled, $poly, $alias, $templatefile, $plaintext, array());
		} else{
			$this->Blocks[$name] = Starkyt::CreateBlock($enabled, $poly, $alias, $templatefile, $plaintext);
		}
		$this->GetSBlocks($templatefile);
		return new StarkytBlock($this->Blocks[$name], $this, $name);
	}

	/**
	 *      .
	 * @param     $name
	 * @param int $SubId
	 * @return bool
	 */
	public function HasBlock($name, $SubId = 0){
		if($SubId != 0){
			return isset($this->Blocks[$name]['sub'][$SubId]);
		} else{
			return isset($this->Blocks[$name]);
		}
	}

	public function Compile(){
		return StarkytCompile($this->TemplateFile, array($this->Blocks), array(array()), 0, $this);
	}

}

class StarkytBlock extends StarkytAbstractBlock{

	/**
	 *  .
	 * @since 1.4.1
	 * @var string
	 */
	public $Name;

	public function __construct(&$block, Starkyt &$starkyt, $Name = ''){
		$this->Name = $Name;
		parent::__construct($block, $starkyt);
	}

	/**
	 *         
	 * @param bool   $enabled
	 * @param array  $vars
	 * @param array  $tempvars
	 * @param string $templatefile
	 * @param string $plaintext
	 * @return StarkytSubBlock
	 */
	public function NewSubBlock($enabled = true, $vars = array(), $tempvars = array(), $templatefile = '', $plaintext = ''){
		$this->block['sub'][] = Starkyt::CreateSubBlock($enabled, $vars, $tempvars, $templatefile, $plaintext, array(), $this);
		$this->starkyt->GetSBlocks($templatefile);
		foreach($tempvars as $temp){
			$this->starkyt->GetSBlocks($temp);
		}
		return new StarkytSubBlock($this->block['sub'][count($this->block['sub']) - 1], $this->starkyt);
	}

	/**
	 *          .
	 * @param string $name
	 * @param bool   $enabled
	 * @param bool   $poly
	 * @param string $alias
	 * @param string $templatefile
	 * @param string $plaintext
	 * @return StarkytBlock
	 */
	public function NewBlock($name, $enabled = true, $poly = false, $alias = '', $templatefile = '', $plaintext = ''){
		$this->block['child'][$name] = Starkyt::CreateBlock($enabled, $poly, $alias, $templatefile, $plaintext, array(), $this);
		if($templatefile != ''){
			$this->starkyt->GetSBlocks($templatefile);
		}
		return new StarkytBlock($this->block['child'][$name], $this->starkyt, $name);
	}

	/**
	 *      
	 * @param $BlockName
	 * @return StarkytBlock
	 */
	public function GetChildBlock($BlockName){
		if($this->HasBlock($BlockName)){
			return new StarkytBlock($this->block['child'][$BlockName], $this->starkyt, $BlockName);
		} else{
			return null;
		}
	}

	/**
	 *    (  STARKYT_POLY).
	 *
	 * @param int $Index
	 */
	public function GetSubBlock($Index = 0){
		if(isset($this->block['sub'][$Index])){
			return new StarkytSubBlock($this->block['sub'][$Index], $this->starkyt);
		} else{
			return null;
		}
	}

	/**
	 *     .
	 * @param $Enabled
	 * @since 1.4.1
	 */
	public function Enabled($Enabled = null){
		if(isset($Enabled)){
			$this->block['sub'][0]['enabled'] = $Enabled;
		}
		return $this->block['sub'][0]['enabled'];
	}

}

class StarkytSubBlock extends StarkytAbstractBlock{

	/**
	 *          .
	 * @param string $name
	 * @param bool   $enabled
	 * @param bool   $poly
	 * @param string $alias
	 * @param string $templatefile
	 * @param string $plaintext
	 * @return StarkytBlock
	 */
	public function NewBlock($name, $enabled = true, $poly = false, $alias = '', $templatefile = '', $plaintext = ''){
		$this->block['child'][$name] = Starkyt::CreateBlock($enabled, $poly, $alias, $templatefile, $plaintext, array(), $this);
		if($templatefile != ''){
			$this->starkyt->GetSBlocks($templatefile);
		}
		return new StarkytBlock($this->block['child'][$name], $this->starkyt, $name);
	}

	/**
	 *      
	 * @param $BlockName
	 * @return StarkytBlock
	 */
	public function GetChildBlock($BlockName){
		if($this->HasBlock($BlockName)){
			return new StarkytBlock($this->block['child'][$BlockName], $this->starkyt, $BlockName);
		} else{
			return null;
		}
	}

	/**
	 *     .
	 * @param $Enabled
	 * @since 1.4.1
	 */
	public function Enabled($Enabled = null){
		if(isset($Enabled)){
			$this->block['enabled'] = $Enabled;
		}
		return $this->block['enabled'];
	}

}

abstract class StarkytAbstractBlock{

	protected $block;

	/**
	 * @var Starkyt
	 */
	protected $starkyt;

	public function __construct(&$block, Starkyt &$starkyt){
		$this->block = & $block;
		$this->starkyt = & $starkyt;
	}

	/**
	 * ,      $BlockName     .
	 * @param $BlockName
	 * @since 1.4.1
	 */
	public function HasBlock($BlockName){
		return isset($this->block['child'][$BlockName]);
	}

	/**
	 *  .
	 * @param  $Name
	 * @param  $Value
	 * @return StarkytBlock
	 */
	public function SetVar($Name, $Value){
		$this->block['vars'][$Name] = $Value;
		return $this;
	}

	/**
	 *   .
	 * @param  $Vars
	 * @return StarkytBlock
	 */
	public function SetVars($Vars){
		$this->block['vars'] = $Vars;
		return $this;
	}

	/**
	 *  ,      .
	 * @param     $Vars
	 * @since 1.4.1
	 */
	public function AddVars($Vars){
		if(!isset($this->block['vars'])){
			$this->block['vars'] = array();
		}
		foreach($Vars as $key => $value){
			$this->block['vars'][$key] = $value;
		}
	}

	/**
	 * ,      .
	 * @param $Name
	 * @return bool
	 * @since 1.4.1
	 */
	public function HasVar($Name){
		return isset($this->block['vars'][$Name]);
	}

	/**
	 *   .
	 * @param $Name
	 * @return mixed
	 * @since 1.4.1
	 */
	public function GetVar($Name){
		if($this->HasVar($Name)){
			return $this->block['vars'][$Name];
		} else{
			return null;
		}
	}

	/**
	 *        
	 * @param  $Name
	 * @param  $Value
	 * @return StarkytBlock
	 */
	public function SetTempVar($Name, $Value){
		$this->block['tempvars'][$Name] = $Value;
		return $this;
	}

	/**
	 *  - 
	 * @param  $TempVars
	 * @return StarkytBlock
	 */
	public function SetTempVars($TempVars){
		$this->block['tempvars'] = $TempVars;
		return $this;
	}

	/**
	 * ,   -   .
	 * @param $Name
	 * @return bool
	 * @since 1.4.1
	 */
	public function HasTempVar($Name){
		return isset($this->block['tempvars'][$Name]);
	}

	/**
	 *   -.
	 * @param $Name
	 * @return mixed
	 * @since 1.4.1
	 */
	public function GetTempVar($Name){
		if($this->HasTempVar($Name)){
			return $this->block['tempvars'][$Name];
		} else{
			return null;
		}
	}

	/**
	 *      
	 * @return StarkytBlock
	 */
	public function Parent(){
		return $this->block['parent'];
	}

	/**
	 *           .
	 * : $SB->enabled, $SB->template.
	 *
	 * @param $Name
	 * @return mixed
	 */
	public function &__get($Name){
		return $this->block[$Name];
	}

	public function __set($Name, $Value){
		$this->block[$Name] = $Value;
	}
}

function StarkytCompile($FileName, $Blocks, $OpenedBlocks, $level, $starkyt){

	//    
	if($level > 128) {
		return 'Starkyt Recursion Limit;';
	}
	$SBlocks = $starkyt->GetSBlocks($FileName);
	$result = $SBlocks[0];
	$cnt = count($SBlocks);
	$findClose = false;
	$closename = '';
	$name = '';
	$cols = 1;

	for($start = 1; $start < $cnt; $start = $start + 2){


		$line = & $SBlocks[$start]; //  
		if($findClose){ //   
			if($line === $closename){
				$line = array(STARKYT_END, $Blocks[$level][$name], 0, $name, $findClose, $cols, count($Blocks[$level][$name]['sub']), 1);
				$start -= 2; //    "is_array($line)"
				$SBlocks[$findClose][4] = $start; //     
				$level++;
				$findClose = false;
			}
			continue;
		}




		if(is_array($line)){ //       
			$linetype = & $line[0];

			if($linetype === STARKYT_END){
				$b = & $line[1];
				$i = & $line[2];
				if(isset($b['sub'][$i])){
					$sub = $b['sub'][$i];
					if(!$sub['enabled']){
						$i++;
						$start -= 2;
						continue;
					}
					//     ,   
					$Blocks[$level] = $Blocks[$level - 1];
					$OpenedBlocks[$level] = $OpenedBlocks[$level - 1];
					$line[1]--;
					if(isset($b['vars'])){
						$sub['vars'] = $b['vars'];
					}
					if(isset($b['tempvars'])){
						$sub['tempvars'] = $b['tempvars'];
					}
					if(isset($b['plaintext'])){
						$sub['plaintext'] = $b['plaintext'];
					}
					if(isset($b['template'])){
						$sub['template'] = $b['template'];
					}
					$sub['vars']['even'] = ($i % 2 == 0);
					$sub['vars']['odd'] = !$sub['vars']['even'];
					$sub['vars']['first'] = $i == 0;
					$sub['vars']['last'] = !isset($b['sub'][$i + 1]);
					$sub['vars']['rs'] = ($line[7] == 1);
					$sub['vars']['re'] = ($line[7] == $line[5] || $sub['vars']['last']);
					if($sub['plaintext']){
						$result .= $sub['plaintext'];
						//   
						if($b['type'] == STARKYT_TABLE && $i != 0){
							$result .= '<!--   -->'.$starkyt->TableCellClose."\n";
							if($sub['vars']['re']) {
								$result .= '<!--   -->'."</tr>\n";
							}
							if($i != $line[6]){
								if($sub['vars']['re']) {
									$result .= '<!--   -->'."<tr>\n";
								}
								$tcopen = str_replace('{colspan}', '', $starkyt->TableCellOpen);
								$tcopen = str_replace('{rowspan}', '', $tcopen);
								$result .= '<!--   -->'.$tcopen."\n";
							}
						}
						$i++;
						$line[7]++;
						if($line[7] > $line[5]){
							$line[7] = 1;
						}
						$start -= 2;
						continue;
					}

					//          
					if(isset($b['child'])){
						$Blocks[$level] = array_merge($Blocks[$level], $b['child']);
					}
					$Blocks[$level] = array_merge($Blocks[$level], $sub['child']);

					//     
					$OpenedBlocks[$level][$line[3]] = $sub;
					$OpenedBlocks[$level][$b['alias']] = $sub;

					//    
					if($sub['template']){
						$result .= StarkytCompile($sub['template'], $Blocks, $OpenedBlocks, $level, $starkyt);
						//   
						if($b['type'] == STARKYT_TABLE && $i != 0){
							$result .= '<!--   -->'.$starkyt->TableCellClose."\n";
							if($sub['vars']['re']) {
								$result .= '<!--   -->'."</tr>\n";
							}
							if($i != $line[6]){
								if($sub['vars']['re']) {
									$result .= '<!--   -->'."<tr>\n";
								}
								$tcopen = str_replace('{colspan}', '', $starkyt->TableCellOpen);
								$tcopen = str_replace('{rowspan}', '', $tcopen);
								$result .= '<!--   -->'.$tcopen."\n";
							}
						}
						$i++;
						$line[7]++;
						if($line[7] > $line[5]){
							$line[7] = 1;
						}
						$start -= 2;
						continue;
					}

					//   
					if($b['type'] == STARKYT_TABLE && $i != 0){
						$result .= '<!--   -->'.$starkyt->TableCellClose."\n";
						if($sub['vars']['re']) {
							$result .= '<!--   '.$line[7].' -->'."</tr>\n";
						}
						if($i != $line[6]){
							if($sub['vars']['re']) {
								$result .= '<!--   -->'."<tr>\n";
							}
							$tcopen = str_replace('{colspan}', '', $starkyt->TableCellOpen);
							$tcopen = str_replace('{rowspan}', '', $tcopen);
							$result .= '<!--   -->'.$tcopen."\n";
						}
					}
					$i++;
					$line[7]++; //  
					if($line[7] > $line[5]){ // 
						$line[7] = 1;
					}
					$start = $line[4]; //    
					$result .= $SBlocks[$start + 1];
				}else{ //   (  )
					$i = 0;
					$line[7] = 1;
					$level--;
					$result .= $SBlocks[$start + 1];
					if($b['type'] == STARKYT_TABLE){
						$result .= '<!--   -->'.$starkyt->TableCellClose.'</tr>'.$starkyt->TableClose;
					}
				}
			}elseif($linetype === STARKYT_START){
				$SBlocks[$line[4] + 2][1] = $Blocks[$level][$line[1]];
				//   
				if($Blocks[$level][$line[1]]['type'] == STARKYT_TABLE){
					$tcopen = str_replace('{colspan}', '', $starkyt->TableCellOpen);
					$tcopen = str_replace('{rowspan}', '', $tcopen);
					$result .= '<!--   -->'.$starkyt->TableOpen.'<tr>'.$tcopen."\n";
				}
				$level++;
				$start = $line[4]; //    
			}elseif($linetype === STARKYT_COND){
				$value = $OpenedBlocks[$level][$line[1]]['vars'][$line[2]];
				if(isset($line[6])){ //     =
					$value = $value == $line[6];
				}
				if($line[3]) {
					$value = !$value;
				}
				$level++;
				$start = $line[4]; //    
				$SBlocks[$start + 2][1]['sub'][0]['enabled'] = $value;
			}elseif($linetype === STARKYT_SPEED_COND){
				$value = $OpenedBlocks[$level][$line[1]]['vars'][$line[2]];
				if(isset($line[6])){
					$value = $value == $line[6];
				}
				if($line[3]) {
					$value = !$value;
				}
				if($value){
					$result .= $line[4];
				} else{
					$result .= $line[5];
				}
				$result .= $SBlocks[$start + 1];
			}elseif($linetype === STARKYT_VAR){
				$result .= $OpenedBlocks[$level][$line[1]]['vars'][$line[2]]
					.$SBlocks[$start + 1];
			}elseif($linetype === STARKYT_TEMPVAR){
				$result .= StarkytCompile($OpenedBlocks[$level][$line[1]]['tempvars'][$line[2]], $Blocks, $OpenedBlocks, $level, $starkyt)
					.$SBlocks[$start + 1];
			}elseif($linetype === STARKYT_TEXT){
				$result .= $line[1].$SBlocks[$start + 1];
			}
			continue;
		}




		if(strpos($line, ':') !== false){ // STARKYT_COND
			$m = explode(':', $line, 2);
			$block_name = $m[0];
			$inv = false;
			if($m[0]{0} === '!'){
				$block_name = substr($m[0], 1);
				$inv = true;
			}
			if(strpos($m[1], '(') !== false){ //STARKYT_SPEED_COND
				$m[1] = explode('(', $m[1], 2);
				$var_name = $m[1][0];
				$var_name = explode('=', $var_name, 2);
				if(isset($var_name[1])){
					$cond_value = $var_name[1];
				} else{
					$cond_value = null;
				}
				$var_name = $var_name[0];
				$vals = explode('|', $m[1][1], 2);
				if(isset($vals[1])){
					$vals[1] = substr($vals[1], 0, -1);
				} else{
					$vals[0] = substr($vals[0], 0, -1);
					$vals[1] = '';
				}
				if(isset($OpenedBlocks[$level][$block_name]['vars'][$var_name])){
					$value = $OpenedBlocks[$level][$block_name]['vars'][$var_name];
					if(isset($cond_value)){
						$value = $value == $cond_value;
					}
					if($inv) {
						$value = !$value;
					}
					if($value){
						$result .= $vals[0];
					} else{
						$result .= $vals[1];
					}
					$result .= $SBlocks[$start + 1];
					$line = array(STARKYT_SPEED_COND, $block_name, $var_name, $inv, $vals[0], $vals[1], $cond_value);
					continue;
				}
			}
			$var_name = $m[1];
			$var_name = explode('=', $var_name, 2);
			if(isset($var_name[1])){
				$cond_value = $var_name[1];
			} else{
				$cond_value = null;
			}
			$var_name = $var_name[0];
			if(isset($OpenedBlocks[$level][$block_name]['vars'][$var_name])){
				$value = $OpenedBlocks[$level][$block_name]['vars'][$var_name];
				if(isset($cond_value)){
					$value = $value == $cond_value;
				}
				if($inv) {
					$value = !$value;
				}
				$name = $line;
				$closename = '/'.$block_name.':'.$var_name;
				$findClose = $start;
				$cols = 1;
				$Blocks[$level][$name] = Starkyt::CreateBlock($value);
				$line = array(STARKYT_COND, $block_name, $var_name, $inv, 0, $name, $cond_value);
				continue;
			}
		}elseif(strpos($line, '.') !== false){ // 
			$m = explode('.', $line, 2);
			if(isset($OpenedBlocks[$level][$m[0]]['tempvars'][$m[1]])){
				$result .= StarkytCompile($OpenedBlocks[$level][$m[0]]['tempvars'][$m[1]], $Blocks, $OpenedBlocks, $level, $starkyt)
					.$SBlocks[$start + 1];
				$line = array(STARKYT_TEMPVAR, $m[0], $m[1]);
				continue;
			}
			if(isset($OpenedBlocks[$level][$m[0]]['vars'][$m[1]])){
				$result .= $OpenedBlocks[$level][$m[0]]['vars'][$m[1]]
					.$SBlocks[$start + 1];
				$line = array(STARKYT_VAR, $m[0], $m[1]);
				continue;
			}
		}elseif(strpos($line, '[') !== false){ //  
			$m = explode('[', $line, 2);
			$m[1] = substr($m[1], 0, -1);
			if(isset($Blocks[$level][$m[0]])){
				$name = $m[0];
				$closename = '/'.$m[0];
				$findClose = $start;
				$cols = intval($m[1]);
				$line = array(STARKYT_START, $name, $closename, $cols);
				continue;
			}
		}elseif(isset($Blocks[$level][$line])){ //   
			$name = $line;
			$closename = '/'.$line;
			$findClose = $start;
			$cols = 1;
			//   
			if($Blocks[$level][$line]['type'] == STARKYT_TABLE){
				$cols = $Blocks[$level][$line]['cols'];
				$tcopen = str_replace('{colspan}', '', $starkyt->TableCellOpen);
				$tcopen = str_replace('{rowspan}', '', $tcopen);
				$result .= '<!--   -->'.$starkyt->TableOpen.'<tr>'.$tcopen."\n";
			}
			$line = array(STARKYT_START, $name, $closename, $cols);
			continue;
		}

		$line = STARKYT_OPENKEY.$line.STARKYT_CLOSEKEY;
		$result .= $line.$SBlocks[$start + 1];
		$line = array(STARKYT_TEXT, $line);
	}


//	if(isset($starkyt->ToCache[$FileName])){
//		System::cache()->Write(STARKYT_CACHE, $starkyt->ToCache[$FileName], $SBlocks);
//	}

	return str_replace(array('&#123;', '&#125;'), array('{', '}'), $result);
}
