<?php

/*
 * LinkorCMS 1.4
 *  2012 LinkorCMS Development Group
 */


/**
 *  
 */

define('ACCESS_ADMIN', 1);
define('ACCESS_MEMBER', 2);
define('ACCESS_GUEST', 3);
define('ACCESS_ALL', 4);

/**
 *    
 *        
 * @param bool $LowProtect
 * @param bool $Redirect
 * @return void
 */
function HackOff( $LowProtect=false, $Redirect=true ){
	global $config;
	if(System::user()->isAdmin() || $LowProtect){
		if(defined('MAIN_SCRIPT') || defined('PLUG_SCRIPT') || !defined('ADMIN_SCRIPT')){
			if($Redirect){
				GO(Ufu('index.php'));
			}
		}elseif(defined('ADMIN_SCRIPT')){
			GO(ADMIN_FILE);
		}
	}else{
		if(System::config('security/hack_event') == 'alert'){
			die(System::config('security/hack_alert'));
		}elseif(System::config('security/hack_event') == 'ban'){
			die('     ,    
			   .   ,     , - 
			    e-mail '.System::config('general/site_email').'.');
		}else{
			if($Redirect){
				GO(Ufu('index.php'));
			}
		}
	}
}

/**
 *     
 * @param $Level
 * @param string $Admins
 * @param string $Members
 * @param string $Guests
 * @param string $All
 * @return string
 */
function ViewLevelToStr( $Level, $Admins='', $Members='', $Guests='', $All='' ){
	switch($Level){
		case 1: $Admins == '' ? $view = '<span style="color: #FF0000;"></span>' : $view = $Admins;
		break;
		case 2: $Members == '' ? $view = '<span style="color: #0080FF;"></span>' : $view = $Members;
		break;
		case 3: $Guests == '' ? $view = '<span style="color: #A0A000;"></span>' : $view = $Guests;
		break;
		case 4:
		default: $All == '' ? $view = '<span style="color: #008000;"></span>' : $view = $All;
	}
	return $view;
}

/**
 *          (),
 *       
 * @param $ParamName         
 * @param $ExWhere  
 * @param null $UserAccess   
 * @return string
 */
function GetWhereByAccess( $ParamName, $ExWhere = '', $UserAccess=null ){
	if($UserAccess == null){
		$UserAccess = System::user()->AccessLevel();
	}
	$where = "`$ParamName`='4'";
	if($UserAccess == ACCESS_ADMIN){ // 
		$where = '';
	}elseif($UserAccess == ACCESS_MEMBER){ // 
		$where .= " or `$ParamName`='2'";
	}else{ // 
		$where .= " or `$ParamName`='3'";
	}
	if($ExWhere != '' && $where != ''){
		return '('.$ExWhere.') and ('.$where.')';
	}elseif($ExWhere != '' && $where == ''){
		return $ExWhere;
	}elseif($ExWhere == '' && $where != ''){
		return $where;
	}else{
		return '';
	}
}

/**
 *             .
 * @param Integer $viewlevel   
 * @param null $user_access   
 * @internal param int $accesslevel   
 * @return Boolean
 */
 function AccessIsResolved( $viewlevel, $user_access = null ){
	if($user_access == null){
		$user_access = System::user()->AccessLevel();
	}
	if($user_access == ACCESS_ADMIN){
		return true;
	}elseif($user_access == ACCESS_MEMBER && ($viewlevel == ACCESS_ALL || $viewlevel == ACCESS_MEMBER)){
		return true;
	}elseif($user_access == ACCESS_GUEST && ($viewlevel == ACCESS_ALL || $viewlevel == ACCESS_GUEST)){
		return true;
	}elseif($user_access == $viewlevel){
		return true;
	}
	return false;
}

/**
 *     ,        .
 * @param array|string $Conditions
 * @param array|string $Uri
 */
function VisibilityConditionsAdmin( $Conditions = array(), $Uri = array() ){
	if(is_string($Conditions)){
		$Conditions = unserialize($Conditions);
	}
	if(is_string($Uri)){
		$Uri = unserialize($Uri);
	}
	$extrauri = SafeDB(implode(WIN_EOL, $Uri), 0, str);

	//          
	$mods = System::database()->Select('modules', "`isindex`='1'");
	array_unshift($mods, array('name'=>' ', 'folder'=>'INDEX'));

	$num = 0;
	$ac = '';
	$ac .= Indent('
		<table width="100%" cellspacing="0" cellpadding="0" style="margin-bottom: 5px;">
			<tr>
				<td style="border: none;"><label>'.System::site()->Radio('showin[]', 'SELECT_ONLY', in_array('SELECT_ONLY', $Conditions) || !in_array('ALL_EXCEPT', $Conditions)).'<span style="display: inline-block; vertical-align: top; padding-top: 3px;"> :</span></label></td>
				<td style="border: none;"><label>'.System::site()->Radio('showin[]', 'ALL_EXCEPT', in_array('ALL_EXCEPT', $Conditions)).'<span style="display: inline-block; vertical-align: top; padding-top: 3px;"> , :<span></label></td>
			</tr>
		</table>
		<table width="100%" cellspacing="0" cellpadding="0" style="margin-bottom: 5px;">
	');
	foreach($mods as $a){
		if($num == 0){
			$ac .= '<tr>';
		}
		$num++;
		$ac .= '<td style="border: none;"><label>'.System::site()->Check('showin[]', SafeDB($a['folder'], 255, str), in_array(SafeDB($a['folder'], 255, str), $Conditions)).'<span style="display: inline-block; vertical-align: top; padding-top: 3px;">'.SafeDB($a['name'], 255, str).'</span></label></td>';
		if($num == 3){
			$ac .= '</tr>';
			$num = 0;
		}
	}
	if($num != 0){
		$ac .= '</tr>';
	}
	$ac .= Indent('
		</table>
		<table width="100%" cellspacing="0" cellpadding="0" style="margin-bottom: 5px;">
			<tr>
				<td style="border: none; padding-bottom: 4px;"> (URL):<br>: /index.php?name=pages&amp;file=page  /pages/page.html.    .</td>
			</tr>
			<tr>
				<td style="border: none;">'.System::site()->TextArea('extra_uri', $extrauri, 'style="width: 95%; min-width: 400px; height: 100px;"').'</td>
			</tr>
		</table>
	');
	System::admin()->FormTitleRow(' ');
	FormRow('', $ac);
}

/**
 *     .
 */
function VisibilityConditionsAdminSave( &$ShowIn, &$ShowInUri ){
	$ShowIn = serialize(SafeEnv($_POST['showin'], 0, str));
	$ShowInUri = serialize(SafeEnv(explode(WIN_EOL, $_POST['extra_uri']), 0, str));
}

/**
 *       .
 * @param array $Conditions
 * @param array $Uri
 * @return bool
 */
function VisibilityConditionsCheck( $Conditions = array(), $Uri = array() ){
	global $ModuleName;

	if(is_string($Conditions)){
		if($Conditions == ''){
			$Conditions = array();
		}else{
			$Conditions = unserialize($Conditions);
		}
	}
	if(is_string($Uri)){
		if($Uri == ''){
			$Uri = array();
		}else{
			$Uri = unserialize($Uri);
		}
	}

	$r = false;

	if(INDEX_PHP == true){
		if(in_array('INDEX', $Conditions)){
			$r = true;
		}
	}else{
		if(in_array($ModuleName, $Conditions)){
			$r = true;
		}elseif($_SERVER['REQUEST_URI'] != '' && in_array($_SERVER['REQUEST_URI'], $Uri)){
			$r = true;
		}
	}

	if(in_array('ALL_EXCEPT', $Conditions)){
		$r = !$r;
	}
	return $r;
}

/**
 *       .
 * @param type $Group
 * @param type $Name
 * @param type $Description
 */
function AddAccessRestriction( $Group, $Name, $Description ){
	$Group = SafeEnv($Group, 255, str);
	$Name = SafeEnv($Name, 255, str);
	$Description = SafeEnv($Description, 255, str);
	System::database()->Insert('access', "'','$Group','$Name','$Description'");
}

/**
 *    .
 * @param type $Group
 * @param type $Name
 */
function RemoveAccessRestriction( $Group, $Name ){
	System::database()->Delete('access', "`group`='$Group' and `name`='$Name'");
}
