<?php

/*
 * LinkorCMS 1.4
 *  2012 LinkorCMS Development Group
 */


/**
 *     .
 */

//    
define('EXT_MODULE', '1');
define('EXT_PLUGIN', '2');
define('EXT_BLOCK', '3');
define('EXT_TEMPLATE', '4');

/**
 *       
 * @param      $ExtPath      
 * @param null $PluginGroupInfo
 * @return array
 */
function ExtLoadInfo( $ExtPath, $PluginGroupInfo = null ){
	$result = false;
	$infoFile = RealPath2($ExtPath.'/info.php');
	if(is_file($infoFile)){ //    PHP 
		$result = include $infoFile;
		if(!is_array($result)){
			if(isset($module)){ //   
				foreach($module as $module){}
				$result = array(
					'name' => $module['name'],
					'description' => $module['comment'],
					'author' => $module['copyright'],
					'site' => '',
					'version' => '',
					'1.3' => true
				);
			}elseif(isset($plugins)){ //   
				foreach($plugins as $plugins){}
				$result = array(
					'name' => $plugins['name-ru'],
					'description' => $plugins['description-ru'],
					'author' => $plugins['author'],
					'site' => $plugins['site'],
					'version' => $plugins['version'],
					'function' => '',
					'type' => PLUG_MANUAL,
					'1.3' => true
				);
				if(isset($plugins['function'])){
					$result['function'] = $plugins['function'];
				}
				if(isset($plugins['type'])){
					$result['type'] = $plugins['type'];
				}elseif(isset($PluginGroupInfo) && isset($PluginGroupInfo['1.3_old_plugins_group_type'])){
					$result['type'] = $PluginGroupInfo['1.3_old_plugins_group_type'];
				}
			}elseif(isset($groups)){ //  1.3
				foreach($groups as $groups){}
				$result = array(
					'name' => $groups['name-ru'],
					'description' => $groups['description-ru'],
					'author' => '',
					'site' => '',
					'version' => '',
					'1.3' => true,
					'1.3_old_plugins_group' => true,
					'1.3_old_plugins_group_type' => $groups['type']
				);
			}else{
				return false;
			}
		}
		return $result;
	}
	$infoXML = RealPath2($ExtPath.'/info.xml');
	if(is_file($infoXML)){ //    XML 
		$info = simplexml_load_file($infoXML);
		$result = get_object_vars($info);
		foreach($result as $f=>&$v) {
			$result[$f] = Utf8ToCp1251($v);
		}
		return $result;
	}else{
		return false;
	}
}

/**
 *    .
 *           .
 * @param string     $Name     
 * @param string     $Folder       
 * @param int|string $IsIndex    index.php (1|0)
 * @param int|string $View      (1|2|3|4)
 * @param int|string $System       (1|0).          .
 * @param int|string $Enabled  (1|0)
 * @return void
 */
function ExtAddModule( $Name, $Folder, $IsIndex = 1, $View = 4, $System = 0, $Enabled = 1 ){
	$Name = SafeEnv($Name, 255, str);
	$Folder = SafeEnv($Folder, 255, str);
	$System = SafeEnv($System, 1, int);
	$IsIndex = SafeEnv($IsIndex, 1, int);
	$View = SafeEnv($View, 1, int);
	$Enabled = SafeEnv($Enabled, 1, int);
	System::database()->Insert('modules',"'','$Name','$Folder','$System','$IsIndex','','','$View','$Enabled','0','1',''");
}

/**
 *      .
 * @param string $Folder      
 * @return void
 */
function ExtRemoveModule( $Folder ){
	$Folder = SafeEnv($Folder, 255, str);
	System::database()->Delete('modules', "`folder`='$Folder'");
}

/**
 *    .
 *           .
 * @param string $Group  ,         
 * @param string $Name          
 * @param string $Function  .        
 * @param string $Type  
 * @param string $Enabled 
 * @return void
 */
function ExtAddPlugin( $Group, $Name, $Function, $Type, $Enabled = '1' ){
	$Group = SafeEnv($Group, 250, str);
	$Name = SafeEnv($Name, 255, str);
	$Function = SafeEnv($Function, 255, str);
	$Type = SafeEnv($Type, 1, int);
	$Enabled = SafeEnv($Enabled, 1, int);
	if($Type == PLUG_MANUAL_ONE && $Enabled == '1'){ //     - 
		System::database()->Update('plugins', "`enabled`='0'", "`group`='$Group'");
	}
	System::database()->Insert('plugins',"'','$Name','$Function','','$Type','$Group','0','$Enabled'");
	PluginsClearCache();
}

/**
 *      .
 * @param string $Group    ( )
 * @param string $Name  
 * @return void
 */
function ExtRemovePlugin( $Group, $Name ){
	$Group = SafeEnv($Group, 250, str);
	$Name = SafeEnv($Name, 255, str);
	System::database()->Delete('plugins', "`name`='$Name' and `group`='$Group'");
	PluginsClearCache();
}

/**
 *    .
 *           .
 * @param string $Name   
 * @param string $Folder      
 * @return void
 */
function ExtAddBlock( $Name, $Folder ){
	$Name = SafeEnv($Name, 255, str);
	$Folder = SafeEnv($Folder, 255, str);
	System::database()->Insert('block_types',"'','$Name','','$Folder'");
}

/**
 *      .
 * @param string $Folder      
 * @return void
 */
function ExtRemoveBlock( $Folder ){
	$Folder = SafeEnv($Folder, 255, str);
	System::database()->Delete('block_types', "`folder`='$Folder'");
}

/**
 *    .
 *           .
 * @param        $Name
 * @param string $Folder      
 * @param string $Admin    -
 * @return void
 */
function ExtAddTemplate( $Name, $Folder, $Admin = '0' ){
	$Name = SafeEnv($Name, 255, str);
	$Folder = SafeEnv($Folder, 255, str);
	$Admin = SafeEnv($Admin, 1, int);
	System::database()->Insert('templates',"'','$Name','$Folder','$Admin','0'");
}

/**
 *      .
 * @param string $Folder      
 * @param bool $DelFiles    
 * @return void
 */
function ExtRemoveTemplate( $Folder, $DelFiles = false ){
	$FolderEnv = SafeEnv($Folder, 255, str);
	System::database()->Delete('templates', "`folder`='$FolderEnv'");
	if($DelFiles){ //   
		RmDirRecursive(RealPath2(System::config('tpl_dir').$Folder));
	}
}

/**
 *       .     .
 *        AdminMenuDeleteModule.
 * @param        $Title
 * @param        $Module
 * @param string $Icon
 * @param string $Action       (: admin: exe=mod; external: http://site/; js: alert('message');)
 * @param string $Type    (  jquery_menu: admin, external, js, node, delimiter)
 * @param string $ParentMod
 * @param bool   $ExternalBlank
 * @param string $Js
 * @param bool   $Enabled
 */
function AdminMenuAddItem( $Title, $Module, $Icon = '', $Action = '', $Type = 'admin', $ParentMod = '_mods_menu', $ExternalBlank = true, $Enabled = true ){
	static $ModCache = array();
	if($ParentMod == ''){ //   
		$Parent = '0';
	}else{
		if(!isset($ModCache[$ParentMod])){
			$ParentModEnv = SafeEnv($ParentMod, 255, str);
			System::database()->Select('adminmenu', "`module`='$ParentModEnv'");
			if(System::database()->NumRows() > 0){
				$mod = System::database()->FetchRow();
				$ModCache[$ParentMod] = SafeEnv($mod['id'], 11, int);
			}else{
				return false;
			}
		}
		$Parent = $ModCache[$ParentMod];
	}
	$Title = SafeEnv($Title, 255, str);
	$Module = SafeEnv($Module, 255, str);
	System::database()->Select('adminmenu', "`parent`='$Parent'");
	$Order = System::database()->NumRows();
	if($Icon == ''){
		if(is_file(System::config('mod_dir').$Module.'/icon.png')){
			$Icon = System::config('mod_dir').$Module.'/icon.png';
		}else{
			$Icon = 'images/application.png';
		}
	}
	$Icon = RealPath2(SafeEnv($Icon, 255, str));

	$AdminLink = '';
	$ExternalLink = '';
	$Js = '';

	if($Type == 'admin'){
		if($Action == ''){
			$AdminLink = 'exe='.$Module;
		}else{
			$AdminLink = $Action;
		}
	}elseif($Type == 'external'){
		$ExternalLink = $Action;
	}elseif($Type == 'js'){
		$Js = $Action;
	}

	if($ExternalBlank) $ExternalBlank = '1'; else $ExternalBlank = '0';
	if($Enabled) $Enabled = '1'; else $Enabled = '0';
	System::database()->Insert('adminmenu', "'','$Parent','$Order','$Module','$Title','$Icon','$AdminLink','$ExternalLink','$ExternalBlank','$Js','$Type','$Enabled'");
}

/**
 *         .
 * @param $Title   .
 * @param $Module  .
 * @param string $Icon    .
 * @param string $AdminLink  - (exe=mod_name)
 * @param string $ParentMod   ()      (: _system_menu, _site_menu, _mods_menu, _help_menu).
 */
function AdminMenuAddModule( $Title, $Module, $Icon = '', $AdminLink = '', $ParentMod = '_mods_menu' ){
	AdminMenuAddItem($Title, $Module, $Icon, $AdminLink, 'admin', $ParentMod);
}

/**
 *        .
 * @param $Module
 * @internal param $ModuleName   ()
 */
function AdminMenuDeleteModule( $Module ){
	$Module = SafeEnv($Module, 255, str);
	if($Module != ''){
		System::database()->Delete('adminmenu', "`module`='$Module'");
	}
}