<?php

/*
 * LinkorCMS 1.4
 *  2012 LinkorCMS Development Group
 */


/**
 *       .
 * @param String $FileName    
 * @param bool   $RemoveDot   
 * @return String
 */
function GetFileExt($FileName, $RemoveDot = false){
	$pos = strrpos($FileName, '.');
	if($RemoveDot){
		$pos++;
	}
	if($pos !== false){
		return substr($FileName, $pos);
	} else{
		return '';
	}
}

/**
 *          .
 * @param String $FileName    
 * @param bool   $RemoveDot   
 * @return String
 */
function GetSecondFileExt($FileName, $RemoveDot = false){
	$pos1 = strrpos($FileName, '.');
	if($pos1 === false){
		return '';
	}

	$pos2 = strrpos($FileName, '.', -(strlen($FileName) - $pos1 + 1));
	if($pos2 === false){
		return '';
	}

	if($RemoveDot){
		$RemoveDot = 1;
	} else{
		$RemoveDot = 0;
	}

	return substr($FileName, $pos2 + $RemoveDot, $pos1 - $pos2 - $RemoveDot);
}

/**
 *       .
 * @param string $FileName    
 * @param bool   $RemoveExt  
 * @return String
 */
function GetFileName($FileName, $RemoveExt = false){
	$pos = strrpos($FileName, '/');
	if($pos !== false){
		$FileName = substr($FileName, $pos + 1);
	}
	if($RemoveExt){
		$pos = strrpos($FileName, '.');
		if($pos !== false){
			$FileName = substr($FileName, 0, $pos);
		}
	}
	return $FileName;
}

/**
 *       .
 * @param      $FileName
 * @param bool $LastSlash
 * @return string
 */
function GetPathName($FileName, $LastSlash = true){
	$pos = strrpos($FileName, '/');
	if($pos !== false){
		return substr($FileName, 0, $pos + ($LastSlash ? 1 : 0));
	} else{
		return '';
	}
}

/**
 *            .
 * @param String  $folder          .
 * @param Boolean $use_subfolders   
 * @param Boolean $use_mask         
 * @param String  $mask            .     ( )  .
 * @param Boolean $newSearch          (   )
 * @param String  $parentf          .    .
 * @return Array   
 */
function GetFiles($folder, $use_subfolders = false, $use_mask = false, $mask = '', $newSearch = true, $parentf = ''){
	static $sfiles = array();
	if(!is_dir($folder)){
		return array();
	}
	if($newSearch){
		$sfiles = array();
		AddLastSlash($folder);
	}
	$mask = strtolower($mask);
	if($parentf == ''){
		$parentf = $folder;
	}
	$files = scandir($folder);
	foreach($files as $file){
		if(is_dir($folder.$file) && ($file != '.') && ($file != '..')){
			if($use_subfolders){
				GetFiles($folder.$file.'/', $use_subfolders, $use_mask, $mask, false, $parentf);
			}
		} elseif(is_file($folder.$file)){
			$ext = GetFileExt($file);
			if(!$use_mask || stripos($mask, strtolower($ext)) !== false){
				$rf       = str_replace($parentf, '', $folder.$file);
				$sfiles[] = $rf;
			}
		}
	}
	return $sfiles;
}

/**
 *          .
 * @param        $folder          .
 * @param bool   $use_subfolders   
 * @param bool   $newSearch          (   )
 * @param string $parentf
 * @return array
 */
function GetAllFilesAndFolders($folder, $use_subfolders = false, $newSearch = true, $parentf = ''){
	static $sfiles = array();
	if(!is_dir($folder)){
		return array();
	}
	if($newSearch){
		$sfiles = array();
		AddLastSlash($folder);
	}
	if($parentf == ''){
		$parentf = $folder;
	}
	$files = scandir($folder);
	foreach($files as $file){
		if(is_dir($folder.$file) && ($file != '.') && ($file != '..')){
			$sfiles[] = str_replace($parentf, '', $folder.$file);
			if($use_subfolders){
				GetAllFilesAndFolders($folder.$file.'/', $use_subfolders, false, $parentf);
			}
		} elseif(is_file($folder.$file)){
			$sfiles[] = str_replace($parentf, '', $folder.$file);
		}
	}
	return $sfiles;
}

/**
 *      .
 * @param string $Folder   .
 * @return array
 */
function GetFolders($Folder){
	$result = array();
	if(!is_dir($Folder)){
		return $result;
	}
	AddLastSlash($Folder);
	$files = scandir($Folder);
	foreach($files as $p){
		if(is_dir($Folder.$p) && ($p != ".") && ($p != "..")){
			$result[] = $p;
		}
	}
	return $result;
}

/**
 *      .
 * @param $Folder  .
 * @return int
 */
function GetFolderSize($Folder){
	$file_size = 0;
	AddLastSlash($Folder);
	$files = scandir($Folder);
	foreach($files as $file){
		if(($file != '.') && ($file != '..')){
			$f = $Folder.$file;
			if(is_dir($f)){
				$file_size += GetFolderSize($f);
			} else{
				$file_size += filesize($f);
			}
		}
	}
	return $file_size;
}

/**
 *     .
 * @param string $Path  .
 * @return bool
 */
function RmDirRecursive($Path){
	if(!is_dir($Path)){
		return false;
	}
	AddLastSlash($Path);
	$dir = @opendir($Path);
	if(!$dir){
		return false;
	}
	while($file = @readdir($dir)){
		$fn = $Path.$file;
		if(is_file($fn) || is_link($fn)){
			if(!unlink($fn)){
				return false;
			}
		} elseif(is_dir($fn) && ($file != '.') && ($file != '..')){
			if(!RmDirRecursive($fn)){
				return false;
			}
		}
	}
	@closedir($dir);
	if(!rmdir($Path)){
		return false;
	}
	return true;
}

/**
 *            .
 * @param     $Path
 * @param int $FilesMode
 * @param int $DirsMode
 * @return bool
 */
function ChmodRecursive($Path, $FilesMode = 0666, $DirsMode = 0777){
	if(is_file($Path)){
		chmod($Path, $FilesMode);
		return true;
	}
	AddLastSlash($Path);
	$files = scandir($Path);
	foreach($files as $file){
		if(is_dir($Path.$file) && ($file != '.') && ($file != '..')){
			chmod($Path.$file, $DirsMode);
			ChmodRecursive($Path.$file, $FilesMode, $DirsMode);
		} elseif(is_file($Path.$file)){
			chmod($Path.$file, $FilesMode);
		}
	}
	return true;
}

/**
 *         .
 * @param      $Path  ,       $Dest
 * @param      $Dest  ,    ( ,   )
 * @param bool $createSub
 */
function CopyRecursive($Path, $Dest, $createSub = false){
	if($createSub || !is_dir($Dest)){
		mkdir($Dest);
	}
	if(!$createSub){
		AddLastSlash($Path);
		AddLastSlash($Dest);
	}
	$files = scandir($Path);
	foreach($files as $file){
		$pfile = $Path.$file;
		$dfile = $Dest.$file;
		if(is_dir($pfile) && ($file != '.') && ($file != '..')){
			CopyRecursive($pfile.'/', $dfile.'/', true);
		} elseif(is_file($pfile)){
			copy($pfile, $dfile);
		}
	}
}

/**
 *     .
 * @param     $Path .
 * @param int $Mode
 * @return bool
 */
function MkDirRecursive($Path, $Mode = 0777){
	return mkdir($Path, $Mode, true);
}

/**
 *      .
 *                ,  false.
 *
 * @param $FileName
 * @return bool
 */
function IsPossiblyCreated( $FileName ){
	$FileName = RemoveLastSlash($FileName);
	$path = GetPathName($FileName, false);
	if(is_dir($path)){
		return is_writable($path);
	}
	$len = substr_count($path, '/');
	for($i=0; $i<$len; $i++){
		$pos = strrpos($path, '/');
		$path = substr($path, 0, $pos);
		if(is_dir($path)){
			return is_writable($path);
		}
	}
	return is_writable('.');
}

/**
 *          ".."  ".",
 *     Unix ,
 *       .
 *
 * @param      $Path
 * @param bool $RemoveSymbolicLinks
 * @return mixed|string
 */
function RealPath2($Path, $RemoveSymbolicLinks = true){
	$Path        = str_replace('\\', '/', $Path);
	$path_result = array();
	foreach(explode('/', $Path) as $name){
		if($RemoveSymbolicLinks){
			$name2 = str_replace('.', '', $name);
			if($name2 != ''){
				$path_result[] = $name;
			}
		} else{
			$path_result[] = $name;
		}
	}
	return implode('/', $path_result);
}

/**
 *     Unix ,
 *     .
 *
 * @param $Path
 * @return string
 */
function AddLastSlash(&$Path){
	$Path = str_replace('\\', '/', $Path);
	if(substr($Path, -1) != '/'){
		$Path .= '/';
	}
	return $Path;
}

/**
 *     Unix ,
 *     .
 *
 * @param $Path
 * @return string
 */
function RemoveLastSlash(&$Path){
	$Path = str_replace('\\', '/', $Path);
	if(substr($Path, -1) == '/'){
		$Path = substr($Path, 0, -1);
	}
	return $Path;
}

/**
 *        .
 * @param        $Size
 * @param string $SizeType
 * @return string
 */
function FormatFileSize($Size, $SizeType = 'b'){
	if($SizeType == 'b'){
		$mb = 1024 * 1024;
		if($Size > $mb){
			$Size = sprintf("%01.2f", $Size / $mb).' ';
		} elseif($Size >= 1024){
			$Size = sprintf("%01.2f", $Size / 1024).' ';
		} else{
			$Size = $Size.' ';
		}
	} else{
		if($SizeType == 'k'){
			$Size = $Size.' ';
		} elseif($SizeType == 'm'){
			$Size = $Size.' ';
		} else{
			$Size = $Size.' ';
		}
	}
	return $Size;
}
