<?php

/*
 * LinkorCMS 1.4
 *  2012 LinkorCMS Development Group
 */


function GDVersion(){
	global $config;
	if(!isset($config['info']['gd'])){
		if(!extension_loaded('gd')){
			return ($config['info']['gd'] = 0);
		}
		if(function_exists('gd_info')){
			$ver_info = gd_info();
			preg_match('/\d/', $ver_info['GD Version'],$match);
			$config['info']['gd'] = $match[0];
			return $match[0];
		}else{
			return ($config['info']['gd'] = 0);
		}
	}else{
		return $config['info']['gd'];
	}
}

/**
 *    .
 * @param        $SrcFileName  .
 * @param string $DstFileName      .
 * @param int    $MaxWidth       .
 * @param int    $MaxHeight      .
 * @param bool   $Stretch            .
 * @param null   $SaveFormat     (jpeg, png, gif, wbmp).
 * @return \TPicture
 */
function CreateThumb( $SrcFileName, $DstFileName = '', $MaxWidth = 0, $MaxHeight = 0, $Stretch = false, $SaveFormat = null ){
	$thumb = new TPicture($SrcFileName);
	if($DstFileName == ''){
		return $thumb;
	}elseif(is_file($DstFileName)){
		unlink($DstFileName);
	}
	if($Stretch || (($MaxWidth > 0 || $MaxHeight > 0) && ($thumb->Width > $MaxWidth || $thumb->Height > $MaxHeight))){
		$thumb->SetImageSize($MaxWidth, $MaxHeight);
	}
	$thumb->SaveToFile($DstFileName, $SaveFormat);
	return $thumb;
}

function ImageSize( $FileName ){
	$size = getimagesize($FileName);
	$size['width'] = $size[0];
	$size['height'] = $size[1];
	return $size;
}

/**
 *     .    .
 * @param      $FileName     .
 * @param int  $MaxWidth     .
 * @param int  $MaxHeight    .
 * @param bool $Streech           
 * @param null $SaveFormat    (jpeg, png, gif, wbmp).
 * @return mixed
 */
function GetThumb( $FileName, $MaxWidth = 0, $MaxHeight = 0, $Streech = false, $SaveFormat = null ){
	if($FileName == ''){
		return 'images/no_image.png';
	}elseif(substr($FileName, 0, 7) == 'http://'){
		return $FileName;
	}
	$FileName = RealPath2($FileName);
	if(isset($SaveFormat)){
		$ext = '.'.$SaveFormat;
	}else{
		$ext = GetFileExt($FileName);
	}
	$tmb_path = System::config('general/tmb_path');
	if(!is_dir($tmb_path)){
		MkDirRecursive($tmb_path);
	}
	$tmb_file = $tmb_path.md5($FileName).'_'.$MaxWidth.'x'.$MaxHeight.($Streech ? '_streech' : '').$ext;
	if(!is_file($tmb_file)){
		CreateThumb($FileName, $tmb_file, $MaxWidth, $MaxHeight, $Streech, $SaveFormat);
	}
	return $tmb_file;
}