<?php

/*
 * LinkorCMS 1.4
 *  2012 LinkorCMS Development Group
 */


$system_users_cache = null;
$system_userranks_cache = null;
$system_usertypes_cache = null;

/**
 *         id.
 * @return array
 */
function &GetUsers(){
	global $system_users_cache;
	if($system_users_cache == null){
		if(System::cache()->HasCache(system_cache, 'users')){
			$system_users_cache = System::cache()->Get(system_cache, 'users');
		}else{
			System::database()->Select('users', '');
			$system_users_cache = array();
			foreach(System::database()->QueryResult as $usr){
				$system_users_cache[$usr['id']] = $usr;
			}
			//         
			System::cache()->Write(system_cache, 'users', $system_users_cache, Day2Sec);
		}
	}
	return $system_users_cache;
}

/**
 *       ,  ,  ,     .   .
 * @param $user_id
 * @return array|bool
 */
function GetUserInfo( $user_id ){
	$system_users_cache = GetUsers();
	if(isset($system_users_cache[$user_id])){
		$usr = $system_users_cache[$user_id];
		// 
		$usr['avatar_file'] = GetUserAvatar($user_id);
		$usr['avatar_file_small'] = GetSmallUserAvatar($user_id, $usr['avatar_file']);
		$usr['avatar_file_smallest'] = GetSmallestUserAvatar($user_id,  $usr['avatar_file']);
		// 
		$rank = GetUserRank($usr['points'], $usr['type'], $usr['access']);
		$usr['rank_name'] = $rank[0];
		$usr['rank_image'] = $rank[1];
		//  
		$online = System::user()->Online();
		$usr['online'] = isset($online[$user_id]);
		//  
		if(!is_array($usr['data'])){
			if($usr['data'] == ''){
				$usr['data'] = array();
			}else{
				$system_users_cache[$user_id]['data'] = unserialize($usr['data']);
				$usr['data'] = $system_users_cache[$user_id]['data'];
			}
		}
		return $usr;
	}else{
		return false;
	}
}

/**
 *   
 * @return array
 */
function &GetUserTypes(){
	global $system_usertypes_cache;
	if($system_usertypes_cache == null){
		if(System::cache()->HasCache(system_cache, 'usertypes')){
			$system_usertypes_cache = System::cache()->Get(system_cache, 'usertypes');
		}else{
			$types = System::database()->Select('usertypes', '');
			$system_usertypes_cache = array();
			foreach($types as $type){
				$system_usertypes_cache[$type['id']] = $type;
			}
			System::cache()->Write(system_cache, 'usertypes', $system_usertypes_cache);
		}
	}
	return $system_usertypes_cache;
}

/**
 *     .   GetPersonalAvatar.
 * @param $user_id
 * @return string
 */
function GetUserAvatar( $user_id ){
	return GetPersonalAvatar($user_id);
}

/**
 *         64px
 * @param $user_id
 * @param string $avatar
 * @return string
 */
function GetSmallUserAvatar( $user_id, $avatar = '' ){
	if($avatar == ''){
		$avatar = GetPersonalAvatar($user_id);
		if(substr($avatar, 0, 10) == 'index.php?'){
			return $avatar.'&size=small';
		}
	}
	$filename = RealPath2(System::config('general/personal_avatars_dir').GetFileName($avatar, true).'_64x64'.GetFileExt($avatar));
	if(is_file($filename)){
		return $filename;
	}else{
		return 'index.php?name=plugins&p=avatars_render&user='.$user_id.'&size=small';
	}
}

/**
 *          24px
 * @param $user_id
 * @param string $avatar
 * @return string
 */
function GetSmallestUserAvatar( $user_id, $avatar = '' ){
	if($avatar == ''){
		$avatar = GetPersonalAvatar($user_id);
		if(substr($avatar, 0, 10) == 'index.php?'){
			return $avatar.'&size=smallest';
		}
	}
	$filename = RealPath2(System::config('general/personal_avatars_dir').GetFileName($avatar, true).'_24x24'.GetFileExt($avatar));
	if(is_file($filename)){
		return $filename;
	}else{
		return 'index.php?name=plugins&p=avatars_render&user='.$user_id.'&size=smallest';
	}
}

/**
 *     
 * @param $user_id
 * @return string
 */
function GetPersonalAvatar( $user_id, $GetFile = false ){
	if($user_id == 0){
		return GetGalleryAvatar('guest.gif');
	}
	if(System::config('user/secure_avatar_upload') && GDVersion() <> 0 && !$GetFile){
		return 'index.php?name=plugins&p=avatars_render&user='.$user_id;
	}else{
		$users = GetUsers();
		if(!isset($users[$user_id])){
			return GetGalleryAvatar('guest.gif');
		}
		if($users[$user_id]['a_personal'] == '1'){
			$avatar_file = RealPath2(System::config('general/personal_avatars_dir').$users[$user_id]['avatar']);
		}else{
			$avatar_file = RealPath2(System::config('general/avatars_dir').$users[$user_id]['avatar']);
		}
		if(is_file($avatar_file)){
			return $avatar_file;
		}else{
			return GetGalleryAvatar('noavatar.gif');
		}
	}
}

/**
 *        
 * @param $filename
 * @return string
 */
function GetGalleryAvatar($filename){
	if(!defined('SETUP_SCRIPT')){
		if(trim($filename)==''){
			$filename = 'noavatar.gif';
		}
		return RealPath2(System::config('general/avatars_dir').$filename);
	}else{
		return $filename;
	}
}

/**
 *   
 * @return array|null|string
 */
function &GetUserRanks(){
	global $system_userranks_cache;
	if($system_userranks_cache == null){
		if(System::cache()->HasCache(system_cache, 'userranks')){
			$system_userranks_cache = System::cache()->Get(system_cache, 'userranks');
		}else{
			$ranks = System::database()->Select('userranks', '');
			SortArray($ranks, 'min');
			foreach($ranks as $rank){
				$system_userranks_cache[$rank['id']] = $rank;
			}
			System::cache()->Write(system_cache, 'userranks', $system_userranks_cache);
		}
	}
	return $system_userranks_cache;
}

/**
 *  ,     .
 * @param $points
 * @param $type
 * @param $access
 * @return array
 */
function GetUserRank( $points = null, $type = null, $access = null ){
	static $admintypes = null;
	if(!isset($points)){
		$points = System::user()->Get('u_points');
		$type = System::user()->Get('u_level');
		$access = System::user()->Get('u_access');
	}
	if($type == 2){ // 
		$ranks = GetUserRanks();
		$last = current($ranks);
		foreach($ranks as $rank){
			if($rank['min'] > $points){
				return array(
					SafeDB($last['title'], 250, str),
					RealPath2(System::config('general/ranks_dir').SafeDB($last['image'], 250, str)),
					SafeDB($last['id'], 11, int));
			}else{
				$last = $rank;
			}
		}
		return array(
			SafeDB($last['title'], 250, str),
			RealPath2(System::config('general/ranks_dir').SafeDB($last['image'], 250, str)),
			SafeDB($last['id'], 11, int));
	}else{ // 
		$admintypes = GetUserTypes();
		if(isset($admintypes[$access])){
			return array(
				'<font color="'.SafeDB($admintypes[$access]['color'], 9, str).'">'.SafeDB($admintypes[$access]['name'], 255, str).'</font>',
				RealPath2(System::config('general/ranks_dir').SafeDB($admintypes[$access]['image'], 250, str)),
				SafeDB($admintypes[$access]['id'], 11, int));
		}
	}
}

/**
 *      .
 * @param type $UserId
 * @return boolean
 */
function GetUserRankInfo( $UserId = null ){
	$system_users_cache = GetUsers();
	if(isset($UserId)){
		$user = $system_users_cache[$UserId];
		$points = $user['points'];
		$type = $user['type'];
		$access = $user['access'];
	}else{
		$points = System::user()->Get('u_points');
		$type = System::user()->Get('u_level');
		$access = System::user()->Get('u_access');
	}
	if($type >= 3){
		return false; // 
	}elseif($type == 1){
		return true; // 
	}
	$ranks = GetUserRanks();
	$last = current($ranks);
	foreach($ranks as $rank){
		if($rank['min'] > $points){
			return $rank;
		}else{
			$last = $rank;
		}
	}
	return $last;
}

/**
 *       .
 * @param type $RankId
 */
function GetRankInfo( $RankId, $SubInfo = null ){
	$system_userranks_cache = GetUserRanks();
	if(!isset($system_userranks_cache[$RankId])){
		return false;
	}
	if(isset($SubInfo)){
		return $system_userranks_cache[$RankId][$SubInfo];
	}else{
		return $system_userranks_cache[$RankId];
	}
}

/**
 *  E-mail    
 * @param $Email
 * @param $error_out
 * @param bool $CheckExist
 * @param int $xor_id
 * @return bool
 */
function CheckUserEmail( $Email, &$error_out, $CheckExist=false, $xor_id=0 ){
	if($Email == ''){
		$error_out[] = '    E-mail .';
		return false;
	}
	if(!CheckEmail($Email)){
		$error_out[] = '   E-mail.    : <b>domain@host.ru</b> .';
		return false;
	}
	if($CheckExist){
        System::database()->Select('users', "`email`='$Email'".($xor_id<>0?' and `id`<>'.$xor_id:''));
		if(System::database()->NumRows() > 0){
			$error_out[] = '   E-mail   !';
			return false;
		}
	}
	return true;
}

/**
 *    
 * @param String $login 
 * @param $error_out      
 * @param bool $CheckExist     
 * @param int $xor_id
 * @return Boolean    
 */
function CheckLogin( $login, &$error_out, $CheckExist=false, $xor_id=0 ){
	$result = true;
	if(System::config('user/login_min_length')){
		$minlength = System::config('user/login_min_length');
	}else{
		$minlength = 4;
	}
	if(strlen($login) < $minlength || strlen($login) > 30){
		$error_out[] = '     '.$minlength.'    30 .';
		$result = false;
	}
	if(preg_match('/[^a-zA-Z--0-9_]/', $login)){
		$error_out[] = '         ,    .';
		$result = false;
	}
	if($CheckExist){
        System::database()->Select('users',"`login`='$login'".($xor_id<>0?' and `id`<>'.$xor_id:''));
		if(System::database()->NumRows()>0){
			$error_out[] = '      !';
			$result = false;
		}
	}
	return $result;
}

/**
 *    
 * @param String $nikname 
 * @param $error_out      
 * @param bool $CheckExist     
 * @param int $xor_id
 * @return Boolean    
 */
function CheckNikname( $nikname, &$error_out, $CheckExist=false, $xor_id=0 ){
	$result = true;
	if($nikname == ''){
		$error_out[] = '   !';
		$result = false;
	}
	if(preg_match("/[^a-zA-Z--0-9_ ]/", $nikname)){
		$error_out[] = '           ,    .';
		$result = false;
	}
	if($CheckExist){
        System::database()->Select('users',"`name`='$nikname'".($xor_id<>0?' and `id`<>'.$xor_id:''));
		if(System::database()->NumRows()>0){
			$error_out[] = '      !';
			$result = false;
		}
	}
	return $result;
}

/**
 *    
 * @param String $pass 
 * @param $error_out       ()
 * @return Boolean    
 */
function CheckPass( $pass, &$error_out ){
	$result = true;
	if(System::config('user/pass_min_length')){
		$minlength = System::config('user/pass_min_length');
	}else{
		$minlength = 4;
	}
	if($pass<>'' && (strlen($pass) < $minlength || strlen($pass)>255)){
		$error_out[] = '     '.$minlength.' .';
		$result = false;
	}
	return $result;
}

/**
 *      E-mail
 * @param $username
 * @param $user_mail
 * @param $login
 * @param $pass
 * @param $code
 * @param $regtime
 * @return void
 */
function UserSendActivationMail( $username, $user_mail, $login, $pass, $code, $regtime ){
	$time = $regtime+604800;
	$time = date("d.m.Y", $time);

	$text = System::config('user/mail_template');
	$keys = array(
		'{sitename}' => System::config('general/site_name'),
		'{siteurl}' => System::config('general/site_url'),
		'{username}' => $username,
		'{date}' => $time,
		'{login}' => $login,
		'{pass}' => $pass,
		'{link}' => System::config('general/site_url').'index.php?name=user&op=activate&code='.$code
	);

	$text = str_replace(array_keys($keys), array_values($keys), $text);
	SendMail($username, $user_mail, '  '.System::config('general/site_name'), $text);
}

/**
 *     
 * @param $user_mail
 * @param $name
 * @param $login
 * @param $pass
 * @param $regtime
 * @return void
 */
function UserSendEndRegMail($user_mail, $name, $login, $pass, $regtime){
	$text = Indent('
		, ['.$name.']!

		     
		"'.GetSiteDomain().'"

		 : '.date("d.m.Y", $regtime).'
		: '.$name.'

		    :
		: '.$login.'
		: '.$pass.'

		,     .
		 ,   "'.GetSiteDomain().'".
	');
	SendMail($name, $user_mail, '  '.GetSiteDomain(), $text);
}

/**
 *     
 * @param $user_mail
 * @param $name
 * @param $login
 * @param $pass
 * @return void
 */
function UserSendForgotPassword($user_mail, $name, $login, $pass){
	$ip = getip();
	$text = Indent('
		, ['.$name.']!

		  '.GetSiteDomain().'
		   .

		: '.$name.'

		    :
		: '.$login.'
		: '.$pass.'

		      :
		'.GetSiteUrl().Ufu('index.php?name=user&op=editprofile', 'user/{op}/').'

		IP-,     : '.$ip.'

		 ,   '.GetSiteDomain().'.
	');
	SendMail($name, $user_mail, '['.GetSiteDomain().']  ', $text);
}

/**
 *          HTML::Select
 * @param $avatar
 * @param $personal
 * @return array
 */
function GetGalleryAvatarsData($avatar, $personal){
	$avatars = GetFiles(System::config('general/avatars_dir'), false, true, '.gif.jpg.jpeg.png');
	$selindex = 0;
	$avd = array(
	);
	if($personal == '1'){
		System::site()->DataAdd($avd, '', '', true);
	}
	for($i = 0, $c = count($avatars); $i < $c; $i++){
		if($avatar == $avatars[$i]){
			$sel = true;
			$selindex = $i;
		} else{
			$sel = false;
		}
		System::site()->DataAdd($avd, $avatars[$i], $avatars[$i], $sel);
	}
	return array(
		$avd, $avatars[$selindex]
	);
}

/**
 *     ($_FILES['upavatar'])
 * @param $errors
 * @param $avatar
 * @param $a_personal
 * @param $oldAvatarName
 * @param $oldAvatarPersonal
 * @param $editmode
 */
function UserLoadAvatar(&$errors, &$avatar, &$a_personal, $oldAvatarName, $oldAvatarPersonal, $editmode){
	$asize = getimagesize($_FILES['upavatar']['tmp_name']);

	//  
	$alloy_mime = array(
		'image/gif', 'image/jpeg', 'image/pjpeg', 'image/png', 'image/x-png'
	);
	$alloy_exts = array(
		'.gif', '.jpg', '.jpeg', '.png'
	);
	if(in_array($_FILES['upavatar']['type'], $alloy_mime) && in_array(strtolower(GetFileExt($_FILES['upavatar']['name'])), $alloy_exts)){
		//   
		if($editmode && $oldAvatarPersonal == '1'){
			UnlinkUserAvatarFiles($oldAvatarName);
		}

		// ,  ,       
		$NewName = GenRandomString(12, 'qwertyuiopasdfghjklzxcvbnm');
		$ext = strtolower(GetFileExt($_FILES['upavatar']['name']));
		$pavatar_dir = System::config('general/personal_avatars_dir');
		$max_width = System::config('user/max_avatar_width');
		$max_height = System::config('user/max_avatar_height');

		if($asize[0] > $max_width || $asize[1] > $max_height){
			CreateThumb($_FILES['upavatar']['tmp_name'], $pavatar_dir.$NewName.$ext, $max_width, $max_height);
		} else{
			copy($_FILES['upavatar']['tmp_name'], $pavatar_dir.$NewName.$ext);
		}

		//     2424  6464
		CreateThumb($_FILES['upavatar']['tmp_name'], System::config('general/personal_avatars_dir').$NewName.'_64x64'.$ext, 64, 64);
		CreateThumb($_FILES['upavatar']['tmp_name'], System::config('general/personal_avatars_dir').$NewName.'_24x24'.$ext, 24, 24);

		$avatar = $NewName.$ext;
		$a_personal = '1';
	}else{
		$errors[] = '   .      GIF, JPEG  PNG.';
		$a_personal = '0';
	}
}

/**
 *       
 * @param $AvatarFileName
 * @return void
 */
function UnlinkUserAvatarFiles( $AvatarFileName ){
	$pavatar_dir = System::config('general/personal_avatars_dir');
	$AvatarFileName = RealPath2($pavatar_dir.$AvatarFileName);
	if(is_file($AvatarFileName)){
		unlink($AvatarFileName);
		$_name = GetFileName($AvatarFileName, true);
		$_ext = GetFileExt($AvatarFileName);
		if(is_file($pavatar_dir.$_name.'_24x24'.$_ext)){
			unlink($pavatar_dir.$_name.'_24x24'.$_ext);
		}
		if(is_file($pavatar_dir.$_name.'_64x64'.$_ext)){
			unlink($pavatar_dir.$_name.'_64x64'.$_ext);
		}
	}
}

/**
 *      Html::Select
 * @param array | int $view          
 * @return array | int
 */
function GetUserTypesFormData( $view ){
	$visdata = array();
	if(!is_array($view)){
		$_view = $view;
		$view = array('1'=>false, '2'=>false, '3'=>false, '4'=>false);
		$view[$_view] = true;
	}
	System::admin()->DataAdd($visdata, 'all', '', $view['4']);
	System::admin()->DataAdd($visdata, 'members', ' ', $view['2']);
	System::admin()->DataAdd($visdata, 'guests', ' ', $view['3']);
	System::admin()->DataAdd($visdata, 'admins', ' ', $view['1']);
	return $visdata;
}

/**
 *    
 * @return int
 */
function GetSystemAdminsCount(){
	$atypes = System::database()->Select('usertypes', '');
	foreach($atypes as $type){
		$types[$type['id']] = $type['system'];
	}
	unset($atypes);
	$admins = System::database()->Select('users', "`type`='1'");
	//   
	$system = 0;
	for($i = 0, $c = count($admins); $i < $c; $i++){
		if($types[$admins[$i]['access']] == '1'){
			$system++;
		}
	}
	return $system;
}

/**
 *      id 
 * @param  $access
 * @return bool
 */
function groupIsSystem($access){
	if($access == -1){
		return false;
	}
    System::database()->Select('usertypes', "`id`='$access'");
	if(System::database()->NumRows() > 0){
		$access = System::database()->FetchRow();
		return $access['system'] == '1';
	} else{
		return false;
	}
}

/**
 *      -.
 *
 * @param  $save_link     (    action)
 * @param string $a     (edit or add)
 * @param int $id  
 * @param bool $isadmin   (       email)
 * @param bool $EditProfile     (        )
 * @return
 */
function AdminUserEditor( $save_link, $a = 'add', $id = '0', $isadmin = false ){
	$active = array(false, false, false);

	$SystemAdmin = System::user()->isSuperUser();

	$edit = $a == 'edit';
	$editProfile = $edit && !$SystemAdmin && $id == System::user()->Get('u_id'); //    
	$editStatus = false; //   
	$editType = false; //    

	//     
	if($edit){
		$user = System::database()->SelectOne('users', "`id`='$id'".($isadmin ? " and `type`='1'" : " and `type`='2'"));
		if(!$user){
			AddTextBox('', '<p align="center">  ,         .</p>');
			return;
		}
	}

	//   
	if($isadmin){ //  
		if($SystemAdmin){ //         
			if(!(groupIsSystem(SafeEnv($user['access'], 11, int)) && GetSystemAdminsCount() <= 1)){//        1
				$editStatus = true;
			}
			$editType = $editStatus;
		}
	}else{ //  
		$editStatus = true; //        
		$editType = $SystemAdmin; //      
	}

	if($editType){
		$user_types_db = System::database()->Select('usertypes');
		$types = array('member'=> array('member', '', false));
		foreach($user_types_db as $type){
			$types[$type['id']] = array(SafeDB($type['id'], 11, int), SafeDB($type['name'], 255, str), false);
		}
	}

	if($edit){
		$login = SafeDB($user['login'], 30, str);
		$mail = SafeDB($user['email'], 50, str);
		$hideemail = ($user['hideemail'] == 1 ? true : false);
		$snews = ($user['servernews'] == 1 ? true : false);
		$name = SafeDB($user['name'], 50, str);
		$tname = SafeDB($user['truename'], 250, str);
		$age = SafeDB($user['age'], 11, str);
		$city = SafeDB($user['city'], 100, str);
		$url = SafeDB($user['url'], 250, str);
		$icq = SafeDB($user['icq'], 15, str);
		$gmt = SafeDB($user['timezone'], 255, str);
		$about = SafeDB($user['about'], 0, str);
		$avatar = SafeDB($user['avatar'], 250, str);
		$apersonal = SafeDB($user['a_personal'], 1, int);

		if($editStatus){
			if($user['active'] == '1'){
				$active[0] = true;
			}elseif($user['active'] == '0' && $user['activate'] == ''){
				$active[1] = true;
			}elseif($user['active'] == '0' && $user['activate'] != ''){
				$active[2] = true;
			}
		}

		if($editType){
			if($user['type'] == '1'){
				$types[$user['access']][2] = true;
			}else{
				$types['member'][2] = true; //
			}
		}

		$caption = '';
		if($isadmin){
			if($editProfile){
				$title = ' ';
			}else{
				$title = ' ';
			}
		}else{
			$title = ' ';
		}
	}else{
		$login = '';
		$mail = '';
		$snews = false;
		$hideemail = false;
		$name = '';
		$tname = '';
		$age = '';
		$city = '';
		$url = '';
		$icq = '';
		$gmt = System::config('general/default_timezone');
		$about = '';
		$avatar = '';
		$apersonal = '0';
		if($editStatus){
			$active[0] = true;
		}
		if($editType){
			$types['member'][2] = true;
		}

		$caption = '';
		$title = ' ';
	}

	FormRow('', System::site()->Edit('login', $login, false, 'style="width:400px;" class="autofocus"'));
	FormRow('', System::site()->Edit('pass', '', true, 'style="width:400px;"'));
	FormRow(' <br /><small>( )</small>', System::site()->Edit('rpass', '', true, 'style="width:400px;"'));
	FormRow('E-mail', System::site()->Edit('email', $mail, false, 'style="width:300px;"').' <label for="hideemail"></label>&nbsp;'.System::site()->Check('hideemail', '1', $hideemail, 'id="hideemail"'));
	FormRow('<label for="snews"></label>', System::site()->Check('snews', '1', $snews, 'id="snews"'));
	FormRow('', System::site()->Edit('nikname', $name, false, 'style="width:400px;"'));
	FormRow(' ', System::site()->Edit('realname', $tname, false, 'style="width:400px;"'));
	FormRow('', System::site()->Edit('age', $age, false, 'style="width:400px;"'));
	FormRow('', System::site()->Edit('city', $city, false, 'style="width:400px;"'));
	FormRow('', System::site()->Edit('homepage', $url, false, 'style="width:400px;"'));
	FormRow('ICQ', System::site()->Edit('icq', $icq, false, 'style="width:400px;"'));
	$gmt = GetGmtData($gmt);
	FormRow(' ', System::site()->Select('gmt', $gmt, false, 'style="width:400px;"'));
	FormRow(' ', System::site()->TextArea('about', $about, 'style="width:400px; height:200px;"'));
	$avatars = GetGalleryAvatarsData($avatar, $apersonal);
	if($apersonal == '1'){
		$selected = GetPersonalAvatar($id);
	} else{
		$selected = GetGalleryAvatar($avatars[1]);
	}
	System::site()->AddJS('
	ShowAvatar = function(){
		if(document.userform.avatar.value==\'\'){
			document.userform.avatarview.src = \''.(System::config('user/secure_avatar_upload') ? 'index.php?name=plugins&p=avatars_render&user='.$id : System::config('general/personal_avatars_dir').$avatar).'\';
		}else{
			document.userform.avatarview.src = \''.(System::config('user/secure_avatar_upload') ? 'index.php?name=plugins&p=avatars_render&aname=' : System::config('general/avatars_dir')).'\'+document.userform.avatar.value;
		}
	}');
	FormRow('', System::site()->Select('avatar', $avatars[0], false, 'onchange="ShowAvatar();"'));
	FormRow('', '<img id="avatarview" src="'.$selected.'" border="0">');
	FormRow(' ', System::site()->FFile('upavatar'));

	if($editStatus){
		FormRow('',
		        System::site()->Radio('activate', 'auto', $active[0]).''
		        .System::site()->Radio('activate', 'manual', $active[1]).' '
		        .(!$isadmin ? System::site()->Radio('activate', 'mail', $active[2]).' E-mail' : '')
		);
	}
	if($editType){
		$user_types = array();
		foreach($types as $type){
			System::site()->DataAdd($user_types, $type[0], $type[1], $type[2]);
		}
		FormRow('', System::site()->Select('status', $user_types));
	}

	TAddSubTitle($title);
	AddCenterBox($title);
	AddForm('<form name="userform" action="'.ADMIN_FILE.'?exe='.$save_link.'&id='.$id.'" method="post"  enctype="multipart/form-data">',
	        System::site()->Button('', 'onclick="history.go(-1);"').System::site()->Submit($caption));
}

/**
 *      AdminUserEditor
 *
 * @param  $back_link
 * @param string $a
 * @param int $id
 * @param bool $IsAdmin
 * @return void
 */
function AdminUserEditSave( $back_link, $a = 'insert', $id = 0, $IsAdmin = false ){

	$SystemAdmin = System::user()->isSuperUser();

	$edit = $a == 'update';
	$editProfile = $edit && !$SystemAdmin && $id == System::user()->Get('u_id'); //    
	$editStatus = false; //   
	$editType = false; //    

	//     
	if($edit){
		$user = System::database()->SelectOne('users', "`id`='$id'".($IsAdmin ? " and `type`='1'" : " and `type`='2'"));
		if(!$user){
			AddTextBox('', '<p align="center">  ,         .</p>');
			return;
		}
	}

	//   
	if($IsAdmin){ //  
		if($SystemAdmin){ //         
			if(!$edit){
				$editStatus = true;
			}elseif(!(groupIsSystem(SafeEnv($user['access'], 11, int)) && GetSystemAdminsCount() <= 1)){//        1
				$editStatus = true;
			}
			$editType = $editStatus;
		}
	}else{ //  
		$editStatus = true; //        
		$editType = $SystemAdmin; //      
	}

	//  
	$errors = array();

	// 
	if(isset($_POST['login']) && CheckLogin($_POST['login'], $errors, !$edit)){
		$login = SafeEnv($_POST['login'], 30, str);
	} else{
		$login = '';
	}

	// 
	$pass = '';
	if(!$edit || $_POST['pass'] != ''){
		$pass_generate_message = '';
		if(isset($_POST['pass']) && CheckPass($_POST['pass'], $errors)){
			$pass = SafeEnv($_POST['pass'], 30, str);
			if(!isset($_POST['rpass']) || SafeEnv($_POST['rpass'], 30, str) != $pass){
				$errors[] = '  .';
			}
		} else{
			$pass = '';
		}
		if(isset($_POST['pass']) && $_POST['pass'] == ''){
			srand(time());
			$pass = GenBPass(rand(System::config('user/pass_min_length'), 15));
			$pass_generate_message = '<br />     ,         E-mail .';
		}
		$pass2 = md5($pass);
	}

	// e-mail
	if(isset($_POST['email']) && $_POST['email'] != ''){
		if(!CheckEmail($_POST['email'])){
			$errors[] = '   E-mail.    : <b>domain@host.ru</b> .';
		}
		$email = SafeEnv($_POST['email'], 50, str, true);
	} else{
		$email = '';
		$errors[] = '   E-mail.';
	}

	//  e-mail
	if(isset($_POST['hideemail'])){
		$hide_email = '1';
	} else{
		$hide_email = '0';
	}

	//    
	if(isset($_POST['nikname']) && CheckNikname($_POST['nikname'], $errors, !$edit)){
		$nik_name = SafeEnv($_POST['nikname'], 50, str, true);
	} else{
		$nik_name = '';
	}

	//  
	if(isset($_POST['realname'])){
		$real_name = SafeEnv($_POST['realname'], 250, str, true);
	} else{
		$real_name = '';
	}

	// 
	if(isset($_POST['age'])){
		if($_POST['age'] == '' || is_numeric($_POST['age'])){
			$age = SafeEnv($_POST['age'], 3, int);
		} else{
			$errors[] = '    !';
		}
	} else{
		$age = '';
	}

	//  
	if(isset($_POST['homepage'])){
		if($_POST['homepage'] != '' && substr($_POST['homepage'], 0, 7) == 'http://'){
			$_POST['homepage'] = substr($_POST['homepage'], 7);
		}
		$homepage = SafeEnv($_POST['homepage'], 250, str, true);
	} else{
		$homepage = '';
	}

	//  ICQ
	if(isset($_POST['icq'])){
		if($_POST['icq'] == '' || is_numeric($_POST['icq'])){
			$icq = SafeEnv($_POST['icq'], 15, str, true);
		} else{
			$errors[] = ' ICQ    !';
		}
	} else{
		$icq = '';
	}

	// 
	if(isset($_POST['city'])){
		$city = SafeEnv($_POST['city'], 100, str, true);
	} else{
		$city = '';
	}

	//  
	if(isset($_POST['gmt'])){
		$gmt = SafeEnv($_POST['gmt'], 255, str);
	} else{
		$gmt = System::config('general/default_timezone');
	}

	//  
	if(isset($_POST['about'])){
		$about = SafeEnv($_POST['about'], System::config('user/about_max_length'), str, true);
	} else{
		$about = '';
	}

	//   
	if(isset($_POST['snews'])){
		$server_news = '1';
	} else{
		$server_news = '0';
	}

	// 
	$updateAvatar = true;
	if(isset($_POST['avatar'])){
		if(System::config('user/avatar_transfer') == '1' && isset($_FILES['upavatar']) && file_exists($_FILES['upavatar']['tmp_name'])){
			if($edit){
				$avatar = $user['avatar'];
				$a_personal = $user['a_personal'];
			}else{
				$avatar = '';
				$a_personal = '0';
			}
			UserLoadAvatar($errors, $avatar, $a_personal, $avatar, $a_personal, $edit);
		}elseif($_POST['avatar'] == ''){
			$updateAvatar = false;
		}elseif(file_exists(RealPath2(System::config('general/avatars_dir').$_POST['avatar']))){
			if($edit){
				if($user['a_personal'] == '1'){
					UnlinkUserAvatarFiles($user['avatar']);
				}
			}
			$a_personal = '0';
			$avatar = $_POST['avatar'];
		}else{
			$avatar = '';
			$a_personal = '0';
		}
	}else{
		$avatar = '';
		$a_personal = '0';
	}

	$SendActivation = false;
	if($edit){
		$active = SafeEnv($user['active'], 11, int);
		$code = SafeEnv($user['activate'], 11, int);
	}else{
		$active = '1';
		$code = '';
	}
	if($editStatus){
		$activate = $_POST['activate'];
		$lastactivate = 'manual';
		if($active == '0' && $code != ''){
			$lastactivate = 'mail';
		}elseif($active == '1' && $code == ''){
			$lastactivate = 'auto';
		}
		if($activate != $lastactivate){
			switch($activate){
				case 'manual':
					$active = '0';
					$code = '';
					$SendActivation = false;
					break;
				case 'auto':
					$active = '1';
					$code = '';
					$SendActivation = false;
					break;
				case 'mail':
					$active = '0';
					$code = GenRandomString(8, 'qwertyuiopasdfghjklzxcvbnm');
					$SendActivation = true;
					break;
			}
		}
	}

	if($edit){
		$access = SafeEnv($user['type'], 11, int);
		$user_type = SafeEnv($user['access'], 11, int);
	}else{
		$access = '2';
		$user_type = '-1';
	}

	if($editType && $_POST['status'] != 'member'){
		$access = '1';
		$user_type = SafeEnv($_POST['status'], 11, int);
	}

	$reg_date = time();
	$last_visit = time();
	$ip = getip();
	$points = 0;
	$visits = 0;
	if($SendActivation){
		UserSendActivationMail($nik_name, $email, $login, $pass, $code, $reg_date);
	}elseif(!$edit){
		UserSendEndRegMail($email, $nik_name, $login, $pass, $reg_date);
	}

	if(!$edit){
		$values = Values('', $login, $pass2, $nik_name, $real_name, $age, $email, $hide_email, $city, $icq, $homepage, $gmt, $avatar, $about, $server_news, $reg_date, $last_visit, $ip, $points, $visits, $active, $code, $access, $user_type, $a_personal, serialize(array()));
		System::database()->Insert('users', $values);
	}else{
		$set = "`login`='$login',`email`='$email',`hideemail`='$hide_email',`name`='$nik_name',"
			."`truename`='$real_name',`age`='$age',`url`='$homepage',`icq`='$icq',`city`='$city',"
			."`timezone`='$gmt'".($updateAvatar == true ? ",`avatar`='$avatar',`a_personal`='$a_personal'" : '').","
			."`about`='$about',`servernews`='$server_news'".($pass != '' ? ",`pass`='$pass2'" : '').",`type`='$access',"
			."`access`='$user_type',`active`='$active',`activate`='$code'";
		System::database()->Update('users', $set, "`id`='".$id."'");
		System::user()->UpdateMemberSession();
		UpdateUserComments($id, $id, $nik_name, $email, $hide_email, $homepage);
	}

	if(count($errors) > 0){
		$text = ' ,     :<br /><ul>';
		foreach($errors as $error){
			$text .= '<li>'.$error;
		}
		$text .= '</ul>';
		AddTextBox('', $text);
	}else{
		//   
		System::cache()->Delete(system_cache, 'users');
		if(!$editProfile){
			GO(ADMIN_FILE.'?exe='.$back_link);
		}else{
			System::admin()->AddCenterBox(' ');
			System::admin()->Highlight('  ,  .');
		}
	}
}

/**
 *  IP  
 * @return string
 */
function getip(){
	static $ip = null;
	if(!isset($ip)){
		if(isset($_SERVER['REMOTE_ADDR'])){
			$ip = $_SERVER['REMOTE_ADDR'];
		}elseif(isset($HTTP_SERVER_VARS['REMOTE_ADDR'])){
			$ip = $HTTP_SERVER_VARS['REMOTE_ADDR'];
		}elseif(getenv('REMOTE_ADDR')){
			$ip = getenv('REMOTE_ADDR');
		}
		if($ip!=""){
			if(preg_match("/^([0-9]+\.[0-9]+\.[0-9]+\.[0-9]+)/", $ip, $ipm)){
				$private = array(
					"/^0\./",
					"/^127\.0\.0\.1/",
					"/^192\.168\..*/",
					"/^172\.16\..*/",
					"/^10..*/","/^224..*/","/^240..*/"
				);
				$ip = preg_replace($private, $ip, $ipm[1]);
			}
		}
		if (strlen($ip)>16) $ip = substr($ip, 0, 16);
	}
	return $ip;
}

/**
 *    .
 * @param type $Name
 * @param type $Title
 * @param type $Description
 * @param type $Value
 */
function AddPointsConfig( $Name, $Title, $Description, $Value ){
	$points_group = '9';
	$Name = SafeEnv($Name, 255, str);
	$Title = SafeEnv($Title, 255, str);
	$Description = SafeEnv($Description, 255, str);
	$Value = SafeEnv($Value, 0, str);
	System::database()->Insert('config', "'','$points_group','$Name','$Value','1','$Title','$Description','edit:w50px','','','10,int,false','1'");
}

/**
 *   .
 * @param type $Name
 */
function RemovePointsConfig( $Name ){
	$points_group = '9';
	System::database()->Delete('config', "`group_id`='$points_group' and `name`='$Name'");
}

/**
 *           .
 * @param null $Name  .
 * @param null $Value ,    .   null.
 * @param null $UserId  .   ,     .
 * @return array|null|var  null    .
 */
function UserData( $Name = null, $Value = null, $UserId = null ){
	$this_user = false;
	if(!isset($UserId)){
		if(System::user()->Auth){
			$UserId = SafeEnv(System::user()->Get('u_id'), 11, int);
			$this_user = true;
		}else{
			if(isset($Name)){
				return null;
			}else{
				return array();
			}
		}
	}
	$Data = GetUserInfo($UserId);
	$Data = $Data['data'];
	if(!isset($Value)){ // 
		if(isset($Name)){
			if(isset($Data[$Name])){
				return $Data[$Name];
			}else{
				return null;
			}
		}else{
			return $Data;
		}
	}else{ // 
		$Data[$Name] = $Value;
		$system_users_cache = GetUsers();
		$system_users_cache[$UserId]['data'] = $Data;
		if($this_user){
			System::user()->Session('u_data', $Data);
		}
		System::database()->Update('users', "`data`='".SafeEnv(serialize($Data), 0, str)."'", "`id`='$UserId'");
	}
}

/**
 *        .
 * @param      $Name  .
 * @param null $UserId  .   ,     .
 * @return var|null    ,  null,    .
 */
function UserDataDelete( $Name, $UserId = null ){
	$this_user = false;
	if(!isset($UserId)){
		if(System::user()->Auth){
			$UserId = SafeEnv($this->Get('u_id'), 11, int);
			$this_user = true;
		}else{
			return null;
		}
	}
	$Data = GetUserInfo($UserId);
	$Data = $Data['data'];
	if(isset($Data[$Name])){
		$value = $Data[$Name];
		unset($Data[$Name]);
		$system_users_cache = GetUsers();
		$system_users_cache[$UserId]['data'] = $Data;
		if($this_user){
			System::user()->Session('u_data', $Data);
		}
		System::database()->Update('users', "`data`='".SafeEnv(serialize($Data), 0, str)."'", "`id`='$UserId'");
		return $value;
	}
}