<?php

/*
 * LinkorCMS 1.4
 *  2012 LinkorCMS Development Group
 */


define("TREE_CHILD_ID", 'child');
global $FCatsData;
$FCatsData = array();

/**
 *         .
 * @author 
 */
class Tree{

	/**
	 *    
	 * @var string
	 */
	public $Table;

	/**
	 *    
	 * @var array
	 */
	public $Cats;

	/**
	 *    
	 * @var array
	 */
	public $IdCats;

	protected $childs = array();
	protected $sel_id = array(0);
	protected $viewitems = true;

	public $IdKey = 'id';
	public $ParentKey = 'parent';
	public $TitleKey = 'title';
	public $FileCounterKey = 'file_counter';
	public $CatCounterKey = 'cat_counter';

	/*
	 *   
	 */
	public $TopCatName = ' /';

	/**
	 *  ,  
	 *
	 * @param string|array $Table       
	 * @param string $IdKey
	 * @param string $ParentKey
	 * @param string $TitleKey
	 * @param string $FileCounterKey
	 * @param string $CatCounterKey
	 * @return \Tree
	 */
	function  __construct( $Table, $IdKey = 'id', $ParentKey = 'parent', $TitleKey = 'title', $FileCounterKey = 'file_counter',
	                       $CatCounterKey = 'cat_counter' ){
		$this->IdKey = $IdKey;
		$this->ParentKey = $ParentKey;
		$this->TitleKey = $TitleKey;
		$this->FileCounterKey = $FileCounterKey;
		$this->CatCounterKey = $CatCounterKey;

		$cats = array();
		$cats2 = array();
		if(!is_array($Table)){  //    
			$this->Table = $Table;
			if(System::cache()->HasCache('tree', $Table)){
				$cats_cache = System::cache()->Get('tree', $Table);
				$cats = &$cats_cache[0];
				$cats2 = &$cats_cache[1];
			}else{
				System::database()->Select($Table);
				foreach(System::database()->QueryResult as $cat){
					$cats[$cat[$ParentKey]][] = $cat;
					$cats2[$cat[$IdKey]] = $cat;
				}
				//  
				$cats_cache = array(&$cats, &$cats2);
				System::cache()->Write('tree', $Table, $cats_cache);
			}
		}else{ //          
			$this->Table = '';
			foreach($Table as $cat){
				$cats[$cat[$ParentKey]][] = $cat;
				$cats2[$cat[$IdKey]] = $cat;
			}
		}

		$this->Cats = &$cats;
		$this->IdCats = &$cats2;
	}

	/**
	 *    
	 *
	 * @param int $parent_id   
	 * @param array $source    
	 *       
	 * @return array
	 */
	public function NewTree( $parent_id, $source ){
		//  
		if(isset($source[$parent_id])){
			//   
			for($i = 0, $c = count($source[$parent_id]); $i < $c; $i++){
				// 
				$cat = $source[$parent_id][$i];
				if(isset($source[$cat['id']])){
					$cat[TREE_CHILD_ID] = $this->NewTree($cat['id'], $source);
				}
				$tree[] = $cat;
			}
			return $tree;
		}else{
			return array();
		}
	}

	/**
	 *    
	 *
	 * @param int $pid   
	 * @return array  ,    
	 *  TREE_CHILD_ID    
	 */
	public function GetChildTree( $pid ){
		return $this->NewTree($pid, $this->Cats);
	}

	/**
	 *      
	 * @param array        $Tree
	 * @param int          $Level
	 * @param string|array $CallbackFunc
	 * @param              $CallbackCatFinish
	 * @see ListingTree
	 * @return void
	 */
	protected function ToCatsTree( $Tree, $Level, $CallbackFunc, $CallbackCatFinish ){
		if(isset($Tree[TREE_CHILD_ID])){
			for($i = 0, $c = count($Tree[TREE_CHILD_ID]); $i < $c; $i++){
				if(call_user_func_array($CallbackFunc, array($Tree[TREE_CHILD_ID][$i], $Level, $i, $c)) !== false){
					$this->ToCatsTree($Tree[TREE_CHILD_ID][$i], $Level + 1, $CallbackFunc, $CallbackCatFinish);
				}
			}
		}
		if(isset($CallbackCatFinish)){
			call_user_func_array($CallbackCatFinish, array($Tree[$this->IdKey], $Level));
		}
	}

	/**
	 *      
	 *   
	 * function UserFunc($cat, $level){
	 *  $cat -   
	 *  $level -  
	 * }
	 *
	 * @param int          $ParentId            
	 * @param string|array $CallbackFunc         
	 * @param string|array $CallbackCatFinish        .  $Id, $Level.
	 * @return bool  true    
	 */
	public function ListingTree( $ParentId, $CallbackFunc, $CallbackCatFinish = null ){
		$tree = $this->GetChildTree($ParentId);
		if((!is_array($CallbackFunc) && !@function_exists($CallbackFunc)) || (is_array($CallbackFunc) && !@method_exists($CallbackFunc[0], $CallbackFunc[1]))){
			ErrorHandler(NOTICE, 'CallBack   .', 'Tree->ListingTree()');
			return false;
		}else{
			if(count($tree) == 0){
				return false;
			}
			$c = count($tree);
			foreach($tree as $i=>$tree_item){
				if(call_user_func_array($CallbackFunc, array($tree_item, 0, $i, $c)) !== false){
					$this->ToCatsTree($tree_item, 1, $CallbackFunc, $CallbackCatFinish);
				}
			}
			if(isset($CallbackCatFinish)){
				call_user_func_array($CallbackCatFinish, array('0', 0));
			}
			return true;
		}
	}

	/**
	 *  ,   GetAllChildId
	 *
	 * @param array $tree
	 * @param array $result
	 * @see GetAllChildId
	 * @return void
	 */
	protected function GetIds( $tree, &$result ){
		if(isset($tree[TREE_CHILD_ID])){
			for($i = 0, $c = count($tree[TREE_CHILD_ID]); $i < $c; $i++){
				$result[] = $tree[TREE_CHILD_ID][$i][$this->IdKey];
				$this->GetIds($tree[TREE_CHILD_ID][$i], $result);
			}
		}
	}

	/**
	 *      .
	 *       $pid.
	 *
	 * @param int $pid  
	 * @return array
	 */
	public function GetAllChildId( $pid ){
		$tree = $this->GetChildTree($pid);
		$result = array();
		$c = count($tree);
		if($c > 0){
			for($i = 0; $i < $c; $i++){
				$result[] = $tree[$i][$this->IdKey];
				$this->GetIds($tree[$i], $result);
			}
		}
		if($pid != 0){ //  ,     
			$result[] = $pid;
		}
		return $result;
	}

	/**
	 *    
	 *
	 * @param int $curId  
	 * @return int   
	 */
	public function GetParentId( $curId ){
		if(isset($this->IdCats[$curId])){
			return $this->IdCats[$curId][$this->ParentKey];
		}else{
			return 0;
		}
	}

	/**
	 *    
	 *
	 * @param int $curId  
	 * @param bool $reverse   
	 * @return array|bool     
	 */
	public function GetAllParent( $curId, $reverse = true ){
		if(count($this->IdCats) > 0){
			$find = true;
			$result = array();
			$result2 = array();
			while($find){
				if(isset($this->IdCats[$curId])){
					$result[] = $this->IdCats[$curId];
					$curId = $this->IdCats[$curId][$this->ParentKey];
				}else{
					$find = false;
				}
			}
			if($reverse){
				$c = count($result) - 1;
				for($i = $c; $i >= 0; $i--){
					$result2[] = $result[$i];
					unset($result[$i]);
				}
				$result = $result2;
			}
			return $result;
		}else{
			return false;
		}
	}

	/**
	 *      
	 *      
	 *
	 * @param int $id  
	 * @param int $inc  
	 * @return void
	 */
	public function CalcFileCounter( $id, $inc ){
		$cat = System::database()->SelectOne($this->Table, "`".$this->IdKey."`='$id'");
		if($cat){
			if($inc === true){
				$counter_val = $cat[$this->FileCounterKey] + 1;
			}elseif($inc === false){
				$counter_val = $cat[$this->FileCounterKey] - 1;
			}else{
				$counter_val = $cat[$this->FileCounterKey] + intval($inc);
			}
			System::database()->Update($this->Table, $this->FileCounterKey."='$counter_val'", "`".$this->IdKey."`='$id'");

			//  
			System::cache()->Delete('tree', $this->Table);
		}
	}

	/**
	 *      
	 *
	 * @param int $id  
	 * @return array
	 */
	public function GetCountersRecursive( $id = 0 ){
		$childs = $this->GetAllChildId($id);
		$file_counter = 0;
		$cat_counter = 0;
		foreach($childs as $id){
			$file_counter += $this->IdCats[$id][$this->FileCounterKey];
			$cat_counter += $this->IdCats[$id][$this->CatCounterKey];
		}
		return array('files'=>$file_counter, 'cats'=>$cat_counter);
	}

	/**
	 *      
	 *      
	 *
	 * @param int $id  
	 * @param int $inc  
	 * @return void
	 */
	public function CalcCatCounter( $id, $inc ){
		$cat = System::database()->SelectOne($this->Table, "`".$this->IdKey."`='$id'");
		if($cat){
			if($inc === true){
				$counter_val = $cat[$this->CatCounterKey] + 1;
			}elseif($inc === false){
				$counter_val = $cat[$this->CatCounterKey] - 1;
			}else{
				$counter_val = $cat[$this->CatCounterKey] + intval($inc);
			}
			System::database()->Update($this->Table, $this->CatCounterKey."='$counter_val'", "`".$this->IdKey."`='$id'");
			//  
			System::cache()->Delete('tree', $this->Table);
		}
	}

	/**
	 *      GetCatsData
	 *
	 * @param  $tree
	 * @param  $level
	 * @return void
	 */
	public function CatsData( $tree, $level ){
		global $FCatsData;
		if(in_array($tree[$this->IdKey], $this->childs) === false){
			$levs = str_repeat('&nbsp;-&nbsp;', $level);
			$title = $levs.$tree[$this->TitleKey];
			if($this->viewitems && isset($tree[$this->FileCounterKey]) && $tree[$this->FileCounterKey] > 0){
				$count = $this->GetCountersRecursive($tree[$this->IdKey]);
				$title .= ' ('.$count['files'].')';
			}
			System::site()->DataAdd($FCatsData, $tree[$this->IdKey], $title, in_array($tree[$this->IdKey], $this->sel_id));
		}
	}

	/**
	 *         
	 *
	 * @param int|array $sel_id   
	 * @param boolean $viewitems       
	 * @param boolean $root   
	 * @param int $id          
	 * @param boolean $xor  
	 * @return array
	 */
	public function GetCatsData( $sel_id, $viewitems = false, $root = false, $id = 0, $xor = false ){
		global $FCatsData;
		$this->childs = array();
		if(!is_array($sel_id)){
			$sel_id = array($sel_id);
		}
		$this->sel_id = $sel_id;
		$this->viewitems = $viewitems;
		if($xor){
			$this->childs = $this->GetAllChildId($id);
		}
		if($root){
			System::site()->DataAdd($FCatsData, '0', $this->TopCatName, in_array(0, $sel_id));
		}
		$this->ListingTree(0, array($this, 'CatsData'));
		return $FCatsData;
	}
}
