<?php

/*
 * LinkorCMS 1.4
 *  2012 LinkorCMS Development Group
 */


if(!defined('VALID_RUN')){
	header("HTTP/1.1 404 Not Found");
	exit;
}

global $config;

$vars['title'] = $title;
$tempvars['content'] = 'block/content/menu.html';
$uri = $_SERVER['REQUEST_URI'];

if(!function_exists('BlockMenuSelectItem')){
	function BlockMenuSelectItem(&$blocks, $uri){
		foreach($blocks['sub'] as &$item){
			if($item['vars']['link'] != '' && strpos($uri, $item['vars']['link']) !== false){
				$item['vars']['selected'] = true;
				break;
			} else{
				foreach($item['child']['block_menu_subitems']['sub'] as &$subitem){
					if($subitem['vars']['link'] != '' && strpos($uri, $subitem['vars']['link']) !== false){
						$subitem['vars']['selected'] = true;
						$item['vars']['selected'] = true;
						break;
					}
				}
			}
		}
	}
}

// 
$bcache_name = 'menu'.System::user()->AccessLevel();
if(System::cache()->HasCache('block', $bcache_name)){
	$block_menu_items = System::cache()->Get('block', $bcache_name);
	BlockMenuSelectItem($block_menu_items, $uri);
	$childs['block_menu_items'] = $block_menu_items;
	return;
}

// 
$pages = System::database()->Select('pages', GetWhereByAccess('view', "`enabled`='1' and `showinmenu`='1'"), null, 'order');
$catsPid = array();
foreach($pages as $page){
	$catsPid[$page['parent']][] = $page;
}
if(!isset($catsPid[0])){
	$catsPid[0] = array();
}

//  
$items = Starkyt::CreateBlock(true, true, 'menu_item');
foreach($catsPid[0] as $page){
	$subitems = Starkyt::CreateBlock(true, true, 'menu_subitem');
	$link = '';
	if($page['type'] == 'page'){
		$link = Ufu('index.php?name=pages&file='.SafeDB($page['link'], 255, str), 'pages:page');
	}elseif($page['type'] == 'link'){
		$link = SafeDB($page['text'], 255, str);
		if(substr($link, 0, 6) == 'mod://'){
			$link = Ufu('index.php?name='.substr($link, 6), 'system:mod');
		}
	}
	$link = str_replace('&amp;', '&', $link);

	$item_vars = array(
		'title' => $page['title'],
		'link' => $link,
		'selected' => false,
		'subitems' => false
	);

	if(isset($catsPid[$page['id']])){
		foreach($catsPid[$page['id']] as $subpage){
			if($subpage['type'] == 'page'){
				$link = Ufu('index.php?name=pages&file='.SafeDB($subpage['link'], 255, str), 'pages:page');
			}elseif($subpage['type'] == 'link'){
				$link = SafeDB($subpage['text'], 255, str);
				if(substr($link, 0, 6) == 'mod://'){
					$link = Ufu('index.php?name='.substr($link, 6), 'system:mod');
				}
			}else{
				continue;
			}
			$link = str_replace('&amp;', '&', $link);

			$subitem_vars = array(
				'title' => $subpage['title'],
				'link' => $link,
				'selected' => false
			);
			$subitems['sub'][] = Starkyt::CreateSubBlock(true, $subitem_vars);
		}
	}
	$item_vars['subitems'] = count($subitems['sub']) > 0;
	$items['sub'][] = Starkyt::CreateSubBlock(true, $item_vars, array(), '', '', array('block_menu_subitems' => $subitems));
}

System::cache()->Write('block', $bcache_name, $items);
BlockMenuSelectItem($items, $uri);
$childs['block_menu_items'] = $items;
