<?php

/*
 * LinkorCMS 1.4
 *  2012 LinkorCMS Development Group
 */


if(!defined('VALID_RUN')){
	header("HTTP/1.1 404 Not Found");
	exit;
}

System::admin()->AddSubTitle('');

global $editprofile, $action;

if(isset($_GET['a'])){
	$action = $_GET['a'];
}else{
	$action = 'main';
}

$editprofile = (($action == 'editadmin' || $action == 'adminsave') && !System::user()->isSuperUser() && isset($_GET['id']) && $_GET['id'] == System::user()->Get('u_id'));

if(!System::user()->isSuperUser() && !$editprofile){
	System::admin()->AccessDenied();
}

if(!$editprofile){
	TAddToolLink('', 'main', 'admins');
	TAddToolLink(' ', 'groups', 'admins&a=groups');
	TAddToolLink(' ', 'addgroup', 'admins&a=addgroup');
	TAddToolBox($action);
}

switch($action){
	case 'main':
		AdminsMain();
		break;
	case 'groups':
		AdminsGroups();
		break;
	case 'editgroup':
		AdminsEditGroup();
		break;
	case 'addgroup':
		AdminsEditGroup();
		break;
	case 'addsave':
	case 'editsave':
		AdminsEditGroupSave();
		break;
	case 'delgroup':
		AdminsDeleteGroup();
		break;
	case 'editadmin':
		if($editprofile){
			System::admin()->BreadCrumbAdd(' ');
		}
		AdminUserEditor('admins&a=adminsave', 'edit', SafeEnv($_GET['id'], 11, int), true);
		break;
	case 'adminsave':
		if($editprofile){
			System::admin()->BreadCrumbAdd(' ');
		}
		AdminUserEditSave('admins', 'update', SafeEnv($_GET['id'], 11, int), true);
		break;
	case 'deladmin':
		AdminsDelete();
		break;
	default:
		AdminsMain();
}

function AdminsGenAccessStr( &$useraccess, &$accesses, $system = false ){
	$msg = '';
	if($system == '1'){
		$msg = '  ';
	}elseif(trim($useraccess) == 'ALL'){
		$msg = ' ,       ';
	}else{
		$useraccess = unserialize($useraccess);
		$keys = array_keys($useraccess);
		for($i = 0, $c = count($keys); $i < $c; $i++){
			for($j = 0, $k = count($useraccess[$keys[$i]]); $j < $k; $j++){
				if(isset($accesses[$keys[$i]][$useraccess[$keys[$i]][$j]])){
					$msg .= $accesses[$keys[$i]][$useraccess[$keys[$i]][$j]].', ';
				}
			}
		}
	}
	if($msg == ''){
		$msg = ' ,   .';
	}else{
		$len = strlen($msg);
		$msg = substr($msg, 0, $len - 2);
		$msg .= '.';
	}
	return $msg;
}

function AdminsGetAccessArray( $useraccess ){
	$all = (trim($useraccess) == 'ALL');
	$result['ALL'][] = array('ALL', 'ALL', '<b><font color="#FF0000"> </font></b>', $all);
	if(!$all){
		$useraccess = unserialize($useraccess);
	}else{
		$useraccess = array();
	}
	$accesses = System::database()->Select('access', '');
	foreach($accesses as $ac){
		$access[] = array(
			SafeDB($ac['group'], 255, str),
			SafeDB($ac['name'], 255, str),
			($ac['group'] == $ac['name'] ? '<b>'.SafeDB($ac['description'], 255, str).'</b>' : SafeDB($ac['description'], 255, str))
		);
	}
	unset($accesses);
	$keys = array_keys($access);
	for($i = 0, $c = count($keys); $i < $c; $i++){
		$s = $all || (isset($useraccess[$access[$i][0]]) && in_array($access[$i][1], $useraccess[$access[$i][0]]));
		$result[$access[$i][0]][] = array($access[$i][0], $access[$i][1], $access[$i][2], $s);
	}
	return $result;
}

//  
function AdminsMain(){
	$atypes = System::database()->Select('usertypes', '');
	foreach($atypes as $type){
		$types[SafeDB($type['id'], 11, int)] = array(
			'<span style="color: '.SafeDB($type['color'], 9, str).';">'.SafeDB($type['name'], 255, str).'</span>',
			SafeDB($type['system'], 1, bool),
			($type['image'] != '' ? '<img src="'.System::config('general/ranks_dir').SafeDB($type['image'], 255, str).'"><br>': '')
		);
	}
	$admins = System::database()->Select('users', "`type`='1'");
	//   
	$system = 0;
	for($i = 0, $c = count($admins); $i < $c; $i++){
		if($types[$admins[$i]['access']][1]){
			$system++;
		}
	}
	$text = '<table cellspacing="0" cellpadding="0" class="cfgtable"><tr><th>&nbsp;</th><th></th><th>E-mail</th><th></th><th>. </th><th></th><th></th></tr>';
	foreach($admins as $adm){
		$id = SafeDB($adm['id'], 11, int);
		$funcs = '';
		$funcs .= System::admin()->SpeedButton('', ADMIN_FILE.'?exe=admins&a=editadmin&id='.$id, 'images/admin/edit.png');
		if($system > 1 || !$types[$adm['access']][1]){
			$funcs .= System::admin()->SpeedButton('    ', ADMIN_FILE.'?exe=admins&a=deladmin&id='.$id, 'images/admin/delete.png');
		}
		$text .= '<tr>
			<td><img src="'.GetSmallestUserAvatar($id).'"></td>
			<td><b>'.System::admin()->Link(SafeDB($adm['name'], 50, str), ADMIN_FILE.'?exe=admins&a=editadmin&id='.$id).'</b></td>
			<td>'.PrintEmail($adm['email']).'</td>
			<td>'.$types[$adm['access']][2].$types[$adm['access']][0].'</td>
			<td>'.TimeRender($adm['lastvisit']).'</td>
			<td>'.SafeDB($adm['visits'], 11, int).'</td>
			<td>'.$funcs.'</td>
			</tr>';
	}
	$text .= '</table>';
	AddTextBox('  ('.count($admins).')', $text);
}

//  
function AdminsDelete(){
	$userid = SafeEnv($_GET['id'], 11, int);
	System::database()->Select('users', "`id`='".$userid."' and `type`='1'");
	$user = System::database()->FetchRow();
	if(groupIsSystem(SafeEnv($user['access'], 11, int)) && GetSystemAdminsCount() <= 1){
		System::admin()->AddCenterBox('');
		System::admin()->HighlightError('    .');
		return;
	}
	if(isset($_GET['ok']) && $_GET['ok'] == '1'){ // 
		$id = SafeEnv($_GET['id'], 11, int);
		if(!isset($_POST['del_comments'])){
			System::database()->Select('users', "`id`='$id'");
			if(System::database()->NumRows() > 0){
				$suser = System::database()->FetchRow();
				UpdateUserComments($id, '0', SafeEnv($suser['name'], 50, str), SafeEnv($suser['email'], 50, str), SafeEnv($suser['hideemail'], 1, bool), SafeEnv($suser['url'], 250, str));
			}
		}else{
			DeleteAllUserComments($id);
		}
		System::database()->Delete('users', "`id`='$id' and `type`='1'");
		System::cache()->Delete(system_cache, 'users');
		Audit(':   "'.$user['name'].'"');
		GO(ADMIN_FILE.'?exe=admins');
	}elseif(isset($_GET['ok']) && $_GET['ok'] == '2'){ //  
		System::database()->Update('users', "type='2',access='-1'", "`id`='".SafeEnv($_GET['id'], 11, int)."' and `type`='1'");
		System::cache()->Delete(system_cache, 'users');
		Audit(': "'.$user['name'].'"   ');
		GO(ADMIN_FILE.'?exe=admins');
	}else{
		System::admin()->AddJS('
		AjaxDeleteAdmin = function(){
			var del = $("#del_comments:checked").val();
			if(del == null){
				del = "0";
			}
			Admin.LoadPage("'.ADMIN_FILE.'?exe=admins&a=deladmin&id='.$userid.'&ok=1&del_comments="+del, undefined, "");
		};
		AjaxAdminSetToUser = function(){
			Admin.LoadPage("'.ADMIN_FILE.'?exe=admins&a=deladmin&id='.$userid.'&ok=2");
		};
		');
		AddCenterBox(' ');
		$Text = '      "'.SafeDB($user['name'], 255, str).'"?';
		$Text .= '<br /><br />'
			.System::admin()->Check('del_comments', '1', false, 'id="del_comments"').'<label for="del_comments" style="cursor: pointer;">    </label><br /><br />'
			.System::admin()->SpeedButton('', 'javascript:history.go(-1)', 'images/admin/cancel.png', false, true).'&nbsp;&nbsp;'
			.System::admin()->SpeedConfirmJs('', 'AjaxDeleteAdmin();', 'images/admin/delete.png', '', true).'&nbsp;&nbsp;'
			.System::admin()->SpeedConfirmJs(' ', 'AjaxAdminSetToUser();', 'images/user_green.png', '', true);
		System::admin()->Highlight($Text);
	}
}

//  
function AdminsGroups(){
	$accesses = System::database()->Select('access', '');
	foreach($accesses as $ac){
		$access[SafeDB($ac['group'], 255, str)][SafeDB($ac['name'], 255, str)] = SafeDB($ac['description'], 255, str);
	}
	unset($accesses);
	$atypes = System::database()->Select('usertypes', '');
	foreach($atypes as $type){
		$types[SafeDB($type['id'], 11, int)] = array(
			'<font color="'.$type['color'].'">'.SafeDB($type['name'], 255, str).'</font>',
			SafeDB($type['access'], 0, str, false, false),
			SafeDB($type['id'], 11, int),
			SafeDB($type['system'], 1, bool)
		);
	}
	unset($atypes);
	unset($type);
	$text = '<table cellspacing="0" cellpadding="0" class="cfgtable"><th></th><th></th><th></th></tr>';
	foreach($types as $type){
		$funcs = '';
		$funcs .= SpeedButton('', ADMIN_FILE.'?exe=admins&a=editgroup&id='.$type[2], 'images/admin/edit.png');
		if($type[3] == '0'){
			$funcs .= SpeedButton('', ADMIN_FILE.'?exe=admins&a=delgroup&id='.$type[2], 'images/admin/delete.png');
		}
		$text .= '<tr>
		<td>'.$type[0].'</td>
		<td>'.SafeDB(AdminsGenAccessStr($type[1], $access, $type[3]), 0, str).'</td>
		<td>'.$funcs.'</td>
		</tr>';
	}
	$text .= '</table>';
	AddTextBox(' ', $text);
}

//  /  
function AdminsEditGroup(){
	global $action;
	if($action == 'editgroup'){
        System::database()->Select('usertypes', "`id`='".SafeEnv($_GET['id'], 11, int)."'");
		$group = System::database()->FetchRow();
		$name = SafeDB($group['name'], 255, str);
		$color = SafeDB($group['color'], 9, str);
		$access = SafeDB($group['access'], 0, str, false, false);
		$image = SafeDB($group['image'], 250, str);
		$method = 'editsave&id='.SafeEnv($_GET['id'], 11, int);
		$title = ' ';
		if($group['system']){
			$other = 'disabled';
		}else{
			$other = '';
		}
	}elseif($action == 'addgroup'){
		$name = '';
		$color = '#000000';
		$image = '';
		$access = serialize(array());
		$method = 'addsave';
		$title = ' ';
		$other = '';
	}
	FormRow('', System::site()->Edit('name', $name, false, 'style="width:400px;" class="autofocus"'));
	FormRow('', System::site()->Edit('color', $color, false, 'style="width:400px;"'));
	FormRow('', System::site()->Edit('image', $image, false, 'style="width:400px;"'));
	$access = AdminsGetAccessArray($access);
	$ac = '';
	foreach($access as $a){
		$ac .= '<table width="100%" cellspacing="0" cellpadding="3" style="border:1px #ABC5D8 solid;margin-bottom:2px;">';
		for($i = 0, $c = count($a); $i < $c; $i++){
			$ac .= '<tr>
			<td style="border:none;"><label>'.System::site()->Check('access[]', $a[$i][0].','.$a[$i][1], $a[$i][3], $other).'<span style="display: inline-block; vertical-align: top; padding-top: 3px;">'.$a[$i][2].'</span></label></td>
			</tr>';
		}
		$ac .= '</table>';
	}
	FormRow('', $ac);
	AddCenterBox($title);
	AddForm('<form action="'.ADMIN_FILE.'?exe=admins&a='.$method.'" method="post">', System::site()->Button('', 'onclick="history.go(-1);"').System::site()->Submit(''));
}

//  
function AdminsEditGroupSave(){
	global $action;
	$access = array();
	$access2 = array();
	if(isset($_POST['access'])){
		$access = SafeEnv($_POST['access'], 0, str);
		$keys = array();
		for($i = 0, $c = count($access); $i < $c; $i++){
			$acca = explode(',', $access[$i]);
			$access2[$acca[0]][] = $acca[1];
			if(!in_array($acca[0], $keys)){
				$keys[] = $acca[0];
			}
		}
		//   "" 
		for($i = 0, $c = count($keys); $i < $c; $i++){
			if(!in_array($keys[$i], $access2[$keys[$i]])){
				unset($access2[$keys[$i]]);
			}
		}
	}
	if(isset($access2['ALL'])){
		$access = 'ALL';
	}else{
		$access = serialize($access2);
	}
	if($action == 'editsave'){
		$adm = System::database()->Select('usertypes', "`id`='".SafeEnv($_GET['id'], 11, int)."'");
		if($adm[0]['system'] == '1'){
			$access = 'ALL';
		}
		$vals = Values('', SafeEnv($_POST['name'], 255, str), SafeEnv($_POST['color'], 9, str), $access, SafeEnv($adm[0]['system'], 1, int), SafeEnv($_POST['image'], 250, str));
        System::database()->Update('usertypes', $vals, "`id`='".SafeEnv($_GET['id'], 11, int)."'", true);
		Audit(':    "'.$_POST['name'].'"');
	}elseif($action == 'addsave'){
		$vals = Values('', SafeEnv($_POST['name'], 255, str), SafeEnv($_POST['color'], 9, str), $access, 0, SafeEnv($_POST['image'], 250, str));
		System::database()->Insert('usertypes', $vals);
		Audit(':    "'.$_POST['name'].'"');
	}

	//  
	System::cache()->Delete(system_cache, 'usertypes');

	GO(ADMIN_FILE.'?exe=admins&a=groups');
}


//   
function AdminsDeleteGroup(){
	if(!isset($_GET['id'])){
		GO(ADMIN_FILE.'?exe=admins&a=groups');
		exit();
	}
	$id = SafeEnv($_GET['id'], 11, int);
	if(isset($_GET['ok']) && SafeEnv($_GET['ok'], 1, int) == '1'){

		//  
		if(System::cache()->HasCache(system_cache, 'usertypes')){
			System::cache()->Delete(system_cache, 'usertypes');
		}

		System::database()->Select('users', "`access`='".$id."'");
		$num_users = System::database()->NumRows();

		System::database()->Select('usertypes', "`id`='$id'");
		$group = System::database()->FetchRow();

		if($num_users > 0){
			if(!isset($_GET['users'])){
				$text = '    '.$num_users.' .  :<br />'
				.'<a href="'.ADMIN_FILE.'?exe=admins&a=delgroup&id='.$id.'&ok=1&users=del"> ...</a> <br />'
				.'<a href="'.ADMIN_FILE.'?exe=admins&a=delgroup&id='.SafeEnv($_GET['id'], 11, int).'&ok=1&users=move">    .</a>';
				AddTextBox('!', $text);
			}else{
				if($_GET['users'] == 'del'){
					System::database()->Delete('users', "`access`='".$id."'");
				}elseif($_GET['users'] == 'move' && !isset($_POST['to'])){
					$text = ' ,      :<br />'.'<form action="'.ADMIN_FILE.'?exe=admins&a=delgroup&id='.$id.'&ok=1&users=move" method="post">';
					System::database()->Select('usertypes', "`id`<>'".$id."'");
					System::site()->DataAdd($group_data, '-1', '');
					while($tp = System::database()->FetchRow()){
						System::site()->DataAdd($group_data, $tp['id'], $tp['name']);
					}
					$text .= System::site()->Select('to', $group_data).'<br />';
					$text .= System::site()->Submit('').'<br />';
					$text .= '</form>';
					AddTextBox('!', $text);
					return;
				}elseif($_GET['users'] == 'move' && isset($_POST['to'])){
					$to = SafeEnv($_POST['to'], 11, int);
					if($to == '-1'){
						$set = "type='2',access='".$to."'";
					}else{
						$set = "access='".$to."'";
					}
					System::database()->Update('users', $set, "`access`='".$id."'");
				}
			}
		}
		System::database()->Delete('usertypes', "`id`='".$id."'");
		Audit(':    "'.$group['name'].'"');
		GO(ADMIN_FILE.'?exe=admins&a=groups');
	}else{
		System::database()->Select('usertypes', "`id`='".$id."'");
		$group = System::database()->FetchRow();
		$text = '     "'.SafeDB($group['name'], 255, str).'"?<br />'.'<a href="'.ADMIN_FILE.'?exe=admins&a=delgroup&id='.$id.'&ok=1"></a> &nbsp;&nbsp;&nbsp; <a href="javascript:history.go(-1)"></a>';
		AddTextBox("", $text);
	}
}

