<?php

/*
 * LinkorCMS 1.4
 *  2012 LinkorCMS Development Group
 */


if(!defined('VALID_RUN')){
	header("HTTP/1.1 404 Not Found");
	exit;
}

System::site()->SetTitle(' ');

if(isset($_GET['op'])){
	$op = $_GET['op'];
}else{
	$op = 'main';
}

switch($op){
	case 'main':
		if(isset($_GET['cat'])){
			$cat = SafeEnv($_GET['cat'], 11, int);
		}else{
			$cat = 0;
		}
		if(System::config('articles/show_catnav') == '1'){
			IndexArticlesGetTree()->BreadCrumbs($cat);
			IndexArticlesGetTree()->ShowCats($cat);
		}
		if($cat != 0 || System::config('articles/show_last') == '1'){
			IndexArticlesShow($cat);
		}
		break;
	case 'read':
		IndexArticlesRead();
		break;
	case 'addvote':
		IndexArticlesAddVote();
		break;
	// 
	case 'addpost':
		$id = intval(SafeEnv($_GET['art'], 11, int));
		$cat = SafeDB($_GET['cat'], 11, int);
		CommentsAddPost(
			$id,
			'articles_comments',
			'articles',
			'comments_counter',
			'allow_comments',
			"index.php?name=articles&op=read&art=$id&cat=$cat",
			'articles/{cat}/{art}/'
		);
		break;
	case 'savepost':
		if(CommentsEditPostSave(SafeEnv($_GET['art'], 11, int), 'articles_comments')){
			break;
		}
	case 'editpost':
		CommentsEditPost('articles_comments', "index.php?name=articles&op=savepost&art=".SafeDB($_GET['art'], 11, int).'&back='.SafeDB($_GET['back'], 255, str));
		break;
	case 'deletepost':
		$id = SafeEnv($_GET['art'], 11, int);
		$delete_url = "index.php?name=articles&op=deletepost&art=$id&back=".SafeDB($_GET['back'], 255, str);
		CommentsDeletePost($id, 'articles_comments', 'articles', 'comments_counter', $delete_url);
		break;
	// //
	default:
		HackOff();
}

function IndexArticlesGetTree() {
	static $tree = null;
	if(is_null($tree)) {
		$tree = new IndexTree('articles_cats');
		$tree->moduleName = 'articles';
		$tree->id_par_name = 'cat';
		$tree->NumItems = 'IndexArticlesGetNumItems';
	}
	return $tree;
}

function IndexArticlesGetNumItems(){
	System::database()->Select('articles', GetWhereByAccess('view', "`active`='1'"));
	$num = System::database()->NumRows();
	System::database()->FreeResult();
	return '<p align="center">    : '.$num.'.</p>';
}

function IndexArticlesFunc( $id ){
	$back = SaveRefererUrl();
	return '&nbsp'
	.'<a href="'.ADMIN_FILE.'?exe=articles&a=editor&id='.$id.'&back='.$back.'" class="admin_edit_link"><img src="images/admin/edit.png" title=""></a>'
	.'<a href="'.ADMIN_FILE.'?exe=articles&a=delete&id='.$id.'&ok=0&back='.$back.'" class="admin_edit_link"><img src="images/admin/delete.png" title=""></a>';
}

function RenderReadArticle( &$art ){
	$vars = array();
	$art_id = SafeDB($art['id'], 11, int);
	$cat_id = SafeDB($art['cat_id'], 11, int);
	$vars['title'] = SafeDB($art['title'], 250, str).(System::user()->isAdmin() ? IndexArticlesFunc($art_id) : '');
	$vars['cat'] = IndexArticlesGetTree()->IdCats[$cat_id]['title'];
	$vars['catlink'] = Ufu("index.php?name=articles&cat=$cat_id", 'articles/{cat}/');
	if($art['auto_br_article'] == '1'){
		$vars['article'] = nl2br(SafeDB($art['article'], 0, str, false, false, false));
	}else{
		$vars['article'] = SafeDB($art['article'], 0, str, false, false, false);
	}
	$vars['lauthor'] = '';
	$vars['author'] = SafeDB($art['author'], 200, str);
	$vars['lemail'] = 'E-mail';
	$vars['email'] = SafeDB($art['email'], 50, str);
	$vars['lurl'] = '';
	$vars['site'] = SafeDB($art['www'], 250, str);
	$vars['site_url'] = UrlRender(SafeDB($art['www'], 250, str));
	$vars['lpublic'] = '';
	$vars['public'] = TimeRender(SafeDB($art['public'], 11, int), false);
	$vars['lhits'] = '';
	$vars['hits'] = SafeDB($art['hits'], 11, int);
	$vars['lcomments'] = '';
	$vars['comments'] = SafeDB($art['comments_counter'], 11, int);
	$vars['allow_votes'] = $art['allow_votes'] == '1';
	$vars['addvote_url'] = "index.php?name=articles&op=addvote&article=$art_id&cat=$cat_id";

	System::site()->DataAdd($vdata, '0', ' ');
	System::site()->DataAdd($vdata, '1', ' ');
	System::site()->DataAdd($vdata, '2', '');
	System::site()->DataAdd($vdata, '3', '');
	System::site()->DataAdd($vdata, '4', '');
	System::site()->DataAdd($vdata, '5', '');
	$vars['votes'] = System::site()->Select('vote', $vdata);
	$vars['lvote'] = '  ';
	$vars['addvotesubm'] = System::site()->Submit(' ');

	// rating
	$rating = GetRatingImage(SafeDB($art['num_votes'], 11, int), SafeDB($art['all_votes'], 11, int));
	$vars['rating_image'] = $rating;
	$vars['alloy_rating'] = SafeDB($art['allow_votes'], 1, bool);
	$vars['disable_rating'] = !$vars['alloy_rating'];
	$vars['lrating'] = '';
	$vars['rating_num_votes'] = SafeDB($art['num_votes'], 11, int);
	//

	System::site()->AddBlock('article', true, false, 'art');
	System::site()->Blocks['article']['vars'] = $vars;
}

function RenderArticle( &$art ){
	$vars = array();
	$art_id = SafeDB($art['id'], 11, int);
	$cat_id = SafeDB($art['cat_id'], 11, int);
	$func = IndexArticlesFunc($art_id);
	$vars['title'] = SafeDB($art['title'], 250, str).(System::user()->isAdmin() ? $func : '');
	$vars['cat'] = IndexArticlesGetTree()->IdCats[$cat_id]['title'];
	$vars['catlink'] = Ufu("index.php?name=articles&cat=$cat_id", 'articles/{cat}/');
	if($art['image'] != ''){
		$vars['image'] = RealPath2(System::config('articles/images_dir').SafeDB($art['image'], 255, str));
		$vars['thumb_image'] = RealPath2(System::config('articles/images_dir').'thumbs/'.SafeDB($art['image'], 255, str));
	}else{
		$vars['image'] = false;
	}
	if($art['auto_br_desc'] == '1'){
		$vars['description'] = nl2br(SafeDB($art['description'], 0, str, false, false, false));
	}else{
		$vars['description'] = SafeDB($art['description'], 0, str, false, false, false);
	}
	$vars['lauthor'] = '';
	$vars['author'] = SafeDB($art['author'], 200, str);
	$vars['lemail'] = 'E-mail';
	$vars['email'] = SafeDB($art['email'], 50, str);
	$vars['lurl'] = '';
	$vars['site'] = SafeDB($art['www'], 250, str);
	$vars['site_url'] = UrlRender(SafeDB($art['www'], 250, str));
	$vars['lpublic'] = '';
	$vars['public'] = TimeRender(SafeDB($art['public'], 11, int), false);
	$vars['link2'] = Ufu("index.php?name=articles&op=read&art=$art_id&cat=$cat_id", 'articles/{cat}/{art}/');
	$vars['link'] = '<a href="'.$vars['link2'].'">...</a>';
	$vars['lhits'] = '';
	$vars['hits'] = SafeDB($art['hits'], 11, int);
	$vars['lcomments'] = '';
	$vars['comments'] = SafeDB($art['comments_counter'], 11, int);

	// rating
	$rating = GetRatingImage(SafeDB($art['num_votes'], 11, int), SafeDB($art['all_votes'], 11, int));
	$vars['rating_image'] = $rating;
	$vars['alloy_rating'] = SafeDB($art['allow_votes'], 1, bool);
	$vars['disable_rating'] = !$vars['alloy_rating'];
	$vars['lrating'] = '';
	$vars['rating_num_votes'] = SafeDB($art['num_votes'], 11, int);
	//

	System::site()->AddSubBlock('articles', true, $vars);
}

function IndexArticlesShow( $cat ){
	if($cat != 0){
		System::site()->SetTitle('   '.SafeDB(IndexArticlesGetTree()->IdCats[$cat]['title'], 255, str));
	}
	if(isset($_GET['page'])){
		$page = SafeEnv($_GET['page'], 11, int);
	}else{
		$page = 1;
	}
	$arts = System::database()->Select('articles', GetWhereByAccess('view', ($cat != 0 ? "`cat_id`='$cat' and " : '')."`active`='1'"));
	SortArray($arts, 'public', true);

	//  
	$num = System::config('articles/articles_on_page');
	$navigation = new Navigation($page);
	$nav_link = Ufu('index.php?name=articles'.($cat != 0 ? '&cat='.$cat : ''), 'articles/'.($cat != 0 ? '{cat}/' : '').'page{page}/', true);
	$navigation->FrendlyUrl = System::config('general/ufu');
	$navigation->GenNavigationMenu($arts, $num, $nav_link);

	if(System::database()->NumRows() > 0){
		System::site()->AddTemplatedBox('', 'module/article.html');
		System::site()->AddBlock('articles', true, true, 'art');
		foreach($arts as $art){
			RenderArticle($art);
		}
	}elseif(!isset(IndexArticlesGetTree()->Cats[$cat]) && count(IndexArticlesGetTree()->Cats) > 0){
		System::site()->AddTextBox('', '<p align="center">     .</p>');
	}
}

function IndexArticlesRead(){
	if(isset($_GET['art'])){
		$id = SafeEnv($_GET['art'], 11, int);
	}else{
		GO(GetSiteUrl().Ufu('index.php?name=articles', '{name}/'));
	}
	$where = "`id`='$id' and `active`='1'";
	System::database()->Select('articles', GetWhereByAccess('view', $where));
	if(System::database()->NumRows() == 0){
		GO(GetSiteUrl().Ufu('index.php?name=articles', '{name}/'));
	}
	$art = System::database()->FetchRow();
	System::database()->Update('articles', "hits='".(SafeEnv($art['hits'], 11, int) + 1)."'", $where);
	$cat = SafeDB($art['cat_id'], 11, int);

	//  
	if(System::config('articles/show_catnav') == '1'){
        IndexArticlesGetTree()->BreadCrumbs($art['cat_id']);
	}
	System::site()->BreadCrumbAdd(SafeDB($art['title'], 255, str));

	System::site()->AddTemplatedBox('', 'module/article_read.html');
	System::site()->SetTitle(SafeDB($art['title'], 255, str));
	System::site()->SeoTitle = SafeDB($art['seo_title'], 255, str);
	System::site()->SeoKeyWords = SafeDB($art['seo_keywords'], 255, str);
	System::site()->SeoDescription = SafeDB($art['seo_description'], 255, str);
	RenderReadArticle($art);

	//  
	if(isset($_GET['page'])){
		$page = SafeEnv($_GET['page'], 11, int);
	}else{
		$page = 0;
	}
	$posts = new Posts('articles_comments', $art['allow_comments'] == '1');
	$posts->EditPageUrl = "index.php?name=articles&op=editpost&art=$id"; //   
	$posts->DeletePageUrl = "index.php?name=articles&op=deletepost&art=$id"; //  
	$posts->PostFormAction = "index.php?name=articles&op=addpost&art=$id&cat=$cat"; //   ()

	$posts->NavigationUrl = Ufu("index.php?name=articles&op=read&art=$id&cat=$cat", 'articles/{cat}/{art}/page{page}/', true);
	$posts->NavigationAnchor = '#comments';
	$posts->RenderPosts($id, 'article_comments', 'comments_navigation', false, $page);
	$posts->RenderForm(false, 'article_comments_form');
}

function IndexArticlesAddVote(){
	$ip = getip();
	$time = time() - 86400; //1 
	$article = SafeEnv($_GET['article'], 11, int);
	$vote = SafeEnv($_POST['vote'], 1, int);
	System::database()->Delete('articles_rating', "`time`<'$time'");
	System::site()->OtherMeta .= '<meta http-equiv="REFRESH" content="3; URL='.HistoryGetUrl(1).'">';
	System::database()->Select('articles', GetWhereByAccess('view', "`id`='$article' and `active`='1'"));
	if(System::database()->NumRows() > 0){
		$dfile = System::database()->FetchRow();
		if($dfile['allow_votes']=='1'){ //  
			System::database()->Select('articles_rating',"`ip`='$ip' and `downid`='$article'");
			if(System::database()->NumRows() > 0){
				System::site()->AddTextBox('','<p align="center">     .<br><br><a href="javascript:history.go(-1)"></a></p>');
			}else{
				if($vote==0){
					System::site()->AddTextBox('','<p align="center">   .<br><br><a href="javascript:history.go(-1)"></a></p>');
				}else{
					System::user()->ChargePoints(System::config('points/article_rating'));
					$time = time();
					System::database()->Insert('articles_rating',"'','$article','$ip','$time'");
					$numvotes = SafeDB($dfile['num_votes'],11,int) + 1;
					$vote = SafeDB($dfile['all_votes'],11,int) + $vote;
					System::database()->Update('articles', "num_votes='$numvotes',all_votes='$vote'", "`id`='$article'");
					System::site()->AddTextBox('','<p align="center">   .<br><br><a href="javascript:history.go(-1)"></a></p>');
				}
			}
		}else{
			System::site()->AddTextBox('','<p align="center">,    .<br><br><a href="javascript:history.go(-1)"></a></p>');
		}
	}else{
		System::site()->AddTextBox('','<p align="center"> .   .<br><br><a href="javascript:history.go(-1)"></a></p>');
	}
}
