<?php

/*
 * LinkorCMS 1.4
 *  2012 LinkorCMS Development Group
 */


if(!defined('VALID_RUN')){
	header("HTTP/1.1 404 Not Found");
	exit;
}

if(!System::user()->isSuperUser()){
	System::admin()->AccessDenied();
}

System::admin()->AddSubTitle('');

$action = isset($_GET['a']) ? $_GET['a'] : 'main';

System::admin()->SideBarAddMenuItem('', 'exe=extensions&a=main', 'main');
System::admin()->SideBarAddMenuItem('', 'exe=extensions&a=installlist', 'installlist');
System::admin()->SideBarAddMenuItem('', 'exe=extensions&a=uploadform', 'uploadform');
System::admin()->SideBarAddMenuBlock('', $action);

switch($action){
	case 'main':
		AdminExtensions();
		break;
	case 'installlist':
		AdminExtensionsInstallList();
		break;
	case 'install':
		AdminExtensionsInstall();
		break;
	case 'uploadform':
		AdminExtensionsUploadForm();
		break;
	case 'upload':
		AdminExtensionsUpload();
		break;
	case 'uninstall':
		AdminExtensionsUninstall();
		break;

	// 
	case 'changestatus':
		AdminExtensionsChangeStatus();
		break;
	case 'mod_config':
		AdminExtensionsConfig();
		break;
	case 'mod_configsave':
		AdminExtensionsConfigSave();
		break;

	case 'plug_config':
		if(isset($_GET['group'])){
			$url = ADMIN_FILE.'?exe=extensions&a=plug_configsave&group='.SafeDB($_GET['group'], 255, str);
			System::admin()->AddCenterBox(' ');
			System::admin()->ConfigGroups(SafeEnv($_GET['group'], 255, str));
			System::admin()->AddConfigsForm($url, 'plugins_config', 'plugins_config_groups');
		}
		break;
	case 'plug_configsave':
		if(isset($_GET['group'])){
			System::admin()->SaveConfigs(SafeEnv($_GET['group'], 255, str), 'plugins_config', 'plugins_config_groups');
			GO(ADMIN_FILE.'?exe=extensions#tabs-3');
		}
		break;
	default:
		AdminExtensions();
}

function AdminExtensionsPluginType( $Type ){
	switch($Type){
		case PLUG_AUTORUN:
			return '';
			break;
		case PLUG_ADMIN_AUTORUN:
			return ' ()';
			break;
		case PLUG_MAIN_AUTORUN:
			return ' ()';
			break;
		case PLUG_CALLEE:
			return '';
			break;
		case PLUG_MANUAL:
			return '';
			break;
		case PLUG_MANUAL_ONE:
			return '';
			break;
		default:
			return '';
	}
}

/*
 *    .
 */
function AdminExtensions(){
	UseScript('jquery_ui');
	$mod_dir = System::config('mod_dir');
	$blocks_dir = System::config('blocks_dir');
	$plug_dir = System::config('plug_dir');
	$tpl_dir = System::config('tpl_dir');

	// 
	$style = '<style>
	.ex-mod{ border-bottom: 1px #ccf solid; background-color: #DDEAF7; cursor: pointer; }
	.ex-mod:hover{ background-color: #F5F5FF; }
	.ex-mod-info { padding-top: 4px; }
	.ex-mod-info-description { padding-top: 0; margin-bottom: 5px; }
	.mod_info { margin-bottom: 5px; }
	</style>';

	// JS
	System::site()->AddJS('
	window.last_mod_id = "";
	ShowModInfo = function(id){
	  $(".mod_info").slideUp().parents(".ex-mod").css("background-color", "#DDEAF7");
	  if(last_mod_id != id){
	  	$("#mod_info_"+id).slideDown().parents(".ex-mod").css("background-color", "#FFF");
	  	last_mod_id = id;
	  }else{
	    last_mod_id = "";
	  }
	};
	window.last_block_id = "";
	ShowBlockInfo = function(id){
	  $(".mod_info").slideUp().parents(".ex-mod").css("background-color", "#DDEAF7");
	  if(last_block_id != id){
	  	$("#mod_info_"+id).slideDown().parents(".ex-mod").css("background-color", "#FFF");
	  	last_block_id = id;
	  }else{
	    last_block_id = "";
	  }
	};
	');

	// 
	$modules_html = '<div style="border-top: 1px #ccf solid; ">';
	$mods = System::database()->Select('modules', "`system`='0'");
	SortArray($mods, 'name');
	foreach($mods as $mod){
		$info = ExtLoadInfo($mod_dir.$mod['folder']);
		if($info === false) continue;

		$mid = SafeEnv($mod['id'], 11, int);
		$func = '';
		$func .= System::admin()->SpeedStatus(
			'', '',
			ADMIN_FILE.'?exe=extensions&a=changestatus&type='.EXT_MODULE.'&id='.$mid,
			$mod['enabled'] == '1',
			'images/bullet_green.png',
			'images/bullet_red.png'
		);
		$func .= System::admin()->SpeedButton('', ADMIN_FILE.'?exe=extensions&a=mod_config&name='.SafeDB($mod['folder'], 255, str), 'images/admin/config.png');

		//   ,  ,    
		if(is_file($mod_dir.$mod['folder'].'/uninstall.php')){
			$func .= System::admin()->SpeedConfirm(
				'',
				ADMIN_FILE.'?exe=extensions&a=uninstall&type='.EXT_MODULE.'&name='.SafeDB($mod['folder'], 255, str),
				'images/admin/delete.png',
				'   '.$mod['name'].'?'
			);
		}
		if(is_file($mod_dir.$mod['folder'].'/icon.png')){
			$icon = $mod_dir.$mod['folder'].'/icon.png';
		}else{
			$icon = 'images/application.png';
		}
		if(isset($info['version'])){
			$version = SafeDB($info['version'], 255, str);
		}else{
			$version = CMS_VERSION;
		}
		if(isset($info['author'])){
			$author = SafeDB($info['author'], 255, str);
		}else{
			$author = '';
		}
		if(isset($info['site'])){
			$site = SafeDB($info['site'], 255, str);
		}else{
			$site = '';
		}
		if(isset($info['description'])){
			$description = SafeDB($info['description'], 0, str, false, false);
		}else{
			$description = ' .';
		}

		$modules_html .= '<table width="100%" class="ex-mod">
		<tr onmousedown="ShowModInfo(\'mod'.$mid.'\');">
			<td style="padding-left: 11px; vertical-align: top;">
				<div style="float: left;">
					<div style="float:left; padding-top: 6px;"><img src="'.$icon.'"></div>
					<div style="float:left; padding-top: 7px;">&nbsp;'.SafeDB($mod['name'], 255, str).' (v'.$version.')</div>
				</div>
			</td>
			<td width="90" align="center" style="padding: 3px; padding-bottom: 2px;">
				<div style="float: left">'.$func.'</div>
			</td>
		</tr>
		<tr>
			<td colspan="2">
				<div class="mod_info" id="mod_info_mod'.$mid.'" style="display: none; padding: 4px; padding-left: 11px;">
					<div class="ex-mod-info-description">'.$description.'</div>
		      '.($author != '' ? '<div class="ex-mod-info">: '.$author.'</div>' : '').'
		      '.($site != '' ? '<div class="ex-mod-info">: <a href="'.$site.'" target="_blank">'.$site.'</a></div>' : '').'
				</div>
			</td>
		</tr>
		</table>';
	}
	$modules_html .= '</div>';

	// 
	$blocks_html = '<div style="border-top: 1px #ccf solid; ">';
	$mods = System::database()->Select('block_types');
	SortArray($mods, 'name');
	foreach($mods as $mod){
		$info = ExtLoadInfo($blocks_dir.$mod['folder']);
		if($info === false) continue;

		$mid = SafeEnv($mod['id'], 11, int);
		$func = '';
		if(is_file($blocks_dir.$mod['folder'].'/uninstall.php')){ //   ,  ,    
			$func .= System::admin()->SpeedConfirm(
				'',
				ADMIN_FILE.'?exe=extensions&a=uninstall&type='.EXT_BLOCK.'&name='.SafeDB($mod['folder'], 255, str),
				'images/admin/delete.png',
				'   '.$mod['name'].'?'
			);
		}
		if(isset($info['icon']) && $info['icon'] != ''){
			$icon = SafeDB($info['icon'], 255, str);
		}else{
			$icon = 'images/application.png';
		}
		if(isset($info['version'])){
			$version = SafeDB($info['version'], 255, str);
		}else{
			$version = CMS_VERSION;
		}
		if(isset($info['author']) && $info['author'] != ''){
			$author = SafeDB($info['author'], 255, str);
		}else{
			$author = '';
		}
		if(isset($info['site']) && $info['site'] != ''){
			$site = SafeDB($info['site'], 255, str);
		}else{
			$site = '';
		}
		if(isset($info['description']) && $info['description'] != '' && $info['description'] != ' - '){
			$description = SafeDB($info['description'], 0, str, false, false);
		}else{
			$description = ' .';
		}

		$blocks_html .= '<table width="100%" class="ex-mod">
		<tr onmousedown="ShowBlockInfo(\'block'.$mid.'\');">
			<td style="padding-left: 11px; vertical-align: top;">
				<div style="float: left;">
					<div style="float:left; padding-top: 6px;"><img src="'.$icon.'"></div>
					<div style="float:left; padding-top: 7px;">&nbsp;'.SafeDB($mod['name'], 255, str).' (v'.$version.')</div>
				</div>
			</td>
			<td width="62" align="center" style="padding: 3px; padding-bottom: 2px;">
				<div style="float: left">'.$func.'</div>
			</td>
		</tr>
		<tr>
			<td colspan="2">
				<div class="mod_info" id="mod_info_block'.$mid.'" style="display: none; padding: 4px; padding-left: 11px;">
					<div class="ex-mod-info-description">'.$description.'</div>
		      '.($author != '' ? '<div class="ex-mod-info">: '.$author.'</div>' : '').'
		      '.($site != '' ? '<div class="ex-mod-info">: <a href="'.$site.'" target="_blank">'.$site.'</a></div>' : '').'
				</div>
			</td>
		</tr>
		</table>';
	}
	$blocks_html .= '</div>';

	// 
	$plugins_html = '<div style="border-top: 1px #ccf solid; ">';
	$mods = System::database()->Select('plugins', "`hidden`='0'");
	SortArray($mods, 'group');
	$configs_groups = PluginsConfigsGroups();
	foreach($mods as $mod){
		if($mod['group'] != ''){
			$path = $plug_dir.$mod['group'].'/'.$mod['name'];
		}else{
			$path = $plug_dir.$mod['name'];
		}
		$info = ExtLoadInfo($path);
		if($info === false) continue;

		$mid = SafeEnv($mod['id'], 11, int);
		$func = '';
		$group =SafeDB(($mod['group'] != '' ? $mod['group'].'.' : '').$mod['name'], 255, str);
		if(isset($configs_groups[$group])){
			$func .= System::admin()->SpeedButton('', ADMIN_FILE.'?exe=extensions&a=plug_config&group='.$group, 'images/admin/config.png');
		}
		$func .= System::admin()->SpeedStatus(
			'', '',
			ADMIN_FILE.'?exe=extensions&a=changestatus&type='.EXT_PLUGIN.'&id='.$mid,
			$mod['enabled'] == '1',
			'images/bullet_green.png',
			'images/bullet_red.png'
		);
		//   ,  ,    
		if(isset($info['1.3']) || is_file($path.'/uninstall.php')){
			$func .= System::admin()->SpeedConfirm(
				'',
				ADMIN_FILE.'?exe=extensions&a=uninstall&type='.EXT_PLUGIN.'&name='.SafeDB($mod['name'], 255, str).($mod['group']!=''?'&group='.SafeDB($mod['group'], 255, str) : ''),
				'images/admin/delete.png',
				'   '.$mod['name'].'?'
			);
		}
		$name = SafeDB($info['name'], 255, str);
		if(isset($info['icon']) && $info['icon'] != ''){
			$icon = SafeDB($info['icon'], 255, str);
		}else{
			$icon = 'images/application.png';
		}
		if(isset($info['version'])){
			$version = SafeDB($info['version'], 255, str);
		}else{
			$version = CMS_VERSION;
		}
		if(isset($info['author']) && $info['author'] != ''){
			$author = SafeDB($info['author'], 255, str);
		}else{
			$author = '';
		}
		if(isset($info['site']) && $info['site'] != ''){
			$site = SafeDB($info['site'], 255, str);
		}else{
			$site = '';
		}
		if(isset($info['description']) && $info['description'] != '' && $info['description'] != ' - '){
			$description = SafeDB($info['description'], 0, str, false, false);
		}else{
			$description = ' .';
		}

		$plugins_html .= '<table width="100%" class="ex-mod">
		<tr onmousedown="ShowBlockInfo(\'plug'.$mid.'\');">
			<td style="padding-left: 11px; vertical-align: top;">
				<div style="float: left;">
					<div style="float:left; padding-top: 6px;"><img src="'.$icon.'"></div>
					<div style="float:left; padding-top: 7px;">&nbsp;'.$name.' (v'.$version.')</div>
				</div>
			</td>
			<td width="62" align="center" style="padding: 3px; padding-bottom: 2px;">
				<div style="float: left">'.$func.'</div>
			</td>
		</tr>
		<tr>
			<td colspan="2">
				<div class="mod_info" id="mod_info_plug'.$mid.'" style="display: none; padding: 4px; padding-left: 11px;">
					<div class="ex-mod-info-description">'.$description.'</div>
		      '.($author != '' ? '<div class="ex-mod-info">: '.$author.'</div>' : '').'
		      '.($site != '' ? '<div class="ex-mod-info">: <a href="'.$site.'" target="_blank">'.$site.'</a></div>' : '').'
		      <div class="ex-mod-info">: '.AdminExtensionsPluginType($mod['type']).'</div>
				</div>
			</td>
		</tr>
		</table>';
	}
	$plugins_html .= '</div>';

	// 
	$templates_html = '<div style="border-top: 1px #ccf solid; ">';
	$mods = System::database()->Select('templates', "`default`='0'");
	SortArray($mods, 'name');
	foreach($mods as $mod){
		$info = ExtLoadInfo($tpl_dir.$mod['folder']);
		if($info === false){
			$info = array(
				'name' => $mod['folder'],
				'description' => '',
				'author' => '',
				'site' => '',
				'version' => '1.0',
				'admin' => false
			);
		}

		$mid = SafeEnv($mod['id'], 11, int);
		$name = SafeDB($info['name'], 255, str);
		$func = '';
		$func .= System::admin()->SpeedConfirm(
			' ',
			ADMIN_FILE.'?exe=extensions&a=uninstall&type='.EXT_TEMPLATE.'&name='.SafeDB($mod['folder'], 255, str),
			'images/admin/delete.png',
			'  '.$name.'?'
		);
		if(isset($info['icon']) && $info['icon'] != ''){
			$icon = $info['icon'];
		}else{
			$icon = 'images/application.png';
		}
		if(isset($info['version'])){
			$version = SafeDB($info['version'], 255, str);
		}else{
			$version = '';
		}
		if(isset($info['author']) && $info['author'] != ''){
			$author = SafeDB($info['author'], 255, str);
		}else{
			$author = '';
		}
		if(isset($info['site']) && $info['site'] != ''){
			$site = SafeDB($info['site'], 255, str);
		}else{
			$site = '';
		}
		if(isset($info['description']) && $info['description'] != '' && $info['description'] != ' - '){
			$description = SafeDB($info['description'], 0, str, false, false);
		}else{
			$description = ' .';
		}

		$templates_html .= '<table width="100%" class="ex-mod">
		<tr onmousedown="ShowBlockInfo(\'tpl'.$mid.'\');">
			<td style="padding-left: 11px; vertical-align: top;">
				<div style="float: left;">
					<div style="float:left; padding-top: 6px;"><img src="'.$icon.'"></div>
					<div style="float:left; padding-top: 7px;">&nbsp;'.$name.($version != '' ?  ' (v'.$version.')' : '').($mod['admin'] == '1' ? ' (-)' : '').'</div>
				</div>
			</td>
			<td width="62" align="center" style="padding: 3px; padding-bottom: 2px;">
				<div style="float: left">'.$func.'</div>
			</td>
		</tr>
		<tr>
			<td colspan="2">
				<div class="mod_info" id="mod_info_tpl'.$mid.'" style="display: none; padding: 4px; padding-left: 11px;">
					<div class="ex-mod-info-description">'.$description.'</div>
		      '.($author != '' ? '<div class="ex-mod-info">: '.$author.'</div>' : '').'
		      '.($site != '' ? '<div class="ex-mod-info">: <a href="'.$site.'" target="_blank">'.$site.'</a></div>' : '').'
				</div>
			</td>
		</tr>
		</table>';
	}
	$templates_html .= '</div>';

	//    
	System::admin()->AddOnLoadJS('
	$("#tabs").tabs({
		event: "mousedown",
		beforeLoad: function( event, ui ){ return false; }
	}).css("width", "700px");
	$(".ui-tabs .ui-tabs-panel")
		.css("padding", "0")
		.css("padding-top","3px")
		.css("height", "400px")
		.css("overflow-y", "auto");
');
	$html = '<div id="tabs">
	<ul>
		<li><a href="#tabs-1"><img src="'.MOD_ICON.'" style="vertical-align: bottom;">&nbsp;</a></li>
		<li><a href="#tabs-2"><img src="images/blocks.png" style="vertical-align: bottom;">&nbsp;</a></li>
		<li><a href="#tabs-3"><img src="images/plugins.png" style="vertical-align: bottom;">&nbsp;</a></li>
		<li><a href="#tabs-4"><img src="images/skins.png" style="vertical-align: bottom;">&nbsp;</a></li>
	</ul>
	<div id="tabs-1">'.$modules_html.'</div>
	<div id="tabs-2">'.$blocks_html.'</div>
	<div id="tabs-3">'.$plugins_html.'</div>
	<div id="tabs-4">'.$templates_html.'</div>
</div>';

	System::admin()->AddTextBox('', $style.$html);
}

/*
 *     .
 */
function AdminExtensionsInstallList(){
	global $config;

	$mod_dir = $config['mod_dir'];
	$plug_dir = $config['plug_dir'];
	$block_dir = $config['blocks_dir'];
	$temp_dir = $config['tpl_dir'];
	$list = array();

	$title = ' ';
	System::admin()->AddSubTitle($title);

	//     
	$installed_mods = array();
	$installed_plugins = array();
	$installed_blocks = array();
	$installed_templates = array();
	System::database()->Select('modules');
	while($mod = System::database()->FetchRow()){
		$installed_mods[] = $mod['folder'];
	}
	System::database()->Select('plugins');
	while($mod = System::database()->FetchRow()){
		$installed_plugins[] = ($mod['group'] != '' ? $mod['group'].'/' : '').$mod['name'];
	}
	System::database()->Select('block_types');
	while($mod = System::database()->FetchRow()){
		$installed_blocks[] = $mod['folder'];
	}
	System::database()->Select('templates');
	while($mod = System::database()->FetchRow()){
		$installed_templates[] = $mod['folder'];
	}

	//  
	$mod_folders = GetFolders($mod_dir);
	foreach($mod_folders as $folder){
		if(!in_array($folder, $installed_mods)){
			$info = ExtLoadInfo($mod_dir.$folder);
			if($info !== false){
				$info['type'] = EXT_MODULE;
				$info['path'] = $mod_dir.$folder.'/';
				$info['folder'] = $folder;
				if(is_file($info['path'].'install.php') && is_file($info['path'].'uninstall.php')){
					$list[] = $info;
				}
			}
		}
	}

	//  
	$plug_folders = GetFolders($plug_dir);
	foreach($plug_folders as $folder){
		$info = false;
		if(is_file($plug_dir.$folder.'/info.php')){ //  
			$info = ExtLoadInfo($plug_dir.$folder);
		}
		if(isset($info['1.3_old_plugins_group']) || $info === false){ // 
			$plug_folders2 = GetFolders($plug_dir.$folder.'/');
			foreach($plug_folders2 as $folder2){
				if(!in_array($folder.'/'.$folder2, $installed_plugins)){
					$info = ExtLoadInfo($plug_dir.$folder.'/'.$folder2);
					if($info !== false){
						$info['type'] = EXT_PLUGIN;
						$info['path'] = $plug_dir.$folder.'/'.$folder2.'/';
						$info['group'] = $folder;
						$info['folder'] = $folder2;
						if(isset($info['1.3']) || (is_file($info['path'].'install.php') && is_file($info['path'].'uninstall.php'))){
							$list[] = $info;
						}
					}
				}
			}
		}else{ //  
			if(!in_array($folder, $installed_plugins)){
				if($info !== false){
					$info['type'] = EXT_PLUGIN;
					$info['path'] = $plug_dir.$folder.'/';
					$info['folder'] = $folder;
					if(isset($info['1.3']) || (is_file($info['path'].'install.php') && is_file($info['path'].'uninstall.php'))){
						$list[] = $info;
					}
				}
			}
		}
	}

	//  
	$block_folders = GetFolders($block_dir);
	foreach($block_folders as $folder){
		if(!in_array($folder, $installed_blocks)){
			$info = ExtLoadInfo($block_dir.$folder);
			if($info !== false){
				$info['type'] = EXT_BLOCK;
				$info['path'] = $block_dir.$folder.'/';
				$info['folder'] = $folder;
				if(is_file($info['path'].'install.php') && is_file($info['path'].'uninstall.php')){
					$list[] = $info;
				}
			}
		}
	}

	//  
	$temp_folders = GetFolders($temp_dir);
	foreach($temp_folders as $folder){
		if(!in_array($folder, $installed_templates)){
			$info = ExtLoadInfo($temp_dir.$folder);
			if($info === false){
				$info = array(
					'name' => $folder,
					'description' => '',
					'author' => '',
					'site' => '',
					'version' => '1.0',
					'admin' => false
				);
			}
			$info['type'] = EXT_TEMPLATE;
			$info['path'] = $temp_dir.$folder.'/';
			$info['folder'] = $folder;
			$list[] = $info;
		}
	}

	$count = count($list);
	$text = '<form action="'.ADMIN_FILE.'?exe=extensions&a=install" method="post">';
	$text .= '<table cellspacing="0" cellpadding="0" class="cfgtable">';
	$text .= '<tr><th></th><th></th><th></th><th></th><th></th><th></th></tr>';

	if(count($list) > 0){
		foreach($list as $i=>$ext){
			switch($ext['type']){
				case 1:
					if(is_file($ext['path'].'icon.png')){
						$type = '<img src="'.$ext['path'].'icon.png" title="">';
					}else{
						$type = '<img src="'.MOD_DIR.'icon.png" title="">';
					}
				break;
				case 2: $type = '<img src="images/plugins.png" title="">';
				break;
				case 3: $type = '<img src="images/blocks.png" title="">';
				break;
				case 4: $type = '<img src="images/skins.png" title="">';
				break;
			}
			$text .= Indent('
				<tr>
					<td>'
					.System::site()->Check('install_'.$i, '1')
					.System::site()->Hidden('folder_'.$i, $ext['folder'])
					.System::site()->Hidden('type_'.$i, $ext['type'])
					.($ext['type'] == EXT_PLUGIN && isset($ext['group']) ? System::site()->Hidden('group_'.$i, $ext['group']) : '')
					.'</td>
					<td>'.$type.'</td>
					<td>'.SafeDB($ext['name'], 255, str).'</td>
					<td>'.(isset($ext['description']) && $ext['description'] != '' && $ext['description'] != ' - ' ? SafeDB($ext['description'], 255, str) : ' ').'</td>
					<td>'.(isset($ext['author']) && $ext['author'] != '' ? SafeDB($ext['author'], 255, str) : '&nbsp;').'</td>
					<td>'.(isset($ext['site']) && $ext['site'] != '' ? '<a href="'.HtmlChars($ext['site']).'" title="'.HtmlChars($ext['site']).'" target="_blank"></a>' : '').'</td>
				</tr>
			');
		}
		$text .= '</table>';
		$text .= '<div style="margin-bottom: 25px;">'.System::site()->Hidden('count', $count).System::site()->Submit(' ').'</div>';
		$text .= '</form>';
	}else{
		$text .= '<tr><td colspan="6" style="text-align: left;">   .</td></tr>';
		$text .= '</table>';
		$text .= '</form>';
	}

	System::admin()->AddCenterBox($title.' ('.$count.'   )');
	System::admin()->AddText($text);
}

/*
 *  .
 */
function AdminExtensionsInstall(){
	global $db, $config, $site; //   
	$count = SafeEnv($_POST['count'], 11, int);
	$new_installed = array();
	for($i = 0; $i < $count; $i++){
		if(isset($_POST['install_'.$i])){
			$type = $_POST['type_'.$i];
			$folder = RealPath2($_POST['folder_'.$i], 255, str);
			switch($type){
				case EXT_PLUGIN:
					$group = '';
					$group_info = null;
					if(isset($_POST['group_'.$i])){
						$group = $_POST['group_'.$i];
						$group_info = ExtLoadInfo(System::config('plug_dir').$group);
					}
					$path = RealPath2(System::config('plug_dir').$group.'/'.$folder);
					$info = ExtLoadInfo($path, $group_info);
					if($info === false) continue;
					if(isset($info['1.3'])){ //    
						$function = '';
						if(isset($info['function'])){
							$function = $info['function'];
						}
						$type = '';
						if(isset($info['function'])){
							$type = $info['function'];
						}
						ExtAddPlugin($group, $folder, $info['function'], $info['type']);
						if(is_file($path.'/install.php')){
							require $path.'/install.php';
						}
						$new_installed[] = $info;
					}else{
						if(is_file($path.'/install.php')){  //  install.php 
							require $path.'/install.php';
							$new_installed[] = $info;
						}
					}
					Audit(':  : '.$group.'/'.$folder);
				break;
				case EXT_BLOCK:
					$path = RealPath2(System::config('blocks_dir').$folder);
					$info = ExtLoadInfo($path);
					if($info === false) continue;
					require $path.'/install.php';
					$new_installed[] = $info;
					Audit(':  : '.$folder);
				break;
				case EXT_MODULE:
					$path = RealPath2(System::config('mod_dir').$folder);
					$info = ExtLoadInfo($path);
					if($info === false) continue;
					require $path.'/install.php';
					if(isset($info['1.3'])){
						//   
						$folder = SafeEnv($folder, 255, str);
						$mod_name = SafeEnv($info['name'], 255, str);
						AdminMenuAddModule($mod_name, $folder);
					}
					$new_installed[] = $info;
					Audit(':  : '.$folder);
				break;
				case EXT_TEMPLATE:
					//     
					$path = RealPath2(System::config('tpl_dir').$folder);
					$info = ExtLoadInfo($path);
					if($info === false){
						$info = array(
							'name' => $folder,
							'description' => '',
							'author' => '',
							'site' => '',
							'version' => '1.0',
							'admin' => false
						);
					}
					$admin = (isset($info['admin']) && $info['admin'] ? '1' : '0');
					ExtAddTemplate($info['name'], $folder, $admin);
					$new_installed[] = $info;
					Audit(':  : '.$folder);
				break;
			}
		}
	}

	$html = '';
	$html .= '<div style="border: 1px #cfcfcf solid; width: 50%; background-color: #fff; margin-bottom: 5px;">';
	if(count($new_installed) > 0){
		foreach($new_installed as $info){
			$html .= Indent('
				<table style="width: 100%;">
					<tr>
						<td style="padding: 5px;">'.SafeDB($info['name'], 255, str).'</td>
						<td style="width: 120px; padding: 5px;"><img src="images/admin/accept.png" style="vertical-align: middle;" /> </td>
					</tr>
				</table>
			');
		}
		$html .= '</div>'.System::admin()->Button('', 'onclick="history.go(-1);"')
		                 .System::admin()->Button('', "onclick=\"Admin.LoadPage('".ADMIN_FILE."?exe=extensions');\"");
		System::cache()->Clear('config');
	}else{
		$html .= '<div style="padding:  5px;">     .  ""       .</div>';
		$html .= '</div>'.System::admin()->Button('', 'onclick="history.go(-1);"');
	}
	System::admin()->AddTextBox(' ', $html);
}

/*
 *   .
 */
function AdminExtensionsUploadForm(){
	System::admin()->AddCenterBox(' ');
	System::admin()->FormRow(' ', System::admin()->FFile('extension'));
	System::admin()->AddForm(System::admin()->FormOpen(ADMIN_FILE.'?exe=extensions&a=upload', 'post', true), System::admin()->Submit(''));
}

/*
 *     .
 */
function AdminExtensionsUpload(){
	if(!isset($_FILES['extension'])){
			System::admin()->AddTextBox('', '  .');
			return;
	}

	$extension = $_FILES['extension'];
	if($extension['error'] != 0){
		System::admin()->AddTextBox('', '   .  : '.$extension['error'].'.');
		return;
	}

	$valid_ext = '.ext.zip';
	$path = './';
	$errors_log = '';
	$to_unpack = array();

	//  
	$archive_filename = $extension['name'];
	if(substr($archive_filename, -strlen($valid_ext)) != $valid_ext){
		$errors_log .= '     LinkorCMS.';
	}else{
		$archive = $extension['tmp_name'];
		$zip = new ZipArchive;
		if($zip->open($archive) === true){
			for($i = 0; $i < $zip->numFiles; $i++){
				$filename = $zip->getNameIndex($i);
				$fileinfo = pathinfo($filename);
				if(!is_writable($path.$fileinfo['dirname'])){
					$errors_log .= '      '.$path.$fileinfo['dirname']."\n";
					continue;
				}
				if(substr($path.$filename, -1) == '/'){
					if(!is_dir($path.$filename)){
						MkDirRecursive($path.$filename);
					}
				}else{
					$to_unpack[] = $filename;
				}
			}
		}else{
			$errors_log .= '   .  .';
		}
	}

	if($errors_log != ''){
		System::admin()->AddCenterBox(',   ');
		System::admin()->HighlightError(nl2br($errors_log));
		$zip->close();
	}else{ //  
		if(!$zip->extractTo($path, $to_unpack)){
			System::admin()->AddCenterBox('');
			System::admin()->HighlightError('  .');
			$zip->close();
			return;
		}
		Audit(':    "'.$archive_filename.'"');
		$zip->close();
		GO(ADMIN_FILE.'?exe=extensions&a=installlist');
	}
}

/*
 *  
 */
function AdminExtensionsUninstall(){
	global $db, $config, $user; //   
	$ext_type = $_GET['type'];
	$folder = $_GET['name'];
	if(isset($_GET['group'])) $group = $_GET['group'];
	switch($ext_type){
		case EXT_MODULE:
			$mod_path = RealPath2(System::config('mod_dir').$folder);
			$info = ExtLoadInfo($mod_path);
			if(isset($_POST['ok']) || isset($info['1.3'])){
				$uninstall = $mod_path.'/uninstall.php';
				if(file_exists($uninstall)){
					$delete_tables = isset($_POST['delete_tables']); //     uninstall.php
					$delete_files = isset($_POST['delete_files']);
					include $uninstall;
					System::cache()->Clear('config');
					if(isset($info['1.3'])){ //   
						$folder = SafeEnv($folder, 255, str);
						AdminMenuDeleteModule($folder);
					}
				}
				Audit(':   "'.$folder.'"');
				GO(ADMIN_FILE.'?exe=extensions#tabs-1');
			}else{
				$folder = SafeEnv($folder, 255, str);
				System::database()->Select('modules', "`folder`='$folder'");
				if(System::database()->NumRows() == 0){
					AddTextBox('', '  .');
					return;
				}
				$mod = System::database()->FetchRow();
				$name = SafeDB($mod['name'], 255, str);
				$text = '';
				$text .= '<form method="post">';
				$text .= '<div style="padding: 10px 0 10px 25px;">';
				$text .= '<div style="padding-bottom: 10px">';
				$text .= '<label><input type="checkbox" name="delete_tables">&nbsp;  </label><br>';
				$text .= '<label><input type="checkbox" name="delete_files">&nbsp;  </label>';
				$text .= '</div>';
				$text .= System::admin()->Hidden('ok', '1');
				$text .= '<div>'.System::admin()->Button('', 'onclick="history.go(-1)"').System::admin()->Submit('').'</div>';
				$text .= '</div></form>';
				AddTextBox('  "'.$name.'"', $text);
			}
			break;
		case EXT_BLOCK:
			$mod_path = RealPath2(System::config('blocks_dir').$folder);
			if(isset($_POST['ok'])){
				$uninstall = $mod_path.'/uninstall.php';
				if(file_exists($uninstall)){
					$delete_tables = isset($_POST['delete_tables']);
					$delete_files = isset($_POST['delete_files']);
					include $uninstall;
					System::cache()->Clear('config');
				}
				Audit('  "'.$folder.'"');
				GO(ADMIN_FILE.'?exe=extensions#tabs-2');
			}else{
				$folder = SafeEnv($folder, 255, str);
				System::database()->Select('block_types', "`folder`='$folder'");
				if(System::database()->NumRows() == 0){
					AddTextBox('', '  .');
					return;
				}
				$mod = System::database()->FetchRow();
				$name = SafeDB($mod['name'], 255, str);
				$text = '';
				$text .= '<form method="post">';
				$text .= '<div style="padding: 10px 0 10px 25px;">';
				$text .= '<div style="padding-bottom: 10px">';
				$text .= '<label><input type="checkbox" name="delete_tables">&nbsp;  </label><br>';
				$text .= '<label><input type="checkbox" name="delete_files">&nbsp; </label>';
				$text .= '</div>';
				$text .= System::admin()->Hidden('ok', '1');
				$text .= '<div>'.System::admin()->Button('', 'onclick="history.go(-1)"').System::admin()->Submit('').'</div>';
				$text .= '</div></form>';
				AddTextBox('  "'.$name.'"', $text);
			}
			break;
		case EXT_PLUGIN:
			if(isset($_GET['group'])){
				$group = $_GET['group'].'/';
				$groupenv = SafeEnv($_GET['group'], 255, str);
			}else{
				$group = '';
				$groupenv = '';
			}
			$mod_path = RealPath2(System::config('plug_dir').$group.$folder);
			$info = ExtLoadInfo($mod_path);
			if(isset($_POST['ok']) || isset($info['1.3'])){
				$uninstall = $mod_path.'/uninstall.php';
				if(file_exists($uninstall)){
					$delete_tables = isset($_POST['delete_tables']);
					$delete_files = isset($_POST['delete_files']);
					include $uninstall;
					System::cache()->Clear('config'); // FIXME: plugin config
				}
				if(isset($info['1.3'])){
					$folder = SafeEnv($folder, 255, str);
					System::database()->Delete('plugins', "`name`='$folder' and `group`='$groupenv'");
				}
				PluginsClearCache();
				Audit(':   "'.$folder.'"');
				GO(ADMIN_FILE.'?exe=extensions#tabs-3');
			}else{
				$folder = SafeEnv($folder, 255, str);
				System::database()->Select('plugins', "`name`='$folder' and `group`='$groupenv'");
				if(System::database()->NumRows() == 0){
					AddTextBox('', '  .');
					return;
				}
				$mod = System::database()->FetchRow();
				$name = SafeDB($info['name'], 255, str);
				$text = '';
				$text .= '<form method="post">';
				$text .= '<div style="padding: 10px 0 10px 25px;">';
				$text .= '<div style="padding-bottom: 10px">';
				$text .= '<label><input type="checkbox" name="delete_tables">&nbsp;  </label><br>';
				$text .= '<label><input type="checkbox" name="delete_files">&nbsp; </label>';
				$text .= '</div>';
				$text .= System::admin()->Hidden('ok', '1');
				$text .= '<div>'.System::admin()->Button('', 'onclick="history.go(-1)"').System::admin()->Submit('').'</div>';
				$text .= '</div></form>';
				AddTextBox('  "'.$name.'"', $text);
			}
			break;
		case EXT_TEMPLATE:
			$mod_path = RealPath2(System::config('tpl_dir').$folder);
			if(isset($_POST['ok'])){
				ExtRemoveTemplate($folder, isset($_POST['delete_files']));
				Audit(':   "'.$folder.'"');
				GO(ADMIN_FILE.'?exe=extensions#tabs-4');
			}else{
				$info = ExtLoadInfo($mod_path);
				if($info === false){
					$info = array(
						'name' => $folder,
						'description' => '',
						'author' => '',
						'site' => '',
						'version' => '1.0',
						'admin' => false
					);
				}
				$name = SafeDB($info['name'], 255, str);
				$text = '';
				$text .= '<form method="post">';
				$text .= '<div style="padding: 10px 0 10px 25px;">';
				$text .= '<div style="padding-bottom: 10px">';
				$text .= '<label><input type="checkbox" name="delete_files">&nbsp; </label>';
				$text .= '</div>';
				$text .= System::admin()->Hidden('ok', '1');
				$text .= '<div>'.System::admin()->Button('', 'onclick="history.go(-1)"').System::admin()->Submit('').'</div>';
				$text .= '</div></form>';
				AddTextBox('  "'.$name.'"', $text);
			}
			break;
	}
}

/*
 *  Ajax   
 */
function AdminExtensionsChangeStatus(){
	if($_GET['type'] == EXT_MODULE){
		$id = SafeEnv($_GET['id'], 11, int);
		System::database()->Select('modules', "`id`='$id'");
		$mod = System::database()->FetchRow();
		if($mod['enabled'] == '1'){
			$en = '0';
		}else{
			$en = '1';
		}
		System::database()->Update('modules', "enabled='$en'", "`id`='$id'");
		Audit(':    "'.$mod['folder'].'"');
	}elseif($_GET['type'] == EXT_PLUGIN){
		$id = SafeEnv($_GET['id'], 11, int);
		System::database()->Select('plugins', "`id`='$id'");
		$mod = System::database()->FetchRow();
		if($mod['enabled'] == '1'){
			$en = '0';
		}else{
			$en = '1';
		}
		if($en == '1' && $mod['type'] == PLUG_MANUAL_ONE){ //        
			$mod_group = SafeEnv($mod['group'], 255, str);
			System::database()->Update('plugins', "`enabled`='0'", "`group`='$mod_group'");
		}
		System::database()->Update('plugins', "`enabled`='$en'", "`id`='$id'");
		PluginsClearCache();
		Audit(':    "'.$mod['name'].'"');
	}

	echo 'OK';
	exit();
}

/*
 *    
 */
function AdminExtensionsConfig(){
	System::admin()->AddSubTitle(' ');
	$name = SafeEnv($_GET['name'], 255, str);
	System::database()->Select('modules', "`folder`='".$name."'");
	$mod = System::database()->FetchRow();

	System::admin()->FormRow('', System::admin()->Edit('name', $mod['name'], false, 'style="width:200px;" class="autofocus"'));
	$dir = System::config('tpl_dir').System::config('general/site_template').'/themes/';
	if(is_dir($dir)){
		$templates = GetFiles($dir, false, true, ".html");
	}else{
		$templates = array();
	}
	System::admin()->DataAdd($templates_data, '', ' "theme.html"', $mod['theme'] == '');
	foreach($templates as $template){
		System::admin()->DataAdd($templates_data, $template, $template, $mod['theme'] == $template);
	}
	System::admin()->FormRow(' ', System::admin()->Select('theme', $templates_data));

	System::admin()->FormRow(' ', System::admin()->Select('view', GetUserTypesFormData(SafeDB($mod['view'], 1, int))));
	System::admin()->FormRow('', System::admin()->Select('enabled', GetEnData((bool)$mod['enabled'], '', '')));

	System::admin()->AddCenterBox('  "'.SafeDB($mod['name'], 255, str).'"');
	System::admin()->AddForm(
		System::admin()->FormOpen(ADMIN_FILE.'?exe=extensions&a=mod_configsave&name='.SafeDB($mod['folder'], 255, str)),
		System::admin()->Button('', 'onclick="history.go(-1)"')
		.System::admin()->Submit('')
	);
}

/*
 *   
 */
function AdminExtensionsConfigSave(){
	$post = SafeR('view', 255, str)
	        +SafeR('name, theme', 255, str)
	        +SafeR('enabled', 3, onoff);
	$post['view'] = ViewLevelToInt($post['view']);
	System::database()->Update('modules', MakeSet($post), "`folder`='".SafeEnv($_GET['name'], 255, str)."'");
	Audit(':    "'.$_GET['name'].'"');
	GO(ADMIN_FILE.'?exe=extensions');
}
