<?php

/*
 * LinkorCMS 1.4
 *  2012 LinkorCMS Development Group
 */

//  ,  

function IndexForumUserTopics(){
	global $forum_lang;

	$forums_tree = ForumTree::Instance();

	//  
	if(isset($_GET['user'])){
		$user_id = SafeEnv($_GET['user'], 11, int);
		$user = GetUserInfo($user_id);
		if($user === false){ //   
			System::site()->AddTextBox($forum_lang['error'], $forum_lang['error_no_user']);
			return;
		}
	}else{
		System::site()->AddTextBox($forum_lang['error'], $forum_lang['error_no_data']); //  
		return;
	}

	//   
	if(isset($_GET['page'])){
		$page = SafeEnv($_GET['page'], 11, int);
	}else{
		$page = 1;
	}
	$topics_on_page = System::config('forum/topics_on_page');

	//   
	$function_title = $forum_lang['allusertopics'].' "'.$user['name'].'"';
	System::site()->SetTitle(SafeDB($function_title, 255, str).' - '.($page > 1 ? $forum_lang['page'].$page.' - ' : '').$forum_lang['forum']);

	$forum_nav_url = Ufu('index.php?name=forum&op=usertopics&user='.$user_id, 'forum/usertopics/{user}-{page}/', true);
	//$forum_url = Ufu('index.php?name=forum&op=usertopics&user='.$user_id, 'forum/usertopics/{user}/');

	//    
	$statistics = ForumStatistics::Instance();
	$online = ForumOnline::Instance('0', '0', true); //   

	//  
	$statistics->Initialize($forum_lang['statistics_cat']);

	//  
	System::site()->BreadCrumbAdd($function_title);

	$auth = System::user()->Auth;
	$is_admin = System::user()->isAdmin();
	$current_user_id = System::user()->Get('u_id');

	//      
	$basket = ForumBasketGetData('forum_basket_topics');

	//      $topics_data    ( )
	$topics_data = ForumCacheGetTopics(); //    (  )
	$topics = array(); //      
	$resolve_cats = $forums_tree->GetAllAccessForumId(0); //       
	foreach($resolve_cats as $resolve_cat){
		if(!isset($topics_data[$resolve_cat])) continue;
		foreach($topics_data[$resolve_cat] as $topic){
			// 
			if($topic['starter_id'] == $user_id){
				//    ,     
				$topic['status'] = '';
				$topic['show_delete'] = $is_admin;
				if($topic['delete'] && isset($basket[$topic['id']]) && $auth && ($is_admin || $topic['starter_id'] == $current_user_id)){
					//   - "  "
					$topic['status'] = ForumBasketRender($topic['id'], $topic['title'], $basket, false);
					$topic['show_delete'] = false;
				}elseif($topic['delete']){
					continue; //         
				}
				$statistics->hits += $topic['hits'];
				$statistics->AddTopicAuthor($topic['starter_id'], $topic['starter_name']);
				$statistics->topics_count += 1;
				$statistics->reply_count += $topic['posts'];
				$topics[] = $topic;
			}
		}
	}
	unset($topics_data);

	//  (, , )
	System::site()->AddBlock('statistik', true, false, 'stat');
	System::site()->SetVars('statistik', array('count_read' => ''));

	//   
	System::site()->AddBlock('topic_form', false, false, 'form');
	System::site()->AddBlock('topic_right', false, false, 'topic');
	System::site()->AddBlock('forum', false);
	System::site()->AddBlock('forum_guest_message', false);

	//  
	// ,          .
	$vars_is_forum_member = array();
	$vars_is_forum_member['url'] = '<a href="'.Ufu('index.php?name=forum&op=markread', 'forum/markread/').'">'.$forum_lang['mark_all_read'].'</a>';
	$vars_is_forum_member['viewnoreadurl'] = '<a href="'.Ufu('index.php?name=forum&op=viewnoread', 'forum/viewnoread/').'">'.$forum_lang['viewnoread'].'</a>';
	$vars_is_forum_member['forum_id'] = '0';
	if(!System::site()->HasBlock('is_forum_member')){
		System::site()->AddBlock('is_forum_member', AccessIsResolved(2), false, 'mark');
	}
	System::site()->SetVars('is_forum_member', $vars_is_forum_member);

	//   
	System::site()->AddBlock('old', true, false, 'mark');
	$vars_old = array();
	$vars_old['lasttopics'] = '<a href="'.Ufu('index.php?name=forum&op=lasttopics', 'forum/lasttopics/').'">'.$forum_lang['lasttopics'].'</a>';
	System::site()->SetVars('old', $vars_old);

	//   
	System::site()->AddBlock('topics', true, true, 'topic');

	//   
	$navigation = new Navigation($page);
	$navigation->FrendlyUrl = System::config('general/ufu');

	//    
	if(count($topics) == 0){ //        
		System::site()->AddBlock('no_topics', true);
		$navigation->DisableNavigation();
	}else{
		//   
		$navigation->GenNavigationMenu($topics, $topics_on_page, $forum_nav_url);

		//     
		$read_data = Forum_Marker_GetReadData();

		$visable_topics = false;

		//        
		foreach($topics as $topic){

			$forum_config = $forums_tree->GetForumConfigRecursive($topic['forum_id']); //   

			//  
			$read = true; // 
			if($auth && (!isset($read_data[$topic['id']]) || $topic['last_post'] > $read_data[$topic['id']]['date'])){
				$read = false;
			}

			$topic = ForumTopicFilterData($topic); //   

			$topic['on'] = !$read;
			$topic['off'] = $read;

			if(!$topic['close']){
				$topic['close'] = $forum_config['close'];
				$topic['begin'] = !$forum_config['close'];
			}

			$topic['page'] = $page;

			$visable_topics = true;
			System::site()->AddSubBlock('topics', true, $topic);
		}
		System::site()->AddBlock('no_topics', !$visable_topics);
	}

	//  
	ModerationForumTopicsBlocks();

	//  
	System::site()->AddTemplatedBox('', 'module/forum_topics.html');

	//   
	$online->Render('0', '0', $forum_lang['all_online'], 'forum_topics_online');

	//  
	$statistics->Render('forum_topics_statistics');

	//     
	ForumQuickTransitionBox(0, $forum_lang['quick_transition']);

}
