<?php

/*
 * LinkorCMS 1.4
 *  2012 LinkorCMS Development Group
 */

//        .
//    ,        .

class ForumOnline{

	static protected $_instance;

	public $MainPage = false;
	public $AllOnline = null; //    (  )
	public $AllOnlineCount = 0; //     (  )

	private $online_process = false; //      
	private $online_load = false; //      

	private $online_cat = null; //      (array(users, count))
	private $online_topic = null; //     
	private $cat_topics_id = null; // id        .

	/**
	 *     .
	 * @var type
	 */
	public $AliveStatusTime = 300;

	/**
	 *       .
	 *     ,   Process .
	 * @param type $cat
	 * @param type $topic
	 * @return type
	 */
	public function Process( $cat = '0', $topic = '0' ){
		if(!$this->online_process){
			$time = time();
			$time2 = $time - $this->AliveStatusTime;
			System::database()->Delete('forum_online', "`time` < $time2");
			$user_ip = getip();
			if(System::user()->Auth === true){
				$user_id = System::user()->Get('u_id');
			}else{
				$user_id = 0;
			}
			$user_name = System::user()->Get('u_name');
			if(!$user_name){
				$user_name = '';
			}
			$user_level = System::user()->Get('u_level');
			$where = "`user_ip`='$user_ip'";
			System::database()->Select('forum_online', $where);
			if(System::database()->NumRows() > 0){
				System::database()->Update('forum_online', "`time`='$time',`user_id`='$user_id',`user_name`='$user_name',`user_level`='$user_level',`user_ip`='$user_ip',`forum_cat`='$cat',`forum_topic`='$topic'", $where);
			}else{
				System::database()->Insert('forum_online', "'$time','$user_id','$user_name','$user_level','$user_ip','$cat','$topic'");
			}
			$this->online_process = true;
		}
	}

	//        .
	public function LoadOnline( $MainPage = false ){
		if(!$this->online_load){
			$onlinerows = System::database()->Select('forum_online');
			$this->OnlineCount = count($onlinerows);
			$this->MainPage = $MainPage;
			if($MainPage){
				$levels = array(1 => 'admins', 2 => 'members', 3 => 'guests');
				$this->AllOnline = array('admins'=>array(), 'members'=>array(), 'guests'=>array(), 'count'=>$this->OnlineCount);
			}
			$online_cat = array(); //     
			$online_topic = array(); //     
			$cat_topics_id = array();
			foreach($onlinerows as $row){
				if($MainPage){
					$this->AllOnline[$levels[$row['user_level']]][] = $row;
				}
				if($row['forum_topic'] != '0'){ //   
					$online_topic[$row['forum_topic']]['u'][] = $row;
					if(!isset($online_topic[$row['forum_topic']]['c'])){
						$online_topic[$row['forum_topic']]['c'] = 0;
					}
					$online_topic[$row['forum_topic']]['c']++;
					if(!in_array($row['forum_topic'], $cat_topics_id)){
						$cat_topics_id[$row['forum_cat']][] = $row['forum_topic'];
					}
				}else{
					$online_cat[$row['forum_cat']]['u'][] = $row;
					if(!isset($online_cat[$row['forum_cat']]['c'])){
						$online_cat[$row['forum_cat']]['c'] = 0;
					}
					$online_cat[$row['forum_cat']]['c']++;
				}
			}
			$this->online_cat = $online_cat;
			$this->online_topic = $online_topic;
			$this->cat_topics_id = $cat_topics_id;
			$this->online_load = true;
		}
	}

	//           .
	public function GetCatOnline( $cat ){
		static $levels = array(1 => 'admins', 2 => 'members', 3 => 'guests');
		$forum_tree = ForumTree::Instance();
		$online = array('admins'=>array(), 'members'=>array(), 'guests'=>array(), 'count'=>0);

		//         
		$all_cats = $forum_tree->GetAllChildId($cat);
		foreach($all_cats as $cat_id){
			//  
			if(isset($this->online_cat[$cat_id])){
				foreach($this->online_cat[$cat_id]['u'] as $memb){
					$online[$levels[$memb['user_level']]][] = $memb;
					$online['count']++;
				}
			}
			//  
			if(isset($this->cat_topics_id[$cat_id])){
				foreach($this->cat_topics_id[$cat_id] as $topic_id){
					foreach($this->online_topic[$topic_id]['u'] as $memb){
						$online[$levels[$memb['user_level']]][] = $memb;
						$online['count']++;
					}
				}
			}
		}
		return $online;
	}

	//       .
	public function GetCatOnlineCount( $cat ){
		$count = 0;
		$forum_tree = ForumTree::Instance();

		//         
		$all_cats = $forum_tree->GetAllChildId($cat);
		foreach($all_cats as $cat_id){
			//  
			if(isset($this->online_cat[$cat_id])){
				$count += $this->online_cat[$cat_id]['c'];
			}
			//  
			if(isset($this->cat_topics_id[$cat_id])){
				foreach($this->cat_topics_id[$cat_id] as $topic_id){
					$count += $this->online_topic[$topic_id]['c'];
				}
			}
		}
		return $count;
	}

	//       .
	public function GetTopicOnline( $topic ){
		$levels = array(1 => 'admins', 2 => 'members', 3 => 'guests');
		$online = array('admins'=>array(), 'members'=>array(), 'guests'=>array(), 'count'=>0);
		if(isset($this->online_topic[$topic])){
			foreach($this->online_topic[$topic]['u'] as $memb){
				$online[$levels[$memb['user_level']]][] = $memb;
				$online['count']++;
			}
		}
		return $online;
	}

	//     .
	public function GetTopicOnlineCount( $topic ){
		if(isset($this->online_topic[$topic])){
			return $this->online_topic[$topic]['c'];
		}
		return 0;
	}

	//     
	public function Render( $cat, $topic = '0', $title = '', $block = 'forum_online' ){
		if($this->MainPage){ //    
			$online = $this->AllOnline;
		}elseif($topic != '0'){ //   
			$online = $this->GetTopicOnline($topic);
		}else{ //   
			$online = $this->GetCatOnline($cat);
		}
		$reg_count = count($online['admins'])+count($online['members']); // -  

		// 
		System::site()->AddBlock($block, true, false, $block, 'module/forum_online.html');

		//  
		System::site()->AddBlock('gen_online', true, false, 'users');
		$vars = array();
		$vars['count'] = $online['count'];
		$vars['online_img'] = true;
		$vars['title'] = $title;
		$vars['reg'] = $reg_count;
		$vars['guest'] = $online['count'] - $reg_count;
		System::site()->Blocks['gen_online']['vars'] = $vars;

		//  
		System::site()->AddBlock('onlines', true, true, 'user');
		$i = 0;
		//  
		$vars = array();
		foreach($online['admins'] as $row){
			$i++;
			$vars['url'] = '<a href="'.Ufu('index.php?name=user&op=userinfo&user='.SafeDB($row['user_id'], 11, int), 'user/{user}/info/').'">'.SafeDB($row['user_name'], 255, str).'</a>';
			System::site()->AddSubBlock('onlines', true, $vars);
			if($i>250) break;
		}
		//  
		$vars = array();
		foreach($online['members'] as $row){
			$i++;
			$vars['url'] = '<a href="'.Ufu('index.php?name=user&op=userinfo&user='.SafeDB($row['user_id'], 11, int), 'user/{user}/info/').'">'.SafeDB($row['user_name'], 255, str).'</a>';
			System::site()->AddSubBlock('onlines', true, $vars);
			if($i>250) break;
		}

		if($this->MainPage){
			$vars['url'] = ($reg_count > 0 ? '<br>' : '').'  : '.$online['count'];
			System::site()->AddSubBlock('onlines', true, $vars);
		}
	}

	/**
	 *  
	 * @return ForumOnline
	 */
	static public function Instance( $Cat = '0', $Topic = '0', $MainPage = false ){
		if(!(self::$_instance instanceof ForumOnline)){
			self::$_instance = new ForumOnline();
			self::$_instance->Process($Cat, $Topic);
			self::$_instance->LoadOnline($MainPage);
		}
		return self::$_instance;
	}

}
