<?php

/*
 * LinkorCMS 1.4
 *  2012 LinkorCMS Development Group
 */


/**
 *   .
 * @todo ()  .
 */

// 
define("FORUM_CACHE_DIR", 'cache/forum/');
define("FORUM_CACHE_ALL_DATA_FORUMS", 'Forum_Cache_AllDataTableForum');
define("FORUM_CACHE_ALL_DATA_FORUM_TOPICS", 'Forum_Cache_AllDataTableForumTopics');

$forum_functions_dir = MOD_DIR.'functions/';
$forum_navigation = '';

if(!defined('ADMIN_SCRIPT')){
	System::site()->AddCSSFile('forum.css');
	UseScript('forum_scripts');
}

System::user()->Def('u_add_rating', true);
System::user()->Def('u_add_comment', true);
System::user()->Def('u_read_comment', true);
System::user()->Def('u_add_forum', true);
System::user()->Def('u_read_forum', true);

ForumBasketAutoclear();

RegisterClass('ForumStatistics', MOD_DIR.'lib/forum_statistics.class.php');
RegisterClass('ForumTree', MOD_DIR.'lib/forum_tree.class.php');
RegisterClass('ForumOnline', MOD_DIR.'lib/forum_online.class.php');
//   //

/**
 *     .       ,
 *            .
 * @global type $forum_lang
 * @global type $config
 * @param type  $forum
 * @param type  $root
 * @param type  $get_online
 * @return type
 */
function IndexForumDataFilter(&$forum, $forum_config = null){
	global $forum_lang, $config;
	$forum2 = array();
	$forum2['id'] = SafeDB($forum['id'], 11, int);
	$forum2['parent_id'] = SafeDB($forum['parent_id'], 11, int);
	$forum2['title'] = SafeDB($forum['title'], 255, str);
	$forum2['description'] = SafeDB($forum['description'], 0, str, false, false);
	if(isset($forum_config)){
		$forum['topics'] = $forum_config['topics'];
		$forum['posts'] = $forum_config['posts'];
		$forum['last_post'] = $forum_config['last_post'];
		$forum['last_poster_id'] = $forum_config['last_poster_id'];
		$forum['last_poster_name'] = $forum_config['last_poster_name'];
		$forum['last_title'] = $forum_config['last_title'];
		$forum['last_id'] = $forum_config['last_id'];
	}
	$forum2['topics'] = SafeDB($forum['topics'], 11, int);
	$forum2['posts'] = SafeDB($forum['posts'], 11, int);
	$forum2['last_post_date'] = SafeDB($forum['last_post'], 11, int);
	$forum2['last_post'] = TimeRender(SafeDB($forum['last_post'], 11, int), true, true);
	if($forum2['last_post_date'] > (time() - 86400)){ //   24 
		$forum2['last_post'] = '<span style="color: #F00">'.$forum2['last_post'].'</span>';
	}
	$forum2['last_poster_id'] = SafeDB($forum['last_poster_id'], 11, int);
	$forum2['last_poster_url'] = Ufu('index.php?name=user&op=userinfo&user='.$forum2['last_poster_id'], 'user/{user}/info/');
	$forum2['last_poster_name'] = SafeDB($forum['last_poster_name'], 255, str);
	$forum2['last_title'] = DivideWord(SafeDB($forum['last_title'], 255, str));
	$forum2['last_id'] = SafeDB($forum['last_id'], 11, int);
	$forum2['order'] = SafeDB($forum['order'], 11, int);
	$forum2['status'] = SafeDB($forum['status'], 1, int);
	$forum2['view'] = SafeDB($forum['view'], 1, int);
	$online_count = ForumOnline::Instance()->GetCatOnlineCount($forum2['id']);
	$forum2['count_read'] = ($online_count > 0 ? '<small> ('.$forum_lang['online'].': '.$online_count.')</small>' : '');
	if(isset($forum_config)){
		$forum2['new_message_email'] = $forum_config['new_message_email'];
		$forum2['no_link_guest'] = $forum_config['no_link_guest'];
		$forum2['rank_access'] = $forum_config['access'];
		$forum2['rank_message'] = $forum_config['add_post'];
		$forum2['rank_add_theme'] = $forum_config['add_topic'];
		$forum2['close_topic'] = $forum_config['close'];
		//		if($forum2['close_topic'] == 1){
		//			$forum2['description'] .= ' '.$forum_lang['close_for_discussion'];
		//		}
	}
	$forum2['pages'] = false;
	//    
	if($forum2['parent_id'] != 0 && $forum['topics'] > $config['forum']['topics_on_page']){
		$forum2['pages'] = $forum_lang['pages'];
		$count_pages = ceil($forum['topics'] / $config['forum']['topics_on_page']);
		$str = '';
		for($i = 1; $i <= $count_pages; $i++){
			$str .= '<a href="'.Ufu('index.php?name=forum&op=showforum&forum='.$forum2['id'].'&page='.$i, 'forum/{forum}-{page}/').'">'.$i.'</a> ';
			if($i > 5 && $count_pages > 14){
				$str .= '<a href="'.Ufu('index.php?name=forum&op=showforum&forum='.$forum2['id'].'&page='.($count_pages - 1), 'forum/{forum}-{page}/').'">'.($count_pages - 1).' </a>';
				$str .= '......<a href="'.Ufu('index.php?name=forum&op=showforum&forum='.$forum2['id'].'&page='.$count_pages, 'forum/{forum}-{page}/').'">'.$count_pages.' </a>';
				break;
			}
		}
		$forum2['pages'] .= $str;
	}
	$forum2['url'] = Ufu('index.php?name=forum&op=showforum&forum='.$forum2['id'], 'forum/{forum}/');
	$forum2['last_url_topic'] = Ufu('index.php?name=forum&op=showtopic&topic='.$forum2['last_id'].'&view=lastpost', 'forum/topic{topic}-new.html');
	return $forum2;
}

/**
 *    .
 * @global type $site
 * @global type $forum_lang
 * @param type  $category
 */
function IndexForumCatOpen(&$category){
	$category['is_cat_open'] = true;
	$category['is_cat'] = false;
	$category['is_forum'] = false;
	$category['is_cat_close'] = false;
	//	if($category['close_topic']==1){
	//		$category['title'] .= '&nbsp;'.$forum_lang['close_for_discussion'];
	//	}
	System::site()->AddSubBlock('forums', true, $category);
}

/**
 *    .
 * @global type $forum_lang
 * @param type  $category
 */
function IndexForumCatClose(&$category){
	$category['is_cat_close'] = true;
	$category['is_cat'] = false;
	$category['is_forum'] = false;
	$category['is_cat_open'] = false;
	$category['close'] = $category['close_topic'] == 0;
	$category['begin'] = !$category['close'];
	$category['status'] = ''; //(!$category['close'] ? $forum_lang['category_locked'] : '');
	if(!isset($category['count_read'])){
		$category['count_read'] = ' ';
	}
	if(!isset($category['users'])){
		$category['users'] = ' ';
	}
	System::site()->AddSubBlock('forums', true, $category);
}

/**
 *  .
 * @global type $site
 * @global type $forum_lang
 * @param type  $forum
 * @param type  $read
 * @param type  $pod_forums
 */
function IndexForumRender(&$forum, $cat = true, $read = false, $pod_forums = array()){
	if($cat){
		$forum['is_cat'] = true;
		$forum['is_forum'] = false;
	} else{
		$forum['is_cat'] = false;
		$forum['is_forum'] = true;
	}
	$forum['is_cat_open'] = false;
	$forum['is_cat_close'] = false;
	$forum['on'] = !$read;
	$forum['off'] = $read;
	$forum['close'] = $forum['close_topic'];
	$forum['begin'] = !$forum['close'];
	$forum['status'] = ''; //(!$forum['close'] ? $forum_lang['category_locked'] : '');
	if(!isset($forum['count_read'])){
		$forum['count_read'] = ' ';
	}
	if(!isset($forum['users'])){
		$forum['users'] = ' ';
	}
	$forum['subforums'] = false;
	//   ( subforums)
	if(count($pod_forums) > 0){
		$forum['subforums'] = true;
		$forum['subforums'] = '<table border="0" cellpadding="0" cellspacing="0" width="100%" align="left" class="forum_subforums"><tr>';
		$i = 0;
		foreach($pod_forums as $pod_forum){
			$i++;
			$forum_link = Ufu('index.php?name=forum&op=showforum&forum='.SafeDB($pod_forum['id'], 11, int), 'forum/{forum}/');
			$img = ($pod_forum['read'] ? 'subforum_old.gif' : 'subforum.gif');
			$alt = ($pod_forum['read'] ? ' ' : '  ');
			$topics = SafeDB($pod_forum['topics'], 11, int);
			$forum['subforums'] .= '
			<td><img src="images/'.$img.'" title="'.$alt.'" alt="'.$alt.'" border="0">&nbsp;<a href="'.$forum_link.'" title="'.substr(strip_tags($pod_forum['description']), 0, 250).'...  '.$topics.'">'.SafeDB($pod_forum['title'], 255, str).' ('.$topics.')</a></td>'.($i == 3 ? '</tr><tr>' : ''); //     
			if($i == 3){
				$i = 0;
			}
		}
		$forum['subforums'] .= ($i < 2 ? '<td></td>' : '').'</tr></table>';
	}
	System::site()->AddSubBlock('forums', true, $forum);
}

/**
 *      functions
 *
 * @global type $forum_functions_dir
 * @param type  $function
 */
function ForumLoadFunction($function){
	global $forum_functions_dir;
	include_once $forum_functions_dir.$function.'.php';
}

/**
 *    .
 * @global type $forum_lang
 * @param type  $errors
 * @return string
 */
function IndexForumPrintErrors($errors){
	global $forum_lang;
	$text = $forum_lang['error_comment_add'].'.<br /><ul>';
	foreach($errors as $error){
		$text .= '<li>'.$error;
	}
	$text .= '</ul><p align="center"><a href="javascript:history.back()">'.$forum_lang['back'].'</a></p>';
	return $text;
}

/**
 *  .
 * @param type $post_id
 */
function ForumAdminDeletePost($post_id){
	System::database()->Delete('forum_posts', "`id`='$post_id'");
}

/**
 *     .
 * @param type $topic_id
 */
function ForumAdminDeletePosts($topic_id){
	System::database()->Delete('forum_posts', "`object`='$topic_id'");
}

/**
 *     .
 * @global type $db
 * @param type  $topic_id
 * @param type  $delete
 */
function ForumAdminDeleteTopic($topic_id, $delete = true){
	ForumAdminDeletePosts($topic_id);
	System::database()->Delete('forum_topics_read', "`tid`='$topic_id'");
	Forum_Subscription_Delete($topic_id);
	if($delete){
		System::database()->Delete('forum_topics', "`id`='$topic_id'");
	}
}

/**
 *    .
 * @param type $forum_id
 */
function ForumAdminDeleteTopics($forum_id){
	$topics = System::database()->Select('forum_topics', "`forum_id`='$forum_id'");
	if(System::database()->NumRows() > 0){
		foreach($topics as $topic){
			$topic_id = SafeEnv($topic['id'], 11, int);
			ForumAdminDeleteTopic($topic_id, false);
		}
	}
	System::database()->Delete('forum_topics', "`forum_id`='$forum_id'");
}

/**
 *     ,   .
 * @param type $forum_id
 */
function ForumAdminDeleteForum($forum_id){
	System::database()->Select('forums', "`id`='$forum_id'");
	if(System::database()->NumRows() > 0){
		$forum = System::database()->FetchRow();

		//   
		if($forum['parent_id'] != '0'){
			ForumAdminDeleteTopics($forum_id);
		}

		$sub_forums = System::database()->Select('forums', "`parent_id`='$forum_id'");
		if(System::database()->NumRows() > 0){
			foreach($sub_forums as $forum2){
				ForumAdminDeleteForum(SafeEnv($forum2['id'], 11, int));
			}
		}
		System::database()->Delete('forums', "`id`='$forum_id'");
	}
}

/**
 *       .
 * @param type $forum
 * @param type $topic
 */
function IndexForumSetLastPostInfo($forum, $topic){
	$forum_id = SafeDB($forum['id'], 11, int);
	$topic_id = SafeDB($topic['id'], 11, int);
	$posts = SafeDB($forum['posts'], 11, int);
	$topics = SafeDB($forum['topics'], 11, int);
	$last_post = time();
	$last_poster_id = System::user()->Get('u_id');
	$last_poster_name = System::user()->Get('u_name');
	$last_topic_title = SafeDB($topic['title'], 255, str);
	$last_topic_id = SafeDB($topic['id'], 11, int);
	System::database()->Update('forums', "`posts`='$posts',`last_post`='$last_post',`last_poster_id`='$last_poster_id',`last_poster_name`='$last_poster_name',`last_title`='$last_topic_title',`last_id`='$last_topic_id',`topics`='$topics'", "`id`='$forum_id'");
	$topic_posts = SafeDB($topic['posts'], 11, int);
	System::database()->Update('forum_topics', "`posts`='$topic_posts',`last_post`='$last_post',`last_poster_id`='$last_poster_id',`last_poster_name`='$last_poster_name'", "`id`='$topic_id'");
}

/**
 *         (id).
 *
 * @param $ignore_ids     
 * @param $objects        
 * @return array
 */
function IgnoreInArray($ignore_ids, &$objects){
	$result = array();
	if(count($ignore_ids) > 0){
		foreach($objects as $obj){
			if(!in_array(current($obj), $ignore_ids)){
				$result[] = $obj;
			}
		}
	} else{
		return $objects; //      
	}
	return $result;
}

/**
 *       .
 * @param type   $TopicId
 * @param string $ExtraSet
 * @param bool   $ReturnSet
 * @return bool|string
 */
function ForumSetLastPost($TopicId, $ExtraSet = '', $ReturnSet = false){
	$posts = System::database()->Select('forum_posts', "`object`='$TopicId' and `delete`='0'");
	if(count($posts) > 0){
		$last_post = $posts[count($posts) - 1];
		$last_post_date = SafeEnv($last_post['public'], 11, int);
		$last_poster_id = SafeEnv($last_post['user_id'], 11, int);
		$last_poster_name = SafeEnv($last_post['name'], 255, str);

		$set = "`last_post`='$last_post_date', `last_poster_id`='$last_poster_id', `last_poster_name`='$last_poster_name'";
	} else{
		$set = "`last_post`='',`last_poster_id`='',`last_poster_name`=''";
	}
	if($ExtraSet != ''){
		$set .= ','.$ExtraSet;
	}
	if($ReturnSet){
		return $set;
	}
	System::database()->Update('forum_topics', $set, "`id`='$TopicId'");
	return true;
}

/**
 *       .
 * @param int    $ForumId
 * @param string $ExtraSet
 * @param bool   $ReturnSet
 * @return boolean
 */
function ForumSetLastTopic($ForumId, $ExtraSet = '', $ReturnSet = false){
	$topics = System::database()->Select('forum_topics', "`forum_id`='$ForumId' and `delete`='0'");
	if(count($topics) > 0){
		//       
		$last_topic = $topics[0];
		foreach($topics as $topic){
			if($topic['last_post'] != '' && $topic['last_post'] > $last_topic['last_post']){
				$last_topic = $topic;
			}
		}
		$last_post = SafeEnv($last_topic['last_post'], 11, int);
		$last_poster_id = SafeEnv($last_topic['last_poster_id'], 11, int);
		$last_poster_name = SafeEnv($last_topic['last_poster_name'], 255, str);
		$last_topic_title = SafeEnv($last_topic['title'], 255, str);
		$last_topic_id = SafeEnv($last_topic['id'], 11, int);

		$set = "`last_post`= '$last_post', `last_poster_id`= '$last_poster_id', `last_poster_name`= '$last_poster_name',"."`last_title`= '$last_topic_title',`last_id`= '$last_topic_id'";
	} else{
		$set = "`last_post`= '', `last_poster_id`= '', `last_poster_name`= '',`last_title`= '',`last_id`= ''";
	}
	if($ExtraSet != ''){
		$set .= ','.$ExtraSet;
	}
	if($ReturnSet){
		return $set;
	}
	System::database()->Update('forums', $set, "`id`= '$ForumId'");
	return true;
}

/**
 *    .
 */
function ForumSmiliesRender(){
	System::site()->AddBlock('smilies', true, true, 'smile');
	if(System::cache()->HasCache('forum', 'ForumSmilies')){
		$smilies = System::cache()->Get('forum', 'ForumSmilies');
	} else{
		$smilies = System::database()->Select('smilies', "`enabled`='1'");
		System::cache()->Write('forum', 'ForumSmilies', $smilies, Day2Sec);
	}
	foreach($smilies as $smile){
		$smile['file'] = RealPath2(System::config('general/smilies_dir').$smile['file']);
		$smile['code'] = SafeDB($smile['code'], 255, str);
		$sub_codes = explode(',', $smile['code']);
		$smile['code'] = $sub_codes[0];
		System::site()->AddSubBlock('smilies', true, $smile);
	}
}

/**
 *         .
 * @param type $table
 * @return type
 */
function ForumGetViewAccessTable(&$table = array()){
	$result = array();
	$a = System::user()->AccessLevel();
	if($a == 1){
		return $table;
	} else{
		foreach($table as $row){
			if($row['view'] == 4 || $row['view'] == $a){
				$result[] = $row;
			}
		}
	}
	return $result;
}

function Moderation_Do_Basket_Topic($topic_id = -1, $text_value = ''){
	global $db;
	if($topic_id > -1){
		$db->Update('forum_topics', "`delete`='1'", "`id`='$topic_id'");
		$text_value = SafeEnv($text_value, 255, str);
		$values = Values('', time(), System::user()->Get('u_id'), $text_value, $topic_id);
		$db->Insert('forum_basket_topics', $values);
	}
	ForumCacheClear();
}

function Moderation_Do_Basket_Post($post_id, $reason = ''){
	System::database()->Update('forum_posts', "`delete`='1'", "`id`='$post_id'");
	$vals = Values('', time(), System::user()->Get('u_id'), $reason, $post_id);
	System::database()->Insert('forum_basket_post', $vals);
}

/**
 *       .
 * @global type $db
 * @global type $config
 */
function Forum_Basket_RestoreBasketAll(){
	global $db, $config;
	if(isset($config['forum']['basket'])){
		$db->Select('config_groups', "`name`='forum'");
		$group = $db->FetchRow();
		$m_group = $group['id'];
		$db->Update('config', "`value`='0'", "`name`='del_auto_time' and `group_id`='$m_group'");
		$db->Delete('forum_basket_topics');
		$db->Delete('forum_basket_post');
		$mdb = $db->Select('forum_topics', "`delete`='1'");
		if(count($mdb) > 0){
			foreach($mdb as $topic){
				$forum_id = SafeDB($topic['forum_id'], 11, int);
				$db->Select('forums', "`id`='$forum_id'");
				$forum = $db->FetchRow();
				$ftopics = (int)$forum['topics'] + 1;
				if($ftopics < 0){
					$ftopics = 0;
				}
				$fposts = (int)$forum['posts'] + (int)$topic['posts'];
				if($fposts < 0){
					$fposts = 0;
				}
				$fset = "`topics`='$ftopics',`posts`='$fposts'";
				$db->Update('forums', $fset, "`id`='$forum_id'");
			}
		}
		$mdb = array();
		$mdb = $db->Select('forum_posts', "`delete`='1'");
		if(count($mdb) > 0){
			foreach($mdb as $post){
				$topic_id = $post['object'];
				$db->Select('forum_topics', "`id`='$topic_id'");
				$topic = $db->FetchRow();
				$tposts = (int)$topic['posts'] + 1;
				if($tposts < 0){
					$tposts = 0;
				}
				$db->Update('forum_topics', "`posts`='$tposts'", "`id`='$topic_id'");
				$forum_id = SafeDB($topic['forum_id'], 11, int);
				$db->Select('forums', "`id`='$forum_id'");
				$forum = $db->FetchRow();
				$fposts = (int)$forum['posts'] + 1;
				if($fposts < 0){
					$fposts = 0;
				}
				$db->Update('forums', "`posts`='$fposts'", "`id`='$forum_id'");
			}
		}
		$db->Update('forum_topics', "`delete`='0'", "`id`>'0'");
		$db->Update('forum_posts', "`delete`='0'", "`id`>'0'");
		ForumCacheClear();
	}
}

/**
 *      .
 * @global type $db
 * @global type $config
 * @param type  $posts
 * @param type  $table
 * @return type
 */
function ForumBasketGetData($table = 'forum_basket_post'){
	$basket = array();
	if(System::config('forum/basket') == true){
		$basket['table'] = $table;
		$basketdb = System::database()->Select($table);
		if(count($basketdb) > 0){
			foreach($basketdb as $b){
				$basket[$b['obj_id']] = $b;
			}
		}
	}
	return $basket;
}

/**
 *       .
 * @global type $forum_lang
 * @staticvar int $num_del
 * @staticvar null $clear_basket_days
 * @param type  $id          .
 * @param type  $text         .
 * @param type  $basket      .
 * @param type  $FullFormat   .
 * @return string
 */
function ForumBasketRender($id = 0, $text = '', &$basket = array(), $FullFormat = true){
	global $forum_lang;
	static $num_del = 0;
	static $clear_basket_days = null;
	if(!isset($clear_basket_days)){
		$clear_basket_days = System::config('forum/clear_basket_day');
	}
	$num_del++;
	$id = SafeDB($id, 11, int);
	$del_admin = '';
	$del_reason = '';
	$del_time = '';
	//  
	$admin_info = GetUserInfo($basket[$id]['user']);
	$del_admin = $forum_lang['deleted'].':<a href="index.php?name=user&op=userinfo&user='.$basket[$id]['user'].'"> '.$admin_info['name'].'</a>';
	//   (  )
	$del_time = $forum_lang['basket_delete_forever'].' '.TimeRender($basket[$id]['date'] + (86400 * $clear_basket_days), false, false);
	//  
	if(trim($basket[$id]['reason']) <> ''){
		$del_reason = '<span style="color: #FF0000;">'.$forum_lang['reason'].'</span>:'.($FullFormat ? '<br>' : '&nbsp;').BbCodePrepare($basket[$id]['reason']).'<br>';
	}
	// 
	if($FullFormat){
		$out_text = $forum_lang['basket_removed_in_basket_message'];
		$out_text .= '<br>'.$del_admin.'<br>'.$del_time.'.<br>'.$del_reason.'<br>';
		//  /   
		$out_text .= '<a href="#" onclick="ShowHide(\'delete_com'.$num_del.'\'); return false;" class="button">'.$forum_lang['basket_see'].'</a>';
		//  - 
		if(System::user()->isAdmin()){
			$out_text .= '&nbsp;|&nbsp;';
			$out_text .= '<a href="index.php?name=forum&op=restore_basket&'.$basket['table'].'='.$id.'&back='.SaveRefererUrl().'" class="button">'.$forum_lang['restore'].'</a>';
		}
		//      ()
		//   ()   
		$text = HtmlChars($text);
		SmiliesReplace($text);
		$text = nl2br($text);
		$text = BbCodePrepare($text);
		$out_text .= '<div align="left" id="delete_com'.$num_del.'" style="visibility: hidden; display: none; border-top: 1px #888 solid; margin: 10px 0 5px 0; padding: 5px 0;">'.$text.'</div>';
	} else{
		//  ,    
		$out_text = $forum_lang['basket_removed_in_basket_message_smile'];
		$out_text .= '<br>'.$del_admin.'<br>'.$del_time.'.<br>'.$del_reason.'<br>';
		//  - 
		if(System::user()->isAdmin()){
			$out_text .= '<a href="index.php?name=forum&op=restore_basket&'.$basket['table'].'='.$id.'&back='.SaveRefererUrl().'" class="button">'.$forum_lang['restore'].'</a>';
		}
	}
	return $out_text;
}

/**
 *  .
 * @global int $config
 */
function ForumBasketAutoclear(){
	global $config;
	if($config['forum']['basket']){
		if($config['forum']['clear_basket_day'] < 1){
			$config['forum']['clear_basket_day'] = 1;
		}
		if($config['forum']['del_auto_time'] < time()){
			$clear_cache = false;
			System::database()->Select('config_groups', "`name`='forum'");
			$group = System::database()->FetchRow();
			$m_time = time() + Day2Sec;
			$m_group = SafeEnv($group['id'], 11, int);
			$delete_date = time() - (Day2Sec * $config['forum']['clear_basket_day']);
			System::database()->Update('config', "`value`='$m_time'", "`name`='del_auto_time' and `group_id`='$m_group'");
			$mdb = System::database()->Select('forum_basket_topics', "`date`<'$delete_date'");
			if(count($mdb) > 0){
				$clear_cache = true;
				foreach($mdb as $d_topic){
					ForumAdminDeleteTopic(SafeDb($d_topic['obj_id'], 11, int));
				}
			}
			System::database()->Delete('forum_basket_topics', "`date`<'$delete_date'");
			$mdb = System::database()->Select('forum_basket_post', "`date`<'$delete_date'");
			if(count($mdb) > 0){
				$clear_cache = true;
				foreach($mdb as $d_post){
					ForumAdminDeletePost(SafeDb($d_post['obj_id'], 11, int));
				}
			}
			System::database()->Delete('forum_basket_post', "`date`<'$delete_date'");
			if($clear_cache){
				ForumCacheClear();
			}
		}
	}
}

/**
 *      forum_topics  .
 *
 * @return Array [forum_id][topic_id]
 */
function ForumCacheGetTopics(){
	static $_topics = null;
	if(!isset($_topics)){
		if(System::cache()->HasCache('forum', FORUM_CACHE_ALL_DATA_FORUM_TOPICS)){
			$_topics = System::cache()->Get('forum', FORUM_CACHE_ALL_DATA_FORUM_TOPICS);
		} else{
			$_topics = array();
			$topics = System::database()->Select('forum_topics');
			foreach($topics as &$t){
				$_topics[$t['forum_id']][] = $t;
			}
			//         
			foreach($_topics as &$forum_topics){
				SortArray($forum_topics, array(
					'stick',
					'last_post'
				), array(
					true,
					true
				));
			}
			System::cache()->Write('forum', FORUM_CACHE_ALL_DATA_FORUM_TOPICS, $_topics);
		}
	}
	return $_topics;
}

/**
 *      forums(  )  .
 *
 * @return Array
 */
function ForumCacheGetForums(){
	if(System::cache()->HasCache('forum', FORUM_CACHE_ALL_DATA_FORUMS)){
		$forums = System::cache()->Get('forum', FORUM_CACHE_ALL_DATA_FORUMS);
	} else{
		$forums = System::database()->Select('forums', "`status`='1'");
		SortArray($forums, 'order');
		System::cache()->Write('forum', FORUM_CACHE_ALL_DATA_FORUMS, $forums);
	}
	return $forums;
}

function ForumCacheUpdate($topics = true, $forums = true){
	if($topics){
		System::cache()->Delete('forum', FORUM_CACHE_ALL_DATA_FORUM_TOPICS);
	}
	if($forums){
		System::cache()->Delete('forum', FORUM_CACHE_ALL_DATA_FORUMS);
	}
}

function ForumCacheClear(){
	System::cache()->Clear('forum');
}

/**
 *        ,   topic id.
 *
 * @return type
 */
function &Forum_Marker_GetReadData(){
	static $read = null;
	if(!isset($read)){
		if(System::user()->Auth){
			$read_data = System::database()->Select('forum_topics_read', "`mid`='".System::user()->Get('u_id')."'");
			foreach($read_data as $data){
				$read[$data['tid']] = $data;
			}
		} else{
			$read = array();
		}
	}
	return $read;
}

/**
 *         id.
 *
 * @param type $topic_id
 */
function ForumIsTopicRead($forum_id, $topic_id){
	$read = Forum_Marker_GetReadData();
	$topics = ForumCacheGetTopics();
	return $read[$topic_id]['date'] < $topics[$forum_id][$topic_id]['last_post'];
}

/**
 *    .
 * @param type $sel_id
 * @param type $title
 * @param type $app_content
 */
function ForumQuickTransitionBox($sel_id, $title = '', $app_content = ''){
	$data = ForumTree::Instance()->GetCatsDataF($sel_id, true, true);
	$nav_url = 'index.php?name=forum&op=showforum';
	System::site()->AddTextBox('', $app_content.Indent('
		<div style="float:right; white-space:nowrap;" class="forum_quick_transition">
			<table cellspacing="0" cellpadding="0" border="0">
				<tr>
					<th>'.$title.':&nbsp;</th>
					<td>
						<form action="'.$nav_url.'" method="get">
							<input type="hidden" name="name" value="forum">
							<input type="hidden" name="op" value="showforum">
							'.System::site()->Select('forum', $data, false, 'onchange="this.form.submit();"').'
						</form>
					</td>
				</tr>
			</table>
		</div>
	'));
}

function word_wrapped_string($text, $limit = 75, $wraptext = '<br />'){
	$limit = intval($limit);
	if($limit > 0 && !empty($text)){
		return preg_replace('#((?>[^\s&/<>"\\-\[\]]|&[\#a-z0-9]{1,7};){'.$limit.'})(?=[^\s&/<>"\\-\[\]]|&[\#a-z0-9]{1,7};)#i', '$0'.$wraptext, $text);
	} else{
		return $text;
	}
}

/**
 *    .
 * @param bool          $edit
 * @param int           $forum
 * @param int           $topic
 * @param int           $id
 * @param string        $value
 * @param string        $text_title
 * @param bool          $loadform
 * @global array        $forum_lang
 */
function ForumRenderPostForm($edit = false, $forum = 0, $topic = 0, $id = 0, $value = '', $text_title = '', $loadform = true){
	global $forum_lang;
	System::site()->AddBlock('forum_editpost_form', $loadform, false, 'form');
	$vars = array();
	$page = 1;
	if(isset($_GET['page'])){
		$page = SafeEnv($_GET['page'], 11, int);
	}
	if($edit){
		$vars['pag'] = $page;
		$vars['post'] = $id;
		$vars['text_value'] = $value;
		$vars['text_title'] = $text_title;
		$vars['edit_title'] = $text_title <> '';
		$vars['topic'] = $topic;
		$vars['title'] = $forum_lang['edit_post'];
		$vars['url'] = "index.php?name=forum&op=savepost&topic=$topic&post=$id&page=$page";
		$vars['edit'] = true;
		$vars['lsubmit'] = $forum_lang['save'];
		$vars['lsubmit_title'] = $forum_lang['save_edit'];
		$vars['visibility'] = 'visible';
	} else{
		$vars['post'] = 0;
		$vars['topic'] = $topic;
		$vars['forum'] = $forum;
		$vars['edit_title'] = $text_title <> '';
		$vars['text_value'] = '';
		$vars['title'] = $forum_lang['add_post'];
		$vars['url'] = "index.php?name=forum&op=addpost&topic=$topic&forum=$forum";
		$vars['edit'] = false;
		$vars['lsubmit'] = $forum_lang['add'];
		$vars['lsubmit_title'] = $forum_lang['add_post'];
		$vars['visibility'] = 'hidden';
	}
	$vars['add'] = !$vars['edit'];
	System::site()->Blocks['forum_editpost_form']['vars'] = $vars;

	ForumSmiliesRender();

	//  BBCode 
	IncludePluginsGroup('bbcode_editors');

	System::site()->AddBlock('files', false, true, 'u_files');
	if($edit){
		System::site()->AddTemplatedBox('', 'module/forum_edit_post.html');
	} else{
		System::site()->AddBlock('post_form', true, false, 'post_form', 'module/forum_edit_post.html');
	}
}

#   " "
function ForumAdminGetUsersTypesComboBox($group = '', $rank = 0){
	global $db, $site, $forum_lang;
	$mdb = $db->Select('userranks');
	SortArray($mdb, 'min', false);
	$types = array(
		array(
			'id' => '0',
			'title' => $forum_lang['all_rang'],
			'select' => false
		)
	);
	foreach($mdb as $type){
		if($type['id'] > 0){
			$types[$type['id']] = array(
				'id' => $type['id'],
				'title' => $type['title'],
				'select' => ($rank == $type['id'] ? true : false)
			);
		}
	}
	$usertypes = array();
	foreach($types as $type){
		$site->DataAdd($usertypes, $type['id'], $type['title'], $type['select']);
	}
	return $site->Select($group, $usertypes);
}

#      
/**
 *             .
 * @param type $Topic
 * @param type $UserId
 */
function Forum_Subscription($Topic = 0, $UserId = 0){
	if($UserId == 0){
		$UserId = System::user()->Get('u_id');
	}
	if(Forum_Subscription_Status($Topic, $UserId)){
		Forum_Subscription_Delete($Topic, $UserId);
	} else{
		Forum_Subscription_Add($Topic, $UserId);
	}
}

/**
 *     .
 * @param int|\type $topic
 * @param int|\type $user_id
 */
function Forum_Subscription_Add($topic = 0, $user_id = 0){
	if($user_id == 0){
		$user_id = System::user()->Get('u_id');
	}
	$vals = "'','$topic','$user_id'";
	System::database()->Insert('forum_subscription', $vals);
}

/**
 *      .
 * @param int|\type $topic
 * @param int|\type $user_id
 */
function Forum_Subscription_Delete($topic = 0, $user_id = 0){
	$where = "`topic`='$topic'";
	if($user_id > 0){
		$where .= " and `user`='$user_id'";
	}
	System::database()->Delete('forum_subscription', $where);
}

/**
 *       .
 * @param type      $Topic
 * @param int|\type $UserId
 * @return type
 */
function Forum_Subscription_Status($Topic, $UserId = 0){
	if($UserId == 0){
		$UserId = System::user()->Get('u_id');
	}
	System::database()->Select('forum_subscription', "`topic`='$Topic' and `user`='$UserId'");
	return (System::database()->NumRows() > 0);
}

function Forum_Subscription_Get_User($topic = 0, $full = true, $ignore_user_id = 0){
	global $db;
	$users = array();
	if($topic > 0){
		$mdb = $db->Select('forum_subscription', "`topic`='$topic'");
		if($db->NumRows() > 0){
			foreach($mdb as $m_user){
				$usr = SafeDb($m_user['user'], 11, int);
				if($usr <> $ignore_user_id){
					if($full){
						$usr = GetUserInfo(SafeDb($m_user['user'], 11, int));
					}
					$users[] = $usr;
				}
			}
		}
	}
	$users = array_unique($users);
	return $users;
}

function Forum_Subscription_Send_Email($users, $topic_id, $name, $title){
	global $config, $forum_lang;
	$link = $config['general']['site_url'].'/index.php?name=forum&op=showtopic&topic='.$topic_id.'&view=lastpost';
	$link_delete = $config['general']['site_url'].'index.php?name=forum&op=subscription&a=delete&topic='.$topic_id;
	$Text = $forum_lang['hello'];
	$Text .= $name.$forum_lang['add_message'].$title.$forum_lang['last_subscription'];
	$Text .= "\r\n";
	$Text .= $forum_lang['view_message'];
	$Text .= $link."\r\n";
	$Text .= $forum_lang['delete_subscription'];
	$Text .= $link_delete."\r\n";
	$Text .= $forum_lang['auto_message'];
	$robot = $forum_lang['robot'];
	$robot_email = 'noreply@'.getenv("HTTP_HOST");
	foreach($users as $c_user){
		SendMail($c_user['name'], $c_user['email'], $forum_lang['new_message'].$title, $Text, false, $robot, $robot_email);
	}
}

function Forum_Subscription_Send($topic_id = 0){
	if($topic_id > 0){
		System::database()->Select('forum_topics', "`id`='$topic_id'");
		if(System::database()->NumRows() > 0){
			$topic = System::database()->FetchRow();
			$title = SafeDB($topic['title'], 75, str);
			$users = Forum_Subscription_Get_User($topic_id, true, System::user()->Get('u_id'));
			if(count($users) > 0){
				Forum_Subscription_Send_Email($users, $topic_id, System::user()->Get('u_name'), $title);
			}
		}
	}
}

/**
 *       .
 * @param type  $topic
 * @global type $forum_lang
 * @internal param \type $root
 * @return string
 */
function ForumTopicFilterData($topic){
	global $forum_lang;
	$topic2 = array();
	$topic2['id'] = SafeDB($topic['id'], 11, int);
	$topic2['forum_id'] = SafeDB($topic['forum_id'], 11, int);
	$topic2['category'] = $topic2['forum_id'];
	$topic2['title'] = SafeDB($topic['title'], 255, str);
	$topic2['state'] = SafeDB($topic['state'], 1, int); // TODO:  ?
	$topic2['posts'] = SafeDB($topic['posts'], 11, int) < 0 ? 0 : SafeDB($topic['posts'], 11, int);
	$topic2['hits'] = SafeDB($topic['hits'], 11, int);
	$topic2['start_date'] = TimeRender(SafeDB($topic['start_date'], 11, int), true, true);
	$topic2['starter_id'] = SafeDB($topic['starter_id'], 11, int);
	$topic2['starter_name'] = SafeDB($topic['starter_name'], 255, str);
	$topic2['starter_url'] = Ufu('index.php?name=user&op=userinfo&user='.$topic2['starter_id'], 'user/{user}/info/');
	$topic2['last_post_date'] = SafeDB($topic['last_post'], 11, int);
	$topic2['last_post'] = TimeRender(SafeDB($topic['last_post'], 11, int), true, true);
	if($topic2['last_post_date'] > (time() - 86400)){
		$topic2['last_post'] = '<font color="#FF0000">'.$topic2['last_post'].'</font>';
	}
	$topic2['last_poster_id'] = SafeDB($topic['last_poster_id'], 11, int);
	$topic2['last_poster_name'] = SafeDB($topic['last_poster_name'], 255, str);
	$topic2['last_poster_url'] = Ufu('index.php?name=user&op=userinfo&user='.$topic2['last_poster_id'], 'user/{user}/info/');
	$topic2['count_read'] = ForumOnline::Instance()->GetTopicOnlineCount($topic2['id']);
	$topic2['read'] = ($topic2['count_read'] > 0 ? '<small> ('.$forum_lang['online'].': '.$topic2['count_read'].')</small>' : '');
	$topic2['close'] = SafeDB($topic['close_topics'], 1, int) == 1;
	$topic2['begin'] = !$topic2['close'];

	if(isset($topic['status'])){
		//  ,     
		$topic2['status'] = $topic['status'];
		//             
		$topic2['show_delete'] = $topic['show_delete'];
	}else{
		$topic2['status'] = '';
		$topic2['show_delete'] = System::user()->isAdmin();
	}

	//  ""
	$topic2['stick'] = ($topic['stick'] == 1 ? $forum_lang['it_is_important'] : '');
	$topic2['delete'] = SafeDB($topic['delete'], 1, int) == 1;
	$topic2['nodelete'] = SafeDB($topic['delete'], 1, int) == 0;
	$topic2['url'] = Ufu('index.php?name=forum&op=showtopic&topic='.$topic2['id'], 'forum/topic{topic}.html');
	$topic2['last_url'] = Ufu('index.php?name=forum&op=showtopic&topic='.$topic2['id'].'&view=lastpost', 'forum/topic{topic}-new.html');
	// 
	$topic2['pages'] = '';
	$posts_on_page = System::config('forum/posts_on_page');
	if($topic2['posts'] + 1 > $posts_on_page){
		$forum_nav_url = 'index.php?name=forum&op=showtopic&topic='.$topic2['id'];
		$forum_nav_url_u = 'forum/topic{topic}-';
		$page = ceil(($topic2['posts'] + 1) / $posts_on_page);
		$str = $forum_lang['pages'];
		for($i = 0; $i < $page; $i++){
			$str .= '<a href="'.Ufu($forum_nav_url.'&page='.($i + 1), $forum_nav_url_u.($i + 1).'.html').'"><font size="1">'.($i + 1).' </font></a>'; // FIXME:    UFU ,   {page}
			if($i > 5 && $page > 10){
				$str .= '....<a href="'.Ufu($forum_nav_url.'&page='.($page - 1), $forum_nav_url_u.($page - 1).'.html').'"><font size="1">'.($page - 1).' </font></a>';
				$str .= '<a href="'.Ufu($forum_nav_url.'&page='.$page, $forum_nav_url_u.$page).'"><font size="1">'.$page.' </font></a>';
				break;
			}
		}
		$topic2['pages'] .= $str.'<br />';
	}
	return $topic2;
}

/**
 *       .
 * @param int $PostsCount     
 *          .
 * @param int $TopicsCount  ,    .
 * @return int
 */
function ForumCalcUserCounters($PostsCount = 0, $TopicsCount = 0){
	$count = UserData('forum_counters');
	if(!isset($count)){
		$count = array(
			'posts' => 0,
			'topics' => 0
		);
	}
	$Increment = false;
	if($PostsCount != 0){
		$count['posts'] += $PostsCount;
		$Increment = true;
	}
	if($TopicsCount != 0){
		$count['topics'] += $TopicsCount;
		$Increment = true;
	}
	if($Increment){
		UserData('forum_counters', $count);
	}
	return $count;
}

/**
 *       .
 */
function ModerationForumTopicsBlocks(){
	if(!System::user()->isAdmin()){
		System::site()->AddBlock('topics_moderation', false);
		System::site()->AddBlock('topics_moderation_options', false);
		return;
	}
	System::site()->AddBlock('topics_moderation', true, false, 'moderation');
	System::site()->SetVars('topics_moderation', array('form_url' => 'index.php?name=forum&op=edit_topics&back='.SaveRefererUrl()));
	System::site()->AddBlock('topics_moderation_options', true, true, 'option');
	$options = array(
		'deletetopic' => ' ',
		'open' => ' ',
		'close' => ' ',
		'stick' => '    ""',
		'unstick' => '    ""',
		'movetopic' => ' ',
		'mergetopic' => ' '
	);
	foreach($options as $name => $title){
		System::site()->AddSubBlock('topics_moderation_options', true, array(
			'name' => $name,
			'title' => $title
		));
	}

}

/**
 *       .
 */
function ModerationForumShowTopicBlocks(){

}

/**
 *          .
 * @param int $PostsCount
 * @param int $TopicsCount
 */
function ForumSetUserPostsCounter($PostsCount = 0, $TopicsCount = 0){
	UserData('forum_counters', array(
		'posts' => $PostsCount,
		'topics' => $TopicsCount
	));
}

/**
 *           .
 */
function ForumUpdateUserCounts(){
	$counts = array();
	foreach(System::database()->Select('forum_posts') as $post){
		if(!isset($counts[$post['user_id']])){
			$counts[$post['user_id']] = array(
				'topics' => 0,
				'posts' => 0
			);
		}
		$counts[$post['user_id']]['posts']++;
	}
	foreach(System::database()->Select('forum_topics') as $topic){
		if(!isset($counts[$topic['starter_id']])){
			$counts[$topic['starter_id']] = array(
				'topics' => 0,
				'posts' => 0
			);
		}
		$counts[$topic['starter_id']]['topics']++;
	}
	foreach($counts as $id => $count){
		UserData('forum_counters', $count, $id);
	}
}
