<?php

/*
 * LinkorCMS 1.4
 *  2012 LinkorCMS Development Group
 */


if(!defined('VALID_RUN')){
	header("HTTP/1.1 404 Not Found");
	exit;
}

System::admin()->AddSubTitle('');

if(!System::user()->CheckAccess2('gallery', 'gallery')) System::admin()->AccessDenied();

global $edit_images, $edit_cats, $edit_conf,  $GalleryDir, $ThumbsDir;
$edit_images = System::user()->CheckAccess2('gallery', 'edit_images');
$edit_cats = System::user()->CheckAccess2('gallery', 'edit_cats');
$edit_conf = System::user()->CheckAccess2('gallery', 'config');
$GalleryDir = System::config('gallery/gallery_dir');
$ThumbsDir = System::config('gallery/thumbs_dir');

if(isset($_GET['a'])){
	$action = $_GET['a'];
}else{
	$action = 'main';
}

TAddToolLink('', 'main', 'gallery');
if($edit_images){
	TAddToolLink(' ', 'editor', 'gallery&a=editor');
	TAddToolLink('', 'upload', 'gallery&a=upload');
}
if($edit_cats){
	TAddToolLink('', 'cats', 'gallery&a=cats');
	TAddToolLink(' ', 'cateditor', 'gallery&a=cateditor');
}
if($edit_conf){
	TAddToolLink('', 'config', 'gallery&a=config');
}
TAddToolBox($action);

switch($action){
	case 'main':
		AdminGalleryMainFunc();
		break;
	case 'editor':
		AdminGalleryEditor();
		break;
	case 'add':
	case 'save':
		AdminGallerySaveImage($action);
		break;
	case 'move':
		AdminGalleryMove();
		break;
	case 'upload':
		AdminGalleryUpload(); //     
		break;
	case 'deleteuploaded':
		AdminGalleryDeleteUploaded();
		break;
	case 'saveuploaded':
		AdminGallerySaveUploaded();
		break;
	case 'changestatus':
		AdminGalleryChangeStatus();
		break;
	case 'delete':
		AdminGalleryDeleteImage();
		break;
	case 'resethits':
		AdminGalleryResetHits();
		break;
	case 'resetrating':
		AdminGalleryResetRating();
		break;
	////////////////// 
	case 'cats':
		if(!$edit_cats) System::admin()->AccessDenied();
		$result = AdminGalleryGetTree()->ShowCats();
		if($result == false){
			$result = '   .';
		}
		AddTextBox('', $result);
		break;
	case 'cateditor':
		if(!$edit_cats) System::admin()->AccessDenied();
		if(isset($_GET['id'])){
			$id = SafeEnv($_GET['id'], 11, str);
		}else{
			$id = null;
		}
		if(isset($_GET['to'])){
			$to = SafeEnv($_GET['to'], 11, str);
		}else{
			$to = null;
		}
		$back = '';
		if(isset($_REQUEST['back'])){
			$back = '&back='.SafeDB($_REQUEST['back'], 255, str);
		}
		AdminGalleryGetTree()->CatEditor($id, $to, $back);
		break;
	case 'catsave':
		if(!$edit_cats) System::admin()->AccessDenied();
		$ret = AdminGalleryGetTree()->EditorSave((isset($_GET['id']) ? SafeEnv($_GET['id'], 11, int) : null));

		if(isset($_REQUEST['back'])){
			GoRefererUrl($_REQUEST['back'], (!isset($_GET['id']) ? '&to='.$ret : ''));
		}else{
			GO(ADMIN_FILE.'?exe=gallery&a=cats');
		}
		break;
	case 'delcat':
		if(!$edit_cats) System::admin()->AccessDenied();
		if(AdminGalleryGetTree()->DeleteCat(SafeEnv($_GET['id'], 11, int))){
			GO(ADMIN_FILE.'?exe=gallery&a=cats');
		}
		break;
	////////////////// 
	case 'config':
		if(!$edit_conf) System::admin()->AccessDenied();
		System::admin()->AddCenterBox('  ""');
		if(CheckGet('saveok')){
			System::admin()->Highlight(' .');
		}
		System::admin()->ConfigGroups('gallery');
		System::admin()->AddConfigsForm(ADMIN_FILE.'?exe=gallery&a=configsave');
		break;
	case 'configsave':
		if(!$edit_conf) System::admin()->AccessDenied();
		System::admin()->SaveConfigs('gallery');
		Audit(':   ');
		GO(ADMIN_FILE.'?exe=gallery&a=config&saveok');
		break;
	////////
	case 'refreshthumb':
		AdminGalleryThumbRefresh();
		break;
	case 'rotate':
		AdminGalleryImageRotate();
		break;
}

function AdminGalleryGetTree() {
	static $tree = null;
	if(is_null($tree)) {
		$tree = new AdminTree('gallery_cats');
		$tree->module = 'gallery';
		$tree->obj_table = 'gallery';
		$tree->obj_cat_coll = 'cat_id';
		$tree->showcats_met = 'cats';
		$tree->edit_met = 'cateditor';
		$tree->save_met = 'catsave';
		$tree->del_met = 'delcat';
		$tree->action_par_name = 'a';
		$tree->id_par_name = 'id';
		$tree->index_id_par_name = 'cat';
	}
	return $tree;
}

function AdminGalleryNewOrder( $cat_id ){
	static $new_order_cache = null;
	if(!isset($new_order_cache) || !isset($new_order_cache[$cat_id])){
		$new_order_cache[$cat_id] = System::database()->Select('gallery', "`cat_id`='$cat_id'");
	}
	$max_order = 0;
	foreach( $new_order_cache[$cat_id] as $img ){
		if($img['order'] > $max_order) $max_order = $img['order'];
	}
	return $max_order+1;
}

/*
 *     .
 */
function AdminGalleryClearBlockCache(){
	System::cache()->Delete('block', array('random_images1', 'random_images2', 'random_images3', 'random_images4'));
}


function AdminGalleryMainFunc(){
	global $edit_images, $GalleryDir, $ThumbsDir;
	UseScript('colorbox?theme=admin');

	$back = SaveRefererUrl();
	if(isset($_GET['cat']) && $_GET['cat'] > -1){
		$cat = SafeEnv($_GET['cat'], 11, int);
		$where = "`cat_id`='$cat'";
	}else{
		$cat = -1;
		$where = "";
	}
	$data = AdminGalleryGetTree()->GetCatsData($cat, true);
	System::site()->DataAdd($data, -1, ' ', $cat == -1);
	if(isset($_GET['page'])){
		$page = SafeEnv($_GET['page'], 11, int);
		$page_param = '&page='.SafeDB($_GET['page'], 11, int);
	}else{
		$page = 1;
		$page_param = '';
	}
	AddCenterBox('');

	System::admin()->AddJS(Indent('
		GallerySelectCat = function(){
			Admin.LoadPage("'.ADMIN_FILE.'?exe=gallery&cat="+$("#gallery-cat").val());
		}
	'));
	$text = '<div style="margin-bottom: 10px;">: '.System::site()->Select('cat', $data, false, 'id="gallery-cat" onchange="GallerySelectCat();"');
	if($cat < 0){
		$text .= ' (  ,  )';
	}
	$text .= '</div>';
	AddText($text);

	$images = System::database()->Select('gallery', $where);
	$count_images = count($images) - 1;
	SortArray($images, 'order');

	if(count($images) > System::config('gallery/images_on_page')){
		$navigator = new Navigation($page);
		$navigator->GenNavigationMenu($images, System::config('gallery/images_on_page'), ADMIN_FILE.'?exe=gallery'.($cat > 0 ? '&cat='.$cat : ''));
		$nav = true;
	}else{
		$nav = false;
	}

	$text = '<table cellspacing="0" cellpadding="0" class="cfgtable">';
	$text .= '<tr>'.($cat > 0 ? '<th></th>' : '').'<th></th><th></th><th></th><th></th><th></th></tr>';
	foreach($images as $i=>$img){
		$id = SafeDB($img['id'], 11, int);
		$title = SafeDB($img['title'], 255, str);
		if($title == '') $title = ' '.$id;
		if(System::config('gallery/show_thumbs')){
			$img_filename = SafeDB($img['file'], 255, str);
			$size = FormatFileSize(filesize($GalleryDir.$img_filename));
			$asize = getimagesize($GalleryDir.$img_filename);
			$asize = $asize[0].'x'.$asize[1];
			$thumb = '<div style="margin: 5px 0;"><a href="'.$GalleryDir.$img_filename.'" target="_blank" class="colorbox">'
				.'<img title="'.$title.'" src="'.$ThumbsDir.$img_filename.(isset($_GET['update']) && $_GET['update'] == $id ? '?'.GenRandomString(5) : '').'"></a></div>'."($asize, $size)";
		}else{
			$thumb = '';
		}

		$hits = SafeDB($img['hits'], 11, int);
		$st = ($img['show'] == '1' ? '.' : '.');
		$func = '-';
		$move_menu = '';

		$link_go = Ufu('index.php?name=gallery&op=view&img='.$id.'&cat='.SafeDB($img['cat_id'], 11, int), 'gallery/{cat}/{img}/');
		$func = '';
		$func .= System::admin()->SpeedButton('    ', $link_go, 'images/link_go.png', false, false, 'target="_blank"');
		if($edit_images){
			$edit_url = ADMIN_FILE.'?exe=gallery&a=editor&id='.$id.'&back='.$back;
			$title = '<b>'.System::admin()->Link($title, $edit_url).'</b>';
			$hits .= '&nbsp;'.System::admin()->SpeedConfirm('  ', ADMIN_FILE.'?exe=gallery&a=resethits&id='.$id.'&back='.$back, 'images/admin/arrow_in.png', '  ?');
			$st = System::admin()->SpeedStatus('.', '.', ADMIN_FILE.'?exe=gallery&a=changestatus&id='.$id, $img['show'] == '1');

			$func .= System::admin()->SpeedButton('', $edit_url, 'images/admin/edit.png');
			$func .= System::admin()->SpeedConfirm('', ADMIN_FILE.'?exe=gallery&a=delete&id='.$id.'&back='.$back, 'images/admin/delete.png', ' ?');
			$func .= '<div style="margin-top: 4px;">';
			$func .= System::admin()->SpeedButton('   90', ADMIN_FILE.'?exe=gallery&a=rotate&turn=left&id='.$id.'&back='.$back, 'images/admin/layer-rotate-left.png');
			$func .= System::admin()->SpeedButton('   90 ', ADMIN_FILE.'?exe=gallery&a=rotate&turn=right&id='.$id.'&back='.$back, 'images/admin/layer-rotate-right.png');
			$func .= System::admin()->SpeedButton(' ', ADMIN_FILE.'?exe=gallery&a=refreshthumb&id='.$id.'&back='.$back, 'images/admin/refresh.png');
			$func .= '</div>';

			if($count_images == 0){ //    
				$move_menu .= ' - ';
			}else{
				if($i != $count_images){ //  
					$move_menu .= System::admin()->SpeedButton('', ADMIN_FILE.'?exe=gallery&a=move&to=down&id='.$id.'&cat='.$cat.$page_param, 'images/admin/down.png');
				}
				if($i != 0){ //  
					$move_menu .= System::admin()->SpeedButton('', ADMIN_FILE.'?exe=gallery&a=move&to=up&id='.$id.'&cat='.$cat.$page_param, 'images/admin/up.png');
				}
			}
		}
		$text .= Indent('
			<tr>
				'.($cat > 0 ? '<td>'.$move_menu.'</td>' : '').'
				<td>'.$title.$thumb.'</td>
				<td>'.$hits.'</td>
				<td>'.ViewLevelToStr(SafeDB($img['view'], 1, int)).'</td>
				<td>'.$st.'</td>
				<td>'.$func.'</td>
			</tr>
		');
	}
	$text .= '</table>';
	AddText($text);
	if($nav){
		AddNavigation();
	}
}

function AdminGalleryEditor(){
	global $edit_images, $ThumbsDir;
	if(!$edit_images) System::admin()->AccessDenied();
	$cat_id = (isset($_GET['to']) ? SafeDB($_GET['to'], 11, int) : 0);
	$author = '';
	$email = '';
	$www = '';
	$title = '';
	$description = '';
	$file = '';
	$allow_comments = true;
	$allow_votes = true;
	$view = array(1=>false, 2=>false, 3=>false, 4=>false);
	$show = true;
	if(!isset($_GET['id'])){
		$view[4] = true;
		$action = 'add';
		$top = ' ';
		$cap = '';
	}else{
		$id = SafeEnv($_GET['id'], 11, int);
		System::database()->Select('gallery', "`id`='$id'");
		$par = System::database()->FetchRow();
		$cat_id = SafeDB($par['cat_id'], 11, int);
		$author = SafeDB($par['author'], 50, str);
		$email = SafeDB($par['email'], 50, str);
		$www = SafeDB($par['site'], 250, str);
		$title = SafeDB($par['title'], 255, str);
		$description = SafeDB($par['description'], 0, str, false);
		$file = SafeDB($par['file'], 255, str);
		$allow_comments = SafeDB($par['allow_comments'], 1, bool);
		$allow_votes = SafeDB($par['allow_votes'], 1, bool);
		$show = SafeDB($par['show'], 1, bool);
		$view[SafeDB($par['view'], 1, int)] = true;
		$action = 'save&id='.$id;
		$top = ' ';
		$cap = ' ';
	}
	$visdata = GetUserTypesFormData($view);
	$cats_data = AdminGalleryGetTree()->GetCatsData($cat_id);
	if(count($cats_data) == 0){
		$back_to_form = SaveRefererUrl();
		AddTextBox($top, '   ! '.System::admin()->SpeedButton(' ', ADMIN_FILE.'?exe=gallery&a=cateditor&back='.$back_to_form, '', true, true));
		return;
	}

	AddCenterBox($top);
	FormRow(' ', System::site()->Select('category', $cats_data, false, ($cat_id == 0 ? 'class="autofocus"' : '')));
	FormRow('', System::site()->Edit('title', $title, false, 'maxlength="250" style="width:400px;"'. ($cat_id != 0 ? ' class="autofocus"' : '')));
	FormRow('', System::site()->Edit('image', $file, false, 'style="width:400px;" maxlength="250"').'<br>'.
		($action != 'add' ? '<img id="image_preview" src="'.$ThumbsDir.$file.'" style="padding: 10px 0 10px 0"><br>' : '')
		.System::site()->FFile('up_image').'<br /><small>   *.jpg, *.jpeg, *.gif, *.png</small><br /><small>  : '.ini_get('upload_max_filesize').'</small>');
	FormTextRow('', System::site()->HtmlEditor('description', $description, 600, 200));
	FormRow('', System::site()->Edit('author', $author, false, 'style="width:400px;" maxlength="50"'));
	FormRow('E-mail ', System::site()->Edit('email', $email, false, 'style="width:400px;" maxlength="50"'));
	FormRow(' ', System::site()->Edit('www', $www, false, 'style="width:400px;" maxlength="250"'));
	$enData = GetEnData($allow_comments, '', '');
	FormRow('', System::site()->Select('allow_comments', $enData));
	$enData = GetEnData($allow_votes, '', '');
	FormRow('', System::site()->Select('allow_votes', $enData));
	FormRow(' ', System::site()->Select('view', $visdata));
	$enData = GetEnData($show, '', '');
	FormRow('', System::site()->Select('show', $enData));
	$back = '';
	if(isset($_REQUEST['back'])){
		$back = '&back='.SafeDB($_REQUEST['back'], 255, str);
	}
	AddForm('<form action="'.ADMIN_FILE.'?exe=gallery&a='.$action.$back.'" method="post" enctype="multipart/form-data">',
		System::site()->Button('', 'onclick="history.go(-1)"').System::site()->Submit($cap));
}

function AdminGallerySaveImage(){
	global $GalleryDir, $ThumbsDir;
	$cat_id = SafeEnv($_POST['category'], 11, int);
	$title = SafeEnv($_POST['title'], 255, str);
	$desc = SafeEnv($_POST['description'], 0, str);
	$author = SafeEnv($_POST['author'], 50, str);
	$email = SafeEnv($_POST['email'], 50, str);
	$site = SafeEnv(url($_POST['www']), 250, str);
	$allow_comments = EnToInt($_POST['allow_comments']);
	$allow_votes = EnToInt($_POST['allow_votes']);
	$view = ViewLevelToInt($_POST['view']);
	$show = EnToInt($_POST['show']);

	//  
	$Error = false;
	$file = LoadImage(
		'up_image',
		$GalleryDir,
		$ThumbsDir,
		System::config('gallery/thumb_max_width'),
		System::config('gallery/thumb_max_height'),
		$_POST['image'],
		$Error,
		true,
		System::config('gallery/optimize_originals'),
		System::config('gallery/original_width'),
		System::config('gallery/original_height')
	);

	if($Error){
		AddTextBox('', '<p align="center">  .      GIF, JPEG  PNG.</p>');
		return;
	}
	if(!isset($_GET['id'])){ // 
		$order = AdminGalleryNewOrder($cat_id);
		System::database()->Insert('gallery', "'','$cat_id','".time()."','$title','$desc','$file','0','$author','$email','$site','$allow_comments','0','$allow_votes','0','0','$view','$show','$order'");
		Audit(':   "'.$title.'"   "'.AdminGalleryGetTree()->IdCats[$cat_id]['title']);
		if($show){
			AdminGalleryGetTree()->CalcFileCounter($cat_id, true);
		}
	}else{ // 
		$set = "`cat_id`='$cat_id',`title`='$title',`description`='$desc',`file`='$file',`author`='$author',`email`='$email',`site`='',`allow_comments`='$allow_comments',`allow_votes`='$allow_votes',`view`='$view',`show`='$show'";
		$id = SafeEnv($_GET['id'], 11, int);
		System::database()->Select('gallery', "`id`='$id'");
		$image = System::database()->FetchRow();
		if($image['cat_id'] != $cat_id){ //     
			//    
			if($image['show'] == '1'){
				AdminGalleryGetTree()->CalcFileCounter(SafeDB($image['cat_id'], 11, int), false);
				AdminGalleryGetTree()->CalcFileCounter($cat_id, true);
			}
			$set .= ",`order`='".AdminGalleryNewOrder($cat_id)."'";
		}
		if($image['show'] != $show){ //  / 
			if($show == 0){
				AdminGalleryGetTree()->CalcFileCounter($cat_id, false);
			}else{
				AdminGalleryGetTree()->CalcFileCounter($cat_id, true);
			}
		}
		if($image['file'] != $file){
			if(is_file($GalleryDir.$image['file'])){
				unlink($GalleryDir.$image['file']);
			}
			if(is_file($ThumbsDir.$image['file'])){
				unlink($ThumbsDir.$image['file']);
			}
		}
		System::database()->Update('gallery', $set, "`id`='$id'");
		Audit(':   "'.$title.'" (id: '.$id.')');
	}
	AdminGalleryClearBlockCache();
	if(isset($_REQUEST['back'])){
		GoRefererUrl($_REQUEST['back']);
	}else{
		GO(ADMIN_FILE.'?exe=gallery&cat='.SafeDB($cat_id, 11, int));
	}
}

function AdminGalleryUploadForm(){
	global $edit_images;
	if(!$edit_images) System::admin()->AccessDenied();

	$top = '';

	$cat_id = (isset($_GET['to']) ? SafeDB($_GET['to'], 11, int) : 0);
	$cats_data = AdminGalleryGetTree()->GetCatsData($cat_id);
	if(count($cats_data) == 0){
		$back_to_form = SaveRefererUrl();
		AddTextBox($top, '   ! '.System::admin()->SpeedButton(' ', ADMIN_FILE.'?exe=gallery&a=cateditor&back='.$back_to_form, '', true, true));
		return;
	}

	System::admin()->AddCenterBox($top);

	UseScript('swfupload');
	$formid = uniqid(); //  ID 
	$_SESSION['uploadforms'][$formid] = array(
		'photos'=>array(),
		'category' => '0',
		'allow_comments' => '1',
		'allow_votes' => '1',
		'view' => '4',
		'show' => '1'
	);

	System::admin()->AddOnLoadJS(Indent('
		window.photo_id = 1;
		window.allUploadComplete = false;
		window.photosCountFiles = 0;
		window.photosUploaded = 0;

		// SWFUpload
		if(window.gallery_swfu){
			window.gallery_swfu.destroy();
		}else{
			window.GallerySubmitFormGuard = function(){
				if(window.photosCountFiles == 0){
					alert("   ");
					return false;
				}
				if(!window.allUploadComplete){
					window.gallery_swfu.startUpload();
					Admin.ShowSplashScreen("   ");
					return false;
				}
				return true;
			}
		}

		window.gallery_swfu = new SWFUpload({
			upload_url: "'.ADMIN_FILE.'?exe=gallery&a=upload&formid='.$formid.'",
			file_post_name : "up_image",
			post_params: {
				"action": "upload"
			},
			file_size_limit: "100 MB",
			file_types: "*.jpg; *.png; *.jpeg; *.gif",
			file_types_description: " ",
			file_upload_limit: 0,
			file_queue_limit: 0,
			debug: false,

			button_placeholder_id: "uploadbutton",
			button_width: "54",
			button_height: "18",
			button_window_mode: SWFUpload.WINDOW_MODE.TRANSPARENT,
			button_text: "<span class=\"btnCap\"><span>",
			button_text_style: ".btnCap{ align: center; color: #4F4F4F; font-family: Verdana, Tahoma, sans-serif; font-weight: bold; }",
			button_text_left_padding: 4,
			button_text_top_padding: 1,

			file_dialog_complete_handler: function(numFilesSelected, numFilesQueued, total){
				$("#uploadFilesCount").html(" " + total + " ()");
				window.photosCountFiles = total;
			},
			upload_progress_handler: function(file, bytesLoaded, bytesTotal){
				var current = window.photosUploaded + 1;
				Admin.SetSplashScreenMessage("   : " + current + "/" + window.photosCountFiles + " (" + Math.round(bytesLoaded/bytesTotal*100) + "%)");
			},
			upload_complete_handler: function(file){
				window.photosUploaded++;
				if(window.photosUploaded == window.photosCountFiles){
					window.allUploadComplete = true;
					$("#galleryForm").submit();
				}
			}
		});
	'));

	FormRow(' ', System::site()->Select('category', $cats_data));
	FormRow(' ', RemoveIndent('
		<div style="float: left;" id="uploadFilesCount"> 0 ()</div>
		&nbsp;&nbsp;&nbsp;&nbsp;
		<div class="button" style="float: right; border: 1px #ccc solid;">
			<span id="uploadbutton">
				<a href="http://www.adobe.com/go/getflashplayer">Get Adobe Flash player</a>
			</span>
		</div>
	'));
	FormRow('', System::site()->Select('allow_comments', GetEnData(true, '', '')));
	FormRow('', System::site()->Select('allow_votes', GetEnData(true, '', '')));
	FormRow(' ', System::site()->Select('view', GetUserTypesFormData(4)));
	FormRow('', System::site()->Select('show', GetEnData(true, '', '')));
	AddForm('<form action="'.ADMIN_FILE.'?exe=gallery&a=upload&formid='.$formid.'" method="post" onsubmit="return GallerySubmitFormGuard();" id="galleryForm">',
		System::admin()->Hidden('action', 'preview').System::admin()->Submit(''));
}

function AdminGalleryUpload(){ // TODO:     
	if(!isset($_POST['action']) || !isset($_GET['formid']) || !isset($_SESSION['uploadforms'][$_GET['formid']])){
		AdminGalleryUploadForm();
		return;
	}
	global $GalleryDir, $ThumbsDir;
	$formid = $_GET['formid'];

	//  
	if($_POST['action'] == 'upload'){
		// SwfUpload     UTF-8
		$_FILES['up_image']['name'] = Utf8ToCp1251($_FILES['up_image']['name']);
		$Error = false;
		$_SESSION['uploadforms'][$formid]['photos'][] = LoadImage(
			'up_image',
			$GalleryDir,
			$ThumbsDir,
			System::config('gallery/thumb_max_width'),
			System::config('gallery/thumb_max_height'),
			'',
			$Error,
			true,
			System::config('gallery/optimize_originals'),
			System::config('gallery/original_width'),
			System::config('gallery/original_height')
		);
		if($Error){
			exit('ERROR 2');
		}
		exit('OK');
	}

	//   
	$_SESSION['uploadforms'][$formid]['category'] = $_POST['category'];
	$_SESSION['uploadforms'][$formid]['allow_comments'] = EnToInt($_POST['allow_comments']);
	$_SESSION['uploadforms'][$formid]['allow_votes'] = EnToInt($_POST['allow_votes']);
	$_SESSION['uploadforms'][$formid]['show'] = EnToInt($_POST['show']);
	$_SESSION['uploadforms'][$formid]['view'] = ViewLevelToInt($_POST['view']);

	AddCenterBox(' - ');
	$count_photos = count($_SESSION['uploadforms'][$formid]['photos']);
	$text = '<form action="'.ADMIN_FILE.'?exe=gallery&a=saveuploaded&formid='.$formid.'" method="post">';
	$submits = System::admin()->Submit('', 'name="submit_cancel" value="cancel"').System::admin()->Submit('', 'name="submit_save" value="save"');
	$text .= '<div class="cfgboxsubmit"><div style="float: left;"> '.$count_photos.' .</div>'.$submits.'</div>';
	foreach($_SESSION['uploadforms'][$formid]['photos'] as $id=>$photo){
		$func = System::admin()->SpeedAjax('', ADMIN_FILE.'?exe=gallery&a=deleteuploaded&id='.$id.'&formid='.$formid, 'images/admin/delete.png', '', '', "jQuery('#photo_box_$id').fadeOut();");
		$text .= Indent('
			<div class="cfgbox" id="photo_box_'.$id.'">
				<table cellspacing="0" cellpadding="0" border="0" style="width: 100%;">
					<tr>
						<td style="vertical-align: top; width: 160px;">
							<a href="'.$GalleryDir.$photo.'" target="_blank"><img src="'.$ThumbsDir.$photo.'" /></a>
							'.$photo.'
						</td>
						<td style="vertical-align: top;">
							<table cellspacing="2" cellpadding="4" style="width: 100%;" class="cfgtable">
								<tr>
									<td></td>
									<td colspan="3" style="text-align: left;">'.System::admin()->Edit('title_'.$id, '', false, 'maxlength="250" style="width:400px;"').'</td>
								</tr>
								<tr>
									<td> (HTML)</td>
									<td colspan="3" style="text-align: left;">'.System::admin()->TextArea('description_'.$id, '', 'style="width: 400px; height: 120px;"').'</td>
								</tr>
								<tr>
									<td></td>
									<td style="text-align: left;">'.System::admin()->Edit('author_'.$id, '', false, 'maxlength="250" style="width:200px;"').'</td>
									<td>Email </td>
									<td style="text-align: left;">'.System::admin()->Edit('email_'.$id, '', false, 'maxlength="250" style="width:200px;"').'</td>
								</tr>
								<tr>
									<td> </td>
									<td colspan="3" style="text-align: left;">'.System::admin()->Edit('www_'.$id, '', false, 'maxlength="250" style="width:200px;"').'</td>
								</tr>
							</table>
						</td>
						<td style="vertical-align: top; text-align: right; width: 50px;">'.$func.'</td>
					</tr>
				</table>
			</div>
		');
	}
	$text .= '<div class="cfgboxsubmit">'.$submits.'</div>';
	$text .= '</form>';
	AddText($text);
}

function AdminGalleryDeleteUploaded(){
	global $GalleryDir, $ThumbsDir;
	if(!isset($_GET['id']) || !isset($_GET['formid']) || !isset($_SESSION['uploadforms'][$_GET['formid']]) || !isset($_SESSION['uploadforms'][$_GET['formid']]['photos'][$_GET['id']])){
		exit("ERROR");
	}
	$photo = $_SESSION['uploadforms'][$_GET['formid']]['photos'][$_GET['id']];
	unlink($GalleryDir.$photo);
	unlink($ThumbsDir.$photo);
	unset($_SESSION['uploadforms'][$_GET['formid']]['photos'][$_GET['id']]);
	exit("OK");
}

function AdminGallerySaveUploaded(){
	global $GalleryDir, $ThumbsDir;
	if(!isset($_GET['formid']) || !isset($_SESSION['uploadforms'][$_GET['formid']])){
		System::admin()->HighlightError('');
		return;
	}
	$formid = $_GET['formid'];
	$form = $_SESSION['uploadforms'][$formid];
	$count_photo = count($form['photos']);

	$cat_id = SafeEnv($form['category'], 11, int);
	$allow_comments = $form['allow_comments'];
	$allow_votes = $form['allow_votes'];
	$view = $form['view'];
	$show = $form['show'];

	if(isset($_POST['submit_cancel'])){ // ,     
		foreach($form['photos'] as $id=>$photo){
			unlink($GalleryDir.$photo);
			unlink($ThumbsDir.$photo);
		}
		unset($_SESSION['uploadforms'][$formid]);
		GO(ADMIN_FILE.'?exe=gallery&a=upload');
	}else{ //     
		$order = AdminGalleryNewOrder($cat_id);
		foreach($form['photos'] as $id=>$photo){
			$photo = SafeEnv($photo, 255, str);
			$title = SafeEnv($_POST['title_'.$id], 255, str);
			$desc = SafeEnv($_POST['description_'.$id], 0, str);
			$author = SafeEnv($_POST['author_'.$id], 50, str);
			$email = SafeEnv($_POST['email_'.$id], 50, str);
			$site = SafeEnv(url($_POST['www_'.$id]), 250, str);
			System::database()->Insert('gallery', "'','$cat_id','".time()."','$title','$desc','$photo','0','$author','$email','$site','$allow_comments','0','$allow_votes','0','0','$view','$show','$order'");
			$order++;
		}
		if($show){
			AdminGalleryGetTree()->CalcFileCounter($cat_id, $count_photo);
		}
		Audit(':  '.count($form['photos']).'       "'.AdminGalleryGetTree()->IdCats[$cat_id]['title'].'"');
		unset($_SESSION['uploadforms'][$formid]);
		AdminGalleryClearBlockCache();
		GO(ADMIN_FILE.'?exe=gallery&cat='.SafeDB($cat_id, 11, int));
	}
}

function AdminGalleryDeleteImage(){ // TODO:       
	global $edit_images, $GalleryDir, $ThumbsDir;
	if(!$edit_images) System::admin()->AccessDenied();
	if(!isset($_GET['id'])){
		GO(ADMIN_FILE.'?exe=gallery');
	}
	$id = SafeEnv($_GET['id'], 11, int);
	System::database()->Select('gallery', "`id`='".$id."'");
	if(System::database()->NumRows() > 0){
		$img = System::database()->FetchRow();
		$filename = $GalleryDir.SafeDB($img['file'], 255, str);
		if(file_exists($filename) && is_file($filename)){
			unlink($filename);
			unlink($ThumbsDir.SafeDB($img['file'], 255, str));
		}
		AdminGalleryGetTree()->CalcFileCounter(SafeDB($img['cat_id'], 11, int), false);
		System::database()->Delete('gallery', "`id`='$id'");
		System::database()->Delete('gallery_comments', "`object_id`='$id'");
		Audit(':   "'.$img['title'].'" (id: '.$img['id'].')');
		AdminGalleryClearBlockCache();
	}
	GoRefererUrl($_REQUEST['back']);
}

function AdminGalleryChangeStatus(){
	global $edit_images;
	if(!$edit_images) System::admin()->AccessDenied();
	if(!isset($_GET['id'])){
		exit("ERROR");
	}
	System::database()->Select('gallery', "`id`='".SafeEnv($_GET['id'], 11, int)."'");
	if(System::database()->NumRows() > 0){
		$img = System::database()->FetchRow();
		if($img['show'] == '1'){
			$en = '0';
			AdminGalleryGetTree()->CalcFileCounter(SafeDB($img['cat_id'], 11, int), false);
		}else{
			$en = '1';
			AdminGalleryGetTree()->CalcFileCounter(SafeDB($img['cat_id'], 11, int), true);
		}
		System::database()->Update('gallery', "`show`='$en'", "`id`='".SafeEnv($_GET['id'], 11, int)."'");
		Audit(':    "'.$img['title'].'" (id: '.$img['id'].')');
		AdminGalleryClearBlockCache();
	}
	exit("OK");
}

function AdminGalleryResetHits(){
	global $edit_images;
	if(!$edit_images) System::admin()->AccessDenied();
	if(isset($_GET['id'])){
		$id = SafeEnv($_GET['id'], 11, int);
		System::database()->Select('gallery', "`id`='".$id."'");
		$img = System::database()->FetchRow();
		System::database()->Update('gallery', "`hits`='0'", "`id`='".$id."'");
		Audit(':     "'.$img['title'].'" (id: '.$img['id'].')');
	}
	GoRefererUrl($_REQUEST['back']);
}

function AdminGalleryThumbRefresh(){
	global $GalleryDir, $ThumbsDir;
	if(!isset($_GET['id'])){
		GO(ADMIN_FILE.'?exe=gallery');
	}
	System::database()->Select('gallery', "`id`='".SafeEnv($_GET['id'], 11, int)."'");
	if(System::database()->NumRows() > 0){
		$img = System::database()->FetchRow();
		$file_name = $img['file'];
		if(is_file($ThumbsDir.$file_name)){
			unlink($ThumbsDir.$file_name);
		}
		CreateThumb($GalleryDir.$file_name, $ThumbsDir.$file_name, System::config('gallery/thumb_max_width'), System::config('gallery/thumb_max_height'));
		Audit(':     "'.$img['title'].'" (id: '.$img['id'].')');
	}
	$back = new Url(GetRefererUrl($_REQUEST['back']));
	$back['update'] = SafeDB($_GET['id'], 11, int); //  /   update
	GO($back);
}

function AdminGalleryMove(){
	global $edit_images;
	if(!$edit_images) System::admin()->AccessDenied();

	$move = SafeEnv($_GET['to'], 4, str); // up, down
	$id = SafeEnv($_GET['id'], 11, int);
	System::database()->Select('gallery', "`id`='$id'");
	if(System::database()->NumRows() > 0){
		$img = System::database()->FetchRow();
		$pid = SafeDB($img['cat_id'], 11, int);
		$images = System::database()->Select('gallery', "`cat_id`='$pid'");
		SortArray($images, 'order');
		$c = count($images);
		// 
		$cur_order = 0;
		for($i = 0; $i < $c; $i++){
			$images[$i]['order'] = $i;
			if($images[$i]['id'] == $id){
				$cur_order = $i;
			}
		}
		// 
		if($move == 'up'){
			$rep_order = $cur_order - 1;
		}elseif($move == 'down'){
			$rep_order = $cur_order + 1;
		}else{
			$rep_order = $cur_order;
		}
		if($rep_order < 0 || $rep_order >= $c){
			$rep_order = $cur_order;
		}
		$temp = intval($images[$cur_order]['order']);
		$images[$cur_order]['order'] = intval($images[$rep_order]['order']);
		$images[$rep_order]['order'] = intval($temp);
		for($i = 0; $i < $c; $i++){
			$order = $images[$i]['order'];
			$id = $images[$i]['id'];
			System::database()->Update('gallery', "`order`='$order'", "`id`='$id'");
		}
		Audit(':   "'.$img['title'].'" (id: '.$img['id'].')');
	}
	System::cache()->Delete('tree', 'gallery');

	$cat = isset($_GET['cat']) ? '&cat='.SafeEnv($_GET['cat'], 11, int) : '';
	$page = isset($_GET['page']) ? '&page='.SafeEnv($_GET['cat'], 11, int) : '';
	GO(ADMIN_FILE.'?exe=gallery'.$cat.$page);
}

function AdminGalleryImageRotate(){
	global $GalleryDir, $ThumbsDir;

	$turn = $_GET['turn'];
	$id = SafeEnv($_GET['id'], 11, int);
	$angle = 0;
	if($turn == 'left'){
		$angle = 90;
	}else{
		$angle = 270;
	}

	System::database()->Select('gallery', "`id`='$id'");
	$img = System::database()->FetchRow();
	$file_name = $img['file'];
	$file = $GalleryDir.$file_name;
	$thumb = $ThumbsDir.$file_name;

	//  
	$pic = new TPicture($file);
	$pic->Rotate($angle);
	$pic->SaveToFile($file);

	//  
	if(is_file($thumb)){
		unlink($thumb);
	}
	CreateThumb($file, $thumb, System::config('gallery/thumb_max_width'), System::config('gallery/thumb_max_height'));
	Audit(':   '.($turn == 'left' ? '' : '').' "'.$img['title'].'" (id: '.$img['id'].')');

	$back = new Url(GetRefererUrl($_REQUEST['back']));
	$back['update'] = SafeDB($_GET['id'], 11, int); //  /   update
	GO($back);
}

function AdminGalleryResetRating(){
	global $edit_images;
	if(!$edit_images) System::admin()->AccessDenied();
	$id = SafeEnv($_GET['id'], 11, int);
	System::database()->Select('gallery', "`id`='$id'");
	$img = System::database()->FetchRow();
	System::database()->Update('gallery', "`num_votes`='0',`sum_votes`='0'", "`id`='$id'");
	Audit(':     "'.$img['title'].'" (id: '.$img['id'].')');
	GoRefererUrl($_REQUEST['back']);
}