<?php

/*
 * LinkorCMS 1.4
 *  2012 LinkorCMS Development Group
 */


if(!defined('VALID_RUN')){
	header("HTTP/1.1 404 Not Found");
	exit;
}

System::admin()->AddSubTitle('');

if(!System::user()->CheckAccess2('messages', 'messages')){
	System::admin()->AccessDenied();
}

if(isset($_GET['a'])){
	$action = $_GET['a'];
}else{
	$action = 'main';
}

TAddToolLink(' ', 'main', 'messages');
TAddToolLink(' ', 'msgeditor', 'messages&a=msgeditor');
TAddToolBox($action);
switch($action){
	case 'main':
		AdminSiteMessagesMain();
		break;
	case 'msgeditor':
		AdminSiteMessagesEditor();
		break;
	case 'save':
		AdminSiteMessagesSave();
		break;
	case 'delete':
		AdminSiteMessagesDelete();
		break;
	case 'changestatus':
		AdminSiteMessagesChangeStatus();
		break;
}

function AdminSiteMessagesMain(){
	System::database()->Select('messages', '');
	$text = '<table cellspacing="0" cellpadding="0" class="cfgtable">';
	$text .= '<tr><th></th><th> </th><th> </th><th></th><th></th></tr>';
	while($msg = System::database()->FetchRow()){
		$mid = SafeDB($msg['id'], 11, int);
		$st = System::admin()->SpeedStatus('.', '.', ADMIN_FILE.'?exe=messages&a=changestatus&id='.$mid, $msg['active'] == '1');
		$resettime = '';
		if($msg['expire'] != '0'){
			$total = TotalTime(time(), SafeDB($msg['date'], 11, int) + (Day2Sec * SafeDB($msg['expire'], 11, int)));
			if($total['days'] > 0 || $total['hours'] > 0){
				if($total['days'] > 0){
					$resettime .= $total['sdays'];
					if($total['hours'] > 0){
						$resettime .= '  ';
					}
				}
				if($total['hours'] > 0){
					$resettime .= $total['shours'];
				}
			}else{
				$resettime = ' ';
			}
		}else{
			$resettime = '';
		}

		$func = '';
		$func .= SpeedButton('', ADMIN_FILE.'?exe=messages&a=msgeditor&id='.$mid, 'images/admin/edit.png');
		$func .= System::admin()->SpeedConfirm('', ADMIN_FILE.'?exe=messages&a=delete&id='.$mid.'&ok=0', 'images/admin/delete.png', ' ?');

		$text .= '<tr><td><b>'.System::admin()->Link(SafeDB($msg['title'], 250, str), ADMIN_FILE.'?exe=messages&a=msgeditor&id='.$mid).'</b></td>
		<td>'.$resettime.'</td>
		<td>'.ViewLevelToStr(SafeDB($msg['view'], 1, int)).'</td>
		<td>'.$st.'</td>
		<td>'.$func.'</td>
		</tr>';
	}
	$text .= '</table>';
	AddTextBox(' ', $text);
}

function AdminSiteMessagesEditor(){
	$title = '';
	$text = '';
	$showin = array('ALL_EXCEPT');
	$extrauri = array();
	$time = '0';

	$view = 4;
	$enabled = 1;

	$view_title = array(false, false);
	$position = array(false, false);

	$resettime = '';
	if(!isset($_GET['id'])){
		$view_title[1] = true;
		$position[1] = true;
		$url = '';
		$btitle = ' ';
		$method = '';
		$a = 'add';
	}else{
		$id = SafeEnv($_GET['id'], 11, int);
		System::database()->Select('messages', "`id`='$id'");
		$msg = System::database()->FetchRow();
		$title = SafeDB($msg['title'], 250, str);
		$text = SafeDB($msg['text'], 0, str, false);
		$time = SafeDB($msg['expire'], 11, int);
		if($time != '0'){
			$total = TotalTime(time(), SafeDB($msg['date'], 11, int) + (Day2Sec * SafeDB($msg['expire'], 11, int)));
			$resettime = '  '.$total['sdays'].'  '.$total['shours'];
		}
		$showin = unserialize($msg['showin']);
		$extrauri = unserialize($msg['showin_uri']);
		$view_title[SafeDB($msg['view_title'], 1, int)] = true;
		$position[SafeDB($msg['position'], 1, int)] = true;
		$view = SafeDB($msg['view'], 1, int);
		$enabled = SafeDB($msg['active'], 1, int);
		$url = '&id='.$id;
		$btitle = ' ';
		$method = ' ';
		$a = 'edit';
	}

	FormRow('', System::site()->Edit('title', $title, false, 'maxlength="250" style="width:400px;" class="autofocus"'));
	FormRow(' ', System::site()->Radio('vtitle', 'on', $view_title[1]).'&nbsp;'.System::site()->Radio('vtitle', 'off', $view_title[0]).'');
	FormTextRow(' ', System::site()->HtmlEditor('text', $text, 625, 300));
	FormRow('&nbsp;:<br /><small> (0 - )</small>', System::site()->Edit('time', $time, false, 'maxlength="3" style="width:40px;"').$resettime);
	if($a == 'edit'){
		FormRow(' ', System::site()->Check('resettime', '1', false));
	}

	VisibilityConditionsAdmin($showin, $extrauri);

	System::site()->DataAdd($posd, 'top', '', $position[1]);
	System::site()->DataAdd($posd, 'bottom', '', $position[0]);
	FormRow('', System::site()->Select('position', $posd));

	FormRow(' ', System::site()->Select('view', GetUserTypesFormData($view)));
	FormRow('', System::site()->Select('enabled', GetEnData($enabled)));

	AddCenterBox($btitle);
	AddForm('<form action="'.ADMIN_FILE.'?exe=messages&a=save'.$url.'" method="post">', System::site()->Button('', 'onclick="history.go(-1)"').System::site()->Submit($method));
}

function AdminSiteMessagesSave(){
	$title = SafeEnv($_POST['title'], 250, str);
	$view_title = EnToInt($_POST['vtitle']);
	$text = SafeEnv($_POST['text'], 0, str);
	$time = SafeEnv($_POST['time'], 3, int);
	$date = time();

	$view = ViewLevelToInt($_POST['view']);
	$active = EnToInt($_POST['enabled']);

	switch($_POST['position']){
		case 'top':
			$pos = '1';
			break;
		case 'bottom':
			$pos = '0';
			break;
		default:
			$pos = '1';
	}

	VisibilityConditionsAdminSave($showin, $extra_uri);

	//      
	if(!isset($_GET['id'])){
		$vals = "'','$title','$text','$date','$time','$showin','$extra_uri','$pos','$view_title','$view','$active'";
		System::database()->Insert('messages', $vals);
		Audit(':    "'.$title.'"');
	}else{
		$id = SafeEnv($_GET['id'], 11, int);
		if(!isset($_POST['resettime'])){
			System::database()->Select('messages', "`id`='$id'");
			if(System::database()->NumRows() > 0){
				$msg = System::database()->FetchRow();
				$date = $msg['date'];
			}else{
				$date = time();
			}
		}
		$vals = "'','$title','$text','$date','$time','$showin','$extra_uri','$pos','$view_title','$view','$active'";
		System::database()->Update('messages', $vals, "`id`='$id'", true);
		Audit(':   "'.$title.'"');
	}
	GO(ADMIN_FILE.'?exe=messages');
}

function AdminSiteMessagesDelete(){
	if(!isset($_GET['id'])){
		GO(ADMIN_FILE.'?exe=messages');
	}
	$msg_id = SafeEnv($_GET['id'], 11, int);
	System::database()->Select('messages', "`id`='$msg_id'");
	$message = System::database()->FetchRow();
	System::database()->Delete('messages', "`id`='$msg_id'");
	Audit(':   "'.$message['title'].'"');
	GO(ADMIN_FILE.'?exe=messages');
}

function AdminSiteMessagesChangeStatus(){
	$msg_id = SafeEnv($_GET['id'], 11, int);
	System::database()->Select('messages', "`id`='$msg_id'");
	if(System::database()->NumRows() > 0){
		$message = System::database()->FetchRow();
		if($message['active'] == 1){
			$en = '0';
		}else{
			$en = '1';
		}
		System::database()->Update('messages', "active='$en'", "`id`='$msg_id'");
		Audit(':    "'.$message['title'].'"');
	}
	if(IsAjax()){
		exit("OK");
	}
	GO(ADMIN_FILE.'?exe=messages');
}
