<?php

/*
 * LinkorCMS 1.4
 *  2012 LinkorCMS Development Group
 */

//  .

if(!defined('VALID_RUN')){
	header("HTTP/1.1 404 Not Found");
	exit;
}

System::admin()->AddSubTitle('');

if(!System::user()->CheckAccess2('polls', 'polls')){
	System::admin()->AccessDenied();
}

// 
global $editpolls, $editconf;
$editpolls = System::user()->CheckAccess2('polls', 'edit');
$editconf = System::user()->CheckAccess2('polls', 'config');

if(isset($_GET['a'])){
	$action = $_GET['a'];
}else{
	$action = 'main';
}

// 
if($editconf || $editpolls){
	TAddToolLink('', 'main', 'polls');
}
if($editpolls){
	TAddToolLink(' ', 'editor', 'polls&a=editor');
}
if($editconf){
	TAddToolLink('', 'config', 'polls&a=config');
}
TAddToolBox($action);
//

switch($action){
	case 'main': AdminPollsMainFunc();
		break;
	case 'editor': AdminPollsEditor();
		break;
	case 'save': AdminPollsSave();
		break;
	case 'delete': AdminPollsDelete();
		break;
	case 'changestatus': AdminPollsChangeStatus();
		break;
	case 'config':
		if(!$editconf){
			System::admin()->AccessDenied();
		}
		System::admin()->AddCenterBox('  ""');
		if(isset($_GET['saveok'])){
			System::admin()->Highlight(' .');
		}
		System::admin()->ConfigGroups('polls');
		System::admin()->AddConfigsForm(ADMIN_FILE.'?exe=polls&a=configsave');
		break;
	case 'configsave':
		if(!$editconf){
			System::admin()->AccessDenied();
		}
		System::admin()->SaveConfigs('polls');
		Audit(':   ');
		GO(ADMIN_FILE.'?exe=polls&a=config&saveok');
		break;
	default: AdminPollsMainFunc();
}

function AdminPollsMainFunc(){
	global $editpolls;
	$polls = System::database()->Select('polls');
	$text = '<table cellspacing="0" cellpadding="0" class="cfgtable"><tr>';
	$text .= '<th></th><th> </th><th></th><th></th><th></th><th></th></tr>';
	foreach($polls as $poll){
		$pid = SafeDB($poll['id'], 11, int);
		if($poll['active'] == '1'){
			$active = '<font color="#008000">.</font></a>';
		}else{
			$active = '<font color="#FF0000">.</font>';
		}
		if($editpolls){
			$active = System::admin()->SpeedStatus('.', '.', ADMIN_FILE.'?exe=polls&a=changestatus&id='.$pid, $poll['active'] == '1');
		}
		$answers = unserialize($poll['answers']);
		$c = count($answers);
		$num_voices = 0;
		for($i = 0; $i < $c; $i++){
			$num_voices += SafeDB($answers[$i][2], 11, int);
		}

		$link_go = Ufu('index.php?name=polls&op=viewpoll&poll_id='.$pid, 'polls/{poll_id}/');

		$func = '';
		$func .= System::admin()->SpeedButton('    ', $link_go, 'images/link_go.png', false, false, 'target="_blank"');
		if($editpolls){
			$func .= System::admin()->SpeedButton('', ADMIN_FILE.'?exe=polls&a=editor&id='.$pid, 'images/admin/edit.png');
			$func .= System::admin()->SpeedConfirm('', ADMIN_FILE.'?exe=polls&a=delete&id='.$pid, 'images/admin/delete.png', ' ?');
		}
		$text .= Indent('
		<tr>
			<td>
				<b>'.System::admin()->Link(SafeDB($poll['question'], 255, str), ADMIN_FILE.'?exe=polls&a=editor&id='.$pid).'</b></td>
			<td>'.$num_voices.'</td>
			<td>'.SafeDB($poll['com_counter'], 11, int).'</td>
			<td>'.ViewLevelToStr($poll['view']).'</td>
			<td>'.$active.'</td>
			<td>'.$func.'</td>
		</tr>
		');
	}
	$text .= '</table>';
	AddTextBox('', $text);
}

function AdminPollsEditor(){
	global $editpolls;
	if(!$editpolls){
		System::admin()->AccessDenied();
	}
	$view = 4;
	$answers = array();
	if(isset($_GET['id'])){ //
		$title = ' ';
		$btitle = ' ';
		$id = SafeEnv($_GET['id'], 11, int);
		System::database()->Select('polls', "`id`='$id'");
		$p = System::database()->FetchRow();
		$poll = SafeDB($p['question'], 255, str);
		$desc = SafeDB($p['description'], 255, str);
		$showinblock = SafeDB($p['showinblock'], 1, int);
		$multianswers = SafeDB($p['multianswers'], 1, int);
		//
		$answers = unserialize($p['answers']);
		$allow_comments = SafeDB($p['allow_comments'], 1, int);
		$active = $p['active'];
		$view = SafeDB($p['view'], 1, int);
		$uid = '&id='.$id;
	}else{ //
		$title = ' ';
		$btitle = '';
		$poll = '';
		$desc = '';
		$showinblock = true;
		$multianswers = false;
		$answers[] = array('  1', '', '0');
		$answers[] = array('  2', '', '0');
		$allow_comments = true;
		$active = true;
		$uid = '';
	}
	FormRow('', System::site()->Edit('poll', $poll, false, 'maxlength="250" style="width:400px;" class="autofocus"'));
	FormRow('', System::site()->Edit('desc', $desc, false, 'maxlength="250" style="width:400px;"'));
	FormRow('  ', System::site()->Select('showinblock', GetEnData($showinblock, '', '')));
	FormRow('', System::site()->Select('multianswers', GetEnData($multianswers, '', '')));

	$answers_js = '';
	foreach($answers as $answer){
		$answers_js .= ",['".HtmlChars($answer[0], ENT_QUOTES)."', '".HtmlChars($answer[1], ENT_QUOTES)."', ".SafeDB($answer[2], 11, int)."]";
	}
	$answers_js = '['.substr($answers_js, 1).']';

	//     
	System::admin()->AddOnLoadJS(Indent('
		if(!("map" in Array.prototype)) Array.prototype.map = function(mapper, that){
			var other = new Array(this.length);
			for(var i=0, n=this.length; i<n; i++){
				if(i in this){
					other[i] = mapper.call(that, this[i], i, this);
				}
			}
			return other;
		};

		answersdata = '.$answers_js.';

		tableAddRow = function(answer, color, voices){
			var tr = $("<tr>");
			var answerinput = $("<input>", {type: "text", name: "answer[]", "class": "fd_answer"}).val(answer).css("width", "400px");
			$("<td>").append(answerinput).appendTo(tr);
			$("<td>").append($("<input>", {type: "text", name: "color[]", "class": "fd_color"}).val(color).css("width", "80px")).appendTo(tr);
			$("<td>").append($("<input>", {type: "text", name: "voices[]", "class": "fd_voices"}).val(voices).css("width", "50px").css("text-align", "right")).appendTo(tr);

			var td_delete = $("<td>").appendTo(tr);
			$("<a>", {"class": "button", html: "<img src=\"images/admin/delete.png\">", href: "#", title: ""}).click(function(){
				tr.remove();
				return false;
			}).appendTo(td_delete);

			tr.appendTo($("#answers_table tbody"));
			answerinput.focus();
		};

		AddPollAnswer = function(){
			tableAddRow("", "", "0");
		};

		answersdata.map(function(item){
			tableAddRow(item[0], item[1], item[2]);
		});

		$("#answers_table tbody").sortable();
	'));

	FormRow('', Indent('
		<table cellspacing="0" cellpadding="0" class="cfgtable" id="answers_table">
			<thead>
				<tr>
					<th style="width: 400px;"></th>
					<th style="width: 80px;"></th>
					<th style="width: 50px;"></th>
					<th style="width: 40px;">&nbsp;</th>
				</tr>
			</thead>
			<tbody></tbody>
		</table>
		<div style="float: right;">'.System::admin()->SpeedConfirmJs(' ', 'AddPollAnswer();', 'images/admin/plus.png', '', true).'</div>
	'));

	FormRow(' ', System::site()->Select('allow_comments', GetEnData($allow_comments, '', '')));
	FormRow('', System::site()->Select('active', GetEnData($active, '', '')));
	FormRow('  ', System::site()->Select('view', GetUserTypesFormData($view)));
	AddCenterBox($title);
	AddForm('<form action="'.ADMIN_FILE.'?exe=polls&a=save'.$uid.'" method="post">', System::site()->Button('', 'onclick="history.go(-1)"').System::site()->Submit($btitle));
}

function AdminPollsSave(){
	global $editpolls;
	if(!$editpolls){
		System::admin()->AccessDenied();
	}
	$poll = SafeEnv($_POST['poll'], 255, str);
	$desc = SafeEnv($_POST['desc'], 255, str);
	$showinblock = EnToInt($_POST['showinblock']);
	$multianswers = EnToInt($_POST['multianswers']);
	$allow_comments = EnToInt($_POST['allow_comments']);
	$active = EnToInt($_POST['active']);
	$view = ViewLevelToInt($_POST['view']);

	// 
	$answer = SafeEnv($_POST['answer'], 255, str);
	$color = SafeEnv($_POST['color'], 8, str);
	$voices = SafeEnv($_POST['voices'], 11, int);
	$cnt = count($answer);
	$answers = array();
	for($i = 0; $i < $cnt; $i++){
		$answers[] = array($answer[$i], $color[$i], $voices[$i]);
	}
	$answers = serialize($answers);
	$answers = SafeEnv($answers, 0, str, false, true, false);

	if(isset($_GET['id'])){ //
		$set = "`question`='$poll',`description`='$desc',`multianswers`='$multianswers',`answers`='$answers',`showinblock`='$showinblock',`allow_comments`='$allow_comments',`view`='$view',`active`='$active'";
		$poll_id = SafeEnv($_GET['id'], 11, int);
		System::database()->Update('polls', $set, "`id`='$poll_id'");
		Audit(':   "'.$poll.'"');
	}else{ // 
		$vals = Values('', $poll, $desc, time(), $multianswers, $answers, $showinblock, $allow_comments, '0', $view, $active);
		System::database()->Insert('polls', $vals);
		Audit(':   "'.$poll.'"');
	}
	GO(ADMIN_FILE.'?exe=polls');
}

//  
function AdminPollsDelete(){
	global $editpolls;
	if(!$editpolls){
		System::admin()->AccessDenied();
	}
	if(!isset($_GET['id'])){
		GO(ADMIN_FILE.'?exe=polls');
	}
	$id = SafeEnv($_GET['id'], 11, int);
	System::database()->Select('polls', "`id`='$id'");
	$poll = System::database()->FetchRow();
	System::database()->Delete('polls', "`id`='$id'");
	System::database()->Delete('polls_comments', "`object_id`='$id'");
	Audit(':   "'.$poll['question'].'"');
	GO(ADMIN_FILE.'?exe=polls');
}

//  
function AdminPollsChangeStatus(){
	global $editpolls;
	if(!$editpolls){
		System::admin()->AccessDenied();
	}
	$id = SafeEnv($_GET['id'], 11, int);
	System::database()->Select('polls', "`id`='$id'");
	$poll = System::database()->FetchRow();
	if($poll['active'] == '1'){
		$en = '0';
	}else{
		$en = '1';
	}
	System::database()->Update('polls', "active='$en'", "`id`='$id'");
	Audit(':    "'.$poll['question'].'"');
	if(IsAjax()){
		exit("OK");
	}else{
		GO(ADMIN_FILE.'?exe=polls');
	}
}
