<?php

/*
 * LinkorCMS 1.4
 *  2012 LinkorCMS Development Group
 */


if(!defined('VALID_RUN')){
	header("HTTP/1.1 404 Not Found");
	exit;
}

define('MOD_UPDATE', true);

if(!System::user()->isSuperUser()){
	System::admin()->AccessDenied();
}

global $updates_folder, $autoupdate_to;
$action         = isset($_GET['a']) ? $_GET['a'] : 'main';
$updates_folder = 'uploads/updates/';
$autoupdate_to  = '';

switch($action){
	case 'main':
		AdminUpdateMain();
		break;
	case 'upload':
		AdminUpdateCheck();
		break;
	case 'apply':
		AdminUpdateApply();
		break;
	case 'autoupdate':
		if(isset($_GET['v'])){
			$autoupdate_to = $_GET['v'];
			include('config/autoupdate.php');

			//  
			System::cache()->ClearAll();
		}
		break;
}

/*
 *  .   .
 */
function AdminUpdateMain(){
	global $updates_folder;
	System::admin()->AddCenterBox(' ');
	System::admin()->FormTitleRow('   ');
	$update_files = GetFiles($updates_folder, false, true, '.zip');

	$update_files_data = array();
	foreach($update_files as $file){
		$zip = new ZipArchive();
		if($zip->open($updates_folder.$file) !== true){
			$metadata = JsonDecode($zip->getFromName('metadata'));
			if(isset($metadata)
				&& isset($metadata['type']) && $metadata['type'] == 'update'
				&& isset($metadata['from_version']) && $metadata['from_version'] == CMS_VERSION
			){
				System::site()->DataAdd($update_files_data, $file, $file);
			}
		}
	}
	if(count($update_files_data) > 0){
		System::admin()->FormRow('   ', System::site()->Select('select_file', $update_files_data));
	}
	System::admin()->FormRow(' ', System::site()->FFile('upload_file'));
	System::admin()->AddForm(System::admin()->FormOpen(ADMIN_FILE.'?exe=update&a=upload', 'post', true), System::admin()->Submit(''));
}

/*
 *  ,         .
 */
function AdminUpdateCheck(){
	global $updates_folder;

	$selected_file = ''; //    

	//      
	if(!isset($_FILES['upload_file'])){
		System::admin()->AddCenterBox('');
		System::admin()->HighlightError(' .');
		return;
	}
	$uploaded_file = $_FILES['upload_file']; //  

	//   
	if($uploaded_file['error'] != 4){
		if($uploaded_file['error'] != 0){
			System::admin()->AddTextBox('', '   .  : '.$_FILES['upload_file'].'.');
			return;
		}
		if(!is_writable($updates_folder)){
			System::admin()->AddCenterBox('');
			System::admin()->HighlightError(' "'.SafeDB($updates_folder, 255, str).'"    .    .');
		} else{
			if(is_file($uploaded_file['tmp_name'])){ //   
				//        updates
				if(strtolower(GetFileExt($_FILES['upload_file']['name'])) == '.zip'){
					$selected_file = $updates_folder.$_FILES['upload_file']['name'];
					copy($_FILES['upload_file']['tmp_name'], $selected_file);
					Audit(' :    "'.$selected_file.'"');
				} else{
					System::admin()->AddCenterBox('');
					System::admin()->HighlightError('   ZIP .');
				}
			}
		}
	} else{
		//     
		if(isset($_POST['select_file'])){
			$selected_file = $updates_folder.$_POST['select_file'];
		} else{
			System::admin()->AddCenterBox('');
			System::admin()->HighlightError('   .');
			return;
		}
	}

	//  select_file,     
	$zip = new ZipArchive();
	if($zip->open($selected_file) !== true){
		System::admin()->AddCenterBox('');
		System::admin()->HighlightError('    ,   .');
		return;
	}
	//  
	$metadata = $zip->getFromName('metadata');
	$metadata = JsonDecode($metadata);
	if(!isset($metadata)
		|| !isset($metadata['product']) || $metadata['product'] != CMS_UPDATE_PRODUCT
		|| !isset($metadata['type']) || $metadata['type'] != 'update'
		|| !isset($metadata['from_version']) || $metadata['from_version'] != CMS_VERSION
		|| !isset($metadata['to_version']) || !isset($metadata['changelog'])
	){
		System::admin()->AddCenterBox('');
		System::admin()->HighlightError('           .');
		return;
	}

	System::admin()->AddCenterBox('  '.SafeDB($metadata['from_version'], 20, str).'  '.SafeDB($metadata['to_version'], 20, str));

	UseLib('markdown');
	$md = new Markdown();
	$metadata['changelog'] = $md->transform(SafeDB($metadata['changelog'], 0, str, false));

	//      
	$update_files = '<h2> :</h2><ul>';
	$numFiles     = $zip->numFiles;
	$create       = false;
	$reason       = '';
	$create_dirs  = array();
	$errors       = false;
	for($i = 0; $i < $numFiles; $i++){
		$reason = '';
		$fn     = $zip->getNameIndex($i);
		if($fn == 'metadata'){
			continue;
		}
		if(substr($fn, -1) != '/'){ // 
			if(is_file($fn)){ // 
				$create = is_writable($fn);
				$reason = '   ';
			} else{
				$fn_path = GetPathName($fn, false);
				if(isset($create_dirs[$fn_path.'/'])){
					$create = $create_dirs[$fn_path.'/'];
					$reason = '   '.$fn_path.'';
				} else{
					$create = is_writable($fn_path);
					$reason = '      '.$fn_path.'';
				}
			}
		} else{ // 
			$create           = IsPossiblyCreated($fn);
			$create_dirs[$fn] = $create;
			$reason           = ' ,    ';
		}
		if($create){
			$update_files .= '<li>'.SafeDB($fn, 255, str).'</li>';
		} else{
			$update_files .= '<li style="color: red;">'.SafeDB($fn, 255, str).' ('.$reason.')</li>';
			$errors = true;
		}
	}
	$update_files .= '</ul>';
	$zip->close();

	//  
	System::site()->AddOnLoadJS(Indent('
		AdminUpdateShowChangelog = function(){
			$("#update_changelog").show();
			$("#update_files").hide();
		}
		AdminUpdateShowFiles = function(){
			$("#update_files").show();
			$("#update_changelog").hide();
		}
	'));

	if($errors){
		System::admin()->HighlightError('     .       .<br>');
	} else{
		System::admin()->Highlight('  ,   ""   .');
	}

	$html = '
		<div style="margin: 10px 0 10px;">
			<a href="#" onclick="AdminUpdateShowChangelog(); return false;" class="button"> </a>
			<a href="#" onclick="AdminUpdateShowFiles(); return false;" class="button"> </a>
			'.($errors ? '' : System::admin()->SpeedButton('', ADMIN_FILE.'?exe=update&a=apply&file='.GetFileName($selected_file), '', true, true)).'
		</div>
		<div id="update_changelog" style="'.($errors ? 'display: none;' : '').'">'.$metadata['changelog'].'</div>
		<div id="update_files" style="'.($errors ? '' : 'display: none;').'">'.$update_files.'</div>
';
	System::admin()->AddText($html);
}

/*
 *  .
 */
function AdminUpdateApply(){
	global $updates_folder, $autoupdate_to;
	//  ,  ,    .
	$update_file = RealPath2($updates_folder.$_GET['file']);
	if(!is_file($update_file)){
		System::admin()->AddCenterBox('');
		System::admin()->HighlightError('   .');
		return;
	}
	$zip = new ZipArchive();
	$zip->open($update_file);

	$metadata = JsonDecode($zip->getFromName('metadata'));
	if(!isset($metadata)
		|| !isset($metadata['product']) || $metadata['product'] != CMS_UPDATE_PRODUCT
		|| !isset($metadata['type']) || $metadata['type'] != 'update'
		|| !isset($metadata['from_version']) || $metadata['from_version'] != CMS_VERSION
		|| !isset($metadata['to_version']) || !isset($metadata['changelog'])
	){
		System::admin()->AddCenterBox('');
		System::admin()->HighlightError('           .');
		return;
	}

	$errors = array();

	$numFiles = $zip->numFiles;
	for($i = 0; $i < $numFiles; $i++){
		$fn = $zip->getNameIndex($i);
		if($fn == 'metadata'){
			continue;
		}
		if(substr($fn, -1) != '/'){ // 
			$content = $zip->getFromIndex($i);
			if(is_file($fn)){
				$r = file_put_contents($fn, $content);
				if($r === false){
					$errors[] = '    '.$r;
				}
			} else{
				$r = file_put_contents($fn, $content);
				if($r !== false){
					chmod($fn, 0666);
				} else{
					$errors[] = '    '.$r;
				}
			}
		} else{ // 
			if(!is_dir($fn)){
				$r = MkDirRecursive($fn);
				if($r === false){
					$errors[] = '    '.$r;
				}
			}
		}
	}
	$zip->close();

	if(count($errors) == 0){
		// 
		$autoupdate_to = $metadata['to_version'];
		Audit(' :      '.$autoupdate_to);
		include('config/autoupdate.php');

		//  
		System::cache()->ClearAll();

		System::admin()->AddCenterBox(' ');
		System::admin()->Highlight('  ,     '.SafeDB($metadata['to_version'], 20, str).'.');
		Audit(' :   ,      "'.$autoupdate_to.'"');
	} else{
		System::admin()->AddCenterBox('   ');
		System::admin()->HighlightError(implode("<br>\n", $errors));
	}
}