<?php

	if(!defined('VALID_RUN')){
		header("HTTP/1.1 404 Not Found");
		exit;
	}

	if(!isset($static_data['ace_index'])){
		$static_data['ace_index'] = 0;
	}
	$static_data['ace_index']++;

	/*
	 * ,         UseScript();
	 */
	$id = ''; // id       ,   ,     
	$var = 'AceEditor'.$static_data['ace_index']; //     javascript
	$softwraps = 'false'; //   
	$wordwrap = 'false'; //  
	$highlightline = 'false'; //   
	$printmargin = 'true'; //   
	$tabsize = '4'; //  
	$mode = ''; //  
	$theme = ''; //  

	/* mode = (c_cpp, clojure, coffee, coldfusion, csharp, css, groovy, haxe, html, java, latex, lua, markdown, ocaml, perl, pgsql, php,
	 * powershell, python, ruby, scad, scala, scss, sql, svg, text, textile, xml)
	 */

	/* theme = (chrome, clouds, clouds_midnight, cobalt, crimson_editor, dawn, dreamweaver, eclipse, idle_fingers, kr_theme,
	 * merbivore, merbivore_soft, mono_industrial, monokai, pastel_on_dark, solarized_dark, solarized_light, tomorrow,
	 * tomorrow_night, tomorrow_night_blue, tomorrow_night_bright, tomorrow_night_eighters, twilight)
	 */

	extract($params, EXTR_OVERWRITE);

	//  ace.js
	ScriptsAddJs('ace/src/ace');

	if($id != ''){
		UseScript('jquery');
		System::site()->AddOnLoadJS(<<<JS
			var aceel = $("#$id");
			var aceeldom = aceel.get(0);
			if(aceeldom.nodeName.toLowerCase() == "textarea"){
				var ecediv = $("<div>", {id: "{$id}_replace"}).css({"position": "relative"}).insertBefore(aceel);
				var style;
				var dest = {};
				if(window.getComputedStyle){
					style = window.getComputedStyle(aceeldom, null);
					dest["width"] = style.getPropertyValue("width");
					dest["height"] = style.getPropertyValue("height");
				}else if(style = aceeldom.currentStyle){
					dest["width"] = style["width"];
					dest["height"] = style["height"];
				}else if(style = aceeldom.style){
					dest["width"] = style["width"];
					dest["height"] = style["height"];
				}
				aceel.hide();
				ecediv.css(dest);
				var $var = ace.edit("{$id}_replace");
				$var.getSession().setValue(aceeldom.defaultValue);
				$var.getSession().on('change', function(){
					aceel.val($var.getSession().getValue());
				});
			}else{
				var $var = ace.edit("$id");
			}
			$var.getSession().setUseSoftTabs($softwraps);
			$var.getSession().setUseWrapMode($wordwrap);
			$var.setHighlightActiveLine($highlightline);
			$var.setShowPrintMargin($printmargin);
			$var.getSession().setTabSize($tabsize);
			aceel.val($var.getSession().getValue());
JS
		);
	}
	ScriptsAddCss('ace/theme');

	if(isset($params['theme']) && $params['theme'] != 'textmate'){
		ScriptsAddJs('ace/src/theme-'.$params['theme']);
		System::site()->AddOnLoadJS($var.'.setTheme("ace/theme/'.$params['theme'].'");');
	}

	if(isset($params['mode'])){
		ScriptsAddJs('ace/src/mode-'.$params['mode']);
		System::site()->AddOnLoadJS('var Mode = require("ace/mode/'.$params['mode'].'").Mode;');
		System::site()->AddOnLoadJS($var.'.getSession().setMode(new Mode());');
	}

	return $var;
