<?php

/*
 * LinkorCMS 1.4
 *  2012 LinkorCMS Development Group
 */


if(!defined('VALID_RUN')){
	header("HTTP/1.1 404 Not Found");
	exit;
}

function ShowTables(){
	global $default_prefix, $info_ext, $bases_path;
	$dir = opendir($bases_path);
	$i = -1;
	$tables = array();
	while($file = readdir($dir)){
		$i++;
		$epos = strpos($file, $info_ext);
		if(!($epos === false)){
			$tname = substr($file, 0, $epos);
			$tables[] = substr($tname, strlen($default_prefix) + 1);
		}
	}
	return $tables;
}

if(isset($_GET['p'])){
	$p = SafeEnv($_GET['p'], 1, int);
}else{
	$p = 1;
}

switch($p){
	case 1: //    
		global $default_prefix, $config;
		$this->SetTitle(_STEP4_2);
		$db_host = System::user()->Session('db_host');
		$db_name = System::user()->Session('db_name');
		$db_pref = System::user()->Session('db_pref');
		if(System::user()->Session('db_init')){
			$db_exdel = System::user()->Session('db_exdel');
		}else{
			$db_exdel = true;
		}
		$this->OpenForm('flatfilesdb_setup&p=2');
		$text = Indent('4/
			<table width="80%" align="center">
				<tr>
					<td>   ( ):</td>
					<td><input type="text" name="db_host" value="'.($db_host ? $db_host : 'db/').'"></td>
				</tr>
				<tr>
					<td>'._SQLCONF_4.' (  ):</td>
					<td><input type="text" name="db_name" value="'.($db_name ? $db_name : 'linkorcmsdb').'"></td>
				</tr>
				<tr>
					<td>'._SQLCONF_5.':</td>
					<td><input type="text" name="db_pref" value="'.($db_pref ? $db_pref : $default_prefix).'"></td>
				</tr>
				<tr>
					<td>'._DROP_TABLE_EX.':</td>
					<td><input type="checkbox" name="exdel" value="1"'.($db_exdel ? ' checked' : '').'></td>
				</tr>
			</table>
		');
		$this->SetContent($text);
		$this->AddButton('', 'install&p=2');
		$this->AddSubmitButton(' ');
		break;
	case 2: //    
		global $config;
		$ok = '<img src="images/admin/accept.png" alt="">';
		$fail = '<img src="images/admin/delete.png" alt="">';

		$db_host = SafeEnv($_POST['db_host'], 250, str);
		$db_name = SafeEnv($_POST['db_name'], 250, str);
		$db_pref = SafeEnv($_POST['db_pref'], 250, str);

		//     
		System::user()->Session('db_host', $db_host);
		System::user()->Session('db_name', $db_name);
		System::user()->Session('db_pref', $db_pref);
		System::user()->Session('db_exdel', isset($_POST['exdel']));
		System::user()->Session('db_init', true);

		// 
		$have_errors = false;
		$text = '<table width="80%" align="center">';
		// db_host   
		$text .= '<tr><td> "'.$db_host.'"   :</td>';
		if(is_writable($db_host)){
			$text .= '<td>'.$ok.'</td></tr>';
		}else{
			$text .= '<td>'.$fail.'</td></tr>';
			$text .= '<tr><td colspan="2">    .</td></tr>';
			$have_errors = true;
		}
		//  db_config.php
		$db_config = $config['config_dir'].'db_config.php';
		if(is_file($db_config)){ //   (     )
			$text .= '<tr><td> "'.$db_config.'"   :</td>';
			if(is_writable($db_config)){
				$text .= '<td>'.$ok.'</td></tr>';
			}else{
				$text .= '<td>'.$fail.'</td></tr>';
				$text .= '<tr><td colspan="2">       (0666  0777).</td></tr>';
				$have_errors = true;
			}
		}else{
			$text .= '<tr><td> "'.$config['config_dir'].'"   :</td>';
			if(is_writable($config['config_dir'])){
				$text .= '<td>'.$ok.'</td></tr>';
			}else{
				$text .= '<td>'.$fail.'</td></tr>';
				$text .= '<tr><td colspan="2">  777   .</td></tr>';
				$have_errors = true;
			}
		}
		$text .= '</table>';

		if($have_errors){
			$this->SetTitle(" ");
			$this->SetContent($text);
			$this->AddButton('', 'flatfilesdb_setup&p=1');
			//$this->AddSubmitButton(' ');
		}else{
			//  ,        
			$filename = $config['config_dir'].'db_config.php';
			WriteConfigFile($filename, 'FilesDB', $db_host, '', '', $db_name, $db_pref, CMS_VERSION);
			$saltfile = $config['config_dir'].'salt.php';
			if(!is_file($saltfile) || is_writable($saltfile)){
				WriteSaltFile($saltfile);
			}
			GO('setup.php?mod=flatfilesdb_setup&p=4'.(isset($_POST['exdel']) ? '&exdel='.$_POST['exdel'] : ''));
		}
		break;
	case 4: //   
		global $config, $default_prefix, $info_ext, $data_ext, $bases_path;
		//   ,     
		$delete_ex = isset($_GET['exdel']);

		$this->SetTitle(_FDB_CREATE);

		if(!System::database()->Connected){
			$this->SetContent("<html>\n<head>\n\t<title>!!!!!!</title>\n</head>\n<body>\n<p align=\"center\">   . ,    .</p>\n</body>\n</html>");
		}else{
			System::database()->CreateDbIfNotExists($config['db_name'], false);
			System::database()->SelectDb($config['db_name']);
			$tables = ShowTables();
			$prefix = System::database()->Prefix();
			foreach($tables as $table){
				$info = $bases_path.$default_prefix.'_'.$table.$info_ext;
				$info2 = $config['db_host'].$config['db_name'].'/'.$prefix.$table.$info_ext;
				$data = $bases_path.$default_prefix.'_'.$table.$data_ext;
				$data2 = $config['db_host'].$config['db_name'].'/'.$prefix.$table.$data_ext;
				if($delete_ex && is_file($info2)){
					unlink($info2);
					unlink($data2);
				}
				if(!is_file($info2)){
					copy($info, $info2);
					copy($data, $data2);
				}
			}
			$this->SetContent(Indent('
				<h2 class="title" align="center">   !</h2>
				<p align="center"> ""      .</p>
			'));
			$this->AddButton('', 'admin'); //     
		}
		break;
}
