<?php

/*
 * LinkorCMS 1.4
 *  2012 LinkorCMS Development Group
 */


if(!defined('VALID_RUN')){
	header("HTTP/1.1 404 Not Found");
	exit;
}

if(isset($_GET['p'])){
	$p = SafeEnv($_GET['p'], 1, int);
}else{
	$p = 1;
}

global $default_prefix, $bases_path;
$ConvertDB = System::user()->Session('setup_type') == 'convertdb';//   mysql_setup
if($ConvertDB){
	$default_prefix = System::user()->Get('convert_default_prefix');
	$bases_path = System::user()->Get('convert_bases_path');
}

function ShowTables(){
	global $default_prefix, $info_ext, $bases_path;
	$dir = opendir($bases_path);
	$i = -1;
	$tables = array();
	while($file = readdir($dir)){
		$i++;
		$epos = strpos($file, $info_ext);
		if(!($epos === false)){
			$tname = substr($file, 0, $epos);
			if($default_prefix != ''){
				$tname = substr($tname, strlen($default_prefix) + 1);
			}
			$tables[] = $tname;
		}
	}
	return $tables;
}

function GetTableInfo( $tablename ){
	global $default_prefix, $info_ext, $bases_path;
	$iname = $bases_path.($default_prefix != '' ? $default_prefix.'_' : '').$tablename.$info_ext;
	$fp = fopen($iname, "r");
	flock($fp, LOCK_EX);
	$info = fread($fp, 1048576); #1
	$info = unserialize($info);
	$info['name'] = $tablename;
	flock($fp, LOCK_UN);
	fclose($fp);
	return $info;
}

function ReadData( $tablename ){
	global $default_prefix, $data_ext, $bases_path;
	$dname = $bases_path.($default_prefix != '' ? $default_prefix.'_' : '').$tablename.$data_ext;
	$data = file_get_contents($dname);
	$data = unserialize($data);
	return $data;
}

function sqlValues( $data ){
	$result = '';
	foreach($data as $var){
		$var = str_replace('&#13', "\r", $var);
		$var = str_replace('&#10', "\n", $var);
		$result .= ",'".mysql_real_escape_string($var)."'";
	}
	$result = substr($result, 1);
	return '('.$result.')';
}

switch($p){
	case 1: //  MySQL  
		global $default_prefix;
		$this->SetTitle(_STEP4_1);
		$db_host = System::user()->Session('db_mysql_host');
		$db_user = System::user()->Session('db_mysql_user');
		$db_pass = System::user()->Session('db_mysql_pass');
		$db_name = System::user()->Session('db_mysql_name');
		$db_pref = System::user()->Session('db_mysql_pref');
		if(System::user()->Session('db_mysql_init')){
			$db_exdel = System::user()->Session('db_mysql_exdel');
		}else{
			$db_exdel = true;
		}
		$this->OpenForm('mysql_setup&p=2');
		$text = Indent('4/
			<table width="80%" align="center">
				<tr><td>'._SQLCONF_1.':</td><td><input type="text" name="db_host" value="'.($db_host ? $db_host : 'localhost').'"></td></tr>
				<tr><td>'._SQLCONF_2.':</td><td><input type="text" name="db_user" value="'.($db_user ? $db_user : 'root').'"></td></tr>
				<tr><td>'._SQLCONF_3.':</td><td><input type="text" name="db_pass" value="'.($db_pass ? $db_pass : '').'"></td></tr>
				<tr><td>'._SQLCONF_4.':</td><td><input type="text" name="db_name" value="'.($db_name ? $db_name : '').'"></td></tr>
				<tr><td>'._SQLCONF_5.':</td><td><input type="text" name="db_pref" value="'.($db_pref ? $db_pref : $default_prefix).'"></td></tr>
				<tr><td>'._DROP_TABLE_EX.':</td><td><input type="checkbox" name="exdel" value="1"'.($db_exdel ? ' checked' : '').'></td></tr>
			</table>');
		$this->SetContent($text);
		if($ConvertDB){
			$this->AddButton('', 'main&p=2');
			$this->AddSubmitButton(' ');
		}else{
			$this->AddButton('', 'install&p=2');
			$this->AddSubmitButton(' ');
		}
		break;
	case 2: //   
		global $config;
		$ok = '<img src="images/admin/accept.png" alt="">';
		$fail = '<img src="images/admin/delete.png" alt="">';

		$db_host = SafeEnv($_POST['db_host'], 250, str);
		$db_user = SafeEnv($_POST['db_user'], 250, str);
		$db_pass = SafeEnv($_POST['db_pass'], 250, str);
		$db_name = SafeEnv($_POST['db_name'], 250, str);
		$db_pref = SafeEnv($_POST['db_pref'], 250, str);

		//     
		System::user()->Session('db_mysql_host', $db_host);
		System::user()->Session('db_mysql_user', $db_user);
		System::user()->Session('db_mysql_pass', $db_pass);
		System::user()->Session('db_mysql_name', $db_name);
		System::user()->Session('db_mysql_pref', $db_pref);
		System::user()->Session('db_mysql_exdel', isset($_POST['exdel']));
		System::user()->Session('db_mysql_init', true);

		// 
		$have_errors = false;
		$mysql_connect = false;
		$text = '<table width="80%" align="center">';
		//   
		$text .= '<tr><td>   :</td>';
		$mysql_connect = mysql_connect($db_host, $db_user, $db_pass);
		if($mysql_connect){
			$text .= '<td>'.$ok.'</td></tr>';
		}else{
			$text .= '<td>'.$fail.'</td></tr>';
			$text .= '<tr><td colspan="2">,     ,    .</td></tr>';
			$have_errors = true;
		}

		//  db_config.php
		$db_config = $config['config_dir'].'db_config.php';
		if(is_file($db_config)){ //   (     )
			$text .= '<tr><td> "'.$db_config.'"   :</td>';
			if(is_writable($db_config)){
				$text .= '<td>'.$ok.'</td></tr>';
			}else{
				$text .= '<td>'.$fail.'</td></tr>';
				$text .= '<tr><td colspan="2">       (0666  0777).</td></tr>';
				$have_errors = true;
			}
		}else{
			$text .= '<tr><td> "'.$config['config_dir'].'"   :</td>';
			if(is_writable($config['config_dir'])){
				$text .= '<td>'.$ok.'</td></tr>';
			}else{
				$text .= '<td>'.$fail.'</td></tr>';
				$text .= '<tr><td colspan="2">  777   .</td></tr>';
				$have_errors = true;
			}
		}

		//     (    ,     )
		if(trim($db_name) == ''){
			$text .= '<tr><td colspan="2">     .</td></tr>';
			$have_errors = true;
		}else{
			if($mysql_connect){
				$text .= '<tr><td>    "'.$db_name.'":</td>';
				if(!mysql_select_db($db_name, $mysql_connect)){
					if(mysql_errno($mysql_connect) == 1049){ //   
						//   
						$query = "CREATE DATABASE `$db_name`";
						if(version_compare(mysql_get_server_info(), '4.1', '>')){
							$query .= ' DEFAULT CHARACTER SET cp1251 COLLATE cp1251_general_ci';
						}
						if(!mysql_query($query.';', $mysql_connect) && mysql_errno($mysql_connect) == 1044){ // Access Denied
							$text .= '<td>'.$fail.'</td></tr>';
							$text .= '<tr><td colspan="2">    .<br>'
							.' MySQL: ('.mysql_errno($mysql_connect).') '.mysql_error($mysql_connect).'.</td></tr>';
							$have_errors = true;
						}
					}else{
						$text .= '<td>'.$fail.'</td></tr>';
						$text .= '<tr><td colspan="2">    .<br>'
						.' MySQL: ('.mysql_errno($mysql_connect).') '.mysql_error($mysql_connect).'.</td></tr>';
						$have_errors = true;
					}
				}else{
					$text .= '<td>'.$ok.'</td></tr>';
				}
			}
		}
		///
		$text .= '</table>';

		if($have_errors){
			$this->SetTitle(" ");
			$this->SetContent($text);
			$this->AddButton('', 'mysql_setup&p=1');
		}else{
			$filename = $config['config_dir']."db_config.php";
			if($ConvertDB){ //   db_config.php
				copy($filename, $config['config_dir']."db_config-backup.php");
			}
			WriteConfigFile($filename, 'MySQL', $db_host, $db_user, $db_pass, $db_name, $db_pref, CMS_VERSION);
			$saltfilename = $config['config_dir']."salt.php";
			WriteSaltFile($saltfilename);
			GO('setup.php?mod=mysql_setup&p=4'.(isset($_POST['exdel']) ? '&exdel='.$_POST['exdel'] : ''));
		}
		break;
	case 4: //   
		global $config;
		$this->SetTitle(_SQL_CREATE);
		$delete_ex = isset($_GET['exdel']);
		if(!System::database()->Connected){
			$this->SetContent(Indent('
				<html>
				<head>
					<title>!!!!!!</title>
				</head>
				<body>
					<p align="center">   . ,    .</p>
				</body>
				</html>
			'));
		}else{
			System::database()->CreateDbIfNotExists($config['db_name']); // ,     
			System::database()->SelectDb($config['db_name']);
			$tables = ShowTables();
			$prefix = System::database()->Prefix();
			$have_errors = false;
			foreach($tables as $table){
				$info = GetTableInfo($table);
				$data = ReadData($table);
				System::database()->CreateTable($info['name'], $info, $delete_ex);
				foreach($data as $row){
					$values = sqlValues($row);
					$sql = "INSERT INTO `$prefix$table` VALUES $values;";
					if(System::database()->MySQLQuery($sql) === false){
						echo System::database()->ErrorMsg;
						$have_errors = true;
					}
				}
			}
			if($ConvertDB){
				if(!$have_errors){
					$this->SetContent(Indent('
						<p align="center">   !</p>
					'));
					$this->AddButton('-', 'finish&p=3');
					$this->AddButton(' ', 'finish&p=2');
				}else{
					$this->SetContent(Indent('
						<p align="center">    .</p>
					'));
				}
			}else{
				if(!$have_errors){
					$this->SetContent(Indent('
						<h2 class="title" align="center">   !</h2>
						<p align="center"> ""      .</p>
					'));
					$this->AddButton('', 'admin');
				}else{
					$this->SetContent(Indent('
						<p align="center">    .</p>
					'));
				}
			}
		}
		break;
}
