<?php

/*
 * LinkorCMS 1.4
 *  2012 LinkorCMS Development Group
 */


class HTML{

	/**
	 *   
	 * @param string $Action
	 * @param string $Method
	 * @param bool $Multipart
	 * @param string $other
	 * @return string
	 */
	public function FormOpen( $Action = '', $Method = 'post', $Multipart = false, $other = '' ){
		return '<form'
		.($Action != '' ? ' action="'.$Action.'"' : '')
		.($Method != '' ? ' method="'.$Method.'"' : '')
		.($Multipart ? ' enctype="multipart/form-data"' : '')
		.($other != '' ? ' '.$other : '')
		.'>';
	}

	/**
	 *  
	 * @return string
	 */
	public function FormClose(){
		return '</form>'."\n";
	}

	/**
	 *    
	 * @param string $caption
	 * @param string $other
	 * @return string
	 */
	public function Submit( $caption = 'Submit', $other = '' ){
		return '<input type="submit" value="'.$caption.'" align="middle"'.($other != '' ? ' '.$other : '').'>';
	}

	/**
	 *  
	 * @param string $caption
	 * @param string $other
	 * @return string
	 */
	public function Button( $caption = 'Button', $other = '' ){
		return '<input type="button" value="'.$caption.'" align="middle"'.($other != '' ? ' '.$other : '').'>';
	}

	/**
	 *      
	 * @param string $name
	 * @param string $text
	 * @param bool $password
	 * @param string $other
	 * @return string
	 */
	public function Edit( $name, $text = '', $password = false, $other = '' ){
		return '<input type="'.($password ? 'password' : 'text').'" name="'.$name.'"'.(strval($text) != '' ? ' value="'.$text.'"' : '').($other != '' ? ' '.$other : '').'>';
	}

	/**
	 *   
	 * @param $name
	 * @param string $text
	 * @param string $other
	 * @return string
	 */
	public function TextArea( $name, $text = '', $other = '' ){
		return '<textarea name="'.$name.'"'.($other != '' ? ' '.$other : '').'>'.$text.'</textarea>';
	}

	/**
	 *    
	 * @param $name
	 * @param bool $multiple
	 * @param string $other
	 * @return string
	 */
	public function Select_open( $name, $multiple = false, $other = '' ){
		return '<select name="'.$name.'"'.($multiple ? ' multiple="multiple"' : '').($other != '' ? ' '.$other : '').'>';
	}

	/**
	 *    
	 * @param $name
	 * @param $caption
	 * @param bool $selected
	 * @param string $other
	 * @return string
	 */
	public function Option( $name, $caption, $selected = false, $other = '' ){
		return '<option value="'.$name.'"'.($selected ? ' selected="selected"' : '').($other != '' ? ' '.$other : '').'>'.$caption.'</option>';
	}

	/**
	 *   
	 * @return string
	 */
	public function Select_close(){
		return '</select>';
	}

	/**
	 *     
	 * @param $name
	 * @param $data
	 * @param bool $multiple
	 * @param string $other
	 * @return string
	 */
	public function Select( $name, $data, $multiple = false, $other = '' ){
		if(!isset($data['selected'])){
			$data['selected'] = '';
		}
		$text = '<select name="'.$name.'"'.($multiple ? ' multiple="multiple"' : '').($other != '' ? ' '.$other : '').'>';
		foreach($data as $field){
			if(is_array($field)){
				$text .= '<option value="'.$field['name'].'" title="'.$field['caption'].'"'.($field['selected'] || $data['selected'] == $field['name'] ? ' selected="selected"' : '').($field['other'] ? ' '.$field['other'] : '').'>'.$field['caption'].'</option>';
			}
		}
		$text .= '</select>';
		return $text;
	}

	/**
	 *       Select()
	 * @param $data
	 * @param $value
	 * @param $caption
	 * @param bool $selected
	 * @param string $other
	 */
	public function DataAdd( &$data, $value, $caption, $selected = false, $other = '' ){
		$data[] = array('name'=>$value, 'caption'=>$caption, 'selected'=>$selected, 'other'=>$other);
	}

	/**
	 *   
	 * @param $name
	 * @param string $value
	 * @param string $other
	 * @return string
	 */
	public function Hidden( $name, $value = '', $other = '' ){
		return '<input type="hidden" name="'.$name.'" value="'.$value.'"'.($other != '' ? ' '.$other : '').'>';
	}

	/**
	 *   -
	 * @param $name
	 * @param $value
	 * @param bool $checked
	 * @param string $other
	 * @return string
	 */
	public function Check( $name, $value, $checked = false, $other = '' ){
		return '<input type="checkbox" name="'.$name.'" value="'.$value.'"'.($checked ? ' checked="checked"' : '').($other != '' ? ' '.$other : '').'>';
	}

	/**
	 *   
	 * @param $name
	 * @param $value
	 * @param bool $checked
	 * @param string $other
	 * @return string
	 */
	public function Radio( $name, $value, $checked = false, $other = '' ){
		return '<input type="radio" name="'.$name.'" value="'.$value.'"'.($checked ? ' checked="checked"' : '').($other != '' ? ' '.$other : '').'>';
	}

	/**
	 *     
	 * @param $name
	 * @param string $other
	 * @return string
	 */
	public function FFile( $name, $other = '' ){
		return '<input type="file" name="'.$name.'"'.($other ? ' '.$other : '').'>';
	}

}
