<?php

/*
 * LinkorCMS 1.4
 *  2012 LinkorCMS Development Group
 */


class Page extends PageTemplate{

	/**
	 *    (  )
	 * @var boolean
	 */
	public $Ufu = false;

	public $BreadCrumbs = array();
	public $BreadCrumbsLastUrl = false;
	public $ShowBreadCrumbs = false;

	/**
	 * @var StarkytBlock
	 */
	private $ContentBox = null;

	function __construct($AlterBodyTemplate = '', $AlterTemplateDir = '', $DisablePageTemplate = false, $PageType = PAGE_DEFAULT){
		if($AlterBodyTemplate != ''){
			$this->InitPage($AlterBodyTemplate, $AlterTemplateDir, $DisablePageTemplate, $PageType);
		}
	}

	/**
	 *  
	 * @param string $AlterBodyTemplate       .
	 * @param string $AlterTemplateDir             .
	 * @param bool   $DisablePageTemplate  
	 * @param string $PageType
	 */
	public function InitPage($AlterBodyTemplate = '', $AlterTemplateDir = '', $DisablePageTemplate = false, $PageType = PAGE_DEFAULT){
		$this->Ufu = System::config('general/ufu');

		$this->InitPageTemplate($DisablePageTemplate, $PageType);
		if($PageType != PAGE_AJAX){ //   ajax,       
			$this->SetGZipCompressionEnabled(System::config('general/gzip_status'));
		}

		if($AlterTemplateDir == ''){
			$TemplateDir = System::config('tpl_dir').System::config('general/site_template').'/';
		} else{
			$TemplateDir = $AlterTemplateDir;
		}
		$DefaultTemplateDir = System::config('tpl_dir').System::config('general/default_template').'/';

		if($AlterBodyTemplate == ''){
			if(defined('MOD_THEME') && MOD_THEME != '' && (is_file($TemplateDir.'themes/'.MOD_THEME) || is_file($DefaultTemplateDir.'themes/'.MOD_THEME))){
				$ThemeFile = 'themes/'.MOD_THEME;
			} else{
				$ThemeFile = 'theme.html';
			}
		} else{
			$ThemeFile = $AlterBodyTemplate;
		}

		$this->SetRoot($TemplateDir);
		$this->DefaultRoot = $DefaultTemplateDir;

		$this->SetTableTemplate('table/table_open.html', 'table/table_close.html', 'table/table_cell_open.html', 'table/table_cell_close.html');

		//     
		$this->AddBlock('template', true, false, 'page');

		if(defined('MOD_DIR')){
			$this->SetVar('template', 'mdir', MOD_DIR.'templates/');
			$this->ModRoot = MOD_DIR.'templates/';
		}

		//  
		$show_bc = System::config('general/breadcrumbs');
		if($show_bc == 0){
			$show_bc = false;
		} elseif($show_bc == 2){
			$show_bc = !INDEX_PHP;
		} else{
			$show_bc = true;
		}

		$this->InitVars($show_bc, $TemplateDir, $DefaultTemplateDir);

		$this->ContentBox = $this->NewBlock('content_box', true, true, 'message');
		$this->AddBlock('lblocks', true, true, 'block');
		$this->AddBlock('rblocks', true, true, 'block');
		$this->AddBlock('tblocks', true, true, 'block');
		$this->AddBlock('bblocks', true, true, 'block');
		$this->AddBlock('left_coll', false);
		$this->AddBlock('right_coll', false);
		$this->AddBlock('top_coll', false);
		$this->AddBlock('bottom_coll', false);

		$this->BreadCrumbs = array();
		$this->BreadCrumbsLastUrl = false;
		$this->ShowBreadCrumbs = $show_bc;
		$this->AddBlock('breadcrumbs', $show_bc, false, '', 'breadcrumbs.html');
		$this->AddBlock('crumbs', true, true, 'crumb');
		$this->BreadCrumbAdd('', Ufu('index.php'), false);
		//       
		if(defined('MOD_TITLE')){
			$this->BreadCrumbAdd(MOD_TITLE, Ufu('index.php?name='.MOD_NAME, '{name}/'));
		}

		//  theme.html
		$this->SetTempVar('head', 'body', $ThemeFile);
		$initfile = $this->Root.'init.php';
		if(file_exists($initfile)){
			global $site, $db, $user, $config, $userAccess, $userAuth; //     
			include $initfile;
		}
	}

	public function InitVars($ShowBreadCrumbs = null, $TemplateDir = null, $DefaultTemplateDir = null){
		$ac = System::user()->AccessLevel();
		if(!isset($ShowBreadCrumbs)){
			$ShowBreadCrumbs = $this->ShowBreadCrumbs;
		}

		$vars = array(
			'powered'            => '<a href="http://linkorcms.ru/" target="_blank">   LinkorCMS</a>',

			'site_name'          => System::config('general/site_name'),
			'site_slogan'        => System::config('general/site_slogan'),
			'site_email'         => System::config('general/site_email'),
			'site_url'           => System::config('general/site_url'),
			'copyright'          => System::config('general/_copyright'),
			'is_crumbs'          => $ShowBreadCrumbs,
			'datetime_delimiter' => System::config('general/datetime_delimiter'),
			'gzip_status'        => $this->GZipCompressPage && $this->SupportGZip,
			'main_title'         => System::config('general/main_title'),
			'showinfo'           => System::config('general/show_script_time'),
			'info'               => '',
			'is_index'           => INDEX_PHP,

			//  
			'is_system_admin'    => System::user()->isSuperUser(),
			//  
			'is_admin'           => $ac == 1,
			// ,   
			'is_member'          => $ac == 2,
			//   
			'is_member_or_admin' => $ac == 1 || $ac == 2,
			//   
			'is_member_or_guest' => $ac == 2 || $ac == 3 || $ac == 4,
			// 
			'is_guest'           => $ac == 3 || $ac == 4,
			//   
			'is_guest_or_admin'  => $ac == 1 || $ac == 3 || $ac == 4,

			'u_id'               => System::user()->Get('u_id'),
			'u_name'             => System::user()->Get('u_name'),
			'u_avatar'           => System::user()->Get('u_avatar'),
			'u_avatar_small'     => System::user()->Get('u_avatar_small'),
			'u_avatar_smallest'  => System::user()->Get('u_avatar_smallest')
		);

		if(isset($TemplateDir)){
			$vars['dir'] = $TemplateDir;
		}
		if(isset($DefaultTemplateDir)){
			$vars['default_dir'] = $DefaultTemplateDir;
		}

		$this->AddVars('template', $vars);
	}

	/**
	 *      ( ).
	 * @param string         $Title
	 * @param string         $Url
	 * @param bool           $Arrow
	 * @return void
	 */
	public function BreadCrumbAdd($Title, $Url = '', $Arrow = true){
		$this->BreadCrumbs[] = array(
			'title'=> $Title,
			'url'  => $Url,
			'arrow'=> $Arrow
		);
	}

	/**
	 *     .
	 */
	private function ViewBreadCrumbs(){
		$cnt = count($this->BreadCrumbs) - 1;
		foreach($this->BreadCrumbs as $i=> $crumb){
			if($i == $cnt && !$this->BreadCrumbsLastUrl){
				$crumb['url'] = '';
			}
			$this->AddSubBlock('crumbs', true, $crumb);
		}
	}

	/**
	 *   
	 * @param        $area
	 * @param        $vars
	 * @param        $tempvars
	 * @param        $childs
	 * @param string $template
	 */
	public function AddUserBlock($area, $vars, $tempvars, $childs, $template = 'standart.html'){
		$template = 'block/'.$template;
		if(!file_exists($this->Root.$template)){
			$template = 'block/standart.html';
		}
		switch($area){
			case 'L':
				$this->AddSubBlock('lblocks', true, $vars, $tempvars, $template, '', $childs);
				$this->Blocks['left_coll']['if'] = true;
				break;
			case 'R':
				$this->AddSubBlock('rblocks', true, $vars, $tempvars, $template, '', $childs);
				$this->Blocks['right_coll']['if'] = true;
				break;
			case 'T':
				$this->AddSubBlock('tblocks', true, $vars, $tempvars, $template, '', $childs);
				$this->Blocks['top_coll']['if'] = true;
				break;
			case 'B':
				$this->AddSubBlock('bblocks', true, $vars, $tempvars, $template, '', $childs);
				$this->Blocks['bottom_coll']['if'] = true;
				break;
			default:
				$this->AddSubBlock('lblocks', true, $vars, $tempvars, $template, '', $childs);
				$this->Blocks['left_coll']['if'] = true;
		}
	}

	/**
	 *    
	 * @param $title
	 * @param $content
	 * @return StarkytSubBlock
	 */
	public function AddTextBox($title, $content){
		$vars = array(
			'container' => $content,
			'title'     => $title
		);
		return $this->ContentBox->NewSubBlock(true, $vars, array(), 'box.html');
	}

	/**
	 *     
	 * @param       $title
	 * @param       $template_file
	 * @param array $vars
	 * @return StarkytSubBlock
	 */
	public function AddTemplatedBox($title, $template_file, $vars = array()){
		$vars['title'] = $title;
		return $this->ContentBox->NewSubBlock(true, $vars, array('container'=> $template_file), 'box.html');
	}

	/**
	 *   
	 * @param $title
	 * @param $text
	 * @param $admin
	 * @return StarkytSubBlock
	 */
	public function AddMessage($title, $text, $admin){
		$vars = array(
			'title' => $title,
			'text'  => $text,
			'admin' => $admin
		);
		return $this->ContentBox->NewSubBlock(true, $vars, array(), 'message.html');
	}

	/**
	 *   ,    
	 */
	public function ViewBlocks(){
		global $site, $db, $user, $config, $userAccess, $userAuth; //  ,  
		$blocks = System::database()->Select('blocks', GetWhereByAccess('view', "`enabled`='1'"), null, 'place');
		foreach($blocks as $block){
			$block_config = $block['config'];
			$area         = SafeDB($block['position'], 1, str);
			$title        = SafeDB($block['title'], 255, str);
			$enabled      = SafeDB($block['enabled'], 1, int);
			$modified     = SafeDB($block['modified'], 11, int);
			$cache        = SafeDB($block['cache'], 0, str, false, false);
			$vars         = array();
			$tempvars     = array();
			$childs       = array();
			if($enabled && VisibilityConditionsCheck($block['showin'], $block['showin_uri'])){
				include(RealPath2(System::config('blocks_dir').$block['type']).'/index.php'); // => $vars
				$this->AddUserBlock($area, $vars, $tempvars, $childs, SafeDB(RealPath2($block['template']), 255, str));
			}
		}
	}

	/**
	 *   
	 * @param string         $Message
	 * @param StarkytBlock   $ToBlock
	 * @return void
	 */
	public function Login($Message = '', $ToBlock = null){
		if(!isset($ToBlock)){
			$ToBlock = $this->AddTemplatedBox('', 'login.html');
		}
		$vars = array(
			'message'         => $Message,
			'form_action'     => 'index.php?name=user&op=login&back=main',
			'llogin'          => '',
			'lpass'           => '',
			'lremember'       => ' ',
			'registration'    => System::config('user/registration') == 'on',
			'lregistration'   => '',
			'registration_url'=> Ufu('index.php?name=user&op=registration', 'user/{op}/'),
			'lsubmit'         => '',
			'lforgot_pass' => ' '
		);
		$ToBlock->NewBlock('login', true, false, 'lf')->SetVars($vars);
	}

	/**
	 *       
	 * @param bool $Blocks
	 * @param bool $OnlineProcess
	 * @param bool $Return
	 * @return bool|string
	 */
	public function TEcho($Blocks = true, $OnlineProcess = true, $Return = false){
		if(defined('INDEX_PHP') && INDEX_PHP == true){
			$title = '';
		} else{
			$title = $this->Title;
		}
		if($OnlineProcess){
			System::user()->OnlineProcess($title);
			if(System::user()->Auth){
				System::user()->ChargePoints(System::config('points/browsing'));
			}
		}
		if($Blocks){
			$this->ViewBlocks();
		}
		if($this->ShowBreadCrumbs){
			$this->ViewBreadCrumbs();
		}

		//     
		$ErrorsText = '';
		if(System::config('debug/php_errors')){
			$ErrorsText .= implode("<br>\n", System::$Errors);
		}
		if(ob_get_level() > 0 && ob_get_length() > 0){
			$ErrorsText .= ob_get_clean();
		}
		$this->SetVar('template', 'errors_text', $ErrorsText);

		return $this->EchoAll($Return);
	}
}
