<?php

/*
 * LinkorCMS 1.4
 *  2012 LinkorCMS Development Group
 */


define('IMAGE_JPEG', 'jpeg');
define('IMAGE_PNG', 'png');
define('IMAGE_GIF', 'gif');
define('IMAGE_WBMP', 'wbmp');

class TPicture{

	/**
	 *  
	 */
	public $Brush = 0xFFFFFF;
	public $JpegQuality = 90;

	/**
	 *  
	 */
	public $gd = null; //     GD
	public $Format = IMAGE_JPEG;
	public $SaveFormat = IMAGE_JPEG;
	public $Width = 100;
	public $Height = 100;
	public $NewWidth = 100;
	public $NewHeight = 100;
	public $WatermarkFile = '/images/watermark.png';

	/**
	 * 
	 * @param null $ImgFileName
	 */
	public function __construct( $ImgFileName = null ){
		if($ImgFileName !== null){
			$this->CreateFromFile($ImgFileName);
		}
	}

	/**
	 *      
	 * @param int $Width
	 * @param int $Height
	 * @param string $Format
	 */
	public function NewPicture( $Width = 100, $Height = 100, $Format = IMAGE_JPEG ){
		if(function_exists('ImageCreateTrueColor')){
			$this->gd = ImageCreateTrueColor($Width, $Height);
		}else{
			$this->gd = ImageCreate($Width, $Height);
		}
		$this->Width = $this->NewWidth = $Width;
		$this->Height = $this->NewHeight = $Height;
		$this->Format = $Format;
		$this->SaveFormat = $Format;
		imagealphablending($this->gd, false);
		imagefill($this->gd, 0, 0, $this->Brush);
	}

	/**
	 *     
	 * @param $ImgFileName
	 * @param int $Width
	 * @param int $Height
	 * @return mixed
	 */
	public function CreateFromFile( $ImgFileName, $Width = 0, $Height = 0 ){
		if(!file_exists($ImgFileName)){
			ErrorHandler(USER_NOTICE, '  ', 'TPicture::CreateFromFile');
			return;
		}
		if($this->gd != null){
			$this->Destruct();
		}
		$size = getimagesize($ImgFileName);
		$format = strtolower(substr($size['mime'], strpos($size['mime'], '/') + 1));
		$vformat = false;
		if($format == 'jpg' || $format == 'jpeg'){
			$vformat = true;
			$this->Format = IMAGE_JPEG;
			$this->gd = ImageCreateFromJPEG($ImgFileName);
		}elseif($format == 'png'){
			$vformat = true;
			$this->Format = IMAGE_PNG;
			$this->gd = ImageCreateFromPNG($ImgFileName);
		}elseif($format == 'gif'){
			$vformat = true;
			$this->Format = IMAGE_GIF;
			$this->gd = ImageCreateFromGIF($ImgFileName);
		}elseif($format == 'wbmp'){
			$vformat = true;
			$this->Format = IMAGE_WBMP;
			$this->gd = ImageCreateFromWBMP($ImgFileName);
		}
		if($vformat){
			$this->SaveFormat = $this->Format;
			$this->Width = $size[0];
			$this->Height = $size[1];
			$this->NewWidth = 0;
			$this->NewHeight = 0;
			$this->JpegQuality = 95;
		}
	}

	/**
	 * ...
	 */
	public function Destruct(){
		imagedestroy($this->pic['src']);
		$this->gd = null;
	}

	/**
	 *      
	 * @param string $Format
	 */
	public function SetSaveFormat( $Format = 'jpeg' ){
		$this->SaveFormat = $Format;
	}

	/**
	 *     (  )
	 * @param $NewWidth
	 * @param $NewHeight
	 */
	public function SetImageSize( $NewWidth, $NewHeight ){
		$this->NewWidth = $NewWidth;
		$this->NewHeight = $NewHeight;
	}

	/**
	 *    JPEG
	 * @param $quality
	 */
	public function SetJpegQuality( $quality ){
		$this->JpegQuality = $quality;
	}

	/**
	 *  
	 * @return mixed
	 */
	public function SetSize(){
		if(($this->NewWidth == 0 && $this->NewHeight == 0) || ($this->NewWidth == $this->Width && $this->NewHeight == $this->Height)){ //    
			return;
		}

		//      

		//       
		$min_width = false;
		if($this->NewHeight == 0){
			$min_width = true;
		}elseif($this->Width > $this->Height){
			$min_width = true;
		}

		if($min_width){ //   
			$nwidth = $this->NewWidth;
			$nheight = round($this->Height / ($this->Width / $this->NewWidth));
			if($this->NewHeight != 0 && $nwidth > $this->Width && $nheight > $this->NewHeight){ //    
				//    , ..     
				$nheight = $this->NewHeight;
				$nwidth = round($nwidth / ($nheight / $this->NewHeight));
			}
		}else{ //   
			$nheight = $this->NewHeight;
			$nwidth = round($this->Width / ($this->Height / $this->NewHeight));
			if($this->NewWidth != 0 && $nheight > $this->Height && $nwidth > $this->NewWidth){ //    
				//    , ..     
				$nwidth = $this->NewWidth;
				$nheight = round($nheight / ($nwidth / $this->NewWidth));
			}
		}

		//      
		if(function_exists('ImageCreateTrueColor')){
			$temp = ImageCreateTrueColor($nwidth, $nheight);
		}else{
			$temp = ImageCreate($nwidth, $nheight);
		}
		imagefill($temp, 0, 0, $this->Brush);
		if(function_exists('imagecopyresampled')){
			imagecopyresampled($temp, $this->gd, 0, 0, 0, 0, $nwidth, $nheight, $this->Width, $this->Height);
		}else{
			imagecopyresized($temp, $this->gd, 0, 0, 0, 0, $nwidth, $nheight, $this->Width, $this->Height);
		}

		imagedestroy($this->gd);
		$this->gd = $temp;
		$this->Width = imagesx($temp);
		$this->Height = imagesy($temp);
		$this->NewWidth = 0;
		$this->NewHeight = 0;
	}

	/**
	 *    
	 * @param $Src
	 * @param $X
	 * @param $Y
	 * @param $Width
	 * @param $Height
	 */
	public function StreachDraw( $Src, $X, $Y, $Width, $Height ){
		if(function_exists('imagecopyresampled')){
			imagecopyresampled($this->gd, $Src, $X, $Y, 0, 0, $Width, $Height, imagesx($Src), imagesy($Src));
		}else{
			imagecopyresized($this->gd, $Src, $X, $Y, 0, 0, $Width, $Height, imagesx($Src), imagesy($Src));
		}
	}

	/**
	 *  
	 * @param $Src
	 * @param $X
	 * @param $Y
	 */
	public function Draw( $Src, $X, $Y ){
		$this->StreachDraw($Src, $X, $Y, imagesx($Src), imagesy($Src));
	}

	/**
	 *  
	 * @param $Src
	 * @param $SrcX
	 * @param $SrcY
	 * @param $SrcWidth
	 * @param $SrcHeight
	 * @param $DstX
	 * @param $DstY
	 */
	public function Copy( $Src, $SrcX, $SrcY, $SrcWidth, $SrcHeight, $DstX, $DstY ){
		if(function_exists('imagecopyresampled')){
			imagecopyresampled($this->gd, $Src, $DstX, $DstY, $SrcX, $SrcY, $SrcWidth, $SrcHeight, $SrcWidth, $SrcHeight);
		}else{
			imagecopyresized($this->gd, $Src, $DstX, $DstY, $SrcX, $SrcY, $SrcWidth, $SrcHeight, $SrcWidth, $SrcHeight);
		}
	}

	/**
	 *     PHP
	 */
	public function SendToHTTPClient(){
		@Header('Content-Type: image/'.$this->SaveFormat);
		$this->SetSize();
		if($this->SaveFormat == 'jpeg'){
			imageJPEG($this->gd, null, $this->JpegQuality);
		}elseif($this->SaveFormat == 'png'){
			imagePNG($this->gd);
		}elseif($this->SaveFormat == 'gif'){
			imageGIF($this->gd);
		}elseif($this->SaveFormat == 'wbmp'){
			imageWBMP($this->gd);
		}
	}

	/**
	 *    
	 * @param $FileName
	 * @param null $SaveFormat
	 */
	public function SaveToFile( $FileName, $SaveFormat = null ){
		if($SaveFormat !== null){
			$this->SetSaveFormat($SaveFormat);
		}
		$this->SetSize();
		if($this->SaveFormat == 'jpeg'){
			imageJPEG($this->gd, $FileName, $this->JpegQuality);
		}elseif($this->SaveFormat == 'png'){
			imagePNG($this->gd, $FileName);
		}elseif($this->SaveFormat == 'gif'){
			imageGIF($this->gd, $FileName);
		}elseif($this->SaveFormat == 'wbmp'){
			imageWBMP($this->gd, $FileName);
		}
	}

	/**
	 *      
	 * @param $angle
	 * @param int $bg_color
	 */
	public function Rotate($angle, $bg_color = 0) {
		$this->gd = imagerotate($this->gd, $angle, $bg_color);
	}

	/**
	 *     
	 * @param $place
	 * @param int $transparency
	 */
	public function AddWatermark($place, $transparency = 50) {
		$wm = new TPicture($this->WatermarkFile);

		if($transparency > 100) {
			$transparency = 100;
		} elseif($transparency < 1) {
			$transparency = 1;
		}

		switch ($place) {
			case 'center':
				ImageCopyMerge($this->gd, $wm->gd, ($this->Width - $wm->Width) / 2, ($this->Height - $wm->Height) / 2, 0, 0, $wm->Width, $wm->Height, $transparency);
				break;
			case 'top_left':
				ImageCopyMerge($this->gd, $wm->gd, 0, 0, 0, 0, $wm->Width, $wm->Height, $transparency);
				break;
			case 'top_right':
				ImageCopyMerge($this->gd, $wm->gd, ($this->Width - $wm->Width), 0, 0, 0, $wm->Width, $wm->Height, $transparency);
				break;
			case 'down_right':
				ImageCopyMerge($this->gd, $wm->gd, ($this->Width - $wm->Width), ($this->Height - $wm->Height), 0, 0, $wm->Width, $wm->Height, $transparency);
				break;
			case 'down_left':
				ImageCopyMerge($this->gd, $wm->gd, 0, ($this->Height - $wm->Height), 0, 0, $wm->Width, $wm->Height, $transparency);
				break;
		}

		$wm->Destruct();
	}

	/**
	 *      
	 * @param $file
	 */
	public function SetWatermarkFile($file) {
		if(file_exists($file)) {
			$this->WatermarkFile = $file;
		}
	}
}
