<?php

/*
 * LinkorCMS 1.4
 *  2012 LinkorCMS Development Group
 */


/**
 *     
 */

/**
 *    ,   
 *       .
 *       .
 * @param  $ObjArray 
 * @param  $OnPage      
 * @param  $Page      
 * @return array
 */
function ArrayPage( &$ObjArray, $OnPage, $Page ){
	$pages_count = ceil(count($ObjArray) / $OnPage);
	if($Page < 1){
		$Page = 1;
	}elseif($Page > $pages_count){
		$Page = $pages_count;
	}
	$start = $OnPage * $Page - $OnPage;
	return array_slice($ObjArray, $start, $OnPage);
}

/**
 *     .      
 *       foreach.
 *
 * @param Array $Array    $array = array(array(col1=1,col2=2,...),arr...)
 *        
 * @param Integer $Colls             .
 * @param Boolean $OnDecreases  true       ,
 *          .
 * @return void
 */
function SortArray( &$Array, $Colls, $OnDecreases = false ) {
	global $SATempVar, //  
	       $SATempVar2; //    
	if (!function_exists('SorterUp')) {
		function SorterUp($a, $b){
			global $SATempVar;
			if ($a[$SATempVar] == $b[$SATempVar]) return 0;
			return ($a[$SATempVar] < $b[$SATempVar]) ? -1 : 1;
		}
		function SorterDown($a, $b){
			global $SATempVar;
			if ($a[$SATempVar] == $b[$SATempVar]) return 0;
			return ($a[$SATempVar] > $b[$SATempVar]) ? -1 : 1;
		}
		function SorterMulti($a, $b){
			global $SATempVar, $SATempVar2;
			$i = 0;
			$c = count($SATempVar);
			while($i < $c){
				if($a[$SATempVar[$i]] != $b[$SATempVar[$i]]){
					if($SATempVar2[$i]){
						return ($a[$SATempVar[$i]] > $b[$SATempVar[$i]]) ? -1 : 1;
					}else{
						return ($a[$SATempVar[$i]] < $b[$SATempVar[$i]]) ? -1 : 1;
					}
				}
				$i++;
			}
		}
	}
	$SATempVar = $Colls;
	if(is_array($SATempVar)){
		if(is_array($OnDecreases)){
			$SATempVar2 = $OnDecreases;
		}else{
			$SATempVar2 = array();
			foreach($Colls as &$coll){
				$SATempVar2[] = $OnDecreases;
			}
		}
		usort($Array, 'SorterMulti');
	}else{
		if($OnDecreases){
			usort($Array, 'SorterDown');
		}else{
			usort($Array, 'SorterUp');
		}
	}
}

/**
 *      
 * @param $Array
 * @param $Value
 * @param null $AfterKey
 * @param null $Key
 * @return array
 */
function InsertToArray( $Array, $Value, $AfterKey = null, $Key = null ){
	$newarray = array();
	foreach($Array as $sk=>$sv){
		if($Key == null){
			$newarray[] = $sv;
		}else{
			$newarray[$sk] = $sv;
		}
		if($sk == $AfterKey){
			if($Key == null){
				$newarray[] = $Value;
			}else{
				$newarray[$Key] = $Value;
			}
		}
	}
	return $newarray;
}

/**
 *     .
 * @param $Array
 * @param $Value
 * @param null $Key
 * @return array
 */
function InsertToArrayFirst( $Array, $Value, $Key = null){
	$newarray = array();
	if($Key == null){
		$newarray[] = $Value;
	}else{
		$newarray[$Key] = $Value;
	}
	foreach($Array as $sk=>$sv){
		if($Key == null){
			$newarray[] = $sv;
		}else{
			$newarray[$sk] = $sv;
		}
	}
	return $newarray;
}

/**
 *       
 * @param $Array 
 * @param $Key     
 * @param bool $SaveKeys     
 * @return void
 */
function DeleteFromArray( $Array, $Key, $SaveKeys = true ){
	$newarray = array();
	foreach($Array as $k=>$row){
		if($k == $Key) continue;
		if($SaveKeys){
			$newarray[$k] = $row;
		}else{
			$newarray[] = $row;
		}
	}
	return $newarray;
}

