<?php

/*
 * LinkorCMS 1.4
 *  2012 LinkorCMS Development Group
 */


/**
 *    ,    .
 */
function GetConfigGroups($GroupsTable = 'config_groups', $Aggregate = 'name'){
	static $GroupsCache = array();
	if($GroupsTable == 'clear'){
		$GroupsCache = array();
		return;
	}
	if(!isset($GroupsCache[$GroupsTable][$Aggregate])){
		$groups = System::database()->Select($GroupsTable);
		foreach($groups as $group){
			$GroupsCache[$GroupsTable][$Aggregate][$group[$Aggregate]] = $group;
		}
	}
	return $GroupsCache[$GroupsTable][$Aggregate];
}

/**
 *  c   .
 *
 * @param        $ConfigVar      
 * @param string $ConfigTable
 * @param string $GroupsTable
 * @return void
 */
function LoadSiteConfig(&$ConfigVar, $ConfigTable = 'config', $GroupsTable = 'config_groups'){
	if(System::cache()->HasCache('config', $ConfigTable)){
		$ConfigVar = System::cache()->Get('config', $ConfigTable);
		return;
	}

	$temp = System::database()->Select($ConfigTable, "`autoload`='1'");
	foreach($temp as $i){
		$configs[$i['group_id']][] = $i;
	}

	//   
	$config_groups = System::database()->Select($GroupsTable, '');
	foreach($config_groups as $group){
		if(isset($configs[$group['id']])){
			foreach($configs[$group['id']] as $config){
				$gname  = $group['name'];
				$cname  = $config['name'];
				$cvalue = $config['value'];
				$type   = trim($config['type']);
				if($type <> ''){
					$type = explode(',', $type);
				} else{
					$type = array(
						255,
						'string',
						'false'
					);
				}
				if($type[0] > 0){
					$cvalue = substr($cvalue, 0, $type[0]);
				}
				if($type[2] != 'false'){
					$cvalue = HtmlChars(strip_tags($cvalue));
				}
				settype($cvalue, $type[1]);
				if($cvalue === '' && ($type[1] == 'bool' || $type[1] == 'boolean')){
					$cvalue = '0';
				}
				$ConfigVar[$gname][$cname] = $cvalue;
			}
		}
	}

	System::cache()->Write('config', $ConfigTable, $ConfigVar);
}

/**
 *   .
 * @param string $Group
 * @param string $ConfigName
 * @param string $NewValue
 * @param string $Table
 * @param string $GroupsTable
 */
function ConfigSetValue($Group, $ConfigName, $NewValue, $Table = 'config', $GroupsTable = 'config_groups'){
	if(!is_numeric($Group)){
		$groups = GetConfigGroups($GroupsTable);
		$Group  = SafeEnv($groups[$Group]['id'], 11, int);
	}
	System::database()->Update($Table, "`value`='$NewValue'", "`group_id`='$Group' and `name`='$ConfigName'");
	System::cache()->Clear('config');
}

/**
 *    .
 * @param string $Group
 * @param string $ConfigName
 * @param string $NewValue
 */
function ConfigPluginSetValue($Group, $ConfigName, $NewValue){
	ConfigSetValue($Group, $ConfigName, $NewValue, 'plugins_config', 'plugins_config_groups');
}

/**
 *   .
 * @param string         $Group         .
 * @param string         $Name         (   ).
 * @param string         $Title       .
 * @param string         $Value        .
 * @param string         $Description .
 * @param bool           $Visible     .
 * @param string         $KindControl     .
 * @param string         $Type          ((255),(string - PHP Type), (true, false)).
 * @param string         $Values          . (optval:title,optval:title)   (function:Callback), .  .
 * @param string         $SaveHandler      . .  .
 * @param bool           $Autoload      $config.
 * @param string         $Table
 * @param string         $GroupsTable
 */
function AddConfig($Group, $Name, $Title, $Value, $Description = '', $Visible = false, $KindControl = '', $Type = '255,string,false', $Values = '', $SaveHandler = '', $Autoload = true, $Table = 'config', $GroupsTable = 'config_groups'){
	if(!is_numeric($Group)){
		$groups = GetConfigGroups($GroupsTable);
		$Group  = SafeEnv($groups[$Group]['id'], 11, int);
	}
	if($Visible){
		$Visible = '1';
	} else{
		$Visible = '0';
	}
	if($Autoload){
		$Autoload = '1';
	} else{
		$Autoload = '0';
	}
	$Name        = SafeEnv($Name, 255, str);
	$Value       = SafeEnv($Value, 0, str);
	$Title       = SafeEnv($Title, 255, str);
	$Description = SafeEnv($Description, 255, str);
	$Values      = SafeEnv($Values, 255, str);
	System::database()->Insert($Table, "'','$Group','$Name','$Value','$Visible','$Title','$Description','$KindControl','$Values','$SaveHandler','$Type','$Autoload'");
	System::cache()->Clear('config');
}

/**
 *  .
 * @param int|string $Group  ,   ,    .
 * @param string     $Name   .
 * @param string     $Table
 * @param string     $GroupsTable
 */
function RemoveConfig($Group, $Name, $Table = 'config', $GroupsTable = 'config_groups'){
	if(!is_numeric($Group)){
		$groups = GetConfigGroups($GroupsTable);
		$Group  = SafeEnv($groups[$Group]['id'], 11, int);
	}
	System::database()->Delete($Table, "`group_id`='$Group' and `name`='$Name'");
}

/**
 *    .
 * @param string         $Group         .
 * @param string         $Name         (   ).
 * @param string         $Title       .
 * @param string         $Value        .
 * @param string         $Description .
 * @param bool           $Visible     .
 * @param string         $KindControl     .
 * @param string         $Type          ((255),(string - PHP Type), (true, false)).
 * @param string         $Values          . (optval:title,optval:title)   (function:Callback), .  .
 * @param string         $SaveHandler      . .  .
 * @param bool           $Autoload      $config.
 */
function AddPluginConfig($Group, $Name, $Title, $Value, $Description = '', $Visible = false, $KindControl = '', $Type = '255,string,false', $Values = '', $SaveHandler = '', $Autoload = true){
	AddConfig(
		$Group,
		$Name,
		$Title,
		$Value,
		$Description,
		$Visible,
		$KindControl,
		$Type,
		$Values,
		$SaveHandler,
		$Autoload,
		'plugins_config',
		'plugins_config_groups'
	);
}

/**
 *   .
 * @param int|string $Group  ,   ,    .
 * @param string     $Name   .
 */
function RemovePluginConfig($Group, $Name){
	RemoveConfig($Group, $Name, 'plugins_config', 'plugins_config_groups');
}

/**
 *      .
 * @param string         $Name
 * @param string         $Title
 * @param string         $Description
 * @param bool           $Visible
 * @param string         $GroupsTable
 * @return int
 */
function AddConfigGroup($Name, $Title, $Description = '', $Visible = false, $GroupsTable = 'config_groups'){
	if($Visible){
		$Visible = '1';
	} else{
		$Visible = '0';
	}
	System::database()->Insert($GroupsTable, "'','$Name','$Title','$Description','$Visible'");
	GetConfigGroups('clear');
	return System::database()->GetLastId();
}

/**
 *   .
 * @param string   $Group    .
 * @param string   $Table
 * @param string   $GroupsTable
 */
function RemoveConfigGroup($Group, $Table = 'config', $GroupsTable = 'config_groups'){
	if(!is_numeric($Group)){
		$groups = GetConfigGroups($GroupsTable);
		$Group  = SafeEnv($groups[$Group]['id'], 11, int);
	}
	System::database()->Delete($GroupsTable, "`id`='$Group'");
	//    
	System::database()->Delete($Table, "`group_id`='$Group'");
	GetConfigGroups('clear');
}

/**
 *       .
 * @param string         $Name
 * @param string         $Title
 * @param string         $Description
 * @param bool           $Visible
 * @return int
 */
function AddPluginConfigGroup($Name, $Title, $Description = '', $Visible = false){
	return AddConfigGroup($Name, $Title, $Description = '', $Visible, 'plugins_config_groups');
}

/**
 *    .
 * @param string $Group    .
 */
function RemovePluginConfigGroup($Group){
	RemoveConfigGroup($Group, 'plugins_config', 'plugins_config_groups');
}