<?php

/*
 * LinkorCMS 1.4
 *  2012 LinkorCMS Development Group
 */


define('EOL', "\n");
define('WIN_EOL', "\r\n");
define('MAC_EOL', "\r");

/**
 *  ,    ,  
 * @param string $Text
 * @param string $MaxWordLength
 * @return string
 */
function DivideWord( $Text, $MaxWordLength='30' ){
	return wordwrap($Text, $MaxWordLength, chr(13), 1);
}

/**
 *     
 * @param int $Length  
 * @param string $Chars
 * @return String
 */
function GenRandomString($Length, $Chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789'){
	srand((double)microtime()*1000000);
	$char_length = (strlen($Chars)-1);
	$random_string = '';
	for($i=0; $i<$Length; $i++){
		$random_string .= $Chars[rand(0,$char_length)];
	}
	return $random_string;
}

/**
 *    
 * @param int $Length  
 * @return String
 */
function GenBPass($Length){
	srand((double)microtime()*1000000);
	$password = '';
	$vowels = array('a','e','i','o','u');
	$cons = array('b','c','d','g','h','j','k','l','m','n','p','r','s','t','u','v','w','tr','cr','br','fr','th','dr','ch','ph','wr','st','sp','sw','pr','sl','cl');
	$num_vowels = count($vowels);
	$num_cons = count($cons);
	for($i=0; $i<$Length; $i++){
		$password .= $cons[rand(0, $num_cons-1)].$vowels[rand(0, $num_vowels-1)];
	}
	return substr($password, 0, $Length);
}

/**
 *     ()  PHP .
 *     ,     LinkorCMS.
 * @param string $String   .
 *        
 * ( "2/" -      ).
 *     ,      .
 *    .
 * @param bool $FirstNewLine    .
 * @return string
 */
function Indent($String, $FirstNewLine = true){
	$lines = explode("\n", $String);
	$indent_lines = '';
	$first_line = false;
	$indent = 0; //  
	$cont_indent = 0; //     -    

	if($FirstNewLine){
		$indent_lines = "\n";
	}

	//      
	$first_line_length = strlen($lines[0]);
	if($first_line_length > 0){
		$param = explode('/', $lines[0], 2);
		if(is_numeric($param[0])){ //   
			$indent = (int)$param[0];
			if($param[1] != ''){ //   
				$first_line = $param[1];
			}
		}else{
			$first_line = $lines[0];
		}
	}
	$indent = str_repeat("\t", $indent);
	if($first_line !== false){ //      
		for($i=0; $i<strlen($first_line); $i++){
			if($first_line[$i] == "\t"){
				$cont_indent++;
			}else{
				break;
			}
		}
		$indent_lines .= $indent.substr($first_line, $cont_indent)."\n";
	}else{ //   -  ,    - 
		if(isset($lines[1])){
			for($i=0; $i<strlen($lines[1]); $i++){
				if($lines[1][$i] == "\t"){
					$cont_indent++;
				}else{
					break;
				}
			}
		}
	}
	//       
	// (      -     () )
	unset($lines[0]);
	//      -  .
	if(trim($lines[count($lines)]) == '') unset($lines[count($lines)]);
	foreach($lines as $line){
		if(trim($line) != ''){
			$indent_lines .= $indent.substr($line, $cont_indent)."\n";
		}else{
			$indent_lines .= "\n";
		}
	}
	return substr($indent_lines, 0, -1); //   \n
}

/**
 *     .
 * @param      $String      
 * @param bool $RemoveNL   
 * @return string
 */
function RemoveIndent( $String, $RemoveNL = true ){
	$lines = explode("\n", $String);
	$text = '';
	foreach( $lines as $line ){
		$line = trim($line);
		if($line != ''){
			$text .= $line;
			if(!$RemoveNL){
				$text .= "\n";
			}
		}
	}
	return $text;
}

/**
 *     .
 * @param $Eol
 * @param $Content
 * @return mixed
 */
function ReplaceEol( $Eol, $Content ){
	$order   = array("\r\n", "\n", "\r");
	$replace = '___***new'.'_'.'line***___';
	$Content = str_replace($order, $replace, $Content);
	$Content = str_replace($replace, $Eol, $Content);
	return $Content;
}