<?php

/*
 * LinkorCMS 1.4
 *  2012 LinkorCMS Development Group
 */


/**
 *      .
 */
class AdminTree extends Tree{

	public $obj_table = 'cats';
	public $module = '';
	public $edit_met = 'editcat';
	public $save_met = 'catsave';
	public $del_met = 'delcat';
	public $showcats_met = 'cat';
	public $action_par_name = 'a';
	public $obj_cat_coll = 'cat';
	public $id_par_name = 'id';
	public $index_id_par_name = '';

	/**
	 *    html-    -
	 * @param int $ParentId
	 * @return bool|string
	 */
	public function ShowCats( $ParentId = 0 ){
		UseScript('jquery_ui_treeview');
		if($ParentId == 0 && isset($_GET['_cat_parent'])){
			$ParentId = SafeEnv($_GET['_cat_parent'], 11, int);
		}
		$elements = array();

		if($ParentId == 0 && !isset($this->Cats[$ParentId])){
			return ' ';
		}

		foreach($this->Cats[$ParentId] as $cat){
			$id = SafeDB($cat['id'], 11, int);
			$icon = trim(SafeDB($cat['icon'], 255, str));
			$info = '';
			if($icon != ''){
				$info .= '<img src="'.$icon.'">';
			}
			if($this->index_id_par_name != ''){
				$link_go = Ufu('index.php?name='.$this->module.'&'.$this->index_id_par_name.'='.$id, $this->module.'/{'.$this->index_id_par_name.'}/');
				$info .= ($icon != '' ? '<br>' : '').'<b></b>: <a href="'.$link_go.'" target="_blank">/'.$link_go.'</a>';
			}
			$icon = 'images/folder.png';

			$add_cat_link = ADMIN_FILE.'?exe='.$this->module.'&'.$this->action_par_name.'='.$this->edit_met.'&_cat_adto='.$id;
			$edit_cat_link = ADMIN_FILE.'?exe='.$this->module.'&'.$this->action_par_name.'='.$this->edit_met.'&'.$this->id_par_name.'='.$id;

			$func = '';
			$func .= System::admin()->SpeedButton('  ', $add_cat_link, 'images/admin/folder_add.png');
			$func .= System::admin()->SpeedButton('', $edit_cat_link, 'images/admin/edit.png');
			$func .= System::admin()->SpeedConfirmJs(
				' ',
				'$(\'#cats_tree_container\').treeview(\'deleteNode\', '.$id.');',
				'images/admin/delete.png',
				'   ?    -  .'
			);

			$obj_counts = $this->GetCountersRecursive($id);
			$elements[] = array(
				'id'=>$id,
				'icon'=>$icon,
				'title'=>'<b>'.System::admin()->Link(SafeDB($cat['title'], 255, str).' ('.$obj_counts['files'].')', $edit_cat_link).'</b>',
				'info'=>$info,
				'func'=>$func,
				'isnode'=>isset($this->Cats[$id]),
				'child_url'=>ADMIN_FILE.'?exe='.$this->module.'&'.$this->action_par_name.'='.$this->showcats_met.'&_cat_parent='.$id
			);
		}
		if($ParentId == 0){
			System::admin()->AddOnLoadJS('$("#cats_tree_container").treeview({del: \''.ADMIN_FILE.'?exe='.$this->module.'&'.$this->action_par_name.'='.$this->del_met.'&ok=1\', delRequestType: \'GET\', tree: '.JsonEncode($elements).'});');
			return '<div id="cats_tree_container"></div>';
		}else{
			echo JsonEncode($elements);
			exit;
		}
	}

	/**
	 *  
	 * @param null   $CatId
	 * @param null   $ToId
	 * @param string $OtherUrlParams
	 * @return void
	 */
	public function CatEditor( $CatId = null, $ToId = null, $OtherUrlParams = '' ){
		$title = '';
		$desc = '';
		$icon = '';
		$boxtitle = ' ';
		$save_met = $this->save_met;
		if($CatId != null){
			$cat = System::database()->SelectOne($this->Table, "`id`='$CatId'");
			$title = SafeDB($cat['title'], 255, str);
			$desc = SafeDB($cat['description'], 0, str, false);
			$icon = SafeDB($cat['icon'], 255, str);
			$parent = SafeDB($cat['parent'], 11, int);
			$boxtitle = ' ';
			$save_met = $this->save_met.'&'.$this->id_par_name.'='.$CatId;
			$cmd = ' ';
		}else{
			if($ToId != null){
				$parent = $ToId;
			}elseif(isset($_GET['_cat_adto'])){
				$parent = SafeEnv($_GET['_cat_adto'], 11, int);
			}else{
				$parent = -1;
			}
			$cmd = '';
		}
		$cats_data = $this->GetCatsData($parent, false, true, $CatId, true);
		FormRow(' ', System::site()->Select('cat', $cats_data, false, ($parent == -1 ? 'class="autofocus"' : '')));
		FormRow(' ', System::site()->Edit('title', $title, false, 'maxlength="250" style="width:400px;"'.($parent != -1 ? 'class="autofocus"' : '')));
		FormRow('', System::site()->Edit('icon', $icon, false, 'maxlength="250" style="width:400px;"'));
		FormTextRow('', System::site()->HtmlEditor('desc', $desc));
		AddCenterBox($boxtitle);
		AddForm('<form action="'.ADMIN_FILE.'?exe='.$this->module.'&'.$this->action_par_name.'='.$save_met.$OtherUrlParams.'" method="post">', System::site()->Button('', 'onclick="history.go(-1);"').System::site()->Submit($cmd));
	}

	/**
	 *  
	 * @param null $Id
	 * @return bool|int      id ,    .
	 */
	public function EditorSave( $Id = null ){
		$ret = false;
		$title = SafeEnv($_POST['title'], 250, str);
		$desc = SafeEnv($_POST['desc'], 0, str);
		$icon = SafeEnv($_POST['icon'], 250, str);
		$parent = SafeEnv($_POST['cat'], 11, int);
		if($Id == null){
			$query = Values('', $title, $desc, $icon, 0, 0, $parent);
			System::database()->Insert($this->Table, $query);
			Audit(':   "'.$this->Table.'"/"'.$title.'"');
			$ret = System::database()->GetLastId();
			$this->CalcCatCounter($parent, true);
		}else{
			if(in_array($Id, $this->GetAllChildId($Id))){
				$query = "`title`='$title',`description`='$desc',`icon`='$icon',`parent`='$parent'";
				System::database()->Update($this->Table, $query, "`id`='$Id'");
				Audit(':   "'.$this->Table.'"/"'.$title.'"');
				$ret = true;
			}
		}
		System::cache()->Delete('tree', $this->Table);
		return $ret;
	}

	/**
	 *  
	 * @param $Id
	 * @return bool
	 */
	public function DeleteCat( $Id ){
		$cat = System::database()->SelectOne($this->Table, "`id`='$Id'");
		$childs = $this->GetAllChildId($Id);
		for($i = 0, $c = count($childs); $i < $c; $i++){
			System::database()->Delete($this->obj_table, "`$this->obj_cat_coll`='".$childs[$i]."'");
			System::database()->Delete($this->Table, "`id`='".$childs[$i]."'");
		}
		Audit(':   "'.$this->Table.'"/"'.$cat['title'].'"');
		$this->CalcCatCounter($cat['parent'], false);
		System::cache()->Delete('tree', $this->Table);
		return true;
	}

} // End Class;
