<?php

/*
 * LinkorCMS 1.4
 *  2012 LinkorCMS Development Group
 */


/**
 *         
 */

class IndexTree extends Tree{

	public $catTemplate = 'module/cat.html';
	public $moduleName = '';
	public $id_par_name = 'cat';
	public $NumItems = '';
	public $NumItemsCaption = '';
	public $TopCatName = ' ';

	/**
	 *       .
	 * @param $CatId
	 * @since 1.4
	 */
	public function BreadCrumbs( $CatId ){
		if($CatId == 0) return;
		$parents = $this->GetAllParent($CatId);
		foreach($parents as $parent){
			$link = Ufu('index.php?name='.$this->moduleName.'&'.$this->id_par_name.'='.SafeDB($parent['id'], 11, int), $this->moduleName.'/{'.$this->id_par_name.'}/');
			System::site()->BreadCrumbAdd(SafeDB($parent['title'], 255, str), $link);
		}
	}

	/**
	 *       .
	 * @param type $cat_id
	 * @param type $CallBackNumItems
	 * @deprecated since version 1.4
	 */
	public function Catalog( $cat_id = 0, $CallBackNumItems = '' ){
		$this->NumItems = $CallBackNumItems;
		if($cat_id != 0){
			$this->ShowPath($cat_id);
		}
		$this->ShowCats($cat_id);
	}

	/**
	 *   .
	 * @param type $cat_id
	 */
	public function ShowCats( $cat_id ){
		$vars = array();
		$cats = $this->GetChildTree($cat_id);
		$c = count($cats);
		if($c > 0){
			System::site()->AddTemplatedBox('', $this->catTemplate);
			System::site()->AddBlock('cats', true, true, 'cat');
			for($i = 0; $i < $c; $i++){
				$id = SafeDB($cats[$i]['id'], 11, int);

				$vars['url'] = Ufu('index.php?name='.$this->moduleName.'&'.$this->id_par_name.'='.$id, $this->moduleName.'/{'.$this->id_par_name.'}/');
				$vars['title2'] = SafeDB($cats[$i]['title'], 255, str);
				$vars['title'] = '<a href="'.$vars['url'].'">'.$vars['title2'].'</a>';

				if(file_exists($cats[$i]['icon'])){
					$vars['icon_url'] = SafeDB(RealPath2($cats[$i]['icon']), 255, str);
				}else{
					$vars['icon_url'] = 'images/cat.gif';
				}
				$vars['icon'] = '<img border="0" src="'.$vars['icon_url'].'" />';

				$vars['description'] = $cats[$i]['description'];

				$counters = $this->GetCountersRecursive($id);
				$vars['count'] = $counters['files'];
				$vars['cat_count'] = $counters['cats'];

				//  
				$childs = '';
				$sub = '';
				if(isset($cats[$i][TREE_CHILD_ID])){
					for($j = 0, $k = count($cats[$i][TREE_CHILD_ID]); $j < $k; $j++){
						$child_id = SafeDB($cats[$i][TREE_CHILD_ID][$j]['id'], 11, int);
						$child_counters = $this->GetCountersRecursive($child_id);
						$link = Ufu('index.php?name='.$this->moduleName.'&'.$this->id_par_name.'='.$child_id, $this->moduleName.'/{'.$this->id_par_name.'}/');
						$sub .= '<a href="'.$link.'">'.$cats[$i][TREE_CHILD_ID][$j]['title'].'</a>'.'&nbsp;('.$child_counters['files'].'), ';
					}
					$childs .= substr($sub, 0, -2).'.';
				}
				$vars['childs_cats'] = $childs;

				System::site()->AddSubBlock('cats', true, $vars);
			}
			if($cat_id == 0 && function_exists($this->NumItems)){
				$text = '<br>'.$this->NumItemsCaption.call_user_func($this->NumItems);
			}else{
				$text = '';
			}
			System::site()->AddBlock('cat_caption', true, false, '', '', $text);
		}elseif($cat_id == 0){
			System::site()->AddTextBox('', '<p align="center">  .</p>');
		}
	}

	/**
	 *    .
	 * @param type $id
	 * @param type $view_obj
	 * @param type $obj_title
	 * @deprecated since version 1.4
	 */
	public function ShowPath( $id, $view_obj = false, $obj_title = '' ){
		$vars = array();
		$parents = array();
		$parents = $this->GetAllParent($id);
		$parent = $this->GetParentId($id);
		if($parent == 0 && !$view_obj){
			$burl = Ufu('index.php?name='.$this->moduleName, '{name}/');
		}elseif($parent != 0 && !$view_obj){
			$burl = Ufu('index.php?name='.$this->moduleName.'&'.$this->id_par_name.'='.$parent, $this->moduleName.'/{'.$this->id_par_name.'}/');;
		}elseif($view_obj == true){
			$burl = Ufu('index.php?name='.$this->moduleName.'&'.$this->id_par_name.'='.$id, $this->moduleName.'/{'.$this->id_par_name.'}/');;
		}
		$vars['back'] = '[<a href="'.$burl.'">&lt;&lt;&lt;</a>]';
		$vars['back_url'] = $burl;

		$path = '<b><a href="'.Ufu('index.php?name='.$this->moduleName, '{name}/').'">'.$this->TopCatName.'</a></b>';
		if(!$view_obj){
			$c = count($parents) - 1;
		}else{
			$c = count($parents);
		}
		for($i = 0; $i < $c; $i++){
			$link = Ufu('index.php?name='.$this->moduleName.'&'.$this->id_par_name.'='.$parents[$i]['id'], $this->moduleName.'/{'.$this->id_par_name.'}/');
			$path .= '/<a href="'.$link.'">'.$parents[$i]['title'].'</a>';
		}
		if(!$view_obj){
			$path .= '/<b>'.$parents[$c]['title'].'</b>';
		}else{
			$path .= '/<b>'.$obj_title.'</b>';
		}
		$vars['path'] = $path;

		if(System::site()->TemplateExists('module/cat_path.html') !== false){
			System::site()->AddTemplatedBox('', 'module/cat_path.html');
			System::site()->AddBlock('cat_path', true, false, 'path');
			System::site()->Blocks['cat_path']['vars'] = $vars;
		}else{
			System::site()->AddTextBox('', $vars['back'].'&nbsp;'.$path);
		}
	}
}
