<?php

/*
 * LinkorCMS 1.4
 *  2012 LinkorCMS Development Group
 */


if(!defined("USER")){
	define("USER", true);
	define("EXTRA_ADMIN_COOKIE", 'Chahghiu6eiFai2kan4ei'); //         
}else{
	return;
}

/**
 *     
 */
class User{

	public $Auth = false;
	public $Started = false;
	public $session = array();
	public $errors = array();
	public $online = null;
	public $online_process = false;

	/**
	 *       
	 *           . .
	 * @var int
	 */
	public $AliveStatusTime = 600;

	public $SuperUser = false;
	public $host;

	public $userData = null;

	public $access2 = array();
	public $SuperAccess2 = false;

	public $AuthCookieName = 'c_auth';
	public $AdminCookieName = 'c_admin';

	public $SecondLoginAdmin = false;

	/**
	 * .
	 */
	public function __construct(){
		if($this->Started == false){
			if(isset($_GET['PHPSESSID'])){ //   
				session_id($_GET['PHPSESSID']);
			}elseif(isset($_POST['PHPSESSID'])){
				session_id($_POST['PHPSESSID']);
			}elseif(isset($_COOKIE['PHPSESSID'])){
				session_id($_COOKIE['PHPSESSID']);
			}
			session_set_cookie_params(0, GetSiteDir(true));
			if(!session_start()){
				echo $this->errors[] = '<b>!</b>: User->User():    .<br />';
			}else{
				$this->Started = true;
			}
		}
		if(!isset($_SESSION['u_ip']) || $_SESSION['u_ip'] != getip()){ //    ip 
			$_SESSION = array();
		}

		$this->session = $_SESSION;
		$this->Auth = $this->Get('u_auth');

		//   http_referer.    $_SERVER['HTTP_REFERER'].
		if(!IsAjax()){ //  Ajax 
			if($this->isDef('REFERER')){
				$_SERVER['HTTP_REFERER'] = $this->Get('REFERER'); //   HTTP_REFERER
				//  History
				if($this->isDef('HISTORY')){
					$history = $this->Get('HISTORY');
					$history[] = $_SERVER['HTTP_REFERER'];
					if(count($history) > 10){ //       
						array_shift($history);
					}
					$this->Def('HISTORY', $history);
				}else{
					$this->Def('HISTORY', array($_SERVER['HTTP_REFERER']));
				}
			}else{
				if(isset($_SERVER['HTTP_REFERER']) && trim($_SERVER['HTTP_REFERER']) != ''){
					$this->Def('FIRST_REFERER', SafeEnv(trim($_SERVER['HTTP_REFERER']), 255, str));
				}
			}
			$this->Def('REFERER', GetSiteHost().$_SERVER['REQUEST_URI']);
		}
	}

	protected function Started( $func ){
		if($this->Started == false){
			echo $errors[] = "<b>!</b> : User->$func():   .<br />";
			return false;
		}else{
			return true;
		}
	}

	/**
	 *    .
	 * @param type $name
	 * @param type $value
	 */
	public function Def( $name, $value ){
		if($this->Started('Def')){
			$_SESSION[$name] = $value;
			$this->session[$name] = $value;
		}
	}

	/**
	 *   .
	 * @param type $name
	 */
	public function UnDef( $name ){
		if($this->Started('UnDef')){
			unset($_SESSION[$name]);
			unset($this->session[$name]);
		}
	}

	/**
	 *      .
	 * @param type $name
	 * @return type
	 */
	public function isDef( $name ){
		return (isset($this->session[$name]) || isset($_SESSION[$name]));
	}

	/**
	 *     .
	 * @param type $name
	 * @return boolean
	 */
	public function Get( $name ){
		if($this->Started('Get')){
			if(isset($this->session[$name])){
				return $this->session[$name];
			}elseif(isset($_SESSION[$name])){
				return $_SESSION[$name];
			}
			return false;
		}
		return false;
	}

	/**
	 *        .
	 * @param string $Name
	 * @param mixed $Value
	 * @return bool
	 */
	public function Session( $Name, $Value = null ){
		if(isset($Value)){ // 
			$this->Def($Name, $Value);
		}else{ // 
			if($this->isDef($Name)){
				return $this->Get($Name);
			}else{
				return false;
			}
		}
	}

	/**
	 * @param      $Name
	 * @param      $Value
	 * @param null $Expiry
	 */
	public function SetCookie( $Name, $Value, $Expiry = null){
		setcookie($Name, $Value, $Expiry, GetSiteDir(true));
	}

	/**
	 * @param $Name
	 */
	public function UnsetCookie( $Name ){
		if(isset($_COOKIE[$Name])){
			setcookie($Name, null, time() - 3600, GetSiteDir(true));
		}
	}

	/**
	 * @return bool
	 */
	public function isAdmin(){
		if($this->Get('u_level') == ACCESS_ADMIN){
			return true;
		}else{
			return false;
		}
	}

	/**
	 *   .
	 * @return int 1 , 2 , 3 , 4 
	 */
	public function AccessLevel(){
		if($this->Get('u_level') === false){
			return ACCESS_ALL;
		}else{
			return $this->Get('u_level');
		}
	}

	/**
	 *             .
	 * @param Integer $viewlevel   
	 * @param null $user_access   
	 * @internal param int $accesslevel   
	 * @return Boolean
	 */
	public function AccessIsResolved( $viewlevel, $user_access = null ){
		if($user_access == null){
			$user_access = $this->AccessLevel();
		}
		if($user_access == ACCESS_ADMIN){
			return true;
		}elseif($user_access == ACCESS_MEMBER && ($viewlevel == ACCESS_ALL || $viewlevel == ACCESS_MEMBER)){
			return true;
		}elseif($user_access == ACCESS_GUEST && ($viewlevel == ACCESS_ALL || $viewlevel == ACCESS_GUEST)){
			return true;
		}elseif($user_access == $viewlevel){
			return true;
		}
		return false;
	}

	/**
	 *      
	 *       .
	 * $result[group] = array(name,name,name,...);
	 * @param  $UserAccessGroup
	 * @return void
	 * @todo   usertypes    
	 */
	public function AccessInit( $UserAccessGroup ){
		$this->access2 = array();
		$this->SuperUser = false;
		$this->SuperAccess2 = false;
		if($UserAccessGroup == -1 || $UserAccessGroup == 0){
			return;
		}
		$access = System::database()->Select('usertypes', "`id`='".$UserAccessGroup."'");
		$ac2 = array();
		if(System::database()->NumRows() > 0){
			if(trim($access[0]['access']) != 'ALL'){
				$ac2 = unserialize($access[0]['access']);
			}else{
				$this->SuperAccess2 = true;
			}
			if($access[0]['system'] == '1'){
				$this->SuperUser = true;
				$this->SuperAccess2 = true;
			}else{
				$this->SuperUser = false;
			}
		}
		$this->access2 = $ac2;
	}

	/**
	 *     .
	 *         
	 *  false      .
	 * @param  $AccessGroup
	 * @param  $AccessKey
	 * @return bool
	 */
	public function CheckAccess2( $AccessGroup, $AccessKey ){
		if($this->SuperAccess2 || (isset($this->access2[$AccessGroup]) && in_array($AccessKey, $this->access2[$AccessGroup]))){
			return true;
		}else{
			return false;
		}
	}

	/**
	 *    ().
	 * @return bool
	 */
	public function isSuperUser(){
		return $this->SuperUser;
	}

	/**
	 *  id   .
	 * @return int -1 , 0 ,    
	 */
	public function AccessGroup(){
		if(!$this->Auth){
			return -1;
		}
		$acc = $this->Get('u_access');
		if($acc < 0){
			return 0;
		}else{
			return $acc;
		}
	}

	/**
	 *   .
	 * @return string
	 */
	public function Name(){
		return $this->Get('u_name');
	}

	/**
	 *   .
	 * @return int
	 */
	public function Id(){
		return $this->Get('u_id');
	}

	/**
	 *    .
	 * @param $page
	 * @return
	 */
	public function OnlineProcess( $page ){
		if($this->online_process){
			return;
		}else{
			$this->online_process = true;
		}
		//  
		$time = time();
		$time2 = $time - $this->AliveStatusTime;
		System::database()->Delete('online', "`time` < $time2");
		$ip = getip();
		if($this->Auth === true){
			$id = $this->Get('u_id');
		}else{
			$id = -1;
		}
		$name = $this->Get('u_name');
		if(!$name){
			$name = '';
		}
		$level = $this->Get('u_level');
		$where = "`u_ip`='$ip'";
		System::database()->Select('online', $where);
		$uri = SafeEnv($_SERVER['REQUEST_URI'], 255, str);
		if(strpos($uri, ADMIN_FILE) !== false){
			$uri = '';
			$page = '-';
		}
		if(System::database()->NumRows() > 0){
			System::database()->Update('online', "`time`='$time',`u_id`='$id',`u_name`='$name',`u_level`='$level',`p_url`='$uri',`p_title`='$page',`u_ip`='$ip'", $where);
		}else{
			System::database()->Insert('online', "'$time','$id','$name','$level','$uri','$page','$ip'");
		}
	}

	/**
	 *     .
	 * @return array
	 */
	public function Online(){
		if($this->online == null){
			$info = array('admins'=>array(), 'members'=>array(), 'guests'=>array());
			System::database()->Select('online', '');
			while($memb = System::database()->FetchRow()){
				if($memb['u_level'] == 1){
					$info['admins'][] = $memb;
					$info[$memb['u_id']] = $memb;
				}elseif($memb['u_level'] == 2){
					$info['members'][] = $memb;
					$info[$memb['u_id']] = $memb;
				}else{
					$info['guests'][] = $memb;
				}
			}
			$this->online = $info;
			return $info;
		}else{
			return $this->online;
		}
	}

	/**
	 *      .
	 * @param  $num
	 * @param null $user_id
	 * @return bool
	 */
	public function ChargePoints( $num, $user_id = null ){
		if($num == 0 || (!$this->Auth && $user_id == null)){
			return false;
		}
		if($user_id != null){
			$usr = System::database()->SelectOne('users', "`id`='$user_id'");
			if(!$usr){
				return false;
			}
			$points = SafeDB($usr['points'], 11, int) + $num;
		}elseif($this->Auth){
			$user_id = $this->Get('u_id');
			$points = $this->Get('u_points') + $num;
			$this->Def('u_points', $points);
		}else{
			return false;
		}
		System::database()->Update('users', "`points`='$points'", "`id`='$user_id'");
		return true;
	}

	/**
	 *  cookie  .
	 * @param  $login
	 * @param  $password
	 * @param bool $remember
	 * @param int $expiry
	 * @return void
	 */
	public function SetUserCookie( $login, $password_md5, $remember = false, $expiry = 2592000 ){
		$auth = base64_encode($login.':'.md5($password_md5.System::config('salt')));
		if($remember){
			$expiry = time() + $expiry;
		}else{
			$expiry = null;
		}
		$this->SetCookie($this->AuthCookieName, $auth, $expiry);
	}

	public function SetAdminCookie( $login, $password_md5 ){
		$auth = base64_encode($login.':'.md5($password_md5.System::config('salt').EXTRA_ADMIN_COOKIE));
		$this->SetCookie($this->AdminCookieName, $auth);
	}

	/**
	 *       .
	 * @global type $config
	 * @param type $login
	 * @param type $pass
	 * @param type $remember
	 * @param type $Second
	 * @return boolean|string
	 */
	public function Login( $login, $pass, $remember = false, $Second = false ){
		sleep(System::config('security/login_sleep'));
		$login = SafeEnv($login, 32, str);
		$md5_pass = md5(SafeEnv($pass, 32, str));
		$u = System::database()->SelectOne('users', "`login`='".$login."' and `pass`='".$md5_pass."'");
		if($u && $u['active'] == '1'){
			if(!$this->Auth){
				$this->Auth = true;
				$this->SetUserCookie($login, $md5_pass, $remember);
				$this->RegisterData($u);
				$visits = $u['visits'] + 1;
				System::database()->Update('users', "`lastvisit`='".time()."',`lastip`='".getip()."',`visits`='".$visits."'", "`id`='".$u['id']."'");
			}
			if($Second){
				$this->SecondLoginAdmin = ($u['type'] == '1' && $u['id'] == $this->Id());
				if($this->SecondLoginAdmin){
					$this->SetAdminCookie($login, $md5_pass);
					$this->AccessInit(System::user()->AccessGroup());
				}
			}
			return true;
		}else{
			if($Second){
				$this->SecondLoginAdmin = false;
			}else{
				if($u['active'] == '0'){
					return '<p align="center"><br />   .    E-Mail      .        !<br /></p>';
				}else{
					return '<p align="center">    !</p>';
				}
			}
		}
	}

	public function CheckCookies(){
		if(!$this->AllowCookie($this->AuthCookieName)){
			if(isset($_COOKIE[$this->AuthCookieName])){
				$this->UnsetCookie($this->AuthCookieName);
			}
			$this->RegisterGuestData();
		}
	}

	/**
	 *      cookie         .
	 * @global type $config
	 * @param type $CookieName
	 * @param type $AdminCookie
	 * @return boolean
	 */
	public function AllowCookie( $CookieName, $AdminCookie = false ){
		if(defined('SETUP_SCRIPT')) return false;

		//    POST  GET
		if(isset($_GET[$CookieName])){
			$cookie = $_GET[$CookieName];
		}elseif(isset($_POST[$CookieName])){
			$cookie = $_POST[$CookieName];
		}elseif(isset($_COOKIE[$CookieName])){
			$cookie = $_COOKIE[$CookieName];
		}else{
			return false;
		}

		$auth = base64_decode($cookie);
		$auth = explode(":", $auth);
		$login = SafeEnv($auth[0], 255, str);
		$cookie_md5 = $auth[1];

		if($this->isDef('u_md5')){
			$user_password_md5 = $this->Get('u_md5');
		}else{
			if(!isset($users_cache[$login])){
				$user = System::database()->SelectOne('users', "`login`='$login'");
				if(!$user){
					return false;
				}else{
					$user_password_md5 = $user['pass'];
				}
			}
		}

		if($AdminCookie){
			$scode = md5($user_password_md5.System::config('salt').EXTRA_ADMIN_COOKIE);
		}else{
			$scode = md5($user_password_md5.System::config('salt'));
		}
		if($cookie_md5 == $scode){
			if(isset($user)){
				$this->RegisterData($user);
			}
			return true;
		}else{
			return false;
		}
	}

	/**
	 *            .
	 * @global type $config
	 */
	public function UpdateMemberSession(){
		if($this->Auth){
			$user_id = $this->Get('u_id');
			System::database()->Select('users', "`id`='$user_id'");
			if(System::database()->NumRows() > 0){
				$this->RegisterData(System::database()->FetchRow());
			}
		}
	}

	/**
	 *     
	 * @global type $config
	 * @param type $user
	 */
	public function RegisterData( $user ){
		$this->Auth = true;
		$user_id = SafeDB($user['id'], 11, int);
		$this->Def('u_auth', true); //   
		$this->Def('u_level', SafeDB($user['type'], 11, int)); //  
		$this->Def('u_access', SafeDB($user['access'], 11, int)); //     
		$this->Def('u_id', $user_id); //   

		$this->Def('u_login', SafeDB($user['login'], 30, str)); // 
		$this->Def('u_md5', SafeDB($user['pass'], 32, str)); //    md5

		$this->Def('u_name', SafeDB($user['name'], 50, str)); //  
		$this->Def('u_truename', SafeDB($user['truename'], 250, str)); //  
		$this->Def('u_age', SafeDB($user['age'], 3, int)); //  
		$this->Def('u_email', SafeDB($user['email'], 50, str)); //  
		$this->Def('u_hideemail', SafeDB($user['hideemail'], 1, int)); // C   
		$this->Def('u_city', SafeDB($user['city'], 100, str)); // 
		$this->Def('u_icq', SafeDB($user['icq'], 15, str)); //  ICQ 
		$this->Def('u_homepage', SafeDB($user['url'], 250, str)); //   
		$this->Def('u_timezone', SafeDB($user['timezone'], 255, str)); //   
		if($user['data'] != ''){
			$this->Def('u_data', unserialize($user['data'])); //   
		}else{
			$this->Def('u_data', array());
		}

		// 
		$this->UpdateAvatarData($user_id);

		$this->Def('u_regdate', SafeDB($user['regdate'], 11, int)); //  
		$this->Def('u_points', SafeDB($user['points'], 11, int)); //   
		$this->Def('u_ip', getip()); //    ip 
	}

	public function UpdateAvatarData( $user_id ){
		$avatar = GetUserAvatar($user_id);
		$this->Def('u_avatar', $avatar);
		$this->Def('u_avatar_small', GetSmallUserAvatar($user_id, $avatar));
		$this->Def('u_avatar_smallest', GetSmallestUserAvatar($user_id, $avatar));
	}

	/**
	 *    .
	 * @global type $config
	 */
	public function RegisterGuestData(){
		$this->Auth = false;
		$this->Def('u_auth', false);
		$this->Def('u_level', '3');
		$this->Def('u_id', '0');
		$this->Def('u_access', '-1');
		$this->Def('u_ip', getip());
		$this->Def('u_avatar', GetGalleryAvatar('guest.gif'));
		$this->Def('u_data', array());
	}

	/**
	 *         .
	 * @param type $destroy
	 */
	public function UnLogin( $destroy = true ){
		$this->Auth = false;
		$this->UnsetCookie($this->AuthCookieName);
		$this->UnsetCookie($this->AdminCookieName);
		$this->RegisterGuestData();
		if($destroy){
			$_SESSION = array();
			$this->session = array();
			session_destroy();
		}
		$this->RegisterGuestData();
		$ip = getip();
		System::database()->Delete('online', "`u_ip`='$ip'");
	}

	/**
	 *           .
	 * @param $Name $key
	 * @param $Value $value
	 * @return boolean
	 */
	public function Data( $Name = null, $Value = null ){
		return UserData($Name, $Value);
	}

	/**
	 *        .
	 * @param type $Name
	 */
	public function DataDelete( $Name ){
		return UserDataDelete($Name);
	}

}
