<?php

/*
 * LinkorCMS 1.4
 *  2012 LinkorCMS Development Group
 */


if(!defined('VALID_RUN')){
	header("HTTP/1.1 404 Not Found");
	exit;
}

$vars['title'] = $title;

if(System::cache()->HasCache('block', 'forum_last_topics')){
	$topics = System::cache()->Get('block', 'forum_last_topics');
} else{
	$count  = SafeEnv($block_config, 11, int);
	$topics = System::database()->Select('forum_topics', "`delete` = '0'", $count, 'start_date', true); // TODO:     
	System::cache()->Write('block', 'forum_last_topics', $topics, Min2Sec * 10);
}

$en                  = !(count($topics) == 0);
$tempvars['content'] = 'block/content/forum_last_topics.html';
System::site()->AddBlock('no_topics', !$en);
System::site()->AddBlock('last_topics', $en);
System::site()->AddBlock('last_topic', true, true, 't');

foreach($topics as $topic){
	$forum_vars          = array();
	$forum_vars['title'] = SafeDB($topic['title'], 255, str);
	$forum_vars['link']  = Ufu('index.php?name=forum&op=showtopic&topic='.$topic['id'].'&view=lastpost', 'forum/topic{topic}-new.html');
	System::site()->AddSubBlock('last_topic', true, $forum_vars);
}
