<?php

/*
 * LinkorCMS 1.4
 *  2012 LinkorCMS Development Group
 */


if(!defined('VALID_RUN')){
	header("HTTP/1.1 404 Not Found");
	exit;
}

$vars['title'] = $title;
$block_config = unserialize($block_config);

$bcache_name = 'random_images'.System::user()->AccessLevel();
if(!System::cache()->HasCache('block', $bcache_name)){
	if(in_array(0, $block_config['cats'])){
		$where = '';
	}else{
		$where = array();
		foreach($block_config['cats'] as $cat){
			$where[] = "`cat_id` = '".SafeEnv($cat, 11, int)."'";
		}
		$where = '('.implode(' or ', $where).') and ';
	}
	$imagesdb = System::database()->Select('gallery', GetWhereByAccess('view', "$where`show`='1'"));
	$images = array();
	foreach($imagesdb as $img){
		$images[] = array(
			'id' => SafeDB($img['id'], 11, int),
			'cat_id' => SafeDB($img['cat_id'], 11, int),
			'file' => SafeDB($img['file'], 255, str),
			'title' => SafeDB($img['title'], 255, str)
		);
	}
	System::cache()->Write('block', $bcache_name, $images);
}else{
	$images = System::cache()->Get('block', $bcache_name);
}

$count = count($images);
$en = !($count == 0);
$tempvars['content'] = 'block/content/random_images.html';
System::site()->AddBlock('no_images', !$en);
System::site()->AddBlock('random_images', $en, true, 'img');

if($en){
	for($i = 0; $i < $block_config['count']; $i++){
		if($count == 0) break;
		$rand = rand(0, $count - 1);
		$image = $images[$rand];
		array_splice($images, $rand, 1);
		$count--;
		$img_vars = array();
		$img_vars['src'] = System::config('gallery/thumbs_dir').$image['file'];
		$img_vars['url'] = Ufu('index.php?name=gallery&op=view&img='.$image['id'].'&cat='.$image['cat_id'], 'gallery/{cat}/{img}/');
		$img_vars['title'] = $image['title'];
		System::site()->AddSubBlock('random_images', true, $img_vars);
	}
}
