<?php

/*
 * LinkorCMS 1.4
 *  2012 LinkorCMS Development Group
 */


//        Content-Encoding

if($_SERVER['REQUEST_METHOD'] == "HEAD"){
	header("X-Request: HEAD");
	exit();
}

header("X-Process: headers.php");

// 
if(!isset($_GET['nogz'])){
	require 'config/config.php';
	$use_gzip = USE_GZIP_STATIC;
}else{ // Gzip      (    .gz)
	$use_gzip = false;
}

$types = array(
    'js' => 'application/javascript',
    'css' => 'text/css',
    'htm' => 'text/html',
    'html' => 'text/html'
);

$filename = $_GET['file'];

// RealPath
$filename = str_replace('\\', '/', $filename);
$path_result = array();
foreach(explode('/', $filename) as $name){
	$name2 = str_replace('.', '', $name);
	if($name2 != ''){
		$path_result[] = $name;
	}
}
$filename = implode('/', $path_result);

// PathInfo
$pathinfo = pathinfo($filename);

//    
if(!isset($types[$pathinfo['extension']])){
	header("HTTP/1.1 404 Not Found");
	exit();
}

//  .gz        ,   .
$basename = $pathinfo['filename'];
$pathname = $pathinfo['dirname'];
if($pathname != ''){
	$pathname .= '/';
}
$gz = '';
if(($pos = strrpos($basename, '.')) !== false){
	$gz = substr($basename, $pos);
}
if($gz == '.gz'){ //  .gz
	if(!$use_gzip){
		$basename = substr($basename, 0, $pos);
	}
}else{ //  .gz
	if($use_gzip){
		$basename .= '.gz';
	}
}
$filename = $pathname.$basename.'.'.$pathinfo['extension'];

if(!is_file($filename)){ //   
	header("HTTP/1.1 404 Not Found");
	exit;
}

//   
$mod_time = filemtime($filename);
$use_env = array_key_exists('HTTP_HOST', $_ENV);

$since = 0;
$since_str = '';
if($use_env && isset($_ENV['HTTP_IF_MODIFIED_SINCE'])){
	$since_str = $_ENV['HTTP_IF_MODIFIED_SINCE'];
}
if(!$use_env && isset($_SERVER['HTTP_IF_MODIFIED_SINCE'])){
	$since_str = $_SERVER['HTTP_IF_MODIFIED_SINCE'];
}
if($since_str != ''){
	$since_str = explode(";", $since_str); //  IE
	$since = strtotime(trim($since_str[0]));
}

if($since == 0 || $mod_time > $since){
	Header("Cache-Control: private"); //    
	Header('Last-Modified: '.gmdate('r', $mod_time).' GMT');
	Header('Content-Type: '.$types[$pathinfo['extension']]);
	if($use_gzip){
		Header('Content-Encoding: gzip');
	}
}else{
	Header('HTTP/1.1 304 Not Modified');
	Header('Connection: Close');
	exit();
}

readfile($filename);