<?php

/*
 * LinkorCMS 1.4
 *  2012 LinkorCMS Development Group
 */


define('MAIN_SCRIPT', true);
define('VALID_RUN', true);

require 'config/init.php'; //   

// 
UfuInit();

//   
$ModuleName = '';
if(!isset($_GET['name'])){
	define('INDEX_PHP', true); //    
	$ModuleName = SafeEnv(System::config('general/site_module'), 255, str, false, false);
}else{
	define('INDEX_PHP', false);
	$ModuleName = SafeEnv($_GET['name'], 255, str);
}

//    
if(System::config('general/private_site') && System::user()->AccessLevel() != 1){
	System::site()->InitPage('no_access.html');
	System::site()->SetVar('template', 'header', '   '); //       
	System::site()->SetVar('template', 'text', ' .');
	System::site()->TEcho();
	exit;
}

//  
define('MOD_DIR', System::config('mod_dir').$ModuleName.'/');
define('MOD_FILE', MOD_DIR.'index.php');
define('MOD_INIT', MOD_DIR.'init.php');
define('MOD_ICON', is_file(MOD_DIR.'icon.png') ? MOD_DIR.'icon.png' : 'images/application.png');

$module = System::database()->SelectOne('modules', "`enabled`='1' and `folder`='".SafeEnv($ModuleName, 255, str)."'");
if($module === false){
	Error404();
}
//   
if(!AccessIsResolved($module['view'], System::user()->AccessLevel()) || ($module['system'] == '1' && !System::user()->isSuperUser())){
	Header('HTTP/1.1 403 Forbidden');
	System::site()->InitPage();
	System::site()->AddTextBox('', '<p align="center"> .</p>');
	System::site()->TEcho();
	exit;
}

define('MOD_NAME', SafeDB($module['folder'], 255, str));
define('MOD_TITLE', SafeDB($module['name'], 255, str));
define('MOD_THEME', RealPath2(SafeDB($module['theme'], 255, str)));

//  
$valid_init = file_exists(MOD_INIT);
if($valid_init){
	include MOD_INIT;
	if(function_exists('mod_initialization')){
		mod_initialization();
	}
}
if(!$system['no_templates']){ // 
	System::site()->InitPage();
}
if(!$system['no_messages']){ // 
	include_once(System::config('inc_dir').'messages.inc.php');
}
if(is_file(MOD_FILE)){ //  
	require MOD_FILE;
}

// 
$ClassName = 'Module_'.$ModuleName;
if(class_exists($ClassName, false)){
	System::run($ClassName);
}

if(!$system['no_messages']){ //  
	BottomMessages();
}
if(!$system['no_echo']){ //   
	System::site()->TEcho();
}
if($valid_init){ //  
	if(function_exists('mod_finalization')){
		mod_finalization();
	}
}