<?php

/*
 * LinkorCMS 1.4
 *  2012 LinkorCMS Development Group
 */


if(!defined('VALID_RUN')){
	header("HTTP/1.1 404 Not Found");
	exit;
}

if(!System::user()->CheckAccess2('articles', 'articles')){
	System::admin()->AccessDenied();
}

System::admin()->AddSubTitle(' ');

global $editarticles;
$editarticles = System::user()->CheckAccess2('articles', 'edit_articles');
$editcats = System::user()->CheckAccess2('articles', 'edit_cats');
$editconf = System::user()->CheckAccess2('articles', 'config');

if(isset($_GET['a'])){
	$action = $_GET['a'];
}else{
	$action = 'main';
}

TAddToolLink('', 'main', 'articles');
if($editarticles) TAddToolLink(' ', 'editor', 'articles&a=editor');
if($editcats) TAddToolLink('', 'cats', 'articles&a=cats');
if($editcats) TAddToolLink(' ', 'cateditor', 'articles&a=cateditor');
if($editconf) TAddToolLink('', 'config', 'articles&a=config');
TAddToolBox($action);

switch($action){
	case 'main':
		AdminArticlesMain();
		break;
	case 'editor':
		AdminArticlesEditor();
		break;
	case 'preview':
		AdminArticlesPreview();
		break;
	case 'add':
	case 'save':
		AdminArticlesSaveArticle($action);
		break;
	case 'changestatus':
		AdminArticlesChangeStatus();
		break;
	case 'delete':
		AdminArticlesDelete();
		break;
	case 'resethits':
		AdminArticlesResetHits();
		break;
	case 'resetrating':
		AdminArticlesResetRating();
		break;
	// 
	case 'cats':
		if(!$editcats){
			System::admin()->AccessDenied();
		}else{
			$result = AdminArticlesGetTree()->ShowCats();
			if($result == false){
				$result = '   .';
			}
			AddTextBox('', $result);
		}
		break;
	case 'cateditor':
		if(!$editcats){
			System::admin()->AccessDenied();
		}else{
			if(isset($_GET['id'])){
				$id = SafeEnv($_GET['id'], 11, str);
			}else{
				$id = null;
			}
			if(isset($_GET['to'])){
				$to = SafeEnv($_GET['to'], 11, str);
			}else{
				$to = null;
			}
			$back = '';
			if(isset($_REQUEST['back'])){
				$back = '&back='.SafeDB($_REQUEST['back'], 255, str);
			}
			AdminArticlesGetTree()->CatEditor($id, $to, $back);
		}
		break;
	case 'catsave':
		if(!$editcats) System::admin()->AccessDenied();
		$ret = AdminArticlesGetTree()->EditorSave((isset($_GET['id']) ? SafeEnv($_GET['id'], 11, int) : null));
		if(isset($_REQUEST['back'])){
			GoRefererUrl($_REQUEST['back'], (!isset($_GET['id']) ? '&to='.$ret : ''));
		}else{
			GO(ADMIN_FILE.'?exe=articles&a=cats');
		}
		break;
	case 'delcat':
		if(!$editcats){
			System::admin()->AccessDenied();
		}else{
			if(AdminArticlesGetTree()->DeleteCat(SafeEnv($_GET['id'], 11, int))){
				GO(ADMIN_FILE.'?exe=articles&a=cats');
			}
		}
		break;
	// 
	case 'config':
		if(!$editconf){
			System::admin()->AccessDenied();
		}
		System::admin()->AddCenterBox('  " "');
		if(CheckGet('saveok')){
			System::admin()->Highlight(' .');
		}
		System::admin()->ConfigGroups('articles');
		System::admin()->AddConfigsForm(ADMIN_FILE.'?exe=articles&a=configsave');
		break;
	case 'configsave':
		if(!$editconf){
			System::admin()->AccessDenied();
		}
		System::admin()->SaveConfigs('articles');
		GO(ADMIN_FILE.'?exe=articles&a=config&saveok');
		break;
}

function AdminArticlesGetTree() {
	static $tree = null;
	if(is_null($tree)) {
		$tree = new AdminTree('articles_cats');
		$tree->module = 'articles';
		$tree->obj_table = 'articles';
		$tree->obj_cat_coll = 'cat_id';
		$tree->showcats_met = 'cats';
		$tree->edit_met = 'cateditor';
		$tree->save_met = 'catsave';
		$tree->del_met = 'delcat';
		$tree->action_par_name = 'a';
		$tree->id_par_name = 'id';
		$tree->index_id_par_name = 'cat';
	}
	return $tree;
}

//  -  
function AdminArticlesMain(){
	global $editarticles;

	// ,      .
	if(isset($_GET['cat']) && $_GET['cat'] > -1){
		$cat = SafeEnv($_GET['cat'], 11, int);
		$where = "`cat_id`='$cat'";
	}else{
		$cat = -1;
		$where = "";
	}
	$data = array();
	$data = AdminArticlesGetTree()->GetCatsData($cat, true);
	System::site()->DataAdd($data, -1, ' ', $cat == -1);

	//   
	if(isset($_GET['page'])){
		$page = SafeEnv($_GET['page'], 10, int);
	}else{
		$page = 1;
	}
	AddCenterBox('');

	//    
	System::admin()->AddJS('
	ArticlesSelectCat = function(){
		Admin.LoadPage("'.ADMIN_FILE.'?exe=articles&cat="+$("#article-cat").val());
	}
	');
	$text = '<div style="text-align: center; margin-bottom: 10px;">: '.System::site()->Select('cat', $data, false, 'id="article-cat" onchange="ArticlesSelectCat();"').'</div>';
	AddText($text);

	//          .
	$r = System::database()->Select('articles', $where);
	SortArray($r, 'public', true); //    
	if(count($r) > System::config('articles/articles_on_page')){
		$navigator = new Navigation($page);
		$navigator->GenNavigationMenu($r, System::config('articles/articles_on_page'), ADMIN_FILE.'?exe=articles'.($cat > 0 ? '&cat='.$cat : ''));
		$nav = true;
	}else{
		$nav = false;
	}
	$text = '<table cellspacing="0" cellpadding="0" class="cfgtable">';
	$text .= '<tr><th></th><th></th><th></th><th></th><th></th><th></th></tr>';

	$back = SaveRefererUrl();
	foreach($r as $art){
		$id = SafeDB($art['id'], 11, int);
		$cat_id = SafeDB($art['cat_id'], 11, int);
		$title = SafeDB($art['title'], 255, str);
		$hits = SafeDB($art['hits'], 11, int);
		$rating = '<img src="'.GetRatingImage(SafeDB($art['num_votes'], 11, int), SafeDB($art['all_votes'], 11, int)).'" border="0" />';
		$st = ($art['active'] == '1' ? '.' : '.');

		$link_go = Ufu("index.php?name=articles&op=read&art=$id&cat=$cat_id", 'articles/{cat}/{art}/');

		$func = '';
		$func .= System::admin()->SpeedButton('    ', $link_go, 'images/link_go.png', false, false, 'target="_blank"');
		if($editarticles){
			$title = '<b>'.System::admin()->Link($title, ADMIN_FILE.'?exe=articles&a=editor&id='.$id.'&back='.$back).'</b>';
			$hits .= '&nbsp;'.System::admin()->SpeedConfirm('  ', ADMIN_FILE.'?exe=articles&a=resethits&id='.$id.'&back='.$back, 'images/admin/arrow_in.png', '  ?');
			$rating .= '&nbsp;'.System::admin()->SpeedConfirm('   ('.SafeDB($art['num_votes'], 11, int).' )', ADMIN_FILE.'?exe=articles&a=resetrating&id='.$id.'&back='.$back, 'images/admin/arrow_in.png', ' ?');
			$st = System::admin()->SpeedStatus('', '', ADMIN_FILE.'?exe=articles&a=changestatus&id='.$id, $art['active'] == '1');

			$func .= System::admin()->SpeedButton('', ADMIN_FILE.'?exe=articles&a=editor&id='.$id.'&back='.$back, 'images/admin/edit.png');
			$func .= System::admin()->SpeedConfirm('', ADMIN_FILE.'?exe=articles&a=delete&id='.$id.'&ok=1&back='.$back, 'images/admin/delete.png', ' ?');
		}
		$text .= '<tr>
		<td>'.$title.'</td>
		<td>'.$hits.'</td>
		<td>'.($art['allow_votes'] == '1' ? $rating : '').'</td>
		<td>'.ViewLevelToStr(SafeDB($art['view'], 1, int)).'</td>
		<td>'.$st.'</td>
		<td>'.$func.'</td>
		</tr>';
	}
	$text .= '</table>';

	AddText($text);
	if($nav){
		AddNavigation();
	}
}

//   - , 
function AdminArticlesEditor(){
	global $editarticles;
	if(!$editarticles){
		System::admin()->AccessDenied();
	}
	$cat_id = (isset($_GET['to']) ? SafeDB($_GET['to'], 11, int) : 0);
	$author = '';
	$email = '';
	$www = '';
	$title = '';
	$description = '';
	$article = '';
	$image = '';
	$auto_br_desc = false;
	$auto_br_article = false;
	$allow_comments = true;
	$allow_votes = true;
	$view = 4;
	$active = true;
	// SEO
	$seo_title = '';
	$seo_keywords = '';
	$seo_description = '';
	//
	if(!isset($_GET['id'])){
		$action = 'add';
		$top = ' ';
		$cap = '';
	}else{
		$id = SafeEnv($_GET['id'], 11, str);
		System::database()->Select('articles', "`id`='$id'");
		$art = System::database()->FetchRow();
		$cat_id = SafeDB($art['cat_id'], 11, int);
		$author = SafeDB($art['author'], 200, str);
		$email = SafeDB($art['email'], 50, str);
		$www = SafeDB($art['www'], 250, str);
		$title = SafeDB($art['title'], 255, str);
		$description = SafeDB($art['description'], 0, str, false);
		$article = SafeDB($art['article'], 0, str, false);
		$image = SafeDB($art['image'], 250, str);

		$auto_br_article = SafeDB($art['auto_br_article'], 1, bool);
		$auto_br_desc = SafeDB($art['auto_br_desc'], 1, bool);

		$active = SafeDB($art['active'], 1, bool);

		$allow_comments = SafeDB($art['allow_comments'], 1, int);
		$allow_votes = SafeDB($art['allow_votes'], 1, int);
		$view = SafeDB($art['view'], 1, int);
		// SEO
		$seo_title = SafeDB($art['seo_title'], 255, str);
		$seo_keywords = SafeDB($art['seo_keywords'], 255, str);
		$seo_description = SafeDB($art['seo_description'], 255, str);
		//
		$action = 'save&id='.$id;
		$top = ' ';
		$cap = ' ';
	}

	System::admin()->AddJS(Indent('
		ArticlesPreviewOpen = function(){
			if(tinyMCE){
				tinyMCE.triggerSave();
			}
			var form_data = Admin.SerializeFormData(document.forms.edit_form);
			var left = parseInt(screen.width / 2) - 400;
			var top = parseInt(screen.height / 10);
			var wp = window.open("", "Preview", "resizable=yes,scrollbars=yes,menubar=no,status=no,location=no,width=800,height=600,left="+left+",top="+top+"");
			wp.document.open();
			$.ajax({
				type: "POST",
				url: "'.ADMIN_FILE.'?exe=articles&a=preview",
				data: form_data,
				dataType: "html",
				success: function(data){
					wp.document.write(data);
					wp.document.close();
				}
			});
		}
	'));

	$cats_data = AdminArticlesGetTree()->GetCatsData($cat_id);
	if(count($cats_data) == 0){
		$back_to_form = SaveRefererUrl();
		AddTextBox($top, '   ! '.System::admin()->SpeedButton(' ', ADMIN_FILE.'?exe=articles&a=cateditor&back='.$back_to_form, '', true, true));
		return;
	}

	FormRow(' ', System::site()->Select('category', $cats_data, false, ($cat_id == 0 ? 'class="autofocus"' : '')));
	FormRow('', System::site()->Edit('title', $title, false, 'maxlength="250" style="width:400px;"'.($cat_id != 0 ? 'class="autofocus"' : '')));
	// SEO
	FormRow('[seo]  ', System::site()->Edit('seo_title', $seo_title, false, 'style="width:400px;"'));
	FormRow('[seo]  ', System::site()->Edit('seo_keywords', $seo_keywords, false, 'style="width:400px;"'));
	FormRow('[seo] ', System::site()->Edit('seo_description', $seo_description, false, 'style="width:400px;"'));
	//
	AdminImageControl('', ' ', $image, System::config('articles/images_dir'));

	FormTextRow('  (HTML)', System::site()->HtmlEditor('description', $description, 600, 200));
	FormRow('', '   HTML: '.System::site()->Select('auto_br_desc', GetEnData($auto_br_desc, '', '')));

	FormTextRow('  (HTML)', System::site()->HtmlEditor('article', $article, 600, 400));
	FormRow('', '   HTML: '.System::site()->Select('auto_br_article', GetEnData($auto_br_article, '', '')));

	FormRow('', System::site()->Edit('author', $author, false, 'style="width:400px;" maxlength="50"'));
	FormRow('E-mail ', System::site()->Edit('email', $email, false, 'style="width:400px;" maxlength="50"'));
	FormRow(' ', System::site()->Edit('www', $www, false, 'style="width:400px;" maxlength="250"'));
	FormRow('', System::site()->Select('allow_comments', GetEnData($allow_comments, '', '')));
	FormRow('', System::site()->Select('allow_votes', GetEnData($allow_votes, '', '')));
	FormRow(' ', System::site()->Select('view', GetUserTypesFormData($view)));
	FormRow('', System::site()->Select('active', GetEnData($active, '', '')));
	AddCenterBox($top);
	if(!isset($_REQUEST['back'])){
		$_REQUEST['back'] = SaveRefererUrl(ADMIN_FILE.'?exe=articles');
	}
	AddForm('<form name="edit_form" action="'.ADMIN_FILE.'?exe=articles&a='.$action.'&back='.SafeDB($_REQUEST['back'], 255, str).'" method="post" enctype="multipart/form-data">',
		System::site()->Button('', 'onclick="history.go(-1)"')
		.System::site()->Button('', 'onclick="ArticlesPreviewOpen();"')
		.System::site()->Submit($cap));
}

function AdminArticlesPreview(){
	$_POST = ObjectUtf8ToCp1251($_POST);

	$preview = new Page('module/page.html', '', false, PAGE_SPECIAL);
	$preview->Doctype = '<!DOCTYPE html>';
	$preview->AddCSSFile('style.css');

	$preview->AddBlock('page');
	$vars = array();
	$vars['show_info'] = false;
	$vars['show_title'] = true;
	$vars['title'] = SafeDB($_POST['title'], 255, str);
	if($_POST['auto_br_desc'] == '1'){
		$description = nl2br(SafeDB($_POST['description'], 0, str, false, false));
	}else{
		$description = SafeDB($_POST['description'], 0, str, false, false);
	}
	$vars['text'] = $description;

	if($_POST['auto_br_article'] == '1'){
		$article = nl2br(SafeDB($_POST['article'], 0, str, false, false));
	}else{
		$article = SafeDB($_POST['article'], 0, str, false, false);
	}
	$vars['text'] .= $article;

	$preview->SetTitle($vars['title']);

	$preview->SetVars('page', $vars);
	$preview->TEcho(false, false);
	exit();
}

//    
function AdminArticlesSaveArticle( $action ){
	global $editarticles;
	if(!$editarticles){
		System::admin()->AccessDenied();
	}
	$cat_id = SafeEnv($_POST['category'], 11, int);
	if(in_array($cat_id, AdminArticlesGetTree()->GetAllChildId(0)) === false || $cat_id == 0){
		GO(ADMIN_FILE.'?exe=articles');
	}
	$author = SafeEnv($_POST['author'], 200, str, true);
	$email = SafeEnv($_POST['email'], 50, str, true);
	$www = SafeEnv(Url($_POST['www']), 250, str, true);
	$title = SafeEnv($_POST['title'], 255, str);
	$description = SafeEnv($_POST['description'], 0, str, false, true, false);
	$article = SafeEnv($_POST['article'], 0, str, false, true, false);
	//  
	$Error = false;
	$image = LoadImage('up_image', System::config('articles/images_dir'), System::config('articles/images_dir').'thumbs', System::config('articles/thumb_max_width'), System::config('articles/thumb_max_height'), $_POST['image'], $Error);
	$auto_br_desc = EnToInt($_POST['auto_br_desc']);
	$auto_br_article = EnToInt($_POST['auto_br_article']);
	$allow_comments = EnToInt($_POST['allow_comments']);
	$allow_votes = EnToInt($_POST['allow_votes']);
	$view = ViewLevelToInt($_POST['view']);
	$active = EnToInt($_POST['active']);
	// SEO
	$seo_title = SafeEnv($_POST['seo_title'], 255, str);
	$seo_keywords = SafeEnv($_POST['seo_keywords'], 255, str);
	$seo_description = SafeEnv($_POST['seo_description'], 255, str);
	//
	if('add' == $action){
		$values = Values('', $cat_id, time(), $author, $email, $www, $title, $description, $article, $image, 0, $allow_comments, 0, $allow_votes, 0, 0, $active, $view, $auto_br_desc, $auto_br_article, $seo_title, $seo_keywords, $seo_description);
		System::database()->Insert('articles', $values);
		if($active){
			AdminArticlesGetTree()->CalcFileCounter($cat_id, true);
		}
		Audit(':   "'.$title.'"');
	}elseif('save' == $action){
		$set = "`cat_id`='$cat_id',`author`='$author',`email`='$email',`www`='$www',`title`='$title',`description`='$description',`article`='$article',`image`='$image',`allow_comments`='$allow_comments',`allow_votes`='$allow_votes',`view`='$view',`active`='$active',`auto_br_desc`='$auto_br_desc',`auto_br_article`='$auto_br_article',`seo_title`='$seo_title',`seo_keywords`='$seo_keywords',`seo_description`='$seo_description'";
		$id = SafeEnv($_GET['id'], 11, int);
		$r = System::database()->Select('articles', "`id`='$id'");
		if($r[0]['cat_id'] != $cat_id && $r[0]['active'] == '1'){ //     
			AdminArticlesGetTree()->CalcFileCounter($r[0]['cat_id'], false);
			AdminArticlesGetTree()->CalcFileCounter($cat_id, true);
		}
		if($r[0]['active'] != $active){ //  / 
			if($active == 0){
				AdminArticlesGetTree()->CalcFileCounter($cat_id, false);
			}else{
				AdminArticlesGetTree()->CalcFileCounter($cat_id, true);
			}
		}
		System::database()->Update('articles', $set, "`id`='$id'");
		Audit(':   "'.$title.'"');
	}
	if($Error){
		AddTextBox('', '<p align="center">  .      GIF, JPEG  PNG.   .</p><br><a href="'.GetRefererUrl($_REQUEST['back']).'" class="button"></a>');
		return;
	}
	GoRefererUrl($_REQUEST['back']);
}

//   
function AdminArticlesChangeStatus(){
	global $editarticles;
	if(!$editarticles){
		if(IsAjax()){
			exit("ERROR");
		}
		System::admin()->AccessDenied();
	}
	if(!isset($_GET['id'])){
		if(IsAjax()){
			exit("ERROR");
		}
		GO(ADMIN_FILE.'?exe=articles');
	}
	System::database()->Select('articles', "`id`='".SafeEnv($_GET['id'], 11, int)."'");
	if(System::database()->NumRows() > 0){
		$r = System::database()->FetchRow();
		if($r['active'] == 1){
			$en = '0';
			AdminArticlesGetTree()->CalcFileCounter($r['cat_id'], false);
		}else{
			$en = '1';
			AdminArticlesGetTree()->CalcFileCounter($r['cat_id'], true);
		}
		System::database()->Update('articles', "`active`='$en'", "`id`='".SafeEnv($_GET['id'], 11, int)."'");
		Audit(':    "'.$r['title'].'"');
	}
	if(IsAjax()){
		exit("OK");
	}
	GO(ADMIN_FILE.'?exe=articles');
}

//  
function AdminArticlesDelete(){
	global $editarticles;
	if(!$editarticles) System::admin()->AccessDenied();
	if(IsAjax() || isset($_GET['ok']) && $_GET['ok'] == '1'){
		$id = SafeEnv($_GET['id'], 11, int);
		$r = System::database()->Select('articles', "`id`='".$id."'");
		AdminArticlesGetTree()->CalcFileCounter($r[0]['cat_id'], false);
		System::database()->Delete('articles', "`id`='$id'");
		System::database()->Delete('articles_comments', "`object_id`='$id'");
		Audit(':   "'.$r['title'].'"');
		GoRefererUrl($_REQUEST['back']);
	}else{
		System::admin()->AddCenterBox(' ');
		System::database()->Select('articles', "`id`='".SafeEnv($_REQUEST['id'], 11, int)."'");
		$article = System::database()->FetchRow();
		$id = SafeDB($_REQUEST['id'], 11, int);
		$back = SafeDB($_REQUEST['back'], 255, str);
		System::admin()->HighlightConfirmNoAjax('  "'.SafeDB($article['title'], 255, str).'"?', ADMIN_FILE.'?exe=articles&a=delete&id='.$id.'&ok=1&back='.$back);
	}
}

//    
function AdminArticlesResetHits(){
	global $editarticles;
	if(!$editarticles) System::admin()->AccessDenied();
	if(isset($_GET['id'])){
		$id = SafeEnv($_GET['id'], 11, int);
		System::database()->Select('articles', "`id`='$id'");
		$r = System::database()->FetchRow();
		System::database()->Update('articles', "hits='0'", "`id`='$id'");
		Audit(':      "'.$r['title'].'"');
	}
	GoRefererUrl($_REQUEST['back']);
}

//   
function AdminArticlesResetRating(){
	global $editarticles;
	if(!$editarticles) System::admin()->AccessDenied();
	$id = SafeEnv($_GET['id'], 11, int);
	System::database()->Select('articles', "`id`='$id'");
	$r = System::database()->FetchRow();
	System::database()->Update('articles', "num_votes='0',all_votes='0'", "`id`='$id'");
	Audit(':    "'.$r['title'].'"');
	GoRefererUrl($_REQUEST['back']);
}

