<?php

/*
 * LinkorCMS 1.4
 *  2012 LinkorCMS Development Group
 */


if(!defined('VALID_RUN')){
	header("HTTP/1.1 404 Not Found");
	exit();
}

System::admin()->AddSubTitle('');

if(!System::user()->isSuperUser()){
	System::admin()->AccessDenied();
}

if(isset($_GET['a'])){
	$action = $_GET['a'];
}else{
	$action = 'referers';
}

if(System::user()->CheckAccess2('audit', 'audit_conf')){
	TAddToolLink('  ', 'referers', 'audit&a=referers');
	TAddToolLink('', 'log', 'audit&a=log');
}
TAddToolBox($action);


switch($action){
	case 'referers':
		AdminAuditReferers();
		break;
	case 'clear_referers':
		AdminAuditClearReferers();
		break;

	case 'log':
		AdminAuditLog();
		break;
	case 'clear_log':
		AdminAuditClearLog();
		break;

	default:
		AdminAuditLog();
}

//   
function AdminAuditLog(){
	AddCenterBox('  ');
	$query = System::database()->Select('audit', '');
	$count = count($query);

	if($count > 0){
		if(isset($_GET['page'])){
			$page = SafeEnv($_GET['page'], 10, int);
		}else{
			$page = 1;
		}
		SortArray($query, 'date', true);

		$num = 25;
		if($count > $num){
			$navigator = new Navigation($page);
			$navigator->GenNavigationMenu($query, $num, ADMIN_FILE.'?exe=audit&a=log');
			$nav = true;
		}else{
			$nav = false;
		}
		$text = '<table cellspacing="0" cellpadding="0" class="cfgtable">';
		$text .= Indent('<tr>
			<th></th>
			<th></th>
			<th></th>
			<th>IP</th>
		</tr>');
		foreach($query as $q){
			$user = GetUserInfo(SafeDB($q['user'], 11, int));
			$date = TimeRender(SafeDB($q['date'], 11, int));
			$action = SafeDB($q['action'], 255, str);
			$action = nl2br(str_replace(array(' ', "\t"), array('&nbsp;', '&nbsp;&nbsp;&nbsp;&nbsp;'), $action));
			$ip = SafeDB($q['ip'], 255, str);
			$text .= '<tr>
			<td>'.System::admin()->Link(SafeDB($user['name'], 50, str), ADMIN_FILE.'?exe=admins&a=editadmin&id='.SafeDB($user['id'], 11, int)).'</td>
			<td style="text-align: left;">'.$action.'</td>
			<td>'.$date.'</td>
			<td>'.$ip.'</td>
			</tr>';
		}
		$text .= '</table>';
		$text .= System::admin()->SpeedConfirm('  ', ADMIN_FILE.'?exe=audit&a=clear_log', '', '   ?', true, true);
		AddText($text);
		if($nav){
			AddNavigation();
		}
	}else{
		System::admin()->Highlight('    .');
	}
}

//    
function AdminAuditClearLog(){
	System::database()->Delete('audit', '');
	Audit(':    ');
	GO(ADMIN_FILE.'?exe=audit&a=log');
}

//  
function AdminAuditReferers(){
	System::admin()->AddCenterBox('   ()');

	$query = System::database()->Select('referers', '');
	SortArray($query, 'count', true);

	$allcount = 0;
	$count = count($query);
	if(isset($_GET['page'])){
		$page = SafeEnv($_GET['page'], 10, int);
	}else{
		$page = 1;
	}
	$num = 50;
	if($count > $num){
		$navigator = new Navigation($page);
		$navigator->GenNavigationMenu($query, $num, ADMIN_FILE.'?exe=audit&a=referers');
		$nav = true;
	}else{
		$nav = false;
	}

	if($count == 0){
		System::admin()->Highlight('   .');
	}elseif($count >= 1){
		$text = '<table cellspacing="0" cellpadding="0" class="cfgtable">';
		$text .= Indent('<tr>
			<th></th>
			<th></th>
		</tr>');
		foreach($query as $q){
			$referer = 'http://'.$q['referer'];
			$title = AdminAuditDecodeUrl($referer);
			$count = SafeDB($q['count'], 11, int);
			$allcount += $count;
			$text .= '<tr>
			<td><a href="'.$referer.'" target="_blank">'.$title.'</a></td>
			<td>'.$count.'</td>
			</tr>';
		}
		$text .= '</table>';
		$text .= '    : <b>'.$allcount.'</b>.&nbsp;'
			.System::admin()->SpeedConfirm('  ', ADMIN_FILE.'?exe=audit&a=clear_referers', '', '  ?', true, true);

		AddText($text);

		if($nav){
			AddNavigation();
		}
	}
}

function AdminAuditClearReferers(){
	System::database()->Delete('referers', '');
	Audit(':   ');
	GO(ADMIN_FILE.'?exe=audit&a=referers');
}

function AdminAuditDecodeUrl( $Referer = '' ){
	$url = new Url($Referer);
	foreach($url as $key=>$value){
		$url[$key] = AdminAuditDecode($value);
	}
	return $url->ToString(false);
}

function AdminAuditDecode( $str ){
	static $conv = null;
	if(!isset($conv)){
		$conv = array();
		for($x = 128; $x <= 143; $x++){
			$conv['utf'][] = chr(209).chr($x);
			$conv['win'][] = chr($x + 112);
		}
		for($x = 144; $x <= 191; $x++){
			$conv['utf'][] = chr(208).chr($x);
			$conv['win'][] = chr($x + 48);
		}
		$conv['utf'][] = chr(208).chr(129);
		$conv['win'][] = chr(168);
		$conv['utf'][] = chr(209).chr(145);
		$conv['win'][] = chr(184);
	}
	return str_replace($conv['utf'], $conv['win'], $str);
}
