<?php

/*
 * LinkorCMS 1.4
 *  2012 LinkorCMS Development Group
 */


if(!defined('VALID_RUN')){
	header("HTTP/1.1 404 Not Found");
	exit;
}

System::admin()->AddSubTitle('');

if(!System::user()->CheckAccess2('blocks', 'blocks')){
	System::admin()->AccessDenied();
}

/**
 *    ,     
 * @return Array
 */
function GetBlockTemplates(){
	$TemplateDir = System::config('tpl_dir').System::config('general/site_template').'/block/';
	return GetFiles($TemplateDir, false, true, '.html.htm.tpl', true);
}

if(isset($_GET['a'])){
	$action = $_GET['a'];
}else{
	$action = 'main';
}

switch($action){
	case 'main':
		// SideBar
		System::database()->Select('block_types', '');
		$block_types_data = array();
		while($row = System::database()->FetchRow()){
			System::site()->DataAdd($block_types_data, SafeDB($row['folder'], 255, str), SafeDB($row['name'], 255, str));
		}
		$form = Indent('
			<form action="'.ADMIN_FILE.'?exe=blocks&a=add" method="post">
				'.System::site()->Select('type', $block_types_data, false, 'style="width: 200px;"').'
				<div align="right" style="text-align: right; margin-top: 5px;">'.System::site()->Submit('').'</div>
			</form>
		');
		// FIXME:  Indent  ...
		//System::log($form);
		System::admin()->SideBarAddTextBlock(' ', $form);
		AdminBlocksMain();
		break;
	case 'add':
		AdminBlocksEdit($action);
		break;
	case 'newsave':
		AdminBlocksSave($action);
		break;
	case 'del':
		AdminBlockDelete();
		break;
	case 'edit':
		AdminBlocksEdit($action);
		break;
	case 'update':
		AdminBlocksSave($action);
		break;
	case 'changestatus':
		AdminBlocksChangeStatus();
		break;
	case 'move':
		AdminBlocksMove();
		break;
	default:
		AdminBlocksMain();
}


function GetPlace( $pos, $id ){
	System::database()->Select('blocks', "`position`='".$pos."'");
	while($row = System::database()->FetchRow()){
		if(SafeDB($row['id'], 11, int) == $id){
			return SafeDB($row['place'], 11, int);
		}
	}
	return System::database()->NumRows();
}

function AdminBlocksMain(){
	System::database()->Select('block_types', '');
	while($type = System::database()->FetchRow()){
		$types[SafeDB($type['folder'], 255, str)] = SafeDB($type['name'], 255, str);
	}
	unset($type);
	$b_pos = array(
		'L' => ' ',
		'R' => ' ',
		'T' => ' ',
		'B' => ' ',
		'A' => 'A  '
	);
	$text = '';
	$text .= '<table cellspacing="0" cellpadding="0" class="cfgtable">'
	.'<tr>
		<th></th>
		<th></th>
		<th></th>
		<th> </th>
		<th></th>
		<th></th>
	</tr>';

	foreach($b_pos as $pos=>$pos_title){
		System::database()->Select('blocks', "`position`='".SafeEnv($pos, 255, str)."'");
		$maxplace = System::database()->NumRows() - 1;
		if($maxplace + 1 > 0){
			$text .= '<tr><th colspan="6">'.SafeDB($pos_title, 255, str).'</th></tr>';
		}
		usort(System::database()->QueryResult, 'AdminBlocksSort');
		while($block = System::database()->FetchRow()){
			$block_id = SafeDB($block['id'], 11, int);
			$st = System::admin()->SpeedStatus('.', '.', ADMIN_FILE.'?exe=blocks&a=changestatus&id='.$block_id, $block['enabled'] == '1');
			$vi = ViewLevelToStr(SafeDB($block['view'], 1, int));
			$move_menu = '';
			if($maxplace == 0){ //    
				$move_menu .= ' - ';
			}else{
				if($block['place'] >= 0 && $block['place'] < $maxplace){ //  
					$move_menu .= System::admin()->SpeedButton('', ADMIN_FILE.'?exe=blocks&a=move&to=down&id='.$block_id, 'images/admin/down.png');
				}
				if($block['place'] <= $maxplace && $block['place'] > 0){
					$move_menu .= System::admin()->SpeedButton('', ADMIN_FILE.'?exe=blocks&a=move&to=up&id='.$block_id, 'images/admin/up.png');
				}
			}
			$func = '';
			$func .= System::admin()->SpeedButton('', ADMIN_FILE.'?exe=blocks&a=edit&id='.$block_id, 'images/admin/edit.png');
			$func .= System::admin()->SpeedConfirm('', ADMIN_FILE.'?exe=blocks&a=del&id='.$block_id, 'images/admin/delete.png', ' ?');
			$text .= '<tr>
			<td><b>'.System::admin()->Link(SafeDB($block['title'], 255, str), ADMIN_FILE.'?exe=blocks&a=edit&id='.$block_id).'</b></td>
			<td>'.$move_menu.'</td>
			<td>'.$types[SafeDB($block['type'], 255, str)].'</td>
			<td>'.$vi.'</td>
			<td>'.$st.'</td>
			<td>'.$func.'</td>
			</tr>';
		}
	}
	$text .= '</table><br />';
	AddCenterBox('');
	AddText($text);
}

function AdminBlocksEdit( $a ){
	global $config, $site, $user; //      

	$showin = array('ALL_EXCEPT');
	$showin_uri = array();
	$template = '';
	$b_vi = 4;
	$b_en = 1;
	if(isset($_POST['type']) || $a == 'edit'){
		$b_pos = array('L'=>false, 'R'=>false, 'T'=>false, 'B'=>false);
		$b_pos = array('L'=>false, 'R'=>false, 'T'=>false, 'B'=>false, 'A'=>false);
		$b_title = '';
		$b_vi = 4;
		$b_en = 1;
		$block_config = ''; //    
		if($a == 'edit'){
			System::database()->Select('blocks', "`id`='".SafeEnv($_GET['id'], 11, int)."'");
			$r = System::database()->FetchRow();
			$b_title = SafeDB($r['title'], 255, str);
			$b_pos[SafeDB($r['position'], 1, str)] = true;
			$b_vi = SafeDB($r['view'], 1, int);
			$b_en = SafeDB($r['enabled'], 1, bool);
			$b_type = SafeDB($r['type'], 255, str);
			$template = SafeDB($r['template'], 255, str);
			$block_config = $r['config']; //    
			$title = ' ';
			$a_form = ADMIN_FILE.'?exe=blocks&a=update&id='.SafeEnv($_GET['id'], 11, int);
			$button = ' ';
			if($r['showin'] != ''){
				$showin = unserialize($r['showin']);
			}
			if($r['showin_uri'] != ''){
				$showin_uri = unserialize($r['showin_uri']);
			}
		}else{
			$a_form = ADMIN_FILE.'?exe=blocks&a=newsave';
			$b_type = SafeEnv($_POST['type'], 255, str);
			$title = ' ';
			$button = '';
			$showin[] = array('ALL_EXCEPT');
		}

		FormRow('', System::site()->Edit('title', $b_title, false, 'style="width:400px;" class="autofocus"'));
		$constructor = System::config('blocks_dir').$b_type.'/constructor.php';
		if(is_file($constructor)){
			include_once $constructor;
		}
		$btems = GetBlockTemplates();
		$temdata = array();
		foreach($btems as $tem){
			System::site()->DataAdd($temdata, $tem, $tem, $tem == $template);
		}
		FormRow(' ', System::site()->Select('template', $temdata));
		System::site()->DataAdd($posdata, 'Left', ' ', $b_pos['L']);
		System::site()->DataAdd($posdata, 'Right', ' ', $b_pos['R']);
		System::site()->DataAdd($posdata, 'Top', '  ', $b_pos['T']);
		System::site()->DataAdd($posdata, 'Bottom', '  ', $b_pos['B']);
		//System::site()->DataAdd($posdata, 'ABottom', 'A   ', $b_pos['A']);
		FormRow('', System::site()->Select('position', $posdata));

		VisibilityConditionsAdmin($showin, $showin_uri);

		FormRow(' ', System::site()->Select('view', GetUserTypesFormData($b_vi)));
		FormRow('', System::site()->Select('enabled', GetEnData($b_en, '', '')));

		AddCenterBox($title);
		AddForm('<form action="'.$a_form.'" method="post">'.System::site()->Hidden('type', $b_type), System::site()->Button('', 'onclick="history.go(-1);"').System::site()->Submit($button));
	}else{
		GO(ADMIN_FILE);
	}
}

function AdminBlocksSave( $a ){
	$block_config = '';
	$editsave = System::config('blocks_dir').SafeEnv($_POST['type'], 255, str).'/editsave.php';
	if(file_exists($editsave)){
		include_once $editsave; // -   $block_config
	}

	VisibilityConditionsAdminSave($showin, $extra_uri);

	$b_v = ViewLevelToInt($_POST['view']);
	$b_en = EnToInt($_POST['enabled']);

	if(isset($_GET['id'])){
		$id = SafeEnv($_GET['id'], 11, int);
	}else{
		$id = 0;
	}
	$place = GetPlace(SafeEnv($_POST['position'][0], 1, str), $id); // FIXME:   ,     place   
	if($id != 0){
		$block = System::database()->Select('blocks', "`id`='$id'");
		$block_pos = SafeEnv($block[0]['position'], 1, str);
	}
	$vals = Values('', SafeEnv($_POST['title'], 255, str), SafeEnv($_POST['type'], 255, str), $place, '', '1', $block_config, SafeEnv($_POST['template'], 255, str), SafeEnv($_POST['position'][0], 1, str), $b_v, $b_en, $showin, $extra_uri);
	if($a == 'newsave'){
		System::database()->Insert('blocks', $vals);
		Audit(':   "'.$_POST['title'].'"');
	}elseif($a == 'update'){
		System::database()->Update('blocks', $vals, "`id`='".$id."'", true);
		Audit(':   "'.$_POST['title'].'"');
		if($block_pos != $_POST['position'][0]){ //   place   position
			$blocks = System::database()->Select('blocks', "`position`='".$block_pos."'");
			if(count($blocks) > 0){
				usort($blocks, 'AdminBlocksSort');
				foreach($blocks as $i=>$b){
					System::database()->Update('blocks', "`place`='$i'", "`id`='".SafeEnv($b['id'], 11, int)."'");
				}
			}
		}
	}
	GO(ADMIN_FILE.'?exe=blocks');
}

function AdminBlockDelete(){
	$id = SafeEnv($_GET['id'], 11, int);
	System::database()->Select('blocks', "`id`='$id'");
	$block = System::database()->FetchRow();
	System::database()->Delete('blocks', "`id`='$id'");
	Audit(':   "'.$block['title'].'"');
	GO(ADMIN_FILE.'?exe=blocks');
}

function AdminBlocksChangeStatus(){
	System::database()->Select('blocks', "`id`='".SafeEnv($_GET['id'], 11, int)."'");
	if(System::database()->NumRows() > 0){
		$r = System::database()->FetchRow();
		if(SafeDB($r['enabled'], 1, int) == 1){
			$en = '0';
		}else{
			$en = '1';
		}
		System::database()->Update('blocks', "enabled='$en'", "`id`='".SafeEnv($_GET['id'], 11, int)."'");
		Audit(':    "'.$r['title'].'"');
	}
	if(IsAjax()){
		exit("OK");
	}
	GO(ADMIN_FILE.'?exe=blocks');
}

function AdminBlocksSort( $a, $b ){
	if($a['place'] == $b['place']) return 0;
	return ($a['place'] < $b['place']) ? -1 : 1;
}

function AdminBlocksMove(){
	$move = SafeEnv($_GET['to'], 4, str);
	$id = SafeEnv($_GET['id'], 11, int);
	System::database()->Select('blocks', "`id`='".$id."'");
	if(System::database()->NumRows() > 0){
		$block = System::database()->FetchRow();
		$pos = SafeDB($block['place'], 255, str);
		$blocks = System::database()->Select('blocks', "`position`='".SafeDB($block['position'], 1, str)."'");
		usort($blocks, 'AdminBlocksSort');
		$c = count($blocks);
		$cur_pos = 0;
		for($i = 0; $i < $c; $i++){
			$blocks[$i]['place'] = $i;
			if($blocks[$i]['id'] == $id){
				$cur_pos = $i;
			}
		}
		// 
		$rep_pos = $cur_pos;
		if($move == 'up'){
			$rep_pos = $cur_pos - 1;
		}elseif($move == 'down'){
			$rep_pos = $cur_pos + 1;
		}else{
			$rep_pos = $cur_pos;
		}
		if($rep_pos < 0 || $rep_pos >= $c){
			$rep_pos = $cur_pos;
		}
		$temp = intval($blocks[$cur_pos]['place']);
		$blocks[$cur_pos]['place'] = intval($blocks[$rep_pos]['place']);
		$blocks[$rep_pos]['place'] = intval($temp);
		// 
		for($i = 0; $i < $c; $i++){
			System::database()->Update('blocks', "place='".SafeDB($blocks[$i]['place'], 11, int)."'", "`id`='".SafeDB($blocks[$i]['id'], 11, int)."'");
		}
	}
	Audit(':   '.($move == 'up' ? '' : '').' "'.$block['title'].'"');
	GO(ADMIN_FILE.'?exe=blocks');
}
