<?php

/*
 * LinkorCMS 1.4
 *  2012 LinkorCMS Development Group
 */


if(!defined('VALID_RUN')){
	header("HTTP/1.1 404 Not Found");
	exit;
}

System::admin()->AddSubTitle(' ');

if(!System::user()->isSuperUser()){
	System::admin()->AccessDenied();
}

if(isset($_GET['a'])){
	$action = $_GET['a'];
}else{
	if(!isset($_GET['lang']) || $_GET['lang'] == 'php'){
		$action = 'mainphp';
	}else{
		$action = 'mainjs';
	}
}

System::admin()->SideBarAddMenuItem('PHP', 'exe=codetester&lang=php', 'mainphp');
System::admin()->SideBarAddMenuItem(' PHP', 'exe=codetester&a=phpsnippets', 'phpsnippets');
System::admin()->SideBarAddMenuItem('JavaScript', 'exe=codetester&lang=js', 'mainjs');
System::admin()->SideBarAddMenuItem(' JS', 'exe=codetester&a=jssnippets', 'jssnippets');
System::admin()->SideBarAddMenuBlock('', $action);

switch($action){
	case 'mainphp':
		Admincodetester();
		break;
	case 'mainjs':
		AdminJsTester();
		break;
	case 'perform':
		AdminCodetesterPerform();
		break;
	case 'phpsnippets':
		AdminCodetesterSnippets("php");
		break;
	case 'jssnippets':
		AdminCodetesterSnippets("js");
		break;
	case 'add':
	case 'save':
		AdminCodetesterSave($action);
		break;
	case 'delete':
		AdminCodetesterDelete();
		break;
}

function AdminCodetester(){

	$ace = UseScript('ace?mode=php&id=test_code');
	System::admin()->AddOnLoadJS($ace.'.on("focus", function(){ $("#test_code_replace").animate({height: "400"}, 500); });');

	$code = '';
	$title = '';
	if(isset($_GET['id'])){
		$snippet_id = SafeDB($_GET['id'], 11, int);
		System::database()->Select('snippets', "`id`='$snippet_id'");
		$s = System::database()->FetchRow();
		$code = SafeDB($s['code'], 0, str);
		$title = SafeDB($s['title'], 255, str);
	}else{
		$snippet_id = '0';
	}

	System::admin()->AddJS('
window.snippet_id = "'.$snippet_id.'";
PerformPhpCode = function(){
	var label = $("#perform").button("option", "label");
	$("#perform").button("option", "label", "  <img src=\"images/ajax-loader.gif\">");
	$("#result_container").hide();
	$("#perform_result").html("");
	$("#perform_result").hide();
	$.ajax({
		type: "POST",
		url: "'.ADMIN_FILE.'?exe=codetester&a=perform",
		data: {code: $("#test_code").val(), id: window.snippet_id},
		success: function(data){
			$("#perform").button("option", "label", label);
			$("#perform_result").val(data);
			$("#result_container").show();
			$("#test_code_replace").css("height", "100");
			$("#perform_output").show();
			$("#perform_result").slideDown();
		}
	});
};
SavePhpCode = function(met){
	if($("#test_title").val() == ""){
	  alert("   .");
	  return;
	}
	var label = $("#"+met).button("option", "label");
	$("#"+met).button("option", "label", label+" <img src=\"images/ajax-loader.gif\">");
	$.ajax({
		type: "POST",
		url: "'.ADMIN_FILE.'?exe=codetester&a="+met,
		dataType: "json",
		data: {code: $("#test_code").val(), title: $("#test_title").val(), id: window.snippet_id, type: "php"},
		success: function(data){
			window.snippet_id = data.id;
			$("#"+met).button("option", "label", label);
		}
	});
};
');

	$html = <<<HTML
<div style="margin: 0 0 2px 0; ">
	<div style="width: 72px; float: left; line-height: 25px; padding-left: 2px; font-weight: bold;"></div>
	<div style="float: left;"><input type="text" id="test_title" style="width: 400px;" value="$title"></div>
	<div style="float: right; margin-top: 1px;">
		<a href="#" id="add" class="button" onclick="SavePhpCode('add'); return false;" title="   "><img src="images/admin/plus.png" />&nbsp;</a>
		<a href="#" id="save" class="button" onclick="SavePhpCode('save'); return false;" title="     "><img src="images/admin/save.png" />&nbsp;</a>
		<a href="#" id="perform" class="button" onclick="PerformPhpCode(); return false;" title="      "> <img src="images/arrow_blue_right.png" /></a>
	</div>
	<div style="clear: both;"></div>
</div>
<textarea id="test_code" style="width: 100%; height: 400px;">$code</textarea>
<div id="perform_output" style="line-height: 25px; padding-left: 2px; font-weight: bold; display: none;"></div>
<textarea id="perform_result" style="width: 100%; height: 300px; display: none; overflow: auto; padding: 0; background-color: #EEE; border: 1px #DDD solid; border-radius: 3px;-moz-border-radius: 3px; tab-size: 2; -moz-tab-size: 2;" wrap="off" readonly>$code</textarea>
HTML;
	System::admin()->AddTextBox(' PHP', $html);
}

function AdminJsTester(){

	UseScript('ace?mode=javascript&id=test_code');

	$code = '';
	$title = '';
	if(isset($_GET['id'])){
		$snippet_id = SafeDB($_GET['id'], 11, int);
		System::database()->Select('snippets', "`id`='$snippet_id'");
		$s = System::database()->FetchRow();
		$code = SafeDB($s['code'], 0, str);
		$title = SafeDB($s['title'], 255, str);
	}else{
		$snippet_id = '0';
	}

	System::admin()->AddJS('
window.snippet_id = "'.$snippet_id.'";
PerformJsCode = function(){
	var label = $("#perform").button("option", "label");
	$("#perform").button("option", "label", "  <img src=\"images/ajax-loader.gif\">");
	eval($("#test_code").val());
	$("#perform").button("option", "label", label);
};
SaveJSCode = function(met){
	if($("#test_title").val() == ""){
	  alert("   .");
	  return;
	}
	var label = $("#"+met).button("option", "label");
	$("#"+met).button("option", "label", label+" <img src=\"images/ajax-loader.gif\">");
	$.ajax({
		type: "POST",
		url: "'.ADMIN_FILE.'?exe=codetester&a="+met,
		dataType: "json",
		data: {code: $("#test_code").val(), title: $("#test_title").val(), id: window.snippet_id, type: "js"},
		success: function(data){
			window.snippet_id = data.id;
			$("#"+met).button("option", "label", label);
		}
	});
};
');
	$html = <<<HTML
<div style="margin: 0 0 2px 0; ">
	<div style="width: 72px; float: left; line-height: 25px; padding-left: 2px; font-weight: bold;"></div>
	<div style="float: left;"><input type="text" id="test_title" style="width: 400px;" value="$title"></div>
	<div style="float: right; margin-top: 1px;">
		<a href="#" id="add" class="button" onclick="return false;" onmouseup="SaveJSCode('add');" title="   "><img src="images/admin/plus.png" />&nbsp;</a>
		<a href="#" id="save" class="button" onclick="return false;" onmouseup="SaveJSCode('save');" title="     "><img src="images/admin/save.png" />&nbsp;</a>
		<a href="#" id="perform" class="button" onclick="return false;" onmouseup="PerformJsCode();" title=" "> <img src="images/arrow_blue_right.png" /></a>
	</div>
	<div style="clear: both;"></div>
</div>
<textarea id="test_code" style="width: 100%; height: 400px;">$code</textarea>
HTML;
	System::admin()->AddTextBox(' JS', $html);
}

function AdminCodetesterPerform(){
	ob_start();
	$test = eval(Utf8ToCp1251($_POST['code']));
	$source = ob_get_clean();
	if($source == ''){
		ob_start();
		print_r($test);
		$source = ob_get_clean();
	}
	echo $source;
	Audit(' :'."\n".Utf8ToCp1251($_POST['code']).'');
	exit();
}

function AdminCodetesterSnippets( $type ){
	System::admin()->AddSubTitle('');
	UseScript('jquery_ui_table');

	if(isset($_REQUEST['onpage'])){
		$num = intval($_REQUEST['onpage']);
	}else{
		$num = 20;
	}
	if(isset($_REQUEST['page'])){
		$page = intval($_REQUEST['page']);
	}else{
		$page = 1;
	}

	$snippets_db = System::database()->Select('snippets', "`type`='$type'");
	$columns = array('title');
	$sortby = '';
	$sortbyid = -1;
	$desc = true;
	if(isset($_REQUEST['sortby'])){
		$sortby = $columns[$_REQUEST['sortby']];
		$sortbyid = intval($_REQUEST['sortby']);
		$desc = $_REQUEST['desc'] == '1';
	}
	if($sortby != ''){
		SortArray($snippets_db, $sortby, $desc);
	}

	$table = new jQueryUiTable();
	$table->listing = ADMIN_FILE.'?exe=codetester&a='.$type.'snippets&ajax';
	$table->del = ADMIN_FILE.'?exe=codetester&a=delete';
	$table->total = count($snippets_db);
	$table->onpage = $num;
	$table->page = $page;
	$table->sortby = $sortbyid;
	$table->sortdesc = $desc;

	$table->AddColumn('');
	$table->AddColumn('', 'center', false, true);

	$snippets_db = ArrayPage($snippets_db, $num, $page); //      
	foreach($snippets_db as $snip){
		$id = SafeDB($snip['id'], 11, int);
		$editlink = ADMIN_FILE.'?exe=codetester&id='.$id.'&lang='.$type;

		$func = '';
		$func .= System::admin()->SpeedButton('', $editlink, 'images/admin/edit.png');
		$func .= System::admin()->SpeedConfirmJs(
			'',
			'$(\'#jqueryuitable\').table(\'deleteRow\', '.$id.');',
			'images/admin/delete.png',
			',     ?'
		);

		$table->AddRow(
			$id,
			'<b>'.System::admin()->Link(SafeDB($snip['title'], 255, str), $editlink).'</b>',
			$func
		);
	}
	if(isset($_GET['ajax'])){
		echo $table->GetOptions();
		exit;
	}else{
		$table->AddTable('');
	}
}

function AdminCodetesterSave($action){
	$snippet = SafeR('title,type', 255, str) + SafeR('code', 0, str);
	ObjectUtf8ToCp1251($snippet);
	if($action == 'save' && (isset($_POST['id']) && $_POST['id'] != 0)){ // 
		$id = SafeEnv($_POST['id'], 11, int);
		System::database()->Update('snippets', MakeSet($snippet), "`id`='$id'");
		Audit(' :   "'.$snippet['title'].'"');
		echo JsonEncode(array('id'=>$id));
	}else{ //   
		System::database()->Insert('snippets', MakeValues("'','title','code','type'", $snippet));
		Audit(' :   "'.$snippet['title'].'"');
		echo JsonEncode(array('id'=>System::database()->GetLastId()));
	}
	exit();
}

function AdminCodetesterDelete(){
	System::database()->Delete('snippets', "`id`='".SafeEnv($_REQUEST['id'], 11, int)."'");
	exit('OK');
}
