<?php

/*
 * LinkorCMS 1.4
 *  2012 LinkorCMS Development Group
 */

//    

if(!defined('VALID_RUN')){
	header("HTTP/1.1 404 Not Found");
	exit;
}

System::admin()->AddSubTitle(' ');

if(isset($_GET['a'])){
	$action = $_GET['a'];
}else{
	$action = 'main';
}
switch($action){
	case 'main': AdminCommentsMain();
		break;
	case 'edit': AdminCommentsEdit();
		break;
	case 'save': AdminCommentsSave();
		break;
	case 'delete': AdminCommentsDelete();
		break;
	case 'find': AdminCommentsFind();
		break;
}


function AdminConfigMarkPosts( &$posts, $table ){
	$table_keys = array_keys($table);
	foreach($posts as $id=>$post){
		foreach($table_keys as $key){
			$posts[$id]['_'.$key] = &$table[$key];
		}
	}
}

function AdminCommentsMain(){
	System::admin()->AddCenterBox('  ');

	if(isset($_GET['page'])){
		$page = SafeEnv($_GET['page'], 10, int);
	}else{
		$page = 1;
	}

	System::admin()->AddJS('
		UpdateSelectComment = function(){
			$(".comment_check").each(function(){
				$("#comment"+$(this).val()).removeClass("commtable_selected");
			});
			$(".comment_check:checked").each(function(){
				$("#comment"+$(this).val()).addClass("commtable_selected");
			});
		};
		SelectAllComments = function(){
			$(".comment_check").each(function(){
				$(this).attr("checked", true);
			});
			UpdateSelectComment();
		};
		DeleteComments = function(){
			var del = "";
			$(".comment_check:checked").each(function(){
				del += "#"+$(this).val();
			});
			Admin.LoadPagePost("'.ADMIN_FILE.'?exe=comments&a=delete&page='.$page.'", {delcomments: del}, "...");
		};
	');

	$commentsOnPage = 50;

	//     
	$where = '';
	$posts = array();
	$comments_tables = System::database()->Select('comments');
	foreach($comments_tables as $table){
		$temp_posts = System::database()->Select($table['table'], $where);
		AdminConfigMarkPosts($temp_posts, $table);
		$posts = array_merge($posts, $temp_posts);
	}

	//    ( )
	SortArray($posts, 'post_date', true);

	//   
	if(count($posts) > $commentsOnPage){
		$navigator = new Navigation($page);
		$navigator->GenNavigationMenu($posts, $commentsOnPage, ADMIN_FILE.'?exe=comments');
		$nav = true;
	}else{
		$nav = false;
		AddText('<br />');
	}

	// 
	if(count($posts) == 0){
		System::admin()->Highlight('   .');
		return;
	}else{
		$text = '';
	}

	$text .= '<table cellspacing="0" cellpadding="0" width="90%" align="center" class="commtable_header">
	<tr>
	<th style="width: 160px;"></th>
	<th style="width: 260px;">E-mail</th>
	<th style="width: 260px;"></th>
	<th style="width: 260px;">  </th>
	<th style="width: 70px;">IP</th>
	<th></th>
	</tr></table>';

	//  
	foreach($posts as $post){
		$post_id = SafeDB($post['id'], 11, int);
		$object_id = SafeDB($post['object_id'], 11, int);

		$user_id = SafeDB($post['user_id'], 11, int);
		$user_name = SafeDB($post['user_name'], 255, str);
		$user_homepage = SafeDB($post['user_homepage'], 255, str);
		$user_email = SafeDB($post['user_email'], 255, str);
		$user_ip = SafeDB($post['user_ip'], 19, str);

		$post_date = TimeRender($post['post_date']);
		$post_message = SafeDB($post['post_message'], 0, str, false);
		$post_message = nl2br($post_message);

		$edit = ADMIN_FILE.'?exe=comments&a=edit&id='.$post_id.'&table='.$post['_table'].'&page='.$page;

		if($user_id != 0){
			$userinfo = GetUserInfo($user_id);

			$user_name = $userinfo['name'];
			$user_homepage = $userinfo['url'];
			$user_email = PrintEmail($userinfo['email']);

			if($userinfo['online']){
				$online = '<b>  .</b>';
			}else{
				$online = '';
			}
			$avatar = '<img src="'.$userinfo['avatar_file'].'" />';
			$rank_image = '<img src="'.$userinfo['rank_image'].'" />';
			$rank_name = $userinfo['rank_name'];

			$regdate = ': '.TimeRender($userinfo['regdate'], false);
			$ruser = true;
		}else{
			$user_email = PrintEmail($user_email);

			$online = '';
			$avatar = '<img src="'.GetPersonalAvatar(0).'" />';
			$rank_image = '';
			$rank_name = '';

			$regdate = '';
			$ruser = false;
		}

		if($user_homepage != ''){
			$user_homepage = '<a href="http://'.$user_homepage.'" target="_blank">'.$user_homepage.'</a>';
		}else{
			$user_homepage = '&nbsp;';
		}
		if($ruser){
			$user_name = '<a href="'.Ufu("index.php?name=user&op=userinfo&user=$user_id", 'user/{user}/info/').'" target="_blank">'.$user_name.'</a>';
		}

		$link_go = ADMIN_FILE.'?exe=comments&a=find&table='.SafeDB($post['_id'], 11, int).'&post_id='.$post_id;
		$func = '';
		if($post['_url'] != ''){
			$func .= System::admin()->SpeedButton(' ', $link_go, 'images/search.png', false, false, 'target="_blank"');
		}
		$func .= SpeedButton('', $edit, 'images/admin/edit.png');

		$text .= Indent('
			<table cellspacing="0" cellpadding="0" width="90%" align="center" class="commtable" id="comment'.$post_id.'--'.$post['_table'].'--'.$object_id.'">
				<tr>
					<th style="width: 160px;"><b>'.$user_name.'</b></th>
					<th style="width: 260px;">'.$user_email.'</th>
					<th style="width: 260px;">'.$user_homepage.'</th>
					<th style="width: 260px;">'.$post_date.'</th>
					<th style="width: 70px;">'.$user_ip.'</th>
					<th>'.$func.'</th>
					<th>'.System::admin()->Check('delcomments[]', $post_id.'--'.$post['_table'].'--'.$object_id, false, 'class="comment_check" onchange="UpdateSelectComment();"').'</th>
				</tr>
				<tr>
					<td valign="top" width="140">'.$avatar.'<br>'.$rank_image.'<br>'.$rank_name.'</td>
					<td colspan="6" class="commtable_text">'.$post_message.'</td>
				</tr>
			</table>
		');
	}

	// 
	AddText($text);
	if($nav){
		AddNavigation();
	}
	$text = '';
	if(count($posts) > 0){
		$text .= '<div style="text-align: right;">'.System::admin()->SpeedConfirmJs(' ', 'SelectAllComments();', '', '', true).'&nbsp;'
			.System::admin()->SpeedConfirmJs(' ', 'DeleteComments();', 'images/admin/delete.png', '  ?', true).'</div>';
	}
	AddText($text);
}

//  
function AdminCommentsEdit(){
	if(isset($_GET['page'])){
		$page = SafeEnv($_GET['page'], 10, int);
	}else{
		$page = 1;
	}
	$id = SafeEnv($_GET['id'], 11, int);
	$table = SafeEnv($_GET['table'], 255, str);

	System::database()->Select($table, "`id`='$id'");
	$post = System::database()->FetchRow();

	$user_id = SafeDB($post['user_id'], 11, int);
	$user_name = SafeDB($post['user_name'], 255, str);
	$user_homepage = SafeDB($post['user_homepage'], 255, str);
	$user_email = SafeDB($post['user_email'], 255, str);
	$user_hideemail = $post['user_hideemail'] == 1 ? true : false;
	$user_ip = SafeDB($post['user_ip'], 19, str);

	$post_message = SafeDB($post['post_message'], 0, str, false);

	if($user_id == 0){
		FormRow('', System::admin()->Edit('user_name', $user_name, false, 'style="width:400px;" class="autofocus"'));
		FormRow('E-mail', System::admin()->Edit('user_email', $user_email, false, 'style="width:400px;"'));
		FormRow(' e-mail', System::admin()->Check('user_hideemail', '1', $user_hideemail));
		FormRow('', System::admin()->Edit('user_homepage', $user_homepage, false, 'style="width:400px;"'));
	}
	FormRow('', System::admin()->TextArea('post_message', $post_message, 'style="width:400px;height:200px;"'.($user_id != 0 ? ' class="autofocus"' : '')));
	$action = ADMIN_FILE.'?exe=comments&a=save&id='.$id.'&table='.$table.'&page='.$page;
	AddCenterBox(' ');
	AddForm(
		'<form action="'.$action.'" method="post">',
		System::admin()->Button('', 'onclick="history.go(-1)"').System::admin()->Submit('')
	);

}

//  
function AdminCommentsSave(){
	if(isset($_GET['page'])){
		$page = SafeEnv($_GET['page'], 10, int);
	}else{
		$page = 1;
	}
	$id = SafeEnv($_GET['id'], 11, int);
	$table = SafeEnv($_GET['table'], 255, str);

	$post_message = SafeEnv($_POST['post_message'], 0, str, false);

	$set = "`post_message`='$post_message'";

	if(isset($_POST['user_name'])){
		$user_name = SafeEnv($_POST['user_name'], 255, str);
		$user_email = SafeEnv($_POST['user_email'], 255, str);
		if(isset($_POST['user_hideemail'])){
			$user_hideemail = '1';
		}else{
			$user_hideemail = '0';
		}
		$user_homepage = SafeEnv($_POST['user_homepage'], 255, str);

		$set .= ",`user_name`='$user_name',`user_email`='$user_email',`user_hideemail`='$user_hideemail',`user_homepage`='$user_homepage'";
	}
	System::database()->Update($table, $set, "`id`='$id'");
	Audit(':   (table: '.$_GET['table'].', id: '.$_GET['id'].')');
	GO(ADMIN_FILE.'?exe=comments&page='.$page);
}

function AdminCommentsDelete(){
	if(!isset($_POST['delcomments'])){
		GO(ADMIN_FILE.'?exe=comments');
	}
	if(isset($_GET['page'])){
		$page = SafeEnv($_GET['page'], 10, int);
	}else{
		$page = 1;
	}

	$com_tables = System::database()->Select('comments');
	foreach($com_tables as $table){
		$comments_tables[$table['table']] = $table;
	}

	$posts_tables = array();
	$del_posts = explode('#', $_POST['delcomments']);
	foreach($del_posts as $post){
		if($post != ''){
			$a = explode('--', $post);
			$posts_tables[$a[1]][] = array($a[0],$a[2]);
		}
	}

	//      
	foreach($posts_tables as $post_table=>$posts_id){
		$where = '';
		foreach($posts_id as $p){
			$post_id = SafeEnv($p[0], 11, int);
			$obj_id = SafeEnv($p[1], 11, int);
			$where .= "`id`='$post_id' or ";
			$t = $comments_tables[$post_table];
			CalcCounter($t['objects_table'], "`{$t['id_coll']}`='$obj_id'", $t['counter_coll'], -1);
		}
		$where = substr($where, 0, strlen($where) - 4);
		System::database()->Delete($post_table, $where);
		Audit(':   (table: '.$post_table.', where: '.$where.')');
	}
	GO(ADMIN_FILE.'?exe=comments&page='.$page);
}

function AdminCommentsFind(){
	if(System::config('comments/disable_posts_engine')){
		System::admin()->AddCenterBox('');
		System::admin()->HighlightError('  .');
		return;
	}

	//        
	function CommentsFindTopLevelPost( &$posts, $post_id, $post_parent_id ){
		if(isset($posts[$post_parent_id])){
			if($posts[$post_parent_id]['post_parent_id'] == 0){
				return $posts[$post_parent_id]['id'];
			}
			return CommentsFindTopLevelPost($posts, $posts[$post_parent_id]['id'], $posts[$post_parent_id]['post_parent_id']);
		}else{
			return $post_id;
		}
	}

	// id     comments  id 
	$table_id = SafeEnv($_GET['table'], 11, int);
	$post_id = SafeEnv($_GET['post_id'], 11, int);

	System::database()->Select('comments', "`id`='$table_id'");
	if(!System::database()->NumRows()){
		System::admin()->AddCenterBox('');
		System::admin()->HighlightError('   .');
		return;
	}
	$table = System::database()->FetchRow();

	//  
	System::database()->Select($table['table'], "`id`='$post_id'");
	if(!System::database()->NumRows()){
		System::admin()->AddCenterBox('');
		System::admin()->HighlightError('  .');
		return;
	}
	$post = System::database()->FetchRow();

	//   
	$id_coll = SafeEnv($table['id_coll'], 255, str);
	$object_id = SafeEnv($post['object_id'], 11, int);
	System::database()->Select($table['objects_table'], "`$id_coll`='$object_id'");
	if(!System::database()->NumRows()){
		System::admin()->AddCenterBox('');
		System::admin()->HighlightError('   .');
		return;
	}
	$object = System::database()->FetchRow();

	$en_navigation = System::config('comments/ennav');
	$navigation_page = 1;
	if($en_navigation){ //     
		//    
		$comments_on_page = System::config('comments/onpage');

		//   
		$object_postsdb = System::database()->Select($table['table'], "`object_id`='$object_id'");
		SortArray($object_postsdb, 'post_date', !System::config('comments/decreasesort'));
		if(count($object_postsdb) <= $comments_on_page){ //   
			$en_navigation = false;
		}else{ //      
			if($post['post_parent_id'] == 0){ //   
				$post_top_id = $post_id;
			}else{ //     
				//     id
				$object_posts = array();
				foreach($object_postsdb as $p){
					$object_posts[$p['id']] = $p;
				}
				$post_top_id = CommentsFindTopLevelPost($object_posts, $post_id, $post['post_parent_id']);
			}
			//     
			$object_top_posts = array();
			foreach($object_postsdb as $p){
				if($p['post_parent_id'] == 0){
					$object_top_posts[$p['id']] = true;
				}
			}
			//    post_top_id
			$index = array_search($post_top_id, array_keys($object_top_posts));
			$navigation_page = ceil(($index+1) / $comments_on_page); //  
			if($navigation_page > 1){
				$en_navigation = true;
			}
		}
	}

	if(System::config('general/ufu')){
		if($en_navigation){
			$url_template = $table['nav_ufu'];
		}else{
			$url_template = $table['ufu'];
		}
	}else{
		$url_template = $table['url'];
		if($en_navigation){
			$url_template .= '&'.urlencode($table['page_param']).'='.$navigation_page;
		}
	}

	//   URL
	$keys = array();
	foreach($object as $key=>&$val){
		$val = urlencode($val);
		$keys['{'.$key.'}'] = &$val;
	}
	$keys['{'.$table['page_param'].'}'] = $navigation_page;
	$url = str_replace(array_keys($keys), array_values($keys), $url_template);
	GO($url.'#post_'.$post_id);
}
