<?php

/*
 * LinkorCMS 1.4
 *  2012 LinkorCMS Development Group
 */


/*
 *   .
 */

if(!defined('VALID_RUN')){
	header("HTTP/1.1 404 Not Found");
	exit;
}

System::admin()->AddSubTitle(' ');

if(!System::user()->isSuperUser()){
	System::admin()->AccessDenied();
}

include_once System::config('inc_dir').'forms.inc.php';

if(isset($_GET['a'])){
	$action = $_GET['a'];
}else{
	$action = 'view_all';
}

TAddToolLink(' ', 'view_all', 'config_admin&a=view_all');
TAddToolLink(' ', 'add', 'config_admin&a=add');
TAddToolLink(' ', 'view_groups', 'config_admin&a=view_groups');
TAddToolBox($action);
TAddToolLink('  ','view_all_plugins','config_admin&a=view_all_plugins&plugins=1');
TAddToolLink('  ', 'add_plugins', 'config_admin&a=add_plugins&plugins=1');
TAddToolLink('  ', 'view_groups_plugins', 'config_admin&a=view_groups_plugins&plugins=1');
TAddToolBox($action);

switch($action){
	case 'view_all':
	case 'view_all_plugins':
		AdminViewRetrofittingList();
	break;
	case 'add':
	case 'add_plugins':
	case 'edit':
		AdminConfigAdd();
	break;
	case 'save':
		AcAddRetrofitting();
	break;
	case 'delete':
		AdminConfigDeleteRetrofitting();
	break;
	case 'view_groups':
	case 'view_groups_plugins':
		AdminConfigViewGroups();
	break;
	case 'editgroup':
		AdminConfigGroupEdit();
	break;
	case 'savegroup':
		AdminConfigGroupSave();
	break;
	case 'deletegroup':
		AdminConfigGroupDelete();
	break;
	default: AdminViewRetrofittingList();
}

//       
function AdminConfigPlugins(){
	return (isset($_GET['plugins']) && $_GET['plugins'] == '1');
}

//    
function AdminConfigGroupTable(){
	if(AdminConfigPlugins()){
		return 'plugins_config_groups';
	}else{
		return 'config_groups';
	}
}

//    
function AdminConfigConfigTable(){
	if(AdminConfigPlugins()){
		return 'plugins_config';
	}else{
		return 'config';
	}
}

//     
function AdminConfigGetGroupsFormData( $group = 0 ){
    System::database()->Select(AdminConfigGroupTable(), '');
	$result = array();
	while($g = System::database()->FetchRow()){
		System::site()->DataAdd($result, SafeDB($g['id'], 11, int), SafeDB($g['hname'], 255, str).' ('.SafeDB($g['name'], 255, str).')', $group == $g['id']);
	}
	return $result;
}

//  
function AdminViewRetrofittingList(){
	if(!AdminConfigPlugins()){
		$access_config = 'System::config(';
	}else{
		$access_config = 'System::plug_config(';
	}
	$back = SaveRefererUrl();

	$groupid = 1;
	if(isset($_GET['group'])){
		$groupid = SafeEnv($_GET['group'], 11, int);
	}

	$groups_data = array();
	$groups = array();
	System::admin()->DataAdd($groups_data, 0, ' ', $groupid == 0);
	System::database()->Select(AdminConfigGroupTable());
	SortArray(System::database()->QueryResult, 'hname');
	while($group = System::database()->FetchRow()){
		$sel = false;
		if($groupid != 0){
			$sel = $group['id'] == $groupid;
		}
		System::admin()->DataAdd($groups_data, SafeDB($group['id'], 11, int), SafeDB($group['hname'], 255, str), $sel);
		$groups[$group['id']] = $group;
	}

	System::admin()->AddCenterBox(' ');

	System::admin()->AddJS(Indent('
		RetrofittingSelectGroup = function(){
			Admin.LoadPage("'.ADMIN_FILE.'?exe=config_admin'.(AdminConfigPlugins() ? '&a=view_all_plugins&plugins=1' : '').'&group="+$("#retrofitting-group").val());
		}
	'));
	$text = '<div style="text-align: left; margin-bottom: 10px;">: '.System::site()->Select('group', $groups_data, false, 'id="retrofitting-group" onchange="RetrofittingSelectGroup();"').'</div>';
	System::admin()->AddText($text);

	System::database()->Select(AdminConfigConfigTable(), ($groupid > 0 ? "`group_id`='$groupid'" : ''));
	SortArray(System::database()->QueryResult, 'name');

	$text = '<table cellspacing="0" cellpadding="0" class="cfgtable">';
	$text .= Indent('
		<tr>
			<th></th>
			<th></th>
			<th>PHP </th>
			<th></th>
			<th></th>
		</tr>
	');
	$id = 0;
	while($conf = System::database()->FetchRow()){
		$id++;
		$confid = SafeDB($conf['id'], 11, int);
		$func = '';
		$func .= System::admin()->SpeedButton('', ADMIN_FILE.'?exe=config_admin&a=edit&id='.$confid.(AdminConfigPlugins() ? '&plugins=1' : '').'&back='.$back, 'images/admin/edit.png');
		$func .= System::admin()->SpeedConfirm('', ADMIN_FILE.'?exe=config_admin&a=delete&id='.$confid.'&ok=0'.(AdminConfigPlugins() ? '&plugins=1' : '').'&back='.$back, 'images/admin/delete.png', '     .  ,   .  ?');

		$access = $access_config."<span style=\"color: #008200\">'".SafeDB($groups[$conf['group_id']]['name'], 255, str).'/'."".SafeDB($conf['name'], 255, str)."'</span>)";

//		$install_vals = Values('', $conf['group_id'], $conf['name'], $conf['value'],
//			$conf['visible'], $conf['hname'], $conf['description'], $conf['kind'],
//			$conf['values'], $conf['savefunc'], $conf['type'], $conf['autoload']);
//		$install = 'System::database()->Insert("'.AdminConfigConfigTable().'","'.$install_vals.'");';

		if($conf['visible'] == '1'){
			$visible = '<font color="#008000"></font>';
		}else{
			$visible = '<font color="#FF0000"></font>';
		}

		$text .= Indent('
			<tr>
				<td>'.$id.'</td>
				<td style="text-align: left; padding-left: 10px; '.($conf['visible'] == '0' ? 'color: #888;' : '').'">'.SafeDB($conf['hname'], 255, str).'</td>
				<td style="text-align: left; padding-left: 10px;">'.$access.'</td>
				<td>'.$visible.'</td>
				<td>'.$func.'</td>
			</tr>
		');
	}
	$text .= '</table>';

	if(isset($_GET['saveok'])){
		System::admin()->Highlight(' .');
	}elseif(isset($_GET['addok'])){
		System::admin()->Highlight(' .');
	}elseif(isset($_GET['delok'])){
		System::admin()->Highlight(' .');
	}
	System::admin()->AddText($text);
}

//  
function AdminConfigAdd(){
	global $cl_plugins, $cs_plugins;

	if(isset($_GET['id'])){ // 
		$id = SafeEnv($_GET['id'], 11, int);
        System::database()->Select(AdminConfigConfigTable(), "`id`='$id'");
		$ret = System::database()->FetchRow();

		$group = SafeDB($ret['group_id'], 11, int);
		$name = SafeDB($ret['name'], 255, str);
		$hname = SafeDB($ret['hname'], 255, str);
		$description = SafeDB($ret['description'], 255, str);
		$value = SafeDB($ret['value'], 0, str, false);

		$control = explode(':', $ret['kind']);
		$control[0] = trim(strtolower($control[0]));
		$control = FormsParseParams($control);

		$values = SafeDB($ret['values'], 0, str);
		$vals = explode(':', $values);
		if(count($vals) == 2 && FormsConfigCheck2Func($vals[0], $vals[1])){
			$valuesfunc = trim($vals[1]);
			$values = '';
		}else{
			$valuesfunc = '';
		}
		$savefunc = SafeDB($ret['savefunc'], 250, str);

		$type = SafeDB($ret['type'], 60, str);
		if($type != ''){
			$type = explode(',', $type);
			settype($type[0], int); //maxlength
			settype($type[1], str); //type
			if($type[2] == 'false'){
				$type[2] = false;
			}else{
				$type[2] = true;
			}
		}else{
			$type = array(255, str, false);
		}

		$visible = SafeDB($ret['visible'], 1, int);
		$autoload = SafeDB($ret['autoload'], 1, int);

	}else{ // 
		$group = 0;
		if(isset($_GET['group'])){
			$group = SafeEnv($_GET['group'], 11, int);
		}
		$name = '';
		$hname = '';
		$description = '';
		$value = '';

		$control = array('cols'=>1, 'style'=>'', 'control'=>'', 'width'=>'', 'height'=>'');

		$values = '';
		$valuesfunc = '';
		$savefunc = '';
		$type = array(255, str, false);
		$visible = 1;
		$autoload = 1;
	}

	//  
	$controls_array = array('edit', 'password', 'text', 'combo', 'list', 'check', 'radio');
	$controls_array2 = array(' ', '', ' ',
	 ' ', ' ()', '', '');
	$controls = array();
	foreach($controls_array as $c=>$contol_name){
		System::site()->DataAdd($controls, $contol_name, $controls_array2[$c], $contol_name == $control['control']);
	}

	//  
	$collsd = array();
	for($i = 1; $i < 11; $i++){
		System::site()->DataAdd($collsd, $i, $i, $i==$control['cols']);
	}

	//   
	$getfuncdata = array();
	System::site()->DataAdd($getfuncdata, '', '');
	foreach($cl_plugins as $pl){
		System::site()->DataAdd($getfuncdata, $pl[0], $pl[0], $pl[0] == $valuesfunc);
	}

	//  
	$savefuncdata = array();
	System::site()->DataAdd($savefuncdata, '', '');
	foreach($cs_plugins as $pl){
		System::site()->DataAdd($savefuncdata, $pl[0], $pl[0], $pl[0] == $savefunc);
	}

	//  
	$types_array = array('int', 'float', 'string', 'bool');
	$types_array2 = array('', '', '', '');
	$datatypes = array();
	foreach($types_array as $c=>$type_name){
		System::site()->DataAdd($datatypes, $type_name, $types_array2[$c], $type_name == $type[1]);
	}

	AddCenterBox(' ');
	FormRow('', System::site()->Select('group', AdminConfigGetGroupsFormData($group), false, 'class="autofocus"'));
	FormRow('', System::site()->Edit('name', $name, false, 'style="width:400px;" maxlength="255"'));
	FormRow('', System::site()->Edit('hname', $hname, false, 'style="width:400px;" maxlength="255"'));
	FormRow('', System::site()->Edit('description', $description, false, 'style="width:400px;" maxlength="255"'));
	FormRow('', System::site()->TextArea('value', $value, 'style="width:400px;height:200px;"'));
	FormRow(
		' <br /><small>  <br />   </small>',
		System::site()->Select('control', $controls).'<table cellspacing="3" cellpadding="0" border="0">'
		.'<tr><td style="border:none">:</td><td style="border:none">'.System::site()->Edit('cwidth', $control['width'], false, 'style="width:200px;"').'</td></tr>'
		.'<tr><td style="border:none">:</td><td style="border:none">'.System::site()->Edit('cheight', $control['height'], false, 'style="width:200px;"').'</td></tr>'
		.'<tr><td style="border:none">:</td><td style="border:none">'.System::site()->Select('ccols', $collsd).'</td></tr>'.'</table>'
	);
	FormRow(
		' <br /><small>:<br />name:, name:, ...<br />   .</small>',
		System::site()->TextArea('values', $values, 'style="width:400px;height:100px;"')
	);
	FormRow('  ', System::site()->Select('valuesfunc', $getfuncdata));
	FormRow(' ', System::site()->Select('savefunc', $savefuncdata));
	FormRow(' ', System::site()->Select('datatype', $datatypes));
	FormRow(' <br /><small>0 -  </small>', System::site()->Edit('maxlength', $type[0], false, 'style="width:200px;" maxlength="11"'));
	FormRow(' html- <br /> <br />html-', System::site()->Check('striptags', '1', $type[2]));
	FormRow('', System::site()->Check('visible', '1', $visible));
	FormRow('', System::site()->Check('autoload', '1', $autoload));

	$back = '';
	if(isset($_REQUEST['back'])){
		$back = '&back='.SafeDB($_REQUEST['back'], 255, str);
	}
	AddForm(
		System::site()->FormOpen(ADMIN_FILE.'?exe=config_admin&a=save'.(AdminConfigPlugins() ? '&plugins=1' : '').(isset($_GET['id']) ? '&id='.$id : '').$back),
		System::site()->Button('', 'onclick="history.go(-1)"')
		.System::site()->Submit((isset($_GET['id']) ? '' : ''))
	);
}

//  
function AcAddRetrofitting(){
	if(RequestMethod() != 'POST') return;
	$back_url = '';
	if(!AdminConfigPlugins()){
		$access_config = 'System::config(';
		$back_url = ADMIN_FILE.'?exe=config_admin&a=view_all&saveok';
	}else{
		$access_config = 'System::plug_config(';
		$back_url = ADMIN_FILE.'?exe=config_admin&a=view_all_plugins&plugins=1&saveok';
	}

	System::database()->Select(AdminConfigGroupTable());
	$groups = array();
	while($g = System::database()->FetchRow()){
		$groups[$g['id']] = $g['name'];
	}
	$group = SafeEnv($_POST['group'], 11, int);
	$hname = SafeEnv($_POST['hname'], 255, str, true);
	$name = SafeEnv($_POST['name'], 255, str);
	$value = SafeEnv($_POST['value'], 0, str);
	$description = SafeEnv($_POST['description'], 255, str, true);
	if(isset($_POST['visible'])){
		$visible = '1';
	}else{
		$visible = '0';
	}
	if(isset($_POST['autoload'])){
		$autoload = '1';
	}else{
		$autoload = '0';
	}
	//  kind
	$kind = '';
	$values = '';
	$savefunc = '';
	$type = '';
	if($visible == '1'){
		$kind .= SafeEnv($_POST['control'], 25, str);
		$width = SafeEnv($_POST['cwidth'], 14, str);
		$height = SafeEnv($_POST['cheight'], 14, str);
		$cols = SafeEnv($_POST['ccols'], 11, int);
		if($width != ''){
			$kind .= ':w'.$width;
		}
		if($height != ''){
			$kind .= ':h'.$height;
		}
		if($cols > 1){
			$kind .= ':c'.$cols;
		}
		$getfunc = SafeEnv($_POST['valuesfunc'], 255, str);
		if($getfunc == '' || !function_exists(CONF_GET_PREFIX.$getfunc)){
			$values = SafeEnv($_POST['values'], 0, str);
		}else{
			$values = 'function:'.$getfunc;
		}
	}

	if(function_exists(CONF_SAVE_PREFIX.$_POST['savefunc'])){
		$savefunc = SafeEnv($_POST['savefunc'], 255, str);
	}else{
		$savefunc = '';
	}
	$maxlenght = SafeEnv($_POST['maxlength'], 11, int);
	$type = SafeEnv($_POST['datatype'], 255, str);
	if(isset($_POST['striptags'])){
		$striptags = 'true';
	}else{
		$striptags = 'false';
	}
	$type = $maxlenght.','.$type.','.$striptags;


	// 
	$to_db = Values('', $group, $name, $value, $visible, $hname, $description, $kind, $values, $savefunc, $type, $autoload);
	if(isset($_GET['id'])){
		$id = SafeEnv($_GET['id'], 11, str);
		System::database()->Update(AdminConfigConfigTable(), $to_db, "`id`='$id'", true);
		Audit(' :   "'.$hname.'('.$name.')"  "'.AdminConfigConfigTable().'"');
		if(isset($_REQUEST['back'])){
			GoRefererUrl($_REQUEST['back']);
		}else{
			GO($back_url);
		}
	}else{
		if(isset($_REQUEST['back'])){
			$back_url = GetRefererUrl($_REQUEST['back']);
		}
		System::database()->Insert(AdminConfigConfigTable(), $to_db);
		Audit(' :   "'.$hname.'('.$name.')"  "'.AdminConfigConfigTable().'"');
		AddTextBox('', '   .<br />      :<br /><br />'
			.$access_config."<span style=\"color: #008200\">'".$groups[$group].'/'."".$name."'</span>)"
			.'<br><br>'.System::admin()->SpeedButton('', $back_url, '', true, true)
		);
	}
}

//  
function AdminConfigDeleteRetrofitting(){
	$back_url = '';
	if(!AdminConfigPlugins()){
		$back_url = ADMIN_FILE.'?exe=config_admin&a=view_all&delok';
	}else{
		$back_url = ADMIN_FILE.'?exe=config_admin&a=view_all_plugins&plugins=1&delok';
	}

	if(!isset($_GET['id'])){
		if(isset($_REQUEST['back'])){
			GoRefererUrl($_REQUEST['back']);
		}else{
			GO($back_url);
		}
	}else{
		$id = SafeEnv($_GET['id'], 11, int);
	}
	if(isset($_GET['ok']) && $_GET['ok'] == '1' || IsAjax()){
		System::database()->Select(AdminConfigConfigTable(), "`id`='$id'");
		$conf = System::database()->FetchRow();
		System::database()->Delete(AdminConfigConfigTable(), "`id`='$id'");
		Audit(' :   "'.$conf['hname'].'('.$conf['name'].')"  "'.AdminConfigConfigTable().'"');
		if(isset($_REQUEST['back'])){
			GoRefererUrl($_REQUEST['back']);
		}else{
			GO($back_url);
		}
	}else{
		$back = '';
		if(isset($_REQUEST['back'])){
			$back = '&back='.SafeDB($_REQUEST['back'], 255, str);
		}
		$r = System::database()->Select(AdminConfigConfigTable(), "`id`='$id'");
		AddCenterBox(' ');
		System::admin()->HighlightConfirm('     .  ,   .    "'.SafeDB($r[0]['hname'], 255, str).'"?',
			ADMIN_FILE.'?exe=config_admin&a=delete&id='.$id.'&ok=1'.(AdminConfigPlugins() ? '&plugins=1' : '').'$back='.$back);
	}
}

//  
function AdminConfigViewGroups(){
	System::database()->Select(AdminConfigGroupTable());
	AddCenterBox(' ');
	$text = '<table cellspacing="0" cellpadding="0" class="cfgtable">';
	$text .= '<tr>
	<th> </th>
	<th></th>
	<th></th>'
	//<th></th>
	.'<th></th>
	<th></th>'
	.'</tr>';

	while($group = System::database()->FetchRow()){
		$groupid = SafeDB($group['id'], 11, int);
		$func = '';
		$func .= System::admin()->SpeedButton('', ADMIN_FILE.'?exe=config_admin&a=editgroup&id='.$groupid.(AdminConfigPlugins() ? '&plugins=1' : ''), 'images/admin/edit.png');
		$func .= System::admin()->SpeedConfirm('', ADMIN_FILE.'?exe=config_admin&a=deletegroup&id='.$groupid.'&ok=0'.(AdminConfigPlugins() ? '&plugins=1' : ''),
			'images/admin/delete.png', '     .  ,   .   ?');

		if($group['visible'] == '1'){
			$visible = '<font color="#008000"></font>';
		}else{
			$visible = '<font color="#FF0000"></font>';
		}

		//$install_vals = Values('', $group['name'], $group['hname'], $group['description'], $group['visible']);
		//$install = 'System::database()->Insert("'.AdminConfigGroupTable().'","'.$install_vals.'");';

		$text .= '<tr>
		<td>'.SafeDB($group['name'], 255, str).'</td>
		<td>'.SafeDB($group['hname'], 255, str).'</td>
		<td>'.SafeDB($group['description'], 255, str).'</td>'
		//<td>'.$install.'</td>
		.'<td>'.$visible.'</td>
		<td>'.$func.'</td>
		</tr>';
	}
	$text .= '</table><br />';

	if(isset($_GET['saveok'])){
		System::admin()->Highlight(' .');
	}elseif(isset($_GET['addok'])){
		System::admin()->Highlight(' .');
	}elseif(isset($_GET['delok'])){
		System::admin()->Highlight(' .');
	}
	AddText($text);

	//AddText('.: :.');
	System::admin()->FormTitleRow(' ');
	FormRow('', System::site()->Edit('name', '', false, 'style="width:400px;"'));
	FormRow('', System::site()->Edit('hname', '', false, 'style="width:400px;"'));
	FormRow('', System::site()->TextArea('description', '', 'style="width:400px;height:100px;"'));
	FormRow('', System::site()->Check('visible', '1', false));
	AddForm('<form action="'.ADMIN_FILE.'?exe=config_admin&a=savegroup'.(AdminConfigPlugins() ? '&plugins=1' : '').'" method="post">',System::site()->Submit(''));
}

//  
function AdminConfigGroupEdit(){
	$id = SafeEnv($_GET['id'], 11, int);
	System::database()->Select(AdminConfigGroupTable(), "`id`='$id'");
	$group = System::database()->FetchRow();
	FormRow('', System::site()->Edit('name', SafeDB($group['name'],255,str), false, 'style="width:400px;" class="autofocus"'));
	FormRow('', System::site()->Edit('hname', SafeDB($group['hname'],255,str), false, 'style="width:400px;"'));
	FormRow('', System::site()->TextArea('description', SafeDB($group['description'],255,str), 'style="width:400px;height:100px;"'));
	FormRow('', System::site()->Check('visible', '1', $group['visible']=='1'));
	AddCenterBox(' ');
	AddForm('<form action="'.ADMIN_FILE.'?exe=config_admin&a=savegroup&id='.$id.(AdminConfigPlugins() ? '&plugins=1' : '').'" method="post">',
		System::site()->Button('', 'onclick="history.go(-1)"').System::site()->Submit('')
	);
}

//  
function AdminConfigGroupSave(){
	$name = SafeEnv($_POST['name'], 255, str);
	$hname = SafeEnv($_POST['hname'], 255, str);
	$description = SafeEnv($_POST['description'], 255, str);
	if(isset($_POST['visible'])){
		$visible = '1';
	}else{
		$visible = '0';
	}
	$vals = Values('', $name, $hname, $description, $visible);
	if(isset($_GET['id'])){
		$id = SafeEnv($_GET['id'], 11, int);
		System::database()->Update(AdminConfigGroupTable(), $vals, "`id`='$id'", true);
		Audit(' :    "'.$hname.'('.$name.')"  "'.AdminConfigGroupTable().'"');
		$msg = '&saveok';
	}else{
		System::database()->Insert(AdminConfigGroupTable(), $vals);
		Audit(' :    "'.$hname.'('.$name.')"  "'.AdminConfigGroupTable().'"');
		$msg = '&addok';
	}
	GO(ADMIN_FILE.'?exe=config_admin'.(AdminConfigPlugins() ? '&a=view_groups_plugins&plugins=1' : '&a=view_groups').$msg);
}

//  
function AdminConfigGroupDelete(){
	$back_url = '';
	if(!AdminConfigPlugins()){
		$back_url = ADMIN_FILE.'?exe=config_admin&a=view_groups&delok';
	}else{
		$back_url = ADMIN_FILE.'?exe=config_admin&a=view_groups_plugins&plugins=1&delok';
	}
	if(!isset($_GET['id'])){
		GO($back_url);
	}else{
		$id = SafeEnv($_GET['id'], 11, int);
	}
	if(isset($_GET['ok']) && $_GET['ok'] == '1' || IsAjax()){
		System::database()->Select(AdminConfigGroupTable(), "`id`='$id'");
		$conf = System::database()->FetchRow();
		System::database()->Delete(AdminConfigGroupTable(), "`id`='$id'");
		System::database()->Delete(AdminConfigConfigTable(), "`group_id`='$id'");
		Audit(' :    "'.$conf['hname'].'('.$conf['name'].')"  "'.AdminConfigGroupTable().'"');
		GO($back_url);
	}else{
		$r = System::database()->Select(AdminConfigGroupTable(), "`id`='$id'");
		AddCenterBox('  ');
		System::admin()->HighlightConfirm('     .  ,   .    "'.SafeDB($r[0]['hname'], 255, str).'"?',
			ADMIN_FILE.'?exe=config_admin&a=delete&id='.$id.'&ok=1'.(AdminConfigPlugins() ? '&plugins=1' : ''));
	}
}
